/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.keyStores;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ssl.commands.keyStores.CreateKeyStore;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.security.cert.X509Certificate;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ExchangeSigners
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(CreateKeyStore.class, "SSL", "com.ibm.ws.ssl.commands.ExchangeSigners");
    private String keyStoreName1 = null;
    private String keyStoreScope1 = null;
    private String certificateAliasList1 = null;
    private String keyStoreName2 = null;
    private String keyStoreScope2 = null;
    private String certificateAliasList2 = null;
    private KeyStoreInfo ksInfo1 = null;
    private KeyStoreInfo ksInfo2 = null;

    public ExchangeSigners(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public ExchangeSigners(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName objectName = null;
        ObjectName objectName2 = null;
        ObjectName objectName3 = null;
        Object var6_6 = null;
        boolean bl = false;
        try {
            objectName = ConfigServiceHelper.createObjectName(null, "Security");
            objectName2 = configService.resolve(session, "Cell=")[0];
            if (objectName2 != null) {
                objectName3 = configService.queryConfigObjects(session, objectName2, objectName, null)[0];
            }
            this.keyStoreName1 = (String)this.getParameter(CommandConstants.KEY_STORE_NAME1);
            this.keyStoreScope1 = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE1);
            this.certificateAliasList1 = (String)this.getParameter(CommandConstants.CERT_LIST1);
            this.keyStoreName2 = (String)this.getParameter(CommandConstants.KEY_STORE_NAME2);
            this.keyStoreScope2 = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE2);
            this.certificateAliasList2 = (String)this.getParameter(CommandConstants.CERT_LIST2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyStoreName1=" + this.keyStoreName1 + " keyStoreScope1=" + this.keyStoreScope1 + " certificateAliasList1=" + this.certificateAliasList1 + " keyStoreName2=" + this.keyStoreName2 + " keyStoreScope2=" + this.keyStoreScope2 + " certficiateAliasList2=" + this.certificateAliasList2);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.keyStoreScope1 == null) {
                this.keyStoreScope1 = commandHelper.defaultCellScope(objectName2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Default cell scopeName: " + this.keyStoreScope1);
                }
            }
            if (this.keyStoreScope2 == null) {
                this.keyStoreScope2 = commandHelper.defaultCellScope(objectName2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Default cell scopeName: " + this.keyStoreScope2);
                }
            }
            this.ksInfo1 = PersonalCertificateHelper.getKsInfo(session, configService, this.keyStoreName1, this.keyStoreScope1);
            this.ksInfo2 = PersonalCertificateHelper.getKsInfo(session, configService, this.keyStoreName2, this.keyStoreScope2);
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ConfigService exception is" + configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is " + exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        Object var1_1 = null;
        ObjectName objectName = null;
        AttributeList attributeList = new AttributeList();
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "Security");
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            this.exchangeSingerInKeyStores(this.ksInfo1, this.certificateAliasList1, this.ksInfo2, this.certificateAliasList2);
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    public void exchangeSingerInKeyStores(KeyStoreInfo keyStoreInfo, String string, KeyStoreInfo keyStoreInfo2, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exchangeSignerInKeyStores");
        }
        try {
            if (string != null) {
                this.moveSignerToKeyStore(string, keyStoreInfo, keyStoreInfo2);
            }
            if (string2 != null) {
                this.moveSignerToKeyStore(string2, keyStoreInfo2, keyStoreInfo);
            }
        }
        catch (Exception exception) {
            throw new Exception(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exhangeSignersInKeyStores");
        }
    }

    public void moveSignerToKeyStore(String string, KeyStoreInfo keyStoreInfo, KeyStoreInfo keyStoreInfo2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "moveSignerToKeyStore");
        }
        WSKeyStoreRemotable wSKeyStoreRemotable = new WSKeyStoreRemotable(keyStoreInfo);
        WSKeyStoreRemotable wSKeyStoreRemotable2 = new WSKeyStoreRemotable(keyStoreInfo2);
        X509Certificate x509Certificate = null;
        try {
            String[] stringArray = string.split(":");
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                String string2 = "isKeyEntry";
                Object[] objectArray = new Object[]{stringArray[i]};
                Object[] objectArray2 = wSKeyStoreRemotable.invokeKeyStoreCommand(string2, objectArray);
                if (!((Boolean)objectArray2[0]).booleanValue()) continue;
                string2 = "getCertificate";
                objectArray = new Object[]{stringArray[i]};
                Object[] objectArray3 = wSKeyStoreRemotable.invokeKeyStoreCommand(string2, objectArray);
                x509Certificate = (X509Certificate)objectArray3[0];
                string2 = "setCertificateEntry";
                objectArray = new Object[]{stringArray[i], x509Certificate};
                wSKeyStoreRemotable2.invokeKeyStoreCommand(string2, objectArray);
            }
            Session session = this.getConfigSession();
            PersonalCertificateHelper.setWorkspaceUpdated(session, keyStoreInfo2.getLocation());
            PersonalCertificateHelper.markSSLConfigChanged(keyStoreInfo2, session);
        }
        catch (Exception exception) {
            throw new Exception(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "moveSignerToKeyStore");
        }
    }
}

