/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.keyStores;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.crypto.spec.SecretKeySpec;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class KeyStoreHelper {
    private static TraceComponent tc = Tr.register(KeyStoreHelper.class, "SSL", "com.ibm.ws.ssl.commands.keyStores");

    public static int checkKeyFile(String string, String string2, String string3) {
        int n;
        block11: {
            block10: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "checkKeyFile");
                }
                n = 0;
                KeyStore keyStore = null;
                File file = new File(string2);
                if (file == null || !file.isFile() || !file.canRead()) {
                    n = 1;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "fileName not found.");
                    }
                }
                if (n == 0) {
                    try {
                        keyStore = KeyStore.getInstance(string);
                    }
                    catch (Exception exception) {
                        n = 2;
                        if (!tc.isDebugEnabled()) break block10;
                        Tr.debug(tc, "invalid fileType.");
                    }
                }
            }
            if (n == 0) {
                try {
                    WSKeyStore.loadKeyStore(string2, string, string3);
                }
                catch (Exception exception) {
                    n = 3;
                    if (!tc.isDebugEnabled()) break block11;
                    Tr.debug(tc, "invalid password.");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkKeyFile");
        }
        return n;
    }

    public static boolean verifyKeyStoreType(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "verifyKeyStoreType", new Object[]{string});
        }
        Set<String> set = Security.getAlgorithms("KeyStore");
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "type: " + string2);
            }
            if (!string2.equalsIgnoreCase(string)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "verifyKeyStoreType -> true");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "verifyKeyStoreType -> false");
        }
        return false;
    }

    public static boolean passwordVerify(String string, String string2) {
        return string.equals(string2);
    }

    public static KeyStoreInfo makeKsInfo(AttributeList attributeList, Session session) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "makeKsInfo");
        }
        KeyStoreInfo keyStoreInfo = new KeyStoreInfo();
        Object var3_3 = null;
        try {
            keyStoreInfo.setName((String)ConfigServiceHelper.getAttributeValue(attributeList, "name"));
            keyStoreInfo.setType((String)ConfigServiceHelper.getAttributeValue(attributeList, "type"));
            keyStoreInfo.setPassword((String)ConfigServiceHelper.getAttributeValue(attributeList, "password"));
            keyStoreInfo.setProvider((String)ConfigServiceHelper.getAttributeValue(attributeList, "provider"));
            keyStoreInfo.setLocation((String)ConfigServiceHelper.getAttributeValue(attributeList, "location"));
            keyStoreInfo.setFileBased((Boolean)ConfigServiceHelper.getAttributeValue(attributeList, "fileBased"));
            keyStoreInfo.setHostList((String)ConfigServiceHelper.getAttributeValue(attributeList, "hostList"));
            keyStoreInfo.setInitializeAtStartup((Boolean)ConfigServiceHelper.getAttributeValue(attributeList, "initializeAtStartup"));
            keyStoreInfo.setStashFile((Boolean)ConfigServiceHelper.getAttributeValue(attributeList, "createStashFileForCMS"));
            keyStoreInfo.setReadOnly((Boolean)ConfigServiceHelper.getAttributeValue(attributeList, "readOnly"));
            keyStoreInfo.setScopeName((ObjectName)ConfigServiceHelper.getAttributeValue(attributeList, "managementScope"));
            keyStoreInfo.setSlot((Integer)ConfigServiceHelper.getAttributeValue(attributeList, "slot"));
            keyStoreInfo.setAccelerator((Boolean)ConfigServiceHelper.getAttributeValue(attributeList, "useForAcceleration"));
            ConfigService configService = ConfigServiceFactory.getConfigService();
            ObjectName objectName = (ObjectName)ConfigServiceHelper.getAttributeValue(attributeList, "managementScope");
            String string = (String)configService.getAttribute(session, objectName, CommandConstants.SCOPE_NAME);
            if (string != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Management scope name going into the ksinfo is " + string);
                }
                keyStoreInfo.setScopeNameString(string);
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception while create KeyStoreInfo " + exception.getMessage());
            }
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makeKsInfo");
        }
        return keyStoreInfo;
    }

    public static KeyStoreInfo makeKsInfo(com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "makeKsInfo");
        }
        KeyStoreInfo keyStoreInfo = new KeyStoreInfo();
        Object var2_2 = null;
        try {
            keyStoreInfo.setName(keyStore.getName());
            keyStoreInfo.setType(keyStore.getType());
            keyStoreInfo.setPassword(keyStore.getPassword());
            keyStoreInfo.setProvider(keyStore.getProvider());
            keyStoreInfo.setLocation(keyStore.getLocation());
            keyStoreInfo.setHostList(keyStore.getHostList());
            keyStoreInfo.setScopeNameString(keyStore.getManagementScope().getScopeName());
            int n = keyStore.getSlot();
            keyStoreInfo.setSlot(new Integer(n));
            boolean bl = keyStore.isFileBased();
            if (bl) {
                keyStoreInfo.setFileBased(Boolean.TRUE);
            } else {
                keyStoreInfo.setFileBased(Boolean.FALSE);
            }
            boolean bl2 = keyStore.isReadOnly();
            if (bl2) {
                keyStoreInfo.setReadOnly(Boolean.TRUE);
            } else {
                keyStoreInfo.setReadOnly(Boolean.FALSE);
            }
            boolean bl3 = keyStore.isUseForAcceleration();
            if (bl3) {
                keyStoreInfo.setAccelerator(Boolean.TRUE);
            } else {
                keyStoreInfo.setAccelerator(Boolean.FALSE);
            }
            boolean bl4 = keyStore.isInitializeAtStartup();
            if (bl4) {
                keyStoreInfo.setInitializeAtStartup(Boolean.TRUE);
            } else {
                keyStoreInfo.setInitializeAtStartup(Boolean.FALSE);
            }
            boolean bl5 = keyStore.isCreateStashFileForCMS();
            if (bl5) {
                keyStoreInfo.setStashFile(Boolean.TRUE);
            } else {
                keyStoreInfo.setStashFile(Boolean.FALSE);
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception while create KeyStoreInfo " + exception.getMessage());
            }
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makeKsInfo");
        }
        return keyStoreInfo;
    }

    public static ObjectName createKeyStoreCmd(Session session, KeyStoreInfo keyStoreInfo, boolean bl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CreateKeyStoreCmd");
        }
        ObjectName objectName = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        Boolean bl2 = keyStoreInfo.getStashFile();
        String string4 = null;
        String string5 = KeyStoreManager.getInstance().expand(keyStoreInfo.getLocation());
        string = keyStoreInfo.getHostList();
        try {
            objectName = KeyStoreHelper.createKeyStoreObjectName(session, keyStoreInfo);
            if (objectName == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Failed to create KeyStore ObjectName.");
                }
                throw new KeyStoreException("Failed to create KeyStore file ObjectName.");
            }
            if (bl) {
                Object object;
                if (string == null || string != null && string.equals("")) {
                    object = KeyStoreManager.getInstance().expand("${WORKSPACE_ROOT}/" + session.toString() + "/workspace");
                    string2 = KeyStoreHelper.fixLocation((String)object, KeyStoreManager.getInstance().expand(keyStoreInfo.getLocation()));
                    keyStoreInfo.setLocation(string2);
                    if (bl2.booleanValue()) {
                        int n = string5.lastIndexOf(".");
                        string4 = n != -1 ? string5.substring(0, n + 1) + "sth" : string5 + ".sth";
                        string3 = KeyStoreHelper.fixLocation((String)object, string4);
                    }
                }
                if (!KeyStoreHelper.createKeyStoreFile(keyStoreInfo)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Failed to create KeyStore file.");
                    }
                    throw new KeyStoreException("Failed to create KeyStore file " + keyStoreInfo.getLocation() + ".");
                }
                if (string == null || string != null && string.equals("")) {
                    object = WorkSpaceManagerFactory.getManager().getWorkSpace(session.toString());
                    String string6 = "cells/" + ManagementScopeManager.getInstance().getCellName();
                    RepositoryContext repositoryContext = object.findContext(string6);
                    int n = string2.indexOf(string6);
                    if (n != -1) {
                        string2 = string2.substring(n + string6.length());
                    }
                    repositoryContext.notifyChanged(0, string2);
                    if (bl2.booleanValue()) {
                        n = string3.indexOf(string6);
                        if (n != -1) {
                            string3 = string3.substring(n + string6.length());
                        }
                        repositoryContext.notifyChanged(0, string3);
                    }
                }
            }
        }
        catch (Exception exception) {
            if (objectName != null) {
                ConfigService configService = ConfigServiceFactory.getConfigService();
                configService.deleteConfigData(session, objectName);
            }
            throw new KeyStoreException(exception.getMessage(), exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CreateKeyStoreCmd");
        }
        return objectName;
    }

    public static ObjectName createKeyStoreObjectName(Session session, KeyStoreInfo keyStoreInfo) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CreateKeyStoreObjectName");
        }
        ObjectName objectName = null;
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "Security");
        ConfigService configService = ConfigServiceFactory.getConfigService();
        ObjectName objectName3 = configService.resolve(session, "Cell=:Security=")[0];
        AttributeList attributeList = KeyStoreHelper.createKeyStoreAttrList(keyStoreInfo);
        if (attributeList == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Failed to create KeyStore ObjectName.");
            }
            throw new KeyStoreException("Failed to create KeyStore ObjectName.");
        }
        objectName = configService.createConfigData(session, objectName3, "keyStores", "KeyStore", attributeList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CreateKeyStoreObjectName");
        }
        return objectName;
    }

    public static AttributeList createKeyStoreAttrList(KeyStoreInfo keyStoreInfo) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createKeyStoreAttrList");
        }
        AttributeList attributeList = new AttributeList();
        Integer n = null;
        String string6 = keyStoreInfo.getName();
        if (string6 != null) {
            attributeList.add(new Attribute("name", string6));
        }
        if ((string5 = keyStoreInfo.getLocation()) != null) {
            attributeList.add(new Attribute("location", string5));
        }
        if ((string4 = keyStoreInfo.getType()) != null) {
            attributeList.add(new Attribute("type", string4));
        }
        if ((string3 = keyStoreInfo.getPassword()) != null) {
            attributeList.add(new Attribute("password", string3));
        }
        if ((string2 = keyStoreInfo.getProvider()) != null) {
            attributeList.add(new Attribute("provider", string2));
        }
        if ((string = keyStoreInfo.getHostList()) != null) {
            attributeList.add(new Attribute("hostList", string));
        }
        if ((n = keyStoreInfo.getSlot()) != null) {
            attributeList.add(new Attribute("slot", n));
        }
        attributeList.add(new Attribute("fileBased", keyStoreInfo.getFileBased()));
        attributeList.add(new Attribute("readOnly", keyStoreInfo.getReadOnly()));
        attributeList.add(new Attribute("initializeAtStartup", keyStoreInfo.getInitializeAtStartup()));
        attributeList.add(new Attribute("createStashFileForCMS", keyStoreInfo.getStashFile()));
        attributeList.add(new Attribute("useForAcceleration", keyStoreInfo.getAccelerator()));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createKeyStoreAttrList");
        }
        return attributeList;
    }

    public static boolean createKeyStoreFile(KeyStoreInfo keyStoreInfo) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CreateKeyStoreFile");
        }
        WSKeyStoreRemotable wSKeyStoreRemotable = new WSKeyStoreRemotable(keyStoreInfo);
        KeyStore keyStore = null;
        boolean bl = false;
        X509Certificate x509Certificate = null;
        X509Certificate x509Certificate2 = null;
        String string = keyStoreInfo.getHostList();
        String string2 = keyStoreInfo.getType();
        String string3 = keyStoreInfo.getLocation();
        String string4 = keyStoreInfo.getPassword();
        if (string != null && string.equals("")) {
            string = null;
        }
        x509Certificate = KeyStoreHelper.getCertFromArmFile("client");
        x509Certificate2 = KeyStoreHelper.getCertFromArmFile("server");
        try {
            String string5 = null;
            Object[] objectArray = null;
            if (string != null) {
                string5 = "createRemoteKeyStore";
                objectArray = new Object[]{keyStoreInfo.getName(), keyStoreInfo.getType(), keyStoreInfo.getProvider(), keyStoreInfo.getLocation(), keyStoreInfo.getPassword(), "dummyClientSigner", x509Certificate, "dummyServerSigner", x509Certificate2};
                wSKeyStoreRemotable.invokeKeyStoreCommand(string5, objectArray);
                bl = true;
            } else if (string2.equals("JCERACFKS") || string2.equals("JCECCARACFKS")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Trying to load RACF key store.");
                }
                try {
                    WSKeyStore.loadKeyStore(string3, string2, string4);
                    bl = true;
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Failure loading key ring.  The key ring needs to be created on RACF .");
                    }
                }
            } else {
                if (x509Certificate != null) {
                    string5 = "setCertificateEntry";
                    objectArray = new Object[]{"dummyClientSigner", x509Certificate};
                    wSKeyStoreRemotable.invokeKeyStoreCommand(string5, objectArray, Boolean.TRUE);
                    bl = true;
                }
                if (x509Certificate2 != null) {
                    string5 = "setCertificateEntry";
                    objectArray = new Object[]{"dummyServerSigner", x509Certificate2};
                    wSKeyStoreRemotable.invokeKeyStoreCommand(string5, objectArray, Boolean.TRUE);
                    bl = true;
                }
                if (x509Certificate == null && x509Certificate2 == null) {
                    keyStore = wSKeyStoreRemotable.getKeyStore(false, true);
                    wSKeyStoreRemotable.store();
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception cought " + exception.getMessage());
            }
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CreateKeyStoreFile");
        }
        return bl;
    }

    public static boolean createKeyStoreFile(com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CreateKeyStoreFile");
        }
        WSKeyStoreRemotable wSKeyStoreRemotable = new WSKeyStoreRemotable(keyStore);
        KeyStore keyStore2 = null;
        boolean bl = false;
        X509Certificate x509Certificate = null;
        X509Certificate x509Certificate2 = null;
        String string = keyStore.getHostList();
        if (string != null && string.equals("")) {
            string = null;
        }
        x509Certificate = KeyStoreHelper.getCertFromArmFile("client");
        x509Certificate2 = KeyStoreHelper.getCertFromArmFile("server");
        try {
            String string2 = null;
            Object[] objectArray = null;
            if (string != null) {
                string2 = "createRemoteKeyStore";
                objectArray = new Object[]{keyStore.getName(), keyStore.getType(), keyStore.getProvider(), keyStore.getLocation(), keyStore.getPassword(), "dummyClientSigner", x509Certificate, "dummyServerSigner", x509Certificate2};
                wSKeyStoreRemotable.invokeKeyStoreCommand(string2, objectArray);
                bl = true;
            } else {
                if (x509Certificate != null) {
                    string2 = "setCertificateEntry";
                    objectArray = new Object[]{"dummyClientSigner", x509Certificate};
                    wSKeyStoreRemotable.invokeKeyStoreCommand(string2, objectArray, Boolean.TRUE);
                    bl = true;
                }
                if (x509Certificate2 != null) {
                    string2 = "setCertificateEntry";
                    objectArray = new Object[]{"dummyServerSigner", x509Certificate2};
                    wSKeyStoreRemotable.invokeKeyStoreCommand(string2, objectArray, Boolean.TRUE);
                    bl = true;
                }
                if (x509Certificate == null && x509Certificate2 == null) {
                    keyStore2 = wSKeyStoreRemotable.getKeyStore(false, true);
                    wSKeyStoreRemotable.store();
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception cought " + exception.getMessage());
            }
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CreateKeyStoreFile");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate getCertFromArmFile(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCertFromArmFile");
        }
        String string2 = null;
        String string3 = null;
        X509Certificate x509Certificate = null;
        if (string.equals("server")) {
            string2 = "serverCert.arm";
        } else if (string.equals("client")) {
            string2 = "clientCert.arm";
        } else {
            return null;
        }
        FileInputStream fileInputStream = null;
        String string4 = System.getProperty("user.install.root");
        string3 = string4 + "/etc/" + string2;
        try {
            CertificateFactory certificateFactory = null;
            Collection<? extends Certificate> collection = null;
            fileInputStream = new FileInputStream(string3);
            certificateFactory = CertificateFactory.getInstance("X509");
            collection = certificateFactory.generateCertificates(fileInputStream);
            X509Certificate[] x509CertificateArray = new X509Certificate[collection.size()];
            Iterator<? extends Certificate> iterator = collection.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                x509CertificateArray[n] = (X509Certificate)iterator.next();
                ++n;
            }
            x509Certificate = x509CertificateArray[0];
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string3 + " does not exist.  Certificate will no be used.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCertFromArmFile");
            }
            X509Certificate x509Certificate2 = null;
            return x509Certificate2;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception recieve while trying to get certificate from arm file: " + exception.getMessage());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCertFromArmFile");
            }
            X509Certificate x509Certificate3 = null;
            return x509Certificate3;
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCertFromArmFile");
        }
        return x509Certificate;
    }

    private static String fixLocation(String string, String string2) {
        string2 = string2.replace('\\', '/');
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixLocation", new Object[]{string, string2});
        }
        int n = string2.indexOf("/cells/");
        String string3 = string2;
        if (n != -1) {
            String string4 = string2.substring(n);
            string3 = string + string4;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixLocation -> " + string3);
        }
        return string3;
    }

    public static void changePassword(WSKeyStoreRemotable wSKeyStoreRemotable, String string, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changePassword");
        }
        try {
            String string3 = "aliases";
            Object[] objectArray = null;
            Object[] objectArray2 = wSKeyStoreRemotable.invokeKeyStoreCommand(string3, objectArray);
            for (int i = 0; i < objectArray2.length; ++i) {
                string3 = "isKeyEntry";
                String string4 = (String)objectArray2[i];
                objectArray = new Object[]{string4};
                Object[] objectArray3 = wSKeyStoreRemotable.invokeKeyStoreCommand(string3, objectArray);
                if (!((Boolean)objectArray3[0]).booleanValue()) continue;
                string3 = "getCertificateChain";
                objectArray = new Object[]{string4};
                Object[] objectArray4 = wSKeyStoreRemotable.invokeKeyStoreCommand(string3, objectArray);
                string3 = "getKey";
                objectArray = new Object[]{string4, string.toCharArray()};
                Object[] objectArray5 = wSKeyStoreRemotable.invokeKeyStoreCommand(string3, objectArray);
                if (objectArray4[0] != null && objectArray5[0] != null) {
                    string3 = "setKeyEntryOverwrite";
                    objectArray = new Object[]{string4, (Key)objectArray5[0], string2.toCharArray(), (Certificate[])objectArray4[0]};
                    wSKeyStoreRemotable.invokeKeyStoreCommand(string3, objectArray);
                    Tr.debug(tc, "reset " + string4 + " with new new key store password");
                }
                if (objectArray4[0] != null || objectArray5[0] == null || !(objectArray5[0] instanceof SecretKeySpec)) continue;
                string3 = "setKeyEntryOverwrite";
                objectArray = new Object[]{string4, (Key)objectArray5[0], string2.toCharArray(), null};
                wSKeyStoreRemotable.invokeKeyStoreCommand(string3, objectArray);
            }
            string3 = "store";
            objectArray = new Object[]{string2};
            wSKeyStoreRemotable.invokeKeyStoreCommand(string3, objectArray);
        }
        catch (Exception exception) {
            throw new Exception(exception.getMessage());
        }
    }

    public static void changePasswordPKCS12(KeyStoreInfo keyStoreInfo, String string) throws Exception {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changePasswordPKCS12");
        }
        string2 = keyStoreInfo.getPassword();
        WSKeyStoreRemotable wSKeyStoreRemotable = new WSKeyStoreRemotable(keyStoreInfo);
        string3 = keyStoreInfo.getLocation();
        string3 = KeyStoreManager.getInstance().expand(string3);
        File file = new File(string3);
        String string5 = file.getName();
        File file2 = file.getParentFile();
        File file3 = File.createTempFile(string5, null, file2);
        string4 = file3.getAbsolutePath();
        file3.delete();
        keyStoreInfo.setLocation(string4);
        keyStoreInfo.setPassword(string);
        WSKeyStoreRemotable wSKeyStoreRemotable2 = new WSKeyStoreRemotable(keyStoreInfo);
        Object object = "aliases";
        Object object2 = null;
        Object[] objectArray = wSKeyStoreRemotable.invokeKeyStoreCommand((String)object, (Object[])object2);
        for (int i = 0; i < objectArray.length; ++i) {
            Object[] objectArray2;
            Object[] objectArray3;
            object = "isKeyEntry";
            String string6 = (String)objectArray[i];
            object2 = new Object[]{string6};
            Object[] objectArray4 = wSKeyStoreRemotable.invokeKeyStoreCommand((String)object, (Object[])object2);
            if (((Boolean)objectArray4[0]).booleanValue()) {
                Tr.debug(tc, "key alias " + string6);
                object = "getCertificateChain";
                object2 = new Object[]{string6};
                objectArray3 = wSKeyStoreRemotable.invokeKeyStoreCommand((String)object, (Object[])object2);
                object = "getKey";
                object2 = new Object[]{string6, string2.toCharArray()};
                objectArray2 = wSKeyStoreRemotable.invokeKeyStoreCommand((String)object, (Object[])object2);
                if (objectArray3[0] != null && objectArray2[0] != null) {
                    object = "setKeyEntry";
                    object2 = new Object[]{string6, (Key)objectArray2[0], string.toCharArray(), (Certificate[])objectArray3[0]};
                    wSKeyStoreRemotable2.invokeKeyStoreCommand((String)object, (Object[])object2, Boolean.TRUE);
                    Tr.debug(tc, "reset " + string6 + " with new new key store password");
                }
                if (objectArray3[0] == null && objectArray2[0] != null && objectArray2[0] instanceof SecretKeySpec) {
                    object = "setKeyEntry";
                    object2 = new Object[]{string6, (Key)objectArray2[0], string.toCharArray(), null};
                    wSKeyStoreRemotable2.invokeKeyStoreCommand((String)object, (Object[])object2, Boolean.TRUE);
                }
            }
            if (!((Boolean)(objectArray3 = wSKeyStoreRemotable.invokeKeyStoreCommand((String)(object = "isCertificateEntry"), (Object[])(object2 = new Object[]{string6})))[0]).booleanValue()) continue;
            Tr.debug(tc, "key certificate " + string6);
            object = "getCertificate";
            object2 = new Object[]{string6};
            objectArray2 = wSKeyStoreRemotable.invokeKeyStoreCommand((String)object, (Object[])object2);
            X509Certificate x509Certificate = (X509Certificate)objectArray2[0];
            if (x509Certificate == null) continue;
            object = "setCertificateEntry";
            object2 = new Object[]{string6, x509Certificate};
            wSKeyStoreRemotable2.invokeKeyStoreCommand((String)object, (Object[])object2, Boolean.TRUE);
        }
        if (string4 != null) {
            keyStoreInfo.setLocation(string3);
            object = new File(string3);
            ((File)object).delete();
            object2 = new File(string4);
            ((File)object2).renameTo((File)object);
        }
    }

    public static void changePasswordCMS(KeyStoreInfo keyStoreInfo, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changePasswordCMS");
        }
        try {
            WSKeyStoreRemotable wSKeyStoreRemotable = new WSKeyStoreRemotable(keyStoreInfo);
            String string2 = "store";
            Object[] objectArray = new Object[]{string};
            wSKeyStoreRemotable.invokeKeyStoreCommand(string2, objectArray);
        }
        catch (Exception exception) {
            throw new Exception(exception.getMessage());
        }
    }
}

