/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.migrate;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.keyStores.KeyStoreHelper;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.ManagementScopeData;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;

public class ConvertSSLConfigProvider
extends SimpleCommandProvider {
    private static TraceComponent tc = Tr.register(ConvertSSLConfigProvider.class, "security", "com.ibm.ws.security.admintask.securityDomain");
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());

    public String convertSSLConfig(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertSSLConfig");
        }
        String string = null;
        try {
            CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
            ConfigService configService = commandProviderHelper.getConfigService();
            Session session = abstractAdminCommand.getConfigSession();
            String string2 = (String)abstractAdminCommand.getParameter("sslConversionOption");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sslConversionOption name is " + string2);
            }
            if (string2 != null && !this.validSSLConvstionType(string2)) {
                string = "sslConversionOption is not valid.";
                throw new CommandValidationException(string);
            }
            if (string2.equals("CONVERT_SSLCONFIGS")) {
                StringBuffer stringBuffer = this.convertSSLConfigurations(session, configService);
            }
            if (string2.equals("CONVERT_TO_DEFAULT")) {
                string = this.convertToDefaultConfig(session, configService);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.commands.securityDomain.SecurityConfigProvider", "198");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", exception);
            }
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertSSLConfig");
        }
        return string;
    }

    private boolean validSSLConvstionType(String string) {
        return string.equalsIgnoreCase("CONVERT_SSLCONFIGS") || string.equalsIgnoreCase("CONVERT_TO_DEFAULT");
    }

    private String convertToDefaultConfig(Session session, ConfigService configService) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertToDefaultConfig");
        }
        ObjectName objectName = null;
        ObjectName objectName2 = null;
        String string = null;
        boolean bl = false;
        String string2 = null;
        try {
            String string3;
            Object object;
            objectName2 = configService.resolve(session, "Cell=")[0];
            objectName = configService.resolve(session, "Cell=:Security=")[0];
            ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName2, ConfigServiceHelper.createObjectName(null, "ServerEntry"), null);
            for (int i = 0; i < objectNameArray.length; ++i) {
                ObjectName objectName3 = objectNameArray[i];
                object = (String)configService.getAttribute(session, objectName3, "serverType");
                if (object == null || !((String)object).equals("DEPLOYMENT_MANAGER")) continue;
                bl = true;
                string = this.buildScopeName(session, configService, null, "cell");
                this.checkSSLConfigExistsCreateIfNot(session, configService, objectName, "CellDefaultSSLSettings", string, bl);
                break;
            }
            ObjectName[] objectNameArray2 = configService.resolve(session, "Cell=:Node=");
            for (int i = 0; i < objectNameArray2.length; ++i) {
                object = objectNameArray2[i];
                boolean bl2 = false;
                ObjectName objectName4 = ConfigServiceHelper.createObjectName(null, "ServerEntry");
                ObjectName[] objectNameArray3 = configService.queryConfigObjects(session, (ObjectName)object, objectName4, null);
                for (int j = 0; j < objectNameArray3.length; ++j) {
                    String string4 = (String)configService.getAttribute(session, objectNameArray3[j], "serverType");
                    if (!string4.equals("DEPLOYMENT_MANAGER")) continue;
                    bl2 = true;
                }
                String string5 = (String)configService.getAttribute(session, (ObjectName)object, CommandConstants.NAME);
                if (!this.isNodeValid(string5, session)) continue;
                if (!bl2 && (string = this.buildScopeName(session, configService, string5, "Node")) != null) {
                    this.checkSSLConfigExistsCreateIfNot(session, configService, objectName, "NodeDefaultSSLSettings", string, bl);
                }
                this.removeSSLReferences(session, configService, (ObjectName)object);
            }
            if (bl) {
                this.addSignerToCommonTrustStore(session, configService, objectName);
            }
            if ((string3 = System.getProperty("com.ibm.SOAP.ConfigURL")) != null) {
                ConvertSSLConfigProvider.updateProperyFile(string3);
            }
            string2 = "The server's ssl configuration has been converted.   For client command to access the newly converted server you will need to edit the soap.client.props files for the nodes.  The com.ibm.ssl.keyStore, com.ibm.ws.trustStore, com.ibm.ssl.keyStorePassword, com.ibm.ssl.trustStorePassword, and com.ibm.ssl.contextProvider will need to be removed.   The com.ibm.ssl.alias property will need to be set to the default ssl configuration alais in the ssl.client.props file.";
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.commands.SSLConfig.ConvertSSLConfigProvider", "237");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", exception);
            }
            throw exception;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "convertToDefaultConfig");
            }
        }
        return string2;
    }

    public StringBuffer convertSSLConfigurations(Session session, ConfigService configService) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertSSLConfigurations");
        }
        ObjectName objectName = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            objectName = configService.resolve(session, "Cell=:Security=")[0];
            List list = (List)configService.getAttribute(session, objectName, CommandConstants.REPERTOIRE);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string;
                Object object;
                Object object2;
                AttributeList attributeList = (AttributeList)iterator.next();
                ObjectName objectName2 = null;
                ObjectName objectName3 = null;
                ObjectName objectName4 = null;
                ObjectName objectName5 = null;
                ObjectName objectName6 = null;
                String string2 = null;
                String string3 = null;
                String string4 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "alias");
                objectName4 = (ObjectName)ConfigServiceHelper.getAttributeValue(attributeList, "managementScope");
                if (string4.endsWith("/DefaultSSLSettings") && !this.isNodeValid((String)(object2 = string4.substring(0, string4.indexOf("/DefaultSSLSettings"))), session)) continue;
                object2 = (AttributeList)ConfigServiceHelper.getAttributeValue(attributeList, CommandConstants.SETTING);
                AttributeList attributeList2 = new AttributeList();
                if (objectName4 == null) {
                    object = ConfigServiceHelper.createObjectName(attributeList);
                    objectName4 = this.getScopeForThisConfig(session, configService, objectName, attributeList);
                    attributeList2.add(new Attribute(CommandConstants.MANAGEMENT_SCOPE, objectName4));
                    configService.setAttributes(session, (ObjectName)object, attributeList2);
                    attributeList2.clear();
                }
                if ((object = (String)ConfigServiceHelper.getAttributeValue((AttributeList)object2, "keyFileName")) == null) continue;
                String string5 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)object2, "keyFilePassword");
                String string6 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)object2, "keyFileFormat");
                if (string5 != null && string6 != null) {
                    objectName2 = this.findOrCreateKSObj(session, configService, objectName, (String)object, string5, string6, objectName4);
                }
                if ((string = (String)ConfigServiceHelper.getAttributeValue((AttributeList)object2, "trustFileName")) != null) {
                    string5 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)object2, "trustFilePassword");
                    string6 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)object2, "trustFileFormat");
                    if (string5 != null && string6 != null) {
                        objectName3 = this.findOrCreateKSObj(session, configService, objectName, string, string5, string6, objectName4);
                    }
                }
                ObjectName objectName7 = this.findOrCreateKeyManager(session, configService, objectName, objectName4);
                List list2 = this.findOrCreateTrustManager(session, configService, objectName, objectName4);
                ObjectName objectName8 = configService.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName((AttributeList)object2), null)[0];
                AttributeList attributeList3 = configService.getAttributes(session, objectName8, new String[]{"properties"}, false);
                List list3 = (List)((Attribute)attributeList3.get(0)).getValue();
                Iterator iterator2 = list3.iterator();
                while (iterator2.hasNext()) {
                    ObjectName objectName9 = (ObjectName)iterator2.next();
                    String string7 = (String)configService.getAttribute(session, objectName9, "name");
                    if (string7.equals("com.ibm.ssl.contextProvider")) {
                        objectName5 = objectName9;
                        string2 = (String)configService.getAttribute(session, objectName9, "value");
                    }
                    if (!string7.equals("com.ibm.ssl.protocol")) continue;
                    objectName6 = objectName9;
                    string3 = (String)configService.getAttribute(session, objectName9, "value");
                }
                if (objectName2 != null) {
                    attributeList2.add(new Attribute(CommandConstants.KEY_STORE, objectName2));
                }
                if (objectName3 != null) {
                    attributeList2.add(new Attribute(CommandConstants.TRUST_STORE, objectName3));
                }
                if (objectName7 != null) {
                    attributeList2.add(new Attribute(CommandConstants.KEY_MANAGER, objectName7));
                }
                if (!list2.isEmpty()) {
                    attributeList2.add(new Attribute(CommandConstants.TRUST_MANAGER, list2));
                }
                if (string2 != null) {
                    attributeList2.add(new Attribute(CommandConstants.JSSE_PROVIDER, string2));
                }
                if (string3 != null) {
                    attributeList2.add(new Attribute(CommandConstants.SSL_PROTOCOL, string3));
                }
                attributeList2.add(new Attribute("keyFileName", null));
                attributeList2.add(new Attribute("keyFilePassword", null));
                attributeList2.add(new Attribute("keyFileFormat", null));
                attributeList2.add(new Attribute("trustFileName", null));
                attributeList2.add(new Attribute("trustFilePassword", null));
                attributeList2.add(new Attribute("trustFileFormat", null));
                configService.setAttributes(session, objectName8, attributeList2);
                if (objectName5 != null) {
                    configService.deleteConfigData(session, objectName5);
                }
                if (objectName6 != null) {
                    configService.deleteConfigData(session, objectName6);
                }
                stringBuffer.append(string4);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.commands.securityDomain.SecurityConfigProvider", "290");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", exception);
            }
            throw exception;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "convertSSLConfigurations");
            }
        }
        return stringBuffer;
    }

    private List findOrCreateTrustManager(Session session, ConfigService configService, ObjectName objectName, ObjectName objectName2) throws ConfigServiceException, ConnectorException, AttributeNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findOrCreateTrustManager", new Object[]{objectName, objectName2});
        }
        ObjectName objectName3 = null;
        ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>();
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, ConfigServiceHelper.createObjectName(null, "TrustManager"), null);
        for (int i = 0; i < objectNameArray.length; ++i) {
            ObjectName objectName4 = objectNameArray[i];
            String string = (String)configService.getAttribute(session, objectName4, CommandConstants.NAME);
            if (!string.equals("IbmX509")) continue;
            objectName3 = objectName4;
            break;
        }
        if (objectName3 == null) {
            AttributeList attributeList = new AttributeList();
            attributeList.add(new Attribute(CommandConstants.NAME, "IbmX509"));
            attributeList.add(new Attribute(CommandConstants.PROVIDER, "IBMJSSE2"));
            attributeList.add(new Attribute(CommandConstants.ALGORITHM, "IbmX509"));
            attributeList.add(new Attribute(CommandConstants.MANAGEMENT_SCOPE, objectName2));
            objectName3 = configService.createConfigData(session, objectName, CommandConstants.TRUST_MANAGERS, null, attributeList);
        }
        arrayList.add(objectName3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findOrCreateTrustManager", new Object[]{arrayList});
        }
        return arrayList;
    }

    private ObjectName findOrCreateKeyManager(Session session, ConfigService configService, ObjectName objectName, ObjectName objectName2) throws ConfigServiceException, ConnectorException, AttributeNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findOrCreateKeyManager", new Object[]{objectName, objectName2});
        }
        ObjectName objectName3 = null;
        List list = (List)configService.getAttribute(session, objectName, CommandConstants.KEY_MANAGERS);
        Object object = list.iterator();
        while (object.hasNext()) {
            AttributeList attributeList = (AttributeList)object.next();
            String string = (String)ConfigServiceHelper.getAttributeValue(attributeList, CommandConstants.NAME);
            if (!string.equals("IbmX509")) continue;
            objectName3 = ConfigServiceHelper.createObjectName(attributeList);
            break;
        }
        if (objectName3 == null) {
            object = new AttributeList();
            ((AttributeList)object).add(new Attribute(CommandConstants.NAME, "IbmX509"));
            ((AttributeList)object).add(new Attribute(CommandConstants.PROVIDER, "IBMJSSE2"));
            ((AttributeList)object).add(new Attribute(CommandConstants.ALGORITHM, "IbmX509"));
            ((AttributeList)object).add(new Attribute(CommandConstants.MANAGEMENT_SCOPE, objectName2));
            objectName3 = configService.createConfigData(session, objectName, CommandConstants.KEY_MANAGERS, null, (AttributeList)object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findOrCreateKeyManager", new Object[]{objectName3});
        }
        return objectName3;
    }

    private ObjectName findOrCreateKSObj(Session session, ConfigService configService, ObjectName objectName, String string, String string2, String string3, ObjectName objectName2) throws Exception {
        Object object;
        Object object2;
        Object object3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findOrCreateKSObj", new Object[]{objectName, string, string3, objectName2});
        }
        ObjectName objectName3 = null;
        List list = (List)configService.getAttribute(session, objectName, CommandConstants.KEY_STORES);
        String string4 = (String)configService.getAttribute(session, objectName2, CommandConstants.SCOPE_NAME);
        Object object4 = list.iterator();
        while (object4.hasNext()) {
            CommandHelper commandHelper;
            object3 = (AttributeList)object4.next();
            if (string == null || string3 == null || string2 == null) continue;
            object2 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)object3, "location");
            object = (String)ConfigServiceHelper.getAttributeValue((AttributeList)object3, "type");
            String string5 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)object3, "password");
            if (!string.equals(object2) || !string3.equals(object) || !string2.equals(string5) || !(commandHelper = new CommandHelper()).withInScope(configService, session, (AttributeList)object3, string4)) continue;
            objectName3 = ConfigServiceHelper.createObjectName((AttributeList)object3);
            break;
        }
        object4 = string.substring(string.lastIndexOf("/") + 1);
        object3 = "IBMJCE";
        if (string3.equals("CMSKS")) {
            object3 = "IBMCMSProvider";
        } else if (string3.equals("IBMi5OSKeyStore")) {
            object3 = "IBMi5OSJSSEProvider";
        } else if (string3.equals("PKCS11")) {
            object3 = "PKCS11";
        }
        object2 = new KeyStoreInfo((String)object4, string, string2, (String)object3, string3, Boolean.TRUE, null, string4, objectName2, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, null, null, null);
        if (objectName3 == null) {
            object = KeyStoreHelper.createKeyStoreAttrList((KeyStoreInfo)object2);
            objectName3 = configService.createConfigData(session, objectName, "keyStores", null, (AttributeList)object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findOrCreateKSObj", new Object[]{objectName3});
        }
        return objectName3;
    }

    private ObjectName makeDefaultKSObj(Session session, ConfigService configService, ObjectName objectName, String string, String string2, String string3, ObjectName objectName2, String string4) throws Exception {
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "makeDefaultKSObj", new Object[]{objectName, string, string3, objectName2, string4});
        }
        Serializable serializable2 = null;
        String string5 = (String)configService.getAttribute(session, objectName2, CommandConstants.SCOPE_NAME);
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, ConfigServiceHelper.createObjectName(null, "KeyStore"), null);
        for (int i = 0; i < objectNameArray.length; ++i) {
            ObjectName objectName3;
            String string6;
            String string7;
            serializable = objectNameArray[i];
            if (string4 == null || !string4.equals(string7 = (String)configService.getAttribute(session, (ObjectName)serializable, CommandConstants.NAME)) || !string5.equals(string6 = (String)configService.getAttribute(session, objectName3 = (ObjectName)configService.getAttribute(session, (ObjectName)serializable, CommandConstants.MANAGEMENT_SCOPE), CommandConstants.SCOPE_NAME))) continue;
            serializable2 = serializable;
            break;
        }
        String string8 = "IBMJCE";
        if (string3.equals("CMSKS")) {
            string8 = "IBMCMSProvider";
        } else if (string3.equals("IBMi5OSKeyStore")) {
            string8 = "IBMi5OSJSSEProvider";
        } else if (string3.equals("PKCS11")) {
            string8 = "PKCS11";
        }
        serializable = new AttributeList();
        if (string4 != null) {
            ((AttributeList)serializable).add(new Attribute("name", string4));
        }
        if (string != null) {
            ((AttributeList)serializable).add(new Attribute("location", string));
        }
        if (string3 != null) {
            ((AttributeList)serializable).add(new Attribute("type", string3));
        }
        if (string2 != null) {
            ((AttributeList)serializable).add(new Attribute("password", string2));
        }
        if (string8 != null) {
            ((AttributeList)serializable).add(new Attribute("provider", string8));
        }
        ((AttributeList)serializable).add(new Attribute("fileBased", Boolean.TRUE));
        ((AttributeList)serializable).add(new Attribute("readOnly", Boolean.FALSE));
        ((AttributeList)serializable).add(new Attribute("initializeAtStartup", Boolean.FALSE));
        if (objectName2 != null) {
            ((AttributeList)serializable).add(new Attribute(CommandConstants.MANAGEMENT_SCOPE, objectName2));
        }
        if (serializable2 != null) {
            configService.setAttributes(session, (ObjectName)serializable2, (AttributeList)serializable);
        } else {
            serializable2 = configService.createConfigData(session, objectName, "keyStores", null, (AttributeList)serializable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makeDefaultKSObj", new Object[]{serializable2});
        }
        return serializable2;
    }

    private void findOrCreateSSLConfigGroup(Session session, ConfigService configService, ObjectName objectName, ObjectName objectName2, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findOrCreateSSLConfigGroup", new Object[]{objectName, objectName2});
        }
        String string2 = null;
        boolean bl = false;
        boolean bl2 = false;
        ManagementScopeData managementScopeData = new ManagementScopeData(string);
        String string3 = managementScopeData.getScopeType();
        if (string3 != null && string3.equalsIgnoreCase("cell")) {
            string2 = managementScopeData.getCellName();
        } else if (string3 != null && string3.equalsIgnoreCase("node")) {
            string2 = managementScopeData.getNodeName();
        } else {
            return;
        }
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, ConfigServiceHelper.createObjectName(null, "SSLConfigGroup"), null);
        for (int i = 0; i < objectNameArray.length; ++i) {
            ObjectName objectName3 = objectNameArray[i];
            String string4 = (String)configService.getAttribute(session, objectName3, "name");
            if (!string4.equals(string2)) continue;
            String string5 = (String)configService.getAttribute(session, objectName3, "direction");
            if (string5.equals("inbound")) {
                bl = true;
            }
            if (!string5.equals("outbound")) continue;
            bl2 = true;
        }
        if (!bl) {
            AttributeList attributeList = new AttributeList();
            attributeList.add(new Attribute(CommandConstants.NAME, string2));
            attributeList.add(new Attribute(CommandConstants.DIRECTION, "inbound"));
            attributeList.add(new Attribute(CommandConstants.SSL_CONFIG, objectName2));
            attributeList.add(new Attribute(CommandConstants.MANAGEMENT_SCOPE, (ObjectName)configService.getAttribute(session, objectName2, CommandConstants.MANAGEMENT_SCOPE)));
            configService.createConfigData(session, objectName, CommandConstants.SSL_CONFIG_GROUPS, null, attributeList);
        }
        if (!bl2) {
            AttributeList attributeList = new AttributeList();
            attributeList.add(new Attribute(CommandConstants.NAME, string2));
            attributeList.add(new Attribute(CommandConstants.DIRECTION, "outbound"));
            attributeList.add(new Attribute(CommandConstants.SSL_CONFIG, objectName2));
            attributeList.add(new Attribute(CommandConstants.MANAGEMENT_SCOPE, (ObjectName)configService.getAttribute(session, objectName2, CommandConstants.MANAGEMENT_SCOPE)));
            configService.createConfigData(session, objectName, CommandConstants.SSL_CONFIG_GROUPS, null, attributeList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findOrCreateSSLConfigGroup");
        }
    }

    private ObjectName getScopeForThisConfig(Session session, ConfigService configService, ObjectName objectName, AttributeList attributeList) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getScopeForThisConfig");
        }
        ObjectName objectName2 = null;
        String string = this.defaultScope(session, configService);
        ManagementScopeData managementScopeData = new ManagementScopeData(string);
        String string2 = (String)ConfigServiceHelper.getAttributeValue(attributeList, CommandConstants.ALIAS);
        try {
            if (string2.endsWith("/DefaultSSLSettings")) {
                String string3 = managementScopeData.getScopeType();
                if (string3.equalsIgnoreCase("cell")) {
                    String string4 = string2.substring(0, string2.indexOf("/DefaultSSLSettings"));
                    if (string4 != null) {
                        objectName2 = this.getScopeForSSLConfig(session, configService, objectName, string4);
                    }
                    if (objectName2 == null) {
                        objectName2 = this.getScopeObject(session, configService, objectName, string, string3);
                    }
                } else {
                    objectName2 = this.getScopeObject(session, configService, objectName, string, string3);
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.commands.securityDomain.SecurityConfigProvider", "759");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", exception);
            }
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getScopeForThisConfig", new Object[]{objectName2});
        }
        return objectName2;
    }

    private ObjectName getScopeForSSLConfig(Session session, ConfigService configService, ObjectName objectName, String string) throws Exception {
        ObjectName objectName2 = null;
        try {
            ObjectName objectName3;
            ObjectName[] objectNameArray = configService.resolve(session, "Cell=:Node=" + string);
            if (objectNameArray != null && objectNameArray.length > 0 && (objectName3 = objectNameArray[0]) != null) {
                String string2;
                boolean bl = false;
                ObjectName objectName4 = ConfigServiceHelper.createObjectName(null, "ServerEntry");
                ObjectName[] objectNameArray2 = configService.queryConfigObjects(session, objectName3, objectName4, null);
                for (int i = 0; i < objectNameArray2.length; ++i) {
                    string2 = (String)configService.getAttribute(session, objectNameArray2[i], "serverType");
                    if (!string2.equals("DEPLOYMENT_MANAGER")) continue;
                    bl = true;
                }
                ObjectName objectName5 = configService.resolve(session, "Cell=")[0];
                if (objectName5 != null && (string2 = ConfigServiceHelper.getDisplayName(objectName5)) != null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("(cell):");
                    stringBuffer.append(string2);
                    if (!bl) {
                        stringBuffer.append(":(node):");
                        stringBuffer.append(string);
                    }
                    String string3 = stringBuffer.toString();
                    objectName2 = this.getScopeObject(session, configService, objectName, string3, "node");
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.commands.securityDomain.SecurityConfigProvider", "198");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", exception);
            }
            throw exception;
        }
        return objectName2;
    }

    private ObjectName getScopeObject(Session session, ConfigService configService, ObjectName objectName, String string, String string2) throws ConfigServiceException, ConnectorException, AttributeNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getScopeObject", new Object[]{objectName, string, string2});
        }
        ObjectName objectName2 = null;
        List list = (List)configService.getAttribute(session, objectName, CommandConstants.MANAGEMENT_SCOPES);
        Object object = list.iterator();
        while (object.hasNext()) {
            AttributeList attributeList = (AttributeList)object.next();
            String string3 = (String)ConfigServiceHelper.getAttributeValue(attributeList, CommandConstants.SCOPE_NAME);
            if (!string3.equals(string)) continue;
            objectName2 = ConfigServiceHelper.createObjectName(attributeList);
            break;
        }
        if (objectName2 == null) {
            object = new AttributeList();
            ((AttributeList)object).add(new Attribute(CommandConstants.SCOPE_NAME, string));
            ((AttributeList)object).add(new Attribute(CommandConstants.SCOPE_TYPE, string2));
            objectName2 = configService.createConfigData(session, objectName, CommandConstants.MANAGEMENT_SCOPES, null, (AttributeList)object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getScopeObject", new Object[]{objectName2});
        }
        return objectName2;
    }

    private ObjectName checkSSLConfigExistsCreateIfNot(Session session, ConfigService configService, ObjectName objectName, String string, String string2, boolean bl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkSSLConfigExistsCreateIfNot", new Object[]{objectName, string, string2});
        }
        ObjectName objectName2 = null;
        try {
            List list = (List)configService.getAttribute(session, objectName, CommandConstants.REPERTOIRE);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string3;
                AttributeList attributeList = (AttributeList)iterator.next();
                String string4 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "alias");
                ObjectName objectName3 = (ObjectName)ConfigServiceHelper.getAttributeValue(attributeList, "managementScope");
                if (!string4.equals(string) || !(string3 = (String)configService.getAttribute(session, objectName3, "scopeName")).equals(string2)) continue;
                objectName2 = ConfigServiceHelper.createObjectName(attributeList);
                break;
            }
            objectName2 = this.createTheSSLConfig(session, configService, objectName, string, string2, objectName2, bl, true);
            this.findOrCreateSSLConfigGroup(session, configService, objectName, objectName2, string2);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.commands.SSLConfig.ConvertSSLConfigProvider", "893");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", exception);
            }
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkSSLConfigExistsCreateIfNot", new Object[]{objectName2});
        }
        return objectName2;
    }

    private ObjectName createTheSSLConfig(Session session, ConfigService configService, ObjectName objectName, String string, String string2, ObjectName objectName2, boolean bl, boolean bl2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTheSSLConfig", new Object[]{objectName, string, string2});
        }
        AttributeList attributeList = new AttributeList();
        String string3 = null;
        ObjectName objectName3 = null;
        ObjectName objectName4 = null;
        ObjectName objectName5 = null;
        try {
            ManagementScopeData managementScopeData = new ManagementScopeData(string2);
            if (string != null) {
                if (string2 != null && (objectName5 = this.getScopeObject(session, configService, objectName, string2, string3 = managementScopeData.getScopeType())) != null) {
                    attributeList.add(new Attribute(CommandConstants.MANAGEMENT_SCOPE, objectName5));
                }
                if (objectName2 != null) {
                    objectName4 = configService.queryConfigObjects(session, objectName2, ConfigServiceHelper.createObjectName(null, "SecureSocketLayer"), null)[0];
                    objectName3 = objectName2;
                } else {
                    attributeList.add(new Attribute(CommandConstants.ALIAS, string + "1"));
                    objectName2 = configService.createConfigData(session, objectName, CommandConstants.REPERTOIRE, null, attributeList);
                    attributeList.clear();
                    attributeList.add(new Attribute(CommandConstants.ALIAS, string));
                    configService.setAttributes(session, objectName2, attributeList);
                    objectName3 = objectName2;
                }
                if (objectName3 != null) {
                    String string4 = null;
                    String string5 = null;
                    String string6 = null;
                    String string7 = null;
                    ObjectName objectName6 = null;
                    ObjectName objectName7 = null;
                    List list = null;
                    ObjectName objectName8 = null;
                    ObjectName objectName9 = this.getScopeObject(session, configService, objectName, string2, string3);
                    String string8 = "(cell):" + managementScopeData.getCellName();
                    ObjectName objectName10 = this.getScopeObject(session, configService, objectName, string8, "cell");
                    attributeList.clear();
                    if (string3.equalsIgnoreCase("cell")) {
                        string6 = "CellDefaultKeyStore";
                        string7 = "CellDefaultTrustStore";
                        string5 = "${CONFIG_ROOT}/cells/" + managementScopeData.getCellName() + "/trust.p12";
                        string4 = "${CONFIG_ROOT}/cells/" + managementScopeData.getCellName() + "/key.p12";
                    } else {
                        string6 = "NodeDefaultKeyStore";
                        string7 = "NodeDefaultTrustStore";
                        string4 = "${CONFIG_ROOT}/cells/" + managementScopeData.getCellName() + "/nodes/" + managementScopeData.getNodeName() + "/key.p12";
                        string5 = "${CONFIG_ROOT}/cells/" + managementScopeData.getCellName() + "/nodes/" + managementScopeData.getNodeName() + "/trust.p12";
                    }
                    objectName6 = this.makeDefaultKSObj(session, configService, objectName, string4, "WebAS", "PKCS12", objectName9, string6);
                    objectName7 = this.makeDefaultKSObj(session, configService, objectName, string5, "WebAS", "PKCS12", objectName9, string7);
                    if (bl) {
                        objectName7 = this.makeDefaultKSObj(session, configService, objectName, "${CONFIG_ROOT}/cells/" + managementScopeData.getCellName() + "/trust.p12", "WebAS", "PKCS12", objectName10, "CellDefaultTrustStore");
                    }
                    list = this.findOrCreateTrustManager(session, configService, objectName, objectName9);
                    objectName8 = this.findOrCreateKeyManager(session, configService, objectName, objectName9);
                    attributeList.clear();
                    if (objectName6 != null) {
                        attributeList.add(new Attribute(CommandConstants.KEY_STORE, objectName6));
                    }
                    if (objectName7 != null) {
                        attributeList.add(new Attribute(CommandConstants.TRUST_STORE, objectName7));
                    }
                    if (objectName8 != null) {
                        attributeList.add(new Attribute(CommandConstants.KEY_MANAGER, objectName8));
                    }
                    if (!list.isEmpty()) {
                        attributeList.add(new Attribute(CommandConstants.TRUST_MANAGER, list));
                    }
                    attributeList.add(new Attribute(CommandConstants.JSSE_PROVIDER, "IBMJSSE2"));
                    attributeList.add(new Attribute(CommandConstants.SSL_PROTOCOL, "SSL_TLS"));
                    attributeList.add(new Attribute(CommandConstants.CLIENT_AUTHENTICATION, Boolean.FALSE));
                    attributeList.add(new Attribute(CommandConstants.SECURITY_LEVEL, "HIGH"));
                    if (objectName4 != null) {
                        configService.setAttributes(session, objectName4, attributeList);
                    } else {
                        configService.createConfigData(session, objectName3, CommandConstants.SETTING, null, attributeList);
                    }
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.commands.SSLConfig.ConvertSSLConfigProvider", "1029");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", exception);
            }
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTheSSLConfig", new Object[]{objectName3});
        }
        return objectName3;
    }

    private String buildScopeName(Session session, ConfigService configService, String string, String string2) throws ConfigServiceException, ConnectorException {
        ObjectName objectName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildScopeName", new Object[]{string, string2});
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = null;
        String string4 = null;
        ObjectName objectName2 = configService.resolve(session, "Cell=")[0];
        if (objectName2 != null) {
            string4 = ConfigServiceHelper.getDisplayName(objectName2);
        }
        if (string2.equalsIgnoreCase("cell")) {
            stringBuffer.append("(cell):");
            stringBuffer.append(string4);
            string3 = stringBuffer.toString();
        } else if (string2.equals("Node") && (objectName = configService.resolve(session, "Cell=:Node=" + string)[0]) != null && string4 != null) {
            stringBuffer.append("(cell):");
            stringBuffer.append(string4);
            stringBuffer.append(":(node):");
            stringBuffer.append(string);
            string3 = stringBuffer.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildScopeName", new Object[]{string3});
        }
        return string3;
    }

    private String defaultScope(Session session, ConfigService configService) throws Exception {
        String string = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "defaultScope");
        }
        try {
            ObjectName objectName = configService.resolve(session, "Cell=")[0];
            if (objectName != null) {
                ObjectName objectName2;
                String string2 = (String)configService.getAttribute(session, objectName, "cellType");
                String string3 = (String)configService.getAttribute(session, objectName, "name");
                string = "(cell):" + string3;
                if (string2.equals("STANDALONE") && (objectName2 = configService.resolve(session, "Node=")[0]) != null) {
                    String string4 = (String)configService.getAttribute(session, objectName, "name");
                    string = string + ":(node):" + string4;
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.commands.securityDomain.SecurityConfigProvider", "198");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", exception);
            }
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "defaultScope", string);
        }
        return string;
    }

    private boolean isNodeValid(String string, Session session) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isNodeValid", string);
        }
        boolean bl = true;
        try {
            Properties properties = new Properties();
            properties.setProperty("CONFIG_SESSION", session.toString());
            ManagedObjectMetadataAccessor managedObjectMetadataAccessor = ManagedObjectMetadataAccessorFactory.createAccessor(properties);
            ManagedObjectMetadataHelper managedObjectMetadataHelper = new ManagedObjectMetadataHelper(managedObjectMetadataAccessor);
            if (string != null) {
                String string2 = managedObjectMetadataHelper.getNodeBaseProductVersion(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Node product version is " + string2);
                }
                String string3 = managedObjectMetadataHelper.getNodeMajorVersion(string);
                String string4 = managedObjectMetadataHelper.getNodeMinorVersion(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "nodeMajorVersion is " + string3 + " nodeMinorVersion is " + string4);
                }
                int n = Integer.parseInt(string3);
                int n2 = Integer.parseInt(string4);
                if (n < 7 && (n != 6 || n2 < 1)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Resource is not a version 6.1 or above resource.  Version is " + string2);
                    }
                    bl = false;
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.commands.securityDomain.SecurityConfigProvider", "1146");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Node is not valid ", exception.getMessage());
            }
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isNodeValid", new Boolean(bl));
        }
        return bl;
    }

    private void removeSSLReferences(Session session, ConfigService configService, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeSSLReferences", objectName);
        }
        try {
            ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, ConfigServiceHelper.createObjectName(null, "Server"), null);
            for (int i = 0; i < objectNameArray.length; ++i) {
                Object object;
                Object object2;
                ObjectName[] objectNameArray2;
                Object object3;
                AttributeList attributeList;
                ObjectName objectName2 = objectNameArray[i];
                ObjectName[] objectNameArray3 = configService.queryConfigObjects(session, objectName2, ConfigServiceHelper.createObjectName(null, "SOAPConnector"), null);
                if (objectNameArray3 != null && objectNameArray3.length > 0) {
                    attributeList = configService.getAttributes(session, objectNameArray3[0], new String[]{"properties"}, false);
                    object3 = (List)((Attribute)attributeList.get(0)).getValue();
                    objectNameArray2 = object3.iterator();
                    while (objectNameArray2.hasNext()) {
                        object2 = (ObjectName)objectNameArray2.next();
                        object = (String)configService.getAttribute(session, (ObjectName)object2, "name");
                        if (!((String)object).equals("sslConfig")) continue;
                        configService.deleteConfigData(session, (ObjectName)object2);
                        break;
                    }
                }
                attributeList = new AttributeList();
                attributeList.add(new Attribute("sslConfigAlias", null));
                object3 = configService.queryConfigObjects(session, objectName2, ConfigServiceHelper.createObjectName(null, "SSLInboundChannel"), null);
                for (int j = 0; j < ((ObjectName[])object3).length; ++j) {
                    object2 = object3[j];
                    configService.setAttributes(session, (ObjectName)object2, attributeList);
                }
                objectNameArray2 = configService.queryConfigObjects(session, objectName2, ConfigServiceHelper.createObjectName(null, "SSLOutboundChannel"), null);
                for (int j = 0; j < objectNameArray2.length; ++j) {
                    object = objectNameArray2[j];
                    configService.setAttributes(session, (ObjectName)object, attributeList);
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.commands.SSLConfig.ConvertSSLConfigProvider", "1204");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught while clearing ssl config references from server", exception);
            }
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeSSLReferences");
        }
    }

    private void addSignerToCommonTrustStore(Session session, ConfigService configService, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addSignerToCommonTrustStore");
        }
        Object var4_4 = null;
        try {
            Object object;
            Object[] objectArray;
            Object object2;
            Object object3;
            Object object4;
            Object[] objectArray2;
            Object object5;
            Serializable serializable;
            String string;
            Object object6;
            Object object7;
            Object object8;
            Object object9;
            CommandHelper commandHelper = new CommandHelper();
            String string2 = this.buildScopeName(session, configService, null, "cell");
            KeyStoreInfo keyStoreInfo = PersonalCertificateHelper.getKsInfo(session, configService, "CellDefaultTrustStore", string2);
            WSKeyStoreRemotable wSKeyStoreRemotable = new WSKeyStoreRemotable(keyStoreInfo);
            ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, ConfigServiceHelper.createObjectName(null, "KeyStore"), null);
            for (int i = 0; i < objectNameArray.length; ++i) {
                ObjectName objectName2 = objectNameArray[i];
                object9 = (String)configService.getAttribute(session, objectName2, CommandConstants.NAME);
                if (!((String)object9).endsWith("DefaultKeyStore") && !((String)object9).endsWith("DefaultTrustStore") || (object8 = ((WSKeyStoreRemotable)(object7 = new WSKeyStoreRemotable((KeyStoreInfo)(object6 = PersonalCertificateHelper.getKsInfo(session, configService, (String)object9, string = (String)configService.getAttribute(session, (ObjectName)(serializable = (ObjectName)configService.getAttribute(session, objectName2, CommandConstants.MANAGEMENT_SCOPE)), CommandConstants.SCOPE_NAME)))))).invokeKeyStoreCommand((String)(object5 = "aliases"), objectArray2 = null)) == null) continue;
                for (int j = 0; j < ((Object[])object8).length; ++j) {
                    object4 = (String)object8[j];
                    object5 = "isKeyEntry";
                    objectArray2 = new Object[]{object4};
                    object3 = ((WSKeyStoreRemotable)object7).invokeKeyStoreCommand((String)object5, objectArray2);
                    object5 = "isCertificateEntry";
                    objectArray2 = new Object[]{object4};
                    object2 = ((WSKeyStoreRemotable)object7).invokeKeyStoreCommand((String)object5, objectArray2);
                    if (!((Boolean)object3[0]).booleanValue() && !((Boolean)object2[0]).booleanValue()) continue;
                    object5 = "getCertificate";
                    objectArray2 = new Object[]{object4};
                    objectArray = ((WSKeyStoreRemotable)object7).invokeKeyStoreCommand((String)object5, objectArray2);
                    object = (X509Certificate)objectArray[0];
                    object5 = "setCertificateEntry";
                    objectArray2 = new Object[]{object4, object};
                    wSKeyStoreRemotable.invokeKeyStoreCommand((String)object5, objectArray2);
                }
            }
            ObjectName[] objectNameArray2 = configService.queryConfigObjects(session, objectName, ConfigServiceHelper.createObjectName(null, "SSLConfig"), null);
            for (int i = 0; i < objectNameArray2.length; ++i) {
                Object object10;
                object9 = objectNameArray2[i];
                serializable = (AttributeList)configService.getAttribute(session, (ObjectName)object9, "setting");
                string = (String)ConfigServiceHelper.getAttributeValue((AttributeList)serializable, "keyFileName");
                object6 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)serializable, "keyFilePassword");
                object7 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)serializable, "keyFileFormat");
                if (string != null && object6 != null && object7 != null) {
                    object5 = WSKeyStore.loadKeyStore(KeyStoreManager.getInstance().expand(string), (String)object7, (String)object6);
                    objectArray2 = ((KeyStore)object5).aliases();
                    while (objectArray2.hasMoreElements()) {
                        object8 = (String)objectArray2.nextElement();
                        if (!((KeyStore)object5).isKeyEntry((String)object8)) continue;
                        object10 = (X509Certificate)((KeyStore)object5).getCertificate((String)object8);
                        object4 = "setCertificateEntry";
                        object3 = new Object[]{object8, object10};
                        wSKeyStoreRemotable.invokeKeyStoreCommand((String)object4, (Object[])object3);
                    }
                }
                object5 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)serializable, "keyFileName");
                objectArray2 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)serializable, "keyFilePassword");
                object8 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)serializable, "keyFileFormat");
                if (object5 == null || objectArray2 == null || object8 == null) continue;
                object10 = WSKeyStore.loadKeyStore(KeyStoreManager.getInstance().expand((String)object5), (String)object8, (String)objectArray2);
                object4 = ((KeyStore)object10).aliases();
                while (object4.hasMoreElements()) {
                    object3 = (String)object4.nextElement();
                    if (!((KeyStore)object10).isCertificateEntry((String)object3)) continue;
                    object2 = (X509Certificate)((KeyStore)object10).getCertificate((String)object3);
                    objectArray = "setCertificateEntry";
                    object = new Object[]{object3, object2};
                    wSKeyStoreRemotable.invokeKeyStoreCommand((String)objectArray, (Object[])object);
                }
            }
            PersonalCertificateHelper.setWorkspaceUpdated(session, keyStoreInfo.getLocation());
            PersonalCertificateHelper.markSSLConfigChanged(keyStoreInfo, session);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.commands.securityDomain.SecurityConfigProvider", "198");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", exception);
            }
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addSignerToCommonTrustStore");
        }
    }

    public static void updateProperyFile(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updatePropertyFile", new Object[]{string});
        }
        boolean bl = false;
        if (string == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "updatePropertyFile (null props file)");
            }
            return;
        }
        try {
            Object object;
            Object object2;
            URL uRL;
            InputStream inputStream = null;
            FileOutputStream fileOutputStream = null;
            PrintStream printStream = null;
            try {
                uRL = new URL(string);
                inputStream = uRL.openStream();
                fileOutputStream = new FileOutputStream(uRL.getFile() + ".tmp");
                printStream = new PrintStream(fileOutputStream);
                object2 = null;
                object = new BufferedReader(new InputStreamReader(inputStream));
                while ((object2 = ((BufferedReader)object).readLine()) != null) {
                    if (((String)object2).trim().startsWith("#") || ((String)object2).trim().length() <= 0) {
                        printStream.println((String)object2);
                        continue;
                    }
                    if (((String)object2).trim().startsWith("com.ibm.ssl.trustStore")) {
                        printStream.println("#" + ((String)object2).trim());
                        continue;
                    }
                    if (((String)object2).trim().startsWith("com.ibm.ssl.trustStorePassword")) {
                        printStream.println("#" + ((String)object2).trim());
                        continue;
                    }
                    if (((String)object2).trim().startsWith("com.ibm.ssl.keyStore")) {
                        printStream.println("#" + ((String)object2).trim());
                        continue;
                    }
                    if (((String)object2).trim().startsWith("com.ibm.ssl.keyStorePassword")) {
                        printStream.println("#" + ((String)object2).trim());
                        continue;
                    }
                    if (((String)object2).trim().startsWith("com.ibm.ssl.contextProvider")) {
                        printStream.println("#" + ((String)object2).trim());
                        continue;
                    }
                    if (((String)object2).trim().startsWith("com.ibm.ssl.alias")) {
                        bl = true;
                        printStream.println((String)object2);
                        continue;
                    }
                    printStream.println((String)object2);
                }
                if (!bl) {
                    String string2 = ConvertSSLConfigProvider.getSSLAlias();
                    printStream.print(string2);
                }
                ((BufferedReader)object).close();
                printStream.close();
            }
            catch (Exception exception) {
                throw exception;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            uRL = new URL(string);
            object2 = new File(uRL.getPath());
            ((File)object2).delete();
            object = new File(uRL.getPath() + ".tmp");
            ((File)object).renameTo((File)object2);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "updatePropertyFile");
            }
            return;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred in updatePropertyFile: ", new Object[]{exception});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "updatePropertyFile");
            }
            return;
        }
    }

    public static String getSSLAlias() {
        String string;
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getSSLAlias");
            }
            string = "com.ibm.ssl.alias=DefaultSSLSettings";
            String string2 = System.getProperty("com.ibm.SSL.ConfigURL");
            if (string2 != null) {
                InputStream inputStream = null;
                try {
                    URL uRL = new URL(string2);
                    inputStream = uRL.openStream();
                    String string3 = null;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    try {
                        while ((string3 = bufferedReader.readLine()) != null) {
                            if (!string3.trim().startsWith("com.ibm.ssl.alias")) continue;
                            string = string3.trim();
                        }
                        bufferedReader.close();
                    }
                    catch (Exception exception) {
                        throw exception;
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block12;
                    Tr.debug(tc, "Exception occurred in getting client default alias: ", new Object[]{exception});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSSLAlias" + string);
        }
        return string;
    }
}

