/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.personalCertificates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.io.File;
import javax.management.ObjectName;

public class ExtractCertificate
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ExtractCertificate.class, "ExtractCertificate", "com.ibm.ws.ssl.commands.personalCertificates");
    private String keyStoreName = null;
    private String keyStoreScope = null;
    private String certAlias = null;
    private String certFilePath = null;
    private String certFilePathExpanded = null;
    private Boolean base64Encoded = null;
    private KeyStoreInfo ksInfo = null;

    public ExtractCertificate(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public ExtractCertificate(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ObjectName objectName = null;
        ObjectName objectName2 = null;
        Object var3_3 = null;
        try {
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            objectName = ConfigServiceHelper.createObjectName(null, "Security");
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName2 = configService.queryConfigObjects(session, objectName3, objectName, null)[0];
            }
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.keyStoreScope = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE);
            this.certFilePath = (String)this.getParameter(CommandConstants.CERT_FILE_PATH);
            this.certAlias = (String)this.getParameter(CommandConstants.CERT_ALIAS);
            this.base64Encoded = (Boolean)this.getParameter(CommandConstants.CERT_BASE64ENCODED);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyStoreName=" + this.keyStoreName + " certFilePath=" + this.certFilePath + " keyFileDataType=" + this.base64Encoded + " certAlias=" + this.certAlias);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.keyStoreScope == null) {
                this.keyStoreScope = commandHelper.defaultCellScope(objectName3);
                Tr.debug(tc, "Default cell scopeName: " + this.keyStoreScope);
            }
            this.ksInfo = PersonalCertificateHelper.getKsInfo(session, configService, this.keyStoreName, this.keyStoreScope);
            this.certFilePathExpanded = KeyStoreManager.getInstance().expand(this.certFilePath);
            File file = new File(this.certFilePathExpanded);
            if (!file.isAbsolute()) {
                this.certFilePathExpanded = KeyStoreManager.getInstance().expand("${USER_INSTALL_ROOT}" + File.separator + "etc" + File.separator + this.certFilePathExpanded);
                file = new File(this.certFilePathExpanded);
            }
            if (file.exists()) {
                String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.exists.CWPKI0621E", new Object[]{this.certFilePathExpanded}, "File " + this.certFilePathExpanded + " already exists.");
                throw new CommandValidationException(string);
            }
        }
        catch (ConfigServiceException configServiceException) {
            String string = configServiceException.getMessage();
            throw new CommandValidationException(string);
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            throw new CommandValidationException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        boolean bl = false;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            this.personalCertificateExtract(this.ksInfo, this.certFilePathExpanded, this.certAlias, this.base64Encoded);
            taskCommandResultImpl.setResult(this.certFilePathExpanded);
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    public void personalCertificateExtract(KeyStoreInfo keyStoreInfo, String string, String string2, boolean bl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "personalCertificateExtract");
        }
        WSKeyStoreRemotable wSKeyStoreRemotable = new WSKeyStoreRemotable(keyStoreInfo);
        try {
            String string3 = "containsAlias";
            Object[] objectArray = new Object[]{string2};
            Object[] objectArray2 = wSKeyStoreRemotable.invokeKeyStoreCommand(string3, objectArray);
            if (!((Boolean)objectArray2[0]).booleanValue()) {
                String string4 = "Alias " + string2 + " is not in keyStore " + keyStoreInfo.getName();
            } else {
                File file = new File(string);
                if (!file.exists() && !file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                string3 = "personalCertificateExtract";
                objectArray = new Object[]{keyStoreInfo, string, string2, new Boolean(bl)};
                wSKeyStoreRemotable.invokeKeyStoreCommand(string3, objectArray);
            }
        }
        catch (Exception exception) {
            throw new Exception(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "personalCertificateExtract");
        }
    }
}

