/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.personalCertificates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.keyStores.KeyStoreHelper;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.security.Key;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Locale;
import javax.management.ObjectName;

public class ImportCertificate
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ImportCertificate.class, "SSL", "com.ibm.ws.ssl.commands.personalCertificates");
    private String keyStoreName = null;
    private String keyFilePath = null;
    private String keyFilePathExpanded = null;
    private String keyFilePassword = null;
    private String keyFileType = null;
    private String certAliasFromKeyFile = null;
    private String certAlias = null;
    private String keyStoreScope = null;
    private KeyStoreInfo ksInfo = null;
    private Boolean importOverwriteAndReplace = Boolean.FALSE;

    public ImportCertificate(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public ImportCertificate(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ObjectName objectName = null;
        try {
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName2 = configService.resolve(session, "Cell=")[0];
            objectName = configService.resolve(session, "Cell=:Security=")[0];
            String string = (String)PersonalCertificateHelper.getCustomProperty(configService, session, objectName, "com.ibm.websphere.security.OverwriteAndReplaceOnImport");
            if (string != null) {
                this.importOverwriteAndReplace = new Boolean(string);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "importAndReplace value is " + this.importOverwriteAndReplace);
            }
            String string2 = null;
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.keyStoreScope = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE);
            this.keyFilePath = (String)this.getParameter(CommandConstants.KEY_FILE_PATH);
            this.keyFilePassword = (String)this.getParameter(CommandConstants.KEY_FILE_PASSWORD);
            this.keyFileType = (String)this.getParameter(CommandConstants.KEY_FILE_TYPE);
            this.certAliasFromKeyFile = (String)this.getParameter(CommandConstants.CERT_ALIAS_FROM_KEY_FILE);
            this.certAlias = (String)this.getParameter(CommandConstants.CERT_ALIAS);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyStoreName=" + this.keyStoreName + " keyFileName=" + string2 + " keyFileType=" + this.keyFileType + " certAliasFromKeyFile=" + this.certAliasFromKeyFile + " certAlias=" + this.certAlias);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.keyStoreScope == null) {
                this.keyStoreScope = commandHelper.defaultCellScope(objectName2);
                Tr.debug(tc, "Default cell scopeName: " + this.keyStoreScope);
            }
            this.ksInfo = PersonalCertificateHelper.getKsInfo(session, configService, this.keyStoreName, this.keyStoreScope);
            this.keyFilePathExpanded = KeyStoreManager.getInstance().expand(this.keyFilePath);
            if (KeyStoreHelper.checkKeyFile(this.keyFileType, this.keyFilePathExpanded, this.keyFilePassword) != 0) {
                String string3 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.keyStore.check.key.file.CWPKI0663E", new Object[]{this.keyFilePath}, "Key store file \"" + this.keyFilePath + "\" did not verify, make sure the file exits, check key store type and password.");
                throw new CommandValidationException(string3);
            }
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            throw new CommandValidationException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        boolean bl = false;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            this.personalCertificateImport(this.ksInfo, this.keyFilePath, this.keyFileType, this.keyFilePassword, this.certAlias, this.certAliasFromKeyFile);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.commands.ImportCertificate.afterStepsExecuted", "176", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred.", new Object[]{exception});
            }
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void personalCertificateImport(KeyStoreInfo keyStoreInfo, String string, String string2, String string3, String string4, String string5) throws Exception {
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "personalCertificateImport");
            }
            WSKeyStoreRemotable wSKeyStoreRemotable = new WSKeyStoreRemotable(keyStoreInfo);
            Session session = this.getConfigSession();
            String string6 = string4;
            String string7 = KeyStoreManager.getInstance().expand(string);
            if (string6 == null) {
                string6 = string5;
            }
            String string8 = "getCertificateChainFromUnManagedKeyStore";
            Object[] objectArray = new Object[]{string7, string2, string3 != null ? string3.toCharArray() : null, string5};
            Object[] objectArray2 = wSKeyStoreRemotable.invokeKeyStoreCommand(string8, objectArray);
            string8 = "getKeyFromUnManagedKeyStore";
            objectArray = new Object[]{string7, string2, string3 != null ? string3.toCharArray() : null, string5};
            Object[] objectArray3 = wSKeyStoreRemotable.invokeKeyStoreCommand(string8, objectArray);
            if (objectArray2[0] != null && objectArray3[0] != null) {
                string8 = "containsAlias";
                objectArray = new Object[]{string6};
                Object[] objectArray4 = wSKeyStoreRemotable.invokeKeyStoreCommand(string8, objectArray);
                if (((Boolean)objectArray4[0]).booleanValue()) {
                    if (!this.importOverwriteAndReplace.booleanValue()) {
                        String string9 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.alias.already.exists.CWPKI0630E", new Object[]{string6, keyStoreInfo.getLocation()}, "Alias \"" + string6 + "\" already exists in key store \"" + keyStoreInfo.getLocation() + "\".");
                        throw new CommandValidationException(string9);
                    }
                    this.importAndReplaceCertificate(session, keyStoreInfo, wSKeyStoreRemotable, string6, objectArray3, objectArray2);
                    break block9;
                } else {
                    string8 = "setKeyEntry";
                    objectArray = new Object[]{string6, (Key)objectArray3[0], keyStoreInfo.getPassword() != null ? keyStoreInfo.getPassword().toCharArray() : null, (Certificate[])objectArray2[0]};
                    wSKeyStoreRemotable.invokeKeyStoreCommand(string8, objectArray);
                    PersonalCertificateHelper.setWorkspaceUpdated(session, keyStoreInfo.getLocation());
                    PersonalCertificateHelper.markSSLConfigChanged(keyStoreInfo, session);
                }
                break block9;
            }
            String string10 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.not.personal.in.keystore.CWPKI0672E", new Object[]{string5, string}, "Alias \"" + string5 + "\" is not a personal certificate in key store \"" + string + "\".");
            throw new CommandValidationException(string10);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "personalCertificateImport");
        }
    }

    private void importAndReplaceCertificate(Session session, KeyStoreInfo keyStoreInfo, WSKeyStoreRemotable wSKeyStoreRemotable, String string, Object[] objectArray, Object[] objectArray2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "importAndReplaceCertificate");
        }
        Certificate[] certificateArray = (Certificate[])objectArray2[0];
        Key key = (Key)objectArray[0];
        Locale locale = this.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "locale is null, use system locale:" + locale);
            }
        }
        try {
            String string2 = "getCertificate";
            Object[] objectArray3 = new Object[]{string};
            Object[] objectArray4 = wSKeyStoreRemotable.invokeKeyStoreCommand(string2, objectArray3);
            Certificate certificate = (Certificate)objectArray4[0];
            string2 = "setKeyEntryOverwrite";
            objectArray3 = new Object[]{string, key, keyStoreInfo.getPassword() != null ? keyStoreInfo.getPassword().toCharArray() : null, certificateArray};
            wSKeyStoreRemotable.invokeKeyStoreCommand(string2, objectArray3);
            PersonalCertificateHelper.replaceCerts(session, keyStoreInfo, string, (X509Certificate)certificate, null, (X509Certificate)certificateArray[0], certificateArray, key, true, locale);
            PersonalCertificateHelper.setWorkspaceUpdated(session, keyStoreInfo.getLocation());
            PersonalCertificateHelper.markSSLConfigChanged(keyStoreInfo, session);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred while importAndReplaceCertificate.", new Object[]{exception});
            }
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "importAndReplaceCertificate");
        }
    }
}

