/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.personalCertificates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ssl.commands.certificateRequests.CertificateRequestHelper;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.io.File;
import java.io.FileInputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import javax.management.ObjectName;

public class ReceiveCertificate
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ReceiveCertificate.class, "SSL", "com.ibm.ws.ssl.commands.personalCertificates");
    private String keyStoreName = null;
    private String keyStoreScope = null;
    private String certAlias = null;
    private String certFilePath = null;
    private String certFilePathExpanded = null;
    private KeyStoreInfo ksInfo = null;

    public ReceiveCertificate(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public ReceiveCertificate(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ObjectName objectName = null;
        ObjectName objectName2 = null;
        Object var3_3 = null;
        try {
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            objectName = ConfigServiceHelper.createObjectName(null, "Security");
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName2 = configService.queryConfigObjects(session, objectName3, objectName, null)[0];
            }
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.keyStoreScope = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE);
            this.certFilePath = (String)this.getParameter(CommandConstants.CERT_FILE_PATH);
            this.certAlias = (String)this.getParameter(CommandConstants.CERT_ALIAS);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyStoreName=" + this.keyStoreName + " certFilePath=" + this.certFilePath + " certAlias=" + this.certAlias);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.keyStoreScope == null) {
                this.keyStoreScope = commandHelper.defaultCellScope(objectName3);
                Tr.debug(tc, "Default cell scopeName: " + this.keyStoreScope);
            }
            this.ksInfo = PersonalCertificateHelper.getKsInfo(session, configService, this.keyStoreName, this.keyStoreScope);
            this.certFilePathExpanded = KeyStoreManager.getInstance().expand(this.certFilePath);
            File file = new File(this.certFilePathExpanded);
            if (!file.isAbsolute()) {
                this.certFilePathExpanded = KeyStoreManager.getInstance().expand("${USER_INSTALL_ROOT}" + File.separator + "etc" + File.separator + this.certFilePathExpanded);
                file = new File(this.certFilePathExpanded);
            }
            if (file == null | !file.isFile() | !file.canRead()) {
                String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.file.not.exist.CWPKI0652E", new Object[]{this.certFilePath}, "Certificate file \"" + this.certFilePath + "\" does not exist");
                throw new CommandValidationException(string);
            }
        }
        catch (ConfigServiceException configServiceException) {
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        boolean bl = false;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            this.personalCertificateReceive(this.ksInfo, this.certFilePathExpanded, this.certAlias);
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void personalCertificateReceive(KeyStoreInfo keyStoreInfo, String string, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "personalCertificateReceive");
        }
        String string3 = keyStoreInfo.getPassword();
        WSKeyStoreRemotable wSKeyStoreRemotable = new WSKeyStoreRemotable(keyStoreInfo);
        try {
            Object[] objectArray;
            String string4 = null;
            Object[] objectArray2 = null;
            CertificateFactory certificateFactory = null;
            Collection<? extends Certificate> collection = null;
            FileInputStream fileInputStream = new FileInputStream(string);
            certificateFactory = CertificateFactory.getInstance("X509");
            collection = certificateFactory.generateCertificates(fileInputStream);
            X509Certificate[] x509CertificateArray = new X509Certificate[collection.size()];
            Iterator<? extends Certificate> iterator = collection.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                x509CertificateArray[n] = (X509Certificate)iterator.next();
                ++n;
            }
            X509Certificate x509Certificate = null;
            PublicKey publicKey = x509CertificateArray[0].getPublicKey();
            if (string2 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Alias supplied, looking for alias " + string2);
                }
                if (!((Boolean)(objectArray = wSKeyStoreRemotable.invokeKeyStoreCommand(string4 = "containsAlias", objectArray2 = new Object[]{string2}))[0]).booleanValue()) {
                    String string5 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.does.not.exist.CWPKI0655E", new Object[]{string2, keyStoreInfo.getName()}, "Certificate alais \"" + string2 + "\" does not exist in key store \"" + keyStoreInfo.getName() + "\".");
                    throw new KeyStoreException(string5);
                }
                string4 = "getCertificate";
                objectArray2 = new Object[]{string2};
                Object[] objectArray3 = wSKeyStoreRemotable.invokeKeyStoreCommand(string4, objectArray2);
                x509Certificate = (X509Certificate)objectArray3[0];
                if (CertificateRequestHelper.isKeyCertReq(x509Certificate, string2) == null) {
                    String string6 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.not.cert.request.CWPKI0651E", new Object[]{string2}, "Certificate alias \"" + string2 + "\" is not a certificate request.");
                    throw new CommandValidationException(string6);
                }
                if (!publicKey.equals(x509Certificate.getPublicKey())) {
                    String string7 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.publickey.not.match.CWPKI0654E", new Object[]{string2}, "Public key from certificate alais \"" + string2 + "\" and the public key from the certificate authority do no match.");
                    throw new KeyStoreException(string7);
                }
            } else {
                void var16_21;
                string4 = "aliases";
                objectArray2 = null;
                objectArray = wSKeyStoreRemotable.invokeKeyStoreCommand(string4, objectArray2);
                boolean bl = false;
                while (var16_21 < objectArray.length) {
                    String string8 = (String)objectArray[var16_21];
                    string4 = "isKeyEntry";
                    objectArray2 = new Object[]{string8};
                    Object[] objectArray4 = wSKeyStoreRemotable.invokeKeyStoreCommand(string4, objectArray2);
                    string4 = "getCertificate";
                    objectArray2 = new Object[]{string8};
                    Object[] objectArray5 = wSKeyStoreRemotable.invokeKeyStoreCommand(string4, objectArray2);
                    X509Certificate x509Certificate2 = (X509Certificate)objectArray5[0];
                    if (((Boolean)objectArray4[0]).booleanValue() && CertificateRequestHelper.isKeyCertReq(x509Certificate2, string8) != null && publicKey.equals(x509Certificate2.getPublicKey())) {
                        x509Certificate = x509Certificate2;
                        string2 = string8;
                        break;
                    }
                    ++var16_21;
                }
                if (x509Certificate == null) {
                    String string9 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.publickey.not.found.CWPKI0662E", new Object[]{keyStoreInfo.getName()}, "Certificate with a public key matching the public key in the certificate from the Certificate Authority is not found in key store \"" + keyStoreInfo.getName() + "\".");
                    throw new KeyStoreException(string9);
                }
            }
            if ((objectArray = wSKeyStoreRemotable.invokeKeyStoreCommand(string4 = "getKey", objectArray2 = new Object[]{string2, string3.toCharArray()})) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Key entry is not found.");
                }
                String string10 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.key.not.exist.CWPKI0653E", new Object[]{string2}, "Failed to retrieve key for alias \"" + string2 + "\" from the key store.");
                throw new KeyStoreException(string10);
            }
            string4 = "setKeyEntryOverwrite";
            objectArray2 = new Object[]{string2, (Key)objectArray[0], string3 != null ? string3.toCharArray() : null, x509CertificateArray};
            wSKeyStoreRemotable.invokeKeyStoreCommand(string4, objectArray2);
            Session session = this.getConfigSession();
            PersonalCertificateHelper.setWorkspaceUpdated(session, keyStoreInfo.getLocation());
            PersonalCertificateHelper.markSSLConfigChanged(keyStoreInfo, session);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is " + exception.getMessage());
            }
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "personalCertificateImport");
        }
    }
}

