/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.personalCertificates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ssl.commands.certificateRequests.CertificateRequestHelper;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.Locale;
import javax.management.ObjectName;

public class ReplaceCertificate
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ReplaceCertificate.class, "SSL", "com.ibm.ws.ssl.commands.keyStores");
    private String keyStoreName = null;
    private String keyStoreScope = null;
    private String certificateAlias = null;
    private String replacementCertificateAlias = null;
    private Boolean deleteOldCert = null;
    private Boolean deleteOldSigners = null;
    private KeyStoreInfo ksInfo = null;
    private Session session = null;

    public ReplaceCertificate(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public ReplaceCertificate(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ObjectName objectName = null;
        ObjectName objectName2 = null;
        try {
            ConfigService configService = ConfigServiceFactory.getConfigService();
            this.session = this.getConfigSession();
            objectName = ConfigServiceHelper.createObjectName(null, "Security");
            ObjectName objectName3 = configService.resolve(this.session, "Cell=")[0];
            if (objectName3 != null) {
                objectName2 = configService.queryConfigObjects(this.session, objectName3, objectName, null)[0];
            }
            Object var5_7 = null;
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.keyStoreScope = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE);
            this.certificateAlias = (String)this.getParameter(CommandConstants.CERT_ALIAS);
            this.replacementCertificateAlias = (String)this.getParameter(CommandConstants.REPLACE_CERT_ALIAS);
            this.deleteOldCert = (Boolean)this.getParameter(CommandConstants.DELETE_OLD_CERT);
            this.deleteOldSigners = (Boolean)this.getParameter(CommandConstants.DELETE_OLD_SIGNERS);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyStoreName=" + this.keyStoreName + " keyStoreScope= " + this.keyStoreScope + " certAlias=" + this.certificateAlias + " replacementCertificateAlias=" + this.replacementCertificateAlias + " deleteOldCert= " + this.deleteOldCert + " deleteOldSigners= " + this.deleteOldSigners);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.keyStoreScope == null) {
                this.keyStoreScope = commandHelper.defaultCellScope(objectName3);
                Tr.debug(tc, "Default cell scopeName: " + this.keyStoreScope);
            }
            if (this.certificateAlias.equalsIgnoreCase(this.replacementCertificateAlias)) {
                String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.dup.alias.values.CWPKI0674E", new Object[]{"certificateAlias", "replacementCertificateAlias"}, "certificateAlias and replacementCertificate alias values must be different.");
                throw new CommandValidationException(string);
            }
            this.ksInfo = PersonalCertificateHelper.getKsInfo(this.session, configService, this.keyStoreName, this.keyStoreScope);
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            throw new CommandValidationException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        boolean bl = false;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            this.personalCertificateReplace(this.ksInfo, this.certificateAlias, this.replacementCertificateAlias, this.deleteOldCert, this.deleteOldSigners, this.keyStoreScope);
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    public void personalCertificateReplace(KeyStoreInfo keyStoreInfo, String string, String string2, boolean bl, boolean bl2, String string3) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "personalCertificateReplace");
        }
        WSKeyStoreRemotable wSKeyStoreRemotable = new WSKeyStoreRemotable(keyStoreInfo);
        boolean bl3 = keyStoreInfo.getFileBased();
        boolean bl4 = keyStoreInfo.getReadOnly();
        X509Certificate x509Certificate = null;
        X509Certificate x509Certificate2 = null;
        Session session = this.getConfigSession();
        Locale locale = this.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "locale is null, use system locale:" + locale);
            }
        }
        try {
            Object[] objectArray;
            String string4;
            if (!bl4 && bl3) {
                Object object;
                string4 = "isKeyEntry";
                objectArray = new Object[]{string};
                Object[] objectArray2 = wSKeyStoreRemotable.invokeKeyStoreCommand(string4, objectArray);
                if (((Boolean)objectArray2[0]).booleanValue()) {
                    string4 = "getCertificate";
                    objectArray = new Object[]{string};
                    object = wSKeyStoreRemotable.invokeKeyStoreCommand(string4, objectArray);
                    x509Certificate = (X509Certificate)object[0];
                    if (CertificateRequestHelper.isKeyCertReq(x509Certificate, string) != null) {
                        String string5 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.not.personal.cert.CWPKI0666E", new Object[]{string}, "Certificate \"" + string + "\" is not a personal certificate.");
                        throw new CommandValidationException(string5);
                    }
                } else {
                    String string6 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.not.personal.cert.CWPKI0666E", new Object[]{string}, "Certificate \"" + string + "\" is not a personal certificate.");
                    throw new CommandValidationException(string6);
                }
                string4 = "isKeyEntry";
                objectArray = new Object[]{string2};
                objectArray2 = wSKeyStoreRemotable.invokeKeyStoreCommand(string4, objectArray);
                if (((Boolean)objectArray2[0]).booleanValue()) {
                    string4 = "getCertificate";
                    objectArray = new Object[]{string2};
                    object = wSKeyStoreRemotable.invokeKeyStoreCommand(string4, objectArray);
                    x509Certificate2 = (X509Certificate)object[0];
                    if (CertificateRequestHelper.isKeyCertReq(x509Certificate2, string2) != null) {
                        String string7 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.not.personal.cert.CWPKI0666E", new Object[]{string2}, "Certificate \"" + string2 + "\" is not a personal certificate.");
                        throw new CommandValidationException(string7);
                    }
                } else {
                    object = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.not.personal.cert.CWPKI0666E", new Object[]{string2}, "Certificate \"" + string2 + "\" is not a personal certificate.");
                    throw new CommandValidationException((String)object);
                }
            }
            if (x509Certificate != null && x509Certificate2 != null) {
                PersonalCertificateHelper.changeAliasReferences(session, keyStoreInfo, string, string2);
                PersonalCertificateHelper.replaceCerts(session, keyStoreInfo, string, x509Certificate, string2, x509Certificate2, null, null, bl2, locale);
                if (bl) {
                    string4 = "deleteEntry";
                    objectArray = new Object[]{string};
                    wSKeyStoreRemotable.invokeKeyStoreCommand(string4, objectArray);
                }
            } else {
                string4 = "Certificate not found in keyStore.";
                throw new KeyStoreException(string4);
            }
            PersonalCertificateHelper.setWorkspaceUpdated(session, keyStoreInfo.getLocation());
            PersonalCertificateHelper.markSSLConfigChanged(keyStoreInfo, session);
        }
        catch (Exception exception) {
            throw new Exception(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "personalCertificateExport");
        }
    }
}

