/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.signerCertificates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ssl.commands.signerCertificates.SignerCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class RetrieveSignerInfoFromPort
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(RetrieveSignerInfoFromPort.class, "SSL", "com.ibm.ws.ssl.commands.trustedCertificates");
    private String host = null;
    private Integer port = null;
    private String sslConfigName = null;
    private String sslConfigScopeName = null;
    private ObjectName sslCfgObjName = null;

    public RetrieveSignerInfoFromPort(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public RetrieveSignerInfoFromPort(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ObjectName objectName = null;
        ObjectName objectName2 = null;
        try {
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            objectName = ConfigServiceHelper.createObjectName(null, "Security");
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName2 = configService.queryConfigObjects(session, objectName3, objectName, null)[0];
            }
            Object var6_8 = null;
            this.host = (String)this.getParameter(CommandConstants.HOST);
            this.port = (Integer)this.getParameter(CommandConstants.PORT);
            this.sslConfigName = (String)this.getParameter(CommandConstants.CONFIG_NAME);
            this.sslConfigScopeName = (String)this.getParameter(CommandConstants.SSL_CONFIG_SCOPE_NAME);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "host=" + this.host + " port=" + this.port + " sslConfigScopeName=" + this.sslConfigScopeName + " sslConfigName=" + this.sslConfigName);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.sslConfigName != null) {
                AttributeList attributeList = new AttributeList();
                if (this.sslConfigScopeName == null) {
                    this.sslConfigScopeName = commandHelper.defaultCellScope(objectName3);
                    Tr.debug(tc, "Default cell scopeName: " + this.sslConfigScopeName);
                }
                attributeList.clear();
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.ALIAS, this.sslConfigName);
                this.sslCfgObjName = commandHelper.getObjectName(configService, session, objectName2, CommandConstants.REPERTOIRE, attributeList, this.sslConfigScopeName);
                if (this.sslCfgObjName == null) {
                    String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.not.found.CWPKI0600E", new Object[]{this.sslConfigName, this.sslConfigScopeName}, this.sslConfigName + " does not exist within the management scope " + this.sslConfigScopeName);
                    throw new CommandValidationException(string);
                }
            }
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            throw new CommandValidationException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        boolean bl = false;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            AttributeList attributeList = this.getSignerInfoFromPort(this.host, this.port, this.sslConfigName);
            taskCommandResultImpl.setResult(attributeList);
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    public AttributeList getSignerInfoFromPort(String string, Integer n, String string2) throws Exception {
        try {
            Certificate[] certificateArray = SignerCertificateHelper.retrieveSigner(string, n, string2);
            if (certificateArray != null) {
                return this.changeCertToAttrList((X509Certificate)certificateArray[0]);
            }
            String string3 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.no.signer.CWPKI0661E", new Object[]{string, n}, "Unable to get signer information from hostname \"" + string + "\" and port \"" + n + "\".  Verify hostname and port are correct.");
            throw new CommandValidationException(string3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Exception(exception.getMessage());
        }
    }

    private AttributeList changeCertToAttrList(X509Certificate x509Certificate) {
        Date date;
        String string;
        Principal principal;
        AttributeList attributeList = new AttributeList();
        Locale locale = this.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "locale is null, use system locale:" + locale);
            }
        }
        attributeList.clear();
        ConfigServiceHelper.setAttributeValue(attributeList, "serialNumber", x509Certificate.getSerialNumber());
        Principal principal2 = x509Certificate.getSubjectDN();
        if (principal2 != null) {
            ConfigServiceHelper.setAttributeValue(attributeList, "issuedTo", ((Object)principal2).toString());
        }
        if ((principal = x509Certificate.getIssuerDN()) != null) {
            ConfigServiceHelper.setAttributeValue(attributeList, "issuedBy", ((Object)principal).toString());
        }
        if ((string = KeyStoreManager.getInstance().generateDigest("SHA-1", x509Certificate)) != null) {
            ConfigServiceHelper.setAttributeValue(attributeList, "fingerPrint", string);
        }
        if ((date = x509Certificate.getNotAfter()) != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMMMMMMM d, yyyy", locale);
            ConfigServiceHelper.setAttributeValue(attributeList, "expires", simpleDateFormat.format(date));
        }
        return attributeList;
    }
}

