/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.ManagementScopeData;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CommandHelper {
    private static TraceComponent tc = Tr.register(CommandHelper.class, "CommandHelper", "com.ibm.ws.ssl.commands");

    public ObjectName getObjectName(ConfigService configService, Session session, ObjectName objectName, String string, String string2, String string3) throws CommandValidationException, ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectName");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "configDataType : " + string);
            Tr.debug(tc, "key : " + string2);
            Tr.debug(tc, "value : " + string3);
        }
        ObjectName objectName2 = null;
        if (string == null || string2 == null || string3 == null) {
            String string4 = TraceNLSHelper.getInstance().getString("ssl.command.createKeyManager.CWPKI0632E", "Invalid input parameter.");
            throw new CommandValidationException(string4);
        }
        try {
            Object object;
            List list = (List)configService.getAttribute(session, objectName, string);
            Object object2 = list.iterator();
            while (object2.hasNext()) {
                object = (AttributeList)object2.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "attrList : " + object);
                }
                String string5 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)object, string2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "attrValue : " + string5);
                }
                if (string5 == null || !string5.equals(string3)) continue;
                ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName((AttributeList)object), null);
                if (objectNameArray.length == 1) {
                    objectName2 = objectNameArray[0];
                    break;
                }
                throw new InvalidParameterValueException("getObjectName()", string2, string3);
            }
            if (objectName2 == null) {
                object2 = new AttributeList();
                ConfigServiceHelper.setAttributeValue((AttributeList)object2, string2, string3);
                object = this.formOutputErr(string, (AttributeList)object2, null);
                throw new CommandValidationException((String)object);
            }
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectName - " + objectName2);
        }
        return objectName2;
    }

    public ObjectName getObjectName(ConfigService configService, Session session, ObjectName objectName, String string, AttributeList attributeList, String string2) throws CommandValidationException, ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectName");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "configDataType : " + string);
            Tr.debug(tc, "queryAttrs : " + attributeList);
            Tr.debug(tc, "scopeName : " + string2);
        }
        ObjectName objectName2 = null;
        if (string == null || attributeList.size() == 0) {
            String string3 = TraceNLSHelper.getInstance().getString("ssl.command.createKeyManager.CWPKI0632E", "Invalid input parameter.");
            throw new CommandValidationException(string3);
        }
        try {
            List list = (List)configService.getAttribute(session, objectName, string);
            Object object = list.iterator();
            while (object.hasNext()) {
                ObjectName[] objectNameArray;
                int n;
                AttributeList attributeList2 = (AttributeList)object.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "attrList : " + attributeList2);
                }
                int n2 = 0;
                for (n = 0; n < attributeList.size(); ++n) {
                    objectNameArray = (ObjectName[])attributeList.get(n);
                    if (objectNameArray.getValue() == null || objectNameArray.getName() == null) continue;
                    String string4 = (String)ConfigServiceHelper.getAttributeValue(attributeList2, objectNameArray.getName());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "attribute : " + string4);
                    }
                    if (string4 == null || !string4.equals(objectNameArray.getValue())) break;
                    ++n2;
                }
                if (n2 != attributeList.size()) continue;
                if (string2 != null) {
                    n = this.sameScope(configService, session, objectName, attributeList2, string2) ? 1 : 0;
                    if (n == 0) continue;
                    objectNameArray = configService.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(attributeList2), null);
                    if (objectNameArray.length == 1) {
                        objectName2 = objectNameArray[0];
                        break;
                    }
                    throw new InvalidParameterValueException("getObjectName()", string, attributeList2);
                }
                ObjectName[] objectNameArray2 = configService.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(attributeList2), null);
                if (objectNameArray2.length == 1) {
                    objectName2 = objectNameArray2[0];
                    break;
                }
                throw new InvalidParameterValueException("getObjectName()", string, attributeList2);
            }
            if (objectName2 == null) {
                object = this.formOutputErr(string, attributeList, string2);
                throw new CommandValidationException((String)object);
            }
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectName - " + objectName2);
        }
        return objectName2;
    }

    public ObjectName getObjectWithinScope(ConfigService configService, Session session, String string, String string2, String string3) throws CommandValidationException, ConfigServiceException {
        ObjectName objectName;
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getObjectWithinScope");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "configDataType: " + string);
                Tr.debug(tc, "objectId: " + string2);
                Tr.debug(tc, "scopeName: " + string3);
            }
            objectName = null;
            if (string == null || string2 == null || string3 == null) {
                String string4 = TraceNLSHelper.getInstance().getString("ssl.command.createKeyManager.CWPKI0632E", "Invalid input parameter.");
                throw new CommandValidationException(string4);
            }
            try {
                ObjectName[] objectNameArray;
                if (string2.indexOf("security.xml") < 0) {
                    String string5 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.invalid.configid.CWPKI0675E", new Object[]{string2}, "\"" + string2 + "\" is an invalid configuration object name.");
                    throw new CommandValidationException(string5);
                }
                ConfigDataId configDataId = new ConfigDataId(string2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "id: " + configDataId);
                }
                ObjectName objectName2 = ConfigServiceHelper.createObjectName(configDataId, string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "object: " + objectName2);
                }
                if ((objectNameArray = configService.queryConfigObjects(session, null, objectName2, null)) != null && objectNameArray.length == 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "matches[0]: " + objectNameArray[0]);
                    }
                    AttributeList attributeList = configService.getAttributes(session, objectNameArray[0], null, true);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "attrList: " + attributeList);
                    }
                    if (attributeList == null) break block16;
                    boolean bl = this.withInScope(configService, session, attributeList, string3);
                    if (bl) {
                        objectName = objectNameArray[0];
                        break block16;
                    }
                    String string6 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.not.in.management.scope.CWPKI0633E", new Object[]{string, string3}, string + " is not within the management scope " + string3);
                    throw new CommandValidationException(string6);
                }
                throw new InvalidParameterValueException("getObjectWithinScope()", string, configDataId);
            }
            catch (ConfigServiceException configServiceException) {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "exception caught:", configServiceException.getMessage());
                }
                throw new CommandValidationException(configServiceException.getMessage());
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "exception caught:", exception.getMessage());
                }
                throw new CommandValidationException(exception.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectWithinScope - " + objectName);
        }
        return objectName;
    }

    public boolean exists(ConfigService configService, Session session, ObjectName objectName, String string, AttributeList attributeList, String string2) throws CommandValidationException, ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exists");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "configDataType : " + string);
            Tr.debug(tc, "queryAttrs : " + attributeList);
            Tr.debug(tc, "queryAttrs.size() : " + attributeList.size());
            Tr.debug(tc, "scopeName: " + string2);
        }
        boolean bl = false;
        if (string == null || attributeList.size() == 0) {
            String string3 = TraceNLSHelper.getInstance().getString("ssl.command.createKeyManager.CWPKI0632E", "Invalid input parameter.");
            throw new CommandValidationException(string3);
        }
        try {
            List list = (List)configService.getAttribute(session, objectName, string);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                int n;
                AttributeList attributeList2 = (AttributeList)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "attrList : " + attributeList2);
                }
                int n2 = 0;
                for (n = 0; n < attributeList.size(); ++n) {
                    Attribute attribute = (Attribute)attributeList.get(n);
                    if (attribute.getName() == null || attribute.getValue() == null) continue;
                    String string4 = (String)ConfigServiceHelper.getAttributeValue(attributeList2, attribute.getName());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "attribute : " + string4);
                    }
                    if (string4 == null || !string4.equals(attribute.getValue())) break;
                    ++n2;
                }
                if (n2 != attributeList.size()) continue;
                if (string2 != null) {
                    n = this.sameScope(configService, session, objectName, attributeList2, string2) ? 1 : 0;
                    if (n == 0) continue;
                    bl = true;
                } else {
                    bl = true;
                }
                break;
            }
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exists - " + bl);
        }
        return bl;
    }

    public AttributeList getReference(ConfigService configService, Session session, ObjectName objectName, String string, String string2, ObjectName objectName2) throws CommandValidationException, ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getReference");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "configDataType : " + string);
            Tr.debug(tc, "attrName : " + string2);
            Tr.debug(tc, "key : " + objectName2);
        }
        AttributeList attributeList = new AttributeList();
        try {
            List list = (List)configService.getAttribute(session, objectName, string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "configData : " + list);
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                AttributeList attributeList2 = (AttributeList)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "attrList : " + attributeList2);
                }
                ObjectName objectName3 = (ObjectName)ConfigServiceHelper.getAttributeValue(attributeList2, string2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "objectRef : " + objectName3);
                }
                if (objectName3 == null || !objectName3.equals(objectName2)) continue;
                ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(attributeList2), null);
                String string3 = ConfigServiceHelper.getDisplayName(objectNameArray[0]);
                attributeList.add(new Attribute(string, string3));
            }
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getReference - " + attributeList);
        }
        return attributeList;
    }

    public AttributeList getReferenceNested(ConfigService configService, Session session, ObjectName objectName, String string, String string2, ObjectName objectName2) throws CommandValidationException, ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getReferenceFromSubList");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "configDataType : " + string);
            Tr.debug(tc, "attrName : " + string2);
            Tr.debug(tc, "key : " + objectName2);
        }
        AttributeList attributeList = new AttributeList();
        try {
            List list = (List)configService.getAttribute(session, objectName, string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "configData : " + list);
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                AttributeList attributeList2 = (AttributeList)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "attrList : " + attributeList2);
                }
                List list2 = (List)ConfigServiceHelper.getAttributeValue(attributeList2, string2);
                Iterator iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    ObjectName objectName3 = (ObjectName)iterator2.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "thisObject : " + objectName3);
                    }
                    if (objectName3 == null || !objectName3.equals(objectName2)) continue;
                    ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(attributeList2), null);
                    String string3 = ConfigServiceHelper.getDisplayName(objectNameArray[0]);
                    attributeList.add(new Attribute(string, string3));
                }
            }
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getReferenceFromSubList - " + attributeList);
        }
        return attributeList;
    }

    public boolean propertyExists(ConfigService configService, Session session, ObjectName objectName, String string, String string2, String string3) throws CommandValidationException, ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "propertyExists ");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "sslConfigAliasName : " + string);
            Tr.debug(tc, "propertyName : " + string2);
            Tr.debug(tc, "queryScopeName : " + string3);
        }
        if (string == null || string2 == null || string3 == null) {
            String string4 = TraceNLSHelper.getInstance().getString("ssl.command.createKeyManager.CWPKI0632E", "Invalid input parameter.");
            throw new CommandValidationException(string4);
        }
        boolean bl = false;
        try {
            List list = (List)configService.getAttribute(session, objectName, CommandConstants.REPERTOIRE);
            Iterator iterator = list.iterator();
            block3: while (iterator.hasNext()) {
                AttributeList attributeList = (AttributeList)iterator.next();
                String string5 = (String)ConfigServiceHelper.getAttributeValue(attributeList, CommandConstants.ALIAS);
                ObjectName objectName2 = (ObjectName)ConfigServiceHelper.getAttributeValue(attributeList, CommandConstants.MANAGEMENT_SCOPE);
                Object object = null;
                if (objectName2 != null) {
                    object = configService.getAttribute(session, objectName2, CommandConstants.SCOPE_NAME);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "repertoire : " + attributeList);
                    Tr.debug(tc, "alias : " + string5);
                    Tr.debug(tc, "scopeRef : " + objectName2);
                    Tr.debug(tc, "thisScopeName : " + object);
                }
                if (string == null || object == null || !string.equals(string5) || !string3.equals(object)) continue;
                AttributeList attributeList2 = (AttributeList)ConfigServiceHelper.getAttributeValue(attributeList, CommandConstants.SETTING);
                ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(attributeList2), null);
                if (objectNameArray.length == 1) {
                    List list2 = (List)ConfigServiceHelper.getAttributeValue(attributeList2, CommandConstants.PROPERTIES);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "propertyList : " + list2);
                    }
                    Iterator iterator2 = list2.iterator();
                    while (iterator2.hasNext()) {
                        AttributeList attributeList3 = (AttributeList)iterator2.next();
                        String string6 = (String)ConfigServiceHelper.getAttributeValue(attributeList3, CommandConstants.NAME);
                        if (!string6.equals(string2)) continue;
                        bl = true;
                        break block3;
                    }
                    break;
                }
                throw new InvalidParameterValueException("propertyExists()", CommandConstants.SETTING, attributeList2);
            }
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "propertyExists - " + bl);
        }
        return bl;
    }

    public boolean withInScope(ConfigService configService, Session session, AttributeList attributeList, String string) throws CommandValidationException, ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "withInScope");
        }
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "attrList: " + attributeList);
            Tr.debug(tc, "fullScope: " + string);
        }
        boolean bl = false;
        if (attributeList.size() == 0 || string == null) {
            return false;
        }
        try {
            ManagementScopeData managementScopeData = new ManagementScopeData(string);
            List list = managementScopeData.subScopes();
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "allSubScopes: " + list);
            }
            ObjectName objectName = (ObjectName)ConfigServiceHelper.getAttributeValue(attributeList, CommandConstants.MANAGEMENT_SCOPE);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "mgmScopeRef: " + objectName);
            }
            if (objectName != null) {
                Object object = configService.getAttribute(session, objectName, CommandConstants.SCOPE_NAME);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "scopeName: " + object);
                }
                if (object.toString() != null && list.contains(object.toString())) {
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "withInScope: " + bl);
        }
        return bl;
    }

    public boolean sameScope(ConfigService configService, Session session, ObjectName objectName, AttributeList attributeList, String string) throws CommandValidationException, ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sameScope ");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "attrList: " + attributeList);
            Tr.debug(tc, "scopeName: " + string);
        }
        boolean bl = false;
        if (attributeList.size() == 0 || string == null) {
            return false;
        }
        try {
            ObjectName objectName2 = (ObjectName)ConfigServiceHelper.getAttributeValue(attributeList, CommandConstants.MANAGEMENT_SCOPE);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "scopeRef: " + objectName2);
            }
            if (objectName2 != null) {
                String string2 = (String)configService.getAttribute(session, objectName2, CommandConstants.SCOPE_NAME);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "thisScope: " + string2);
                }
                if (string2 != null && string2.equals(string)) {
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sameScope " + bl);
        }
        return bl;
    }

    public boolean contains(String[] stringArray, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "contains ");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "elements " + stringArray);
            Tr.entry(tc, "key " + string);
        }
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "aList " + arrayList);
        }
        if (arrayList.contains(string.toUpperCase()) || arrayList.contains(string)) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "contains " + bl);
        }
        return bl;
    }

    public String formOutputErr(String string, AttributeList attributeList, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formOutputErr ");
        }
        String string3 = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("The ");
        stringBuffer.append(string);
        stringBuffer.append(" ");
        for (int i = 0; i < attributeList.size(); ++i) {
            Attribute attribute = (Attribute)attributeList.get(i);
            stringBuffer.append(attribute.getName());
            stringBuffer.append(" ");
            stringBuffer.append(attribute.getValue());
            if (attributeList.size() <= 1) continue;
            stringBuffer.append(" ");
        }
        if (string2 != null) {
            stringBuffer.append(" and ");
            stringBuffer.append("scopeName ");
            stringBuffer.append(string2.trim());
        }
        stringBuffer.append(" is not found");
        string3 = stringBuffer.toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formOutputErr: " + string3);
        }
        return string3;
    }

    public String defaultCellScope(ObjectName objectName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "defaultCellScope ");
        }
        String string = null;
        String string2 = ConfigServiceHelper.getDisplayName(objectName);
        if (ManagementScopeManager.getInstance().getProcessType().equals("UnManagedProcess")) {
            String string3 = ManagementScopeManager.getInstance().getNodeScopeName();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "defaultNodeScope: " + string3);
            }
            return string3;
        }
        if (string2 != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("(cell):");
            stringBuffer.append(string2);
            string = stringBuffer.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "defaultCellScope: " + string);
        }
        return string;
    }

    public StringBuffer getDisplayAttrs(ConfigService configService, Session session, ObjectName[] objectNameArray, AttributeList attributeList, String[] stringArray) throws CommandValidationException, ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDisplayAttrs");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "objects: " + objectNameArray);
            Tr.debug(tc, "attrList: " + attributeList);
            Tr.debug(tc, "displayAttrs: " + stringArray);
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            if (objectNameArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = null;
                    if (stringArray[i] == null) continue;
                    Tr.debug(tc, "displayAttrs: " + stringArray[i]);
                    if (stringArray[i].equals(CommandConstants.MANAGEMENT_SCOPE)) {
                        ObjectName objectName = (ObjectName)ConfigServiceHelper.getAttributeValue(attributeList, stringArray[i]);
                        if (objectName != null) {
                            string = (String)configService.getAttribute(session, objectName, CommandConstants.SCOPE_NAME);
                        }
                    } else {
                        string = (String)configService.getAttribute(session, objectNameArray[0], stringArray[i]);
                    }
                    if (string == null) continue;
                    stringBuffer.append(stringArray[i]);
                    stringBuffer.append(": ");
                    stringBuffer.append(string);
                    stringBuffer.append(" ");
                }
            }
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDisplayAttrs - " + stringBuffer);
        }
        return stringBuffer;
    }

    public String childDataType(String string) throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "childDataType ");
        }
        String string2 = null;
        if (string != null) {
            if (string.equals(CommandConstants.TRUST_MANAGERS)) {
                string2 = "additionalTrustManagerAttrs";
            } else if (string.equals(CommandConstants.KEY_MANAGERS)) {
                string2 = "additionalKeyManagerAttrs";
            } else if (string.equals(CommandConstants.KEY_STORES)) {
                string2 = "additionalKeyStoreAttrs";
            } else if (string.equals(CommandConstants.KEY_SETS)) {
                string2 = "additionalKeySetAttrs";
            } else {
                String string3 = "The parentDataType is not valid";
                throw new CommandValidationException(string3);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "childDataType: " + string2);
        }
        return string2;
    }

    public boolean DescriptivePropExists(ConfigService configService, Session session, ObjectName objectName, String string, String string2, String string3) throws CommandValidationException, ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DescriptivePropExists ");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "parentObj :        " + objectName);
            Tr.debug(tc, "descPropDataType : " + string);
            Tr.debug(tc, "descPropAttrName : " + string2);
            Tr.debug(tc, "descPropName :     " + string3);
        }
        if (objectName == null || string == null || string2 == null || string3 == null) {
            String string4 = TraceNLSHelper.getInstance().getString("ssl.command.createKeyManager.CWPKI0632E", "Invalid input parameter.");
            throw new CommandValidationException(string4);
        }
        boolean bl = false;
        try {
            AttributeList attributeList = configService.getAttributes(session, objectName, null, true);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "attrs : " + attributeList);
            }
            List list = (List)ConfigServiceHelper.getAttributeValue(attributeList, string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "properties : " + list);
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                AttributeList attributeList2 = (AttributeList)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "property : " + attributeList2);
                }
                ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(attributeList2), null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "matches : " + objectNameArray[0]);
                }
                if (objectNameArray.length == 1) {
                    String string5 = (String)ConfigServiceHelper.getAttributeValue(attributeList2, string2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "propName : " + string5);
                    }
                    if (string5 == null || !string5.equals(string3)) continue;
                    bl = true;
                    break;
                }
                throw new InvalidParameterValueException("DescriptivePropExists", string, attributeList2);
            }
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DescriptivePropExists - " + bl);
        }
        return bl;
    }

    public ObjectName getDescPropObj(ConfigService configService, Session session, ObjectName objectName, String string, String string2, String string3) throws CommandValidationException, ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDescPropObj ");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "parentObj :        " + objectName);
            Tr.debug(tc, "descPropDataType : " + string);
            Tr.debug(tc, "descPropAttrName : " + string2);
            Tr.debug(tc, "descPropName :     " + string3);
        }
        if (objectName == null || string == null || string2 == null || string3 == null) {
            String string4 = TraceNLSHelper.getInstance().getString("ssl.command.createKeyManager.CWPKI0632E", "Invalid input parameter.");
            throw new CommandValidationException(string4);
        }
        ObjectName objectName2 = null;
        try {
            AttributeList attributeList = configService.getAttributes(session, objectName, null, true);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "attrs : " + attributeList);
            }
            List list = (List)ConfigServiceHelper.getAttributeValue(attributeList, string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "properties : " + list);
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                AttributeList attributeList2 = (AttributeList)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "property : " + attributeList2);
                }
                ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(attributeList2), null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "matches : " + objectNameArray[0]);
                }
                if (objectNameArray.length == 1) {
                    String string5 = (String)ConfigServiceHelper.getAttributeValue(attributeList2, string2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "propName : " + string5);
                    }
                    if (string5 == null || !string5.equals(string3)) continue;
                    objectName2 = objectNameArray[0];
                    break;
                }
                throw new InvalidParameterValueException("getDescPropObj", string, attributeList2);
            }
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "exception caught:", exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDescPropObj - " + objectName2);
        }
        return objectName2;
    }
}

