/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.config.ManagementScopeData;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.core.TraceNLSHelper;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import com.ibm.ws.util.PlatformHelperFactory;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;

public class WSKeyStoreRemotable
extends WSKeyStore {
    private static final TraceComponent tc = Tr.register(WSKeyStoreRemotable.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private String name = null;
    private static Map connectorPropMap = null;
    private KeyStore ks = null;

    public WSKeyStoreRemotable(com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore) {
        super(keyStore);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public WSKeyStoreRemotable(WSKeyStore wSKeyStore) {
        Enumeration<?> enumeration = wSKeyStore.propertyNames();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string == null) continue;
                this.setProperty(string, wSKeyStore.getProperty(string));
            }
        }
    }

    public WSKeyStoreRemotable(KeyStoreInfo keyStoreInfo) {
        super(keyStoreInfo);
    }

    public WSKeyStoreRemotable() {
    }

    public Object[] invokeKeyStoreCommand(String string, Object[] objectArray) throws KeyException {
        return this.invokeKeyStoreCommand(string, objectArray, Boolean.FALSE);
    }

    public Object[] invokeKeyStoreCommand(String string, Object[] objectArray, Boolean bl) throws KeyException {
        Object[] objectArray2;
        block45: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "invokeKeyStoreCommand", new Object[]{string});
            }
            objectArray2 = null;
            try {
                Object[] objectArray3;
                Object object;
                String string2 = this.getProperty("com.ibm.ssl.keyStoreHostList");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "keyStoreHostList is " + string2);
                }
                if (string2 != null && !string2.equals("")) {
                    String string3 = "\\|";
                    if (string2.indexOf(44) >= 0) {
                        string3 = ",";
                    }
                    String[] stringArray = string2.split(string3);
                    this.hostInListAreGood(stringArray);
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string4;
                        Properties properties;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Locating connector properties for host: " + stringArray[i]);
                        }
                        if ((properties = (Properties)connectorPropMap.get(string4 = stringArray[i].toLowerCase())) != null) {
                            String string5;
                            String[] stringArray2;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found the node connector props, proceeding to call SSLAdmin MBean using AdminClient.");
                            }
                            if ((stringArray2 = (string5 = properties.getProperty("SOAP HOST|PORT")).split("\\|")) != null && stringArray2.length == 2) {
                                properties.setProperty("host", stringArray2[0]);
                                properties.setProperty("port", stringArray2[1]);
                                properties.setProperty("type", "SOAP");
                                properties.setProperty("isInternal", "true");
                                AdminClient adminClient = AdminClientFactory.createAdminClient(properties);
                                String string6 = properties.getProperty("queryString");
                                ObjectName objectName = new ObjectName(string6);
                                Set set = adminClient.queryNames(objectName, null);
                                ObjectName objectName2 = null;
                                if (set.isEmpty()) {
                                    if (tc.isEntryEnabled()) {
                                        Tr.exit(tc, "invokeKeyStoreCommand: SSLAdmin MBean was not found using queryString " + string6);
                                    }
                                    throw new KeyException("Cannot get AdminClient to make remote keystore request.");
                                }
                                objectName2 = (ObjectName)set.iterator().next();
                                if (objectName2 != null) {
                                    String string7 = this.getProperty("com.ibm.ssl.keyStoreName");
                                    objectArray2 = (Object[])adminClient.invoke(objectName2, "invokeRemoteKeyStoreCommand", new Object[]{string7, string, objectArray}, new String[]{"java.lang.String", "java.lang.String", "[Ljava.lang.Object;"});
                                    continue;
                                }
                                if (tc.isEntryEnabled()) {
                                    Tr.exit(tc, "invokeKeyStoreCommand: SSLAdmin is null.");
                                }
                                throw new KeyException("Cannot get SSLAdmin MBean to make remote keystore request.");
                            }
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "invokeKeyStoreCommand: Host/Port property is null.");
                            }
                            throw new KeyException("Cannot get host and port from connector properties.");
                        }
                        Tr.error(tc, "ssl.cannot.find.node.from.hostlist.CWPKI0039E", new Object[]{string4, this.getProperty("com.ibm.ssl.keyStoreName")});
                    }
                    break block45;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not remote, Calling local KeyStoreCommand via MBean call .");
                }
                if (!PlatformHelperFactory.getPlatformHelper().isZOS()) {
                    return super.invokeKeyStoreCommand(string, objectArray, bl);
                }
                String string8 = this.getProperty("com.ibm.ssl.keyStoreType");
                if (!string8.equals("JCERACFKS") && !string8.equals("JCECCARACFKS")) {
                    return super.invokeKeyStoreCommand(string, objectArray, bl);
                }
                ObjectName objectName = null;
                String string9 = this.getProperty("com.ibm.ssl.keyStoreScope");
                if (string9 != null && !string9.equals("")) {
                    object = new ManagementScopeData(string9);
                    objectArray3 = "WebSphere:type=SSLAdmin";
                    if (((ManagementScopeData)object).getCellName() != null) {
                        objectArray3 = (String)objectArray3 + ",cell=" + ((ManagementScopeData)object).getCellName();
                    }
                    if (((ManagementScopeData)object).getNodeName() != null) {
                        objectArray3 = (String)objectArray3 + ",node=" + ((ManagementScopeData)object).getNodeName();
                    }
                    if (((ManagementScopeData)object).getProcessName() != null) {
                        objectArray3 = (String)objectArray3 + ",process=" + ((ManagementScopeData)object).getProcessName();
                    }
                    objectArray3 = (String)objectArray3 + ",*";
                    objectName = new ObjectName((String)objectArray3);
                } else {
                    objectName = new ObjectName("WebSphere:type=SSLAdmin,*");
                }
                object = AdminServiceFactory.getAdminService().queryNames(objectName, null).iterator();
                if (!object.hasNext()) {
                    if (tc.isDebugEnabled()) {
                        Tr.exit(tc, "SSLAdmin MBean not found. ");
                    }
                    return null;
                }
                objectArray3 = null;
                Object[] objectArray4 = null;
                HashMap<Object, String[]> hashMap = new HashMap<Object, String[]>();
                while (object.hasNext()) {
                    Object object2;
                    Object object3;
                    Iterator iterator;
                    Object object4;
                    String string10 = this.getProperty("com.ibm.ssl.keyStoreName");
                    objectName = (ObjectName)object.next();
                    objectArray2 = (Object[])AdminServiceFactory.getAdminService().invoke(objectName, "invokeRemoteKeyStoreCommand", new Object[]{string10, string, objectArray}, new String[]{"java.lang.String", "java.lang.String", "[Ljava.lang.Object;"});
                    if (string.substring(0, 3).equals("set")) {
                        return objectArray2;
                    }
                    if (string.equals("aliases")) {
                        String[] stringArray;
                        if (objectArray2 == null) continue;
                        if (objectArray3 == null) {
                            object4 = Arrays.asList((String[])objectArray2);
                            iterator = new ArrayList();
                            object3 = object4.iterator();
                            while (object3.hasNext()) {
                                iterator.add((String)((String)object3.next()));
                            }
                            object2 = iterator.toArray((String[])new String[iterator.size()]);
                            objectArray3 = object2;
                            if (!tc.isEntryEnabled()) continue;
                            Tr.debug(tc, "invokeRemoteKeyStoreCommand - merged Aliases list is ", objectArray3);
                            continue;
                        }
                        object4 = Arrays.asList((String[])objectArray3);
                        iterator = Arrays.asList((String[])objectArray2);
                        object3 = new ArrayList();
                        object2 = iterator.iterator();
                        Iterator iterator2 = object4.iterator();
                        while (iterator2.hasNext()) {
                            object3.add((String)iterator2.next());
                        }
                        while (object2.hasNext()) {
                            stringArray = (String[])object2.next();
                            if (object3.contains(stringArray)) continue;
                            object3.add(stringArray);
                        }
                        stringArray = object3.toArray(new String[object3.size()]);
                        objectArray3 = stringArray;
                        continue;
                    }
                    if (string.equals("listPersonalCertificates") || string.equals("listSignerCertificates")) {
                        if (objectArray2 == null) continue;
                        if (hashMap.isEmpty()) {
                            if (tc.isEntryEnabled()) {
                                Tr.debug(tc, "brand new mergedCertsList");
                            }
                            object4 = (HashMap)objectArray2[0];
                            iterator = ((HashMap)object4).keySet().iterator();
                            while (iterator.hasNext()) {
                                object3 = (String)iterator.next();
                                object2 = (Certificate)((HashMap)object4).get(object3);
                                hashMap.put(object3, (String[])object2);
                            }
                            if (!tc.isEntryEnabled()) continue;
                            Tr.debug(tc, "invokeRemoteKeyStoreCommand - new merged Cert list is ", hashMap);
                            continue;
                        }
                        object4 = (HashMap)objectArray2[0];
                        iterator = ((HashMap)object4).keySet().iterator();
                        while (iterator.hasNext()) {
                            object3 = (String)iterator.next();
                            if (hashMap.containsKey(object3)) continue;
                            object2 = (Certificate)((HashMap)object4).get(object3);
                            hashMap.put(object3, (String[])object2);
                        }
                        if (!tc.isEntryEnabled()) continue;
                        Tr.debug(tc, "invokeRemoteKeyStoreCommand - merged Cert list is ", hashMap);
                        continue;
                    }
                    if (!(string.equals("isKeyEntry") | string.equals("isCertificateEntry") | string.equals("containsAlias") ? objectArray2 != null && (Boolean)objectArray2[0] != false : objectArray2 != null && objectArray2.length > 0 && objectArray2[0] != null)) continue;
                    return objectArray2;
                }
                if (string.equals("aliases")) {
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "invokeRemoteKeyStoreCommand - final merged Aliases list is ", objectArray3);
                    }
                    return objectArray3;
                }
                if (string.equals("listPersonalCertificates") || string.equals("listSignerCertificates")) {
                    objectArray4 = new Object[]{hashMap};
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "invokeRemoteKeyStoreCommand - final merged Certs list is ", objectArray4);
                    }
                    return objectArray4;
                }
                return objectArray2;
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception executing KeyStore method.", new Object[]{exception});
                }
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.config.WSKeyStore.invokeKeyStoreCommand", "460", this);
                if (exception instanceof KeyException) {
                    throw (KeyException)exception;
                }
                throw new KeyException(exception.getMessage(), exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invokeKeyStoreCommand");
        }
        return objectArray2;
    }

    private String printParms(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (objectArray == null || objectArray.length == 0) {
            stringBuffer.append("null or empty parms");
            return stringBuffer.toString();
        }
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append("parm ");
            stringBuffer.append(i);
            stringBuffer.append(": ");
            stringBuffer.append(objectArray[i]);
            stringBuffer.append(", ");
        }
        String string = stringBuffer.toString();
        if (string.endsWith(", ")) {
            string = string.substring(0, string.length() - 2);
        }
        return string;
    }

    public static void setConnectorMap(Map map) {
        connectorPropMap = map;
    }

    private void hostInListAreGood(String[] stringArray) throws KeyException {
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            Properties properties;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Locating connector properties for host: " + stringArray[i]);
            }
            if ((properties = (Properties)connectorPropMap.get(string = stringArray[i].toLowerCase())) != null) continue;
            String string2 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.cannot.find.node.from.hostlist.CWPKI0039E", new Object[]{string, this.getProperty("com.ibm.ssl.keyStoreName")}, "Cannot find Node connector properties for the hostname " + string + " in the hostlist for keystore " + this.getProperty("com.ibm.ssl.keyStoreName") + ".");
            throw new KeyException(string2);
        }
    }
}

