/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.websphere.management.dynamicproxy.InvocationHandler;
import com.ibm.websphere.management.dynamicproxy.StateObject;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.core.TraceNLSHelper;
import com.ibm.ws.ssl.core.WSX509TrustManager;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;

public final class SSLAdmin
implements InvocationHandler {
    private static final TraceComponent tc = Tr.register(SSLAdmin.class, "SSL", "com.ibm.ws.ssl.resources.ssl");

    public SSLAdmin() throws Exception {
        this.initialize();
    }

    public void initialize() throws Exception {
    }

    public void preInvoke(String string, Object[] objectArray, String[] stringArray, StateObject stateObject, int n) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "preInvoke() -> " + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "preInvoke");
        }
    }

    public void postInvoke(String string, Object[] objectArray, String[] stringArray, StateObject stateObject, int n, Throwable throwable, boolean bl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "postInvoke -> " + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "postInvoke()");
        }
    }

    public HashMap retrieveSigners(String string, String string2) throws Exception {
        HashMap<String, Object> hashMap;
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "retrieveSigners", new Object[]{string, string2});
            }
            hashMap = new HashMap<String, Object>();
            try {
                if (string == null) {
                    String[] stringArray = KeyStoreManager.getInstance().getKeyStoreAliases();
                    hashMap.put("remoteAliases", stringArray);
                    return hashMap;
                }
                WSKeyStore wSKeyStore = KeyStoreManager.getInstance().getKeyStore(string);
                if (wSKeyStore != null) {
                    KeyStore keyStore = wSKeyStore.getKeyStore(false, false);
                    if (keyStore == null) break block10;
                    if (string2 == null) {
                        Enumeration<String> enumeration = keyStore.aliases();
                        while (enumeration.hasMoreElements()) {
                            Certificate certificate;
                            String string3 = enumeration.nextElement();
                            if (!keyStore.isCertificateEntry(string3) || (certificate = keyStore.getCertificate(string3)) == null) continue;
                            hashMap.put(string3, certificate);
                        }
                        break block10;
                    }
                    Certificate certificate = keyStore.getCertificate(string2);
                    if (certificate != null) {
                        hashMap.put(string2, certificate);
                        break block10;
                    }
                    String string4 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.signer.alias.not.found.CWPKI0305E", new Object[]{string2}, "The <aliasFromRemoteStore> specified as \"" + string2 + "\" was not found in keystore \"" + string + "\" on the server.");
                    throw new SSLException(string4);
                }
                String string5 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.signer.remote.truststore.not.found.CWPKI0304E", new Object[]{string}, "The <remoteTrustStoreName> specified as \"" + string + "\" was not found on the server.");
                throw new SSLException(string5);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught during retrieveSigners, " + exception);
                }
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.core.SSLAdmin.retrieveSigners", "153", this);
                throw exception;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieveSigners");
        }
        return hashMap;
    }

    public Object[] invokeRemoteKeyStoreCommand(String string, String string2, Object[] objectArray) throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeRemoteKeyStoreCommand", new Object[]{string, string2, this.printParms(objectArray)});
        }
        try {
            WSKeyStore wSKeyStore = KeyStoreManager.getInstance().getKeyStore(string);
            if (wSKeyStore == null) {
                if (string2.equals("createRemoteKeyStore")) {
                    if (objectArray == null || objectArray.length != 9) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Invalid parameters for the KeyStore method.");
                        }
                        throw new KeyException("Invalid parameters for the KeyStore method: " + string2);
                    }
                    String string3 = (String)objectArray[0];
                    String string4 = (String)objectArray[1];
                    String string5 = (String)objectArray[2];
                    String string6 = (String)objectArray[3];
                    String string7 = (String)objectArray[4];
                    String string8 = (String)objectArray[5];
                    X509Certificate x509Certificate = (X509Certificate)objectArray[6];
                    String string9 = (String)objectArray[7];
                    X509Certificate x509Certificate2 = (X509Certificate)objectArray[8];
                    KeyStore keyStore = KeyStoreManager.getInstance().getKeyStore(string3, string4, string5, string6, string7, null, true, null);
                    if (keyStore != null) {
                        FileOutputStream fileOutputStream = new FileOutputStream(string6);
                        if (keyStore != null) {
                            if (x509Certificate != null) {
                                keyStore.setCertificateEntry(string8, x509Certificate);
                            }
                            if (x509Certificate2 != null) {
                                keyStore.setCertificateEntry(string9, x509Certificate2);
                            }
                        }
                        keyStore.store(fileOutputStream, string7.toCharArray());
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    return null;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot find \"" + string + "\" on the local node.");
                }
                throw new KeyException("Cannot find \"" + string + "\" in the local node configuration.");
            }
            return wSKeyStore.invokeKeyStoreCommand(string2, objectArray);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception executing KeyStore method.", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.core.SSLAdmin.invokeKeyStoreCommand", "207", this);
            if (exception instanceof KeyException) {
                throw (KeyException)exception;
            }
            throw new KeyException(exception.getMessage(), exception);
        }
    }

    public void temporarilyDisableCertificateAuthentication(Long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "temporarilyDisableCertificateAuthentication", new Object[]{l});
        }
        WSX509TrustManager.temporarilyDisableCertificateAuthentication(l);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "temporarilyDisableCertificateAuthentication");
        }
    }

    private String printParms(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (objectArray == null || objectArray.length == 0) {
            stringBuffer.append("null or empty parms");
            return stringBuffer.toString();
        }
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append("parm ");
            stringBuffer.append(i);
            stringBuffer.append(": ");
            stringBuffer.append(objectArray[i]);
            stringBuffer.append(", ");
        }
        String string = stringBuffer.toString();
        if (string.endsWith(", ")) {
            string = string.substring(0, string.length() - 2);
        }
        return string;
    }
}

