/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.crypto.config.KeySetGroupManager;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.management.service.Admin;
import com.ibm.ws.management.service.ConfigChangeListener;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.util.StreamHandlerUtils;
import com.ibm.ws.ssl.config.CurrentProcessData;
import com.ibm.ws.ssl.config.FIPSManager;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import com.ibm.ws.ssl.config.SSLConfig;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.core.SSLAdmin;
import com.ibm.ws.ssl.core.SSLConfigChangeListener;
import com.ibm.ws.ssl.core.SSLDiagnosticModule;
import com.ibm.ws.ssl.service.SSLService;
import com.ibm.ws.ssl.service.SSLServiceEvent;
import com.ibm.ws.ssl.service.SSLServiceListener;
import com.ibm.ws.ssl.utils.CertificateExpirationMonitor;
import com.ibm.ws.util.PlatformHelperFactory;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;

public class SSLComponentImpl
extends ComponentImpl
implements SSLService {
    private static final TraceComponent tc = Tr.register(SSLComponentImpl.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private ConfigChangeListener configListener = null;
    private EndPointMgr endPointMgr = null;
    private ArrayList listeners = new ArrayList(32);
    private boolean expandedVariables = false;
    private static HashMap configProps = new HashMap();
    private Properties topLevelProps = null;
    private int componentState = 2;
    private static SSLConfigManager sslConfigManager = SSLConfigManager.getInstance();
    private static KeyStoreManager keyStoreManager = KeyStoreManager.getInstance();
    private static KeySetGroupManager keySetGroupManager = KeySetGroupManager.getInstance();
    private static FIPSManager fipsManager = FIPSManager.getInstance();
    private static ManagementScopeManager scopeManager = null;
    private static VariableMap vMap = null;
    private static boolean isServerProcess = false;
    private String processType = null;
    private String processName = null;
    private String serverType = null;
    private String nodeName = null;
    private String[] nodeGroupNames = null;
    private String cellName = null;
    private String jvmType = null;
    private String clusterName = null;
    private String[] currentScopeNames = null;
    private String[] currentNodeGroupScopeNames = null;
    private String currentClusterScopeName = null;
    private String currentProcessScopeName = null;
    private String currentNodeScopeName = null;
    private String currentCellScopeName = null;
    private String configRootPath = null;
    private String cellURI = null;
    private String nodesURI = null;
    private String clustersURI = null;
    private Map nodeConnectorMap = null;
    private CurrentProcessData cpd = null;
    private static final String NODEGROUPHELPER_CLASS = "com.ibm.ws.management.commands.nodegroup.NodeGroupHelper";
    private Class _nodeGroupHelperClass = null;
    private Method _getNodeGroupMembersMethod = null;

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError {
        Tr.info(tc, "ssl.init.startinit.CWPKI0001I");
        Security security2 = null;
        isServerProcess = true;
        try {
            this.addService(SSLService.class);
            vMap = (VariableMap)this.getService(VariableMap.class);
            security2 = this.loadSecurityXMLFromConfig();
            this.initializeCurrentScope();
            scopeManager = ManagementScopeManager.getInstance(this.cpd);
            sslConfigManager.initializeServerSSL(security2, false);
            keySetGroupManager.initializeKeySetGroups(security2, false);
            SSLDiagnosticModule sSLDiagnosticModule = new SSLDiagnosticModule();
            sSLDiagnosticModule.registerWithFFDCService();
            if (ManagementScopeManager.getInstance().getProcessType().equals("DeploymentManager")) {
                WSKeyStoreRemotable.setConnectorMap(this.getNodeAdminProps());
            }
            if ((!PlatformHelperFactory.getPlatformHelper().isZOS() || PlatformHelperFactory.getPlatformHelper().isZOS() && PlatformHelperFactory.getPlatformHelper().isControlJvm()) && (ManagementScopeManager.getInstance().getProcessType().equals("DeploymentManager") || ManagementScopeManager.getInstance().getProcessType().equals("UnManagedProcess"))) {
                CertificateExpirationMonitor.getInstance(security2.getWsCertificateExpirationMonitor());
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.core.SSLComponentImpl.initialize", "190", this);
            Tr.audit(tc, "ssl.init.svcstartfail.CWPKI0007I");
            if (exception instanceof ConfigurationError) {
                throw (ConfigurationError)exception;
            }
            if (exception instanceof ConfigurationWarning) {
                throw (ConfigurationWarning)exception;
            }
            throw new ConfigurationError(exception);
        }
        Tr.info(tc, "ssl.init.startcomplete.CWPKI0002I");
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }

    public void start() throws RuntimeError, RuntimeWarning {
        Tr.info(tc, "ssl.init.svcstart.CWPKI0003I");
        try {
            this.registerListenerWithAdminService();
            this.initializeSSLMBean();
            this.fireStartedEvent();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.core.SSLComponentImpl.start", "233", this);
            Tr.error(tc, "ssl.init.error.CWPKI0008E", new Object[]{exception});
            Tr.audit(tc, "ssl.init.svcstartfail.CWPKI0007I");
            throw new RuntimeError(exception);
        }
        Tr.info(tc, "ssl.init.svcstartcomplete.CWPKI0004I");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerListenerWithAdminService() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerListenerWithAdminService");
        }
        Admin admin2 = null;
        try {
            admin2 = (Admin)this.getService(Admin.class);
            if (admin2 != null) {
                this.configListener = new SSLConfigChangeListener(this);
                admin2.addConfigChangeListener(this.configListener);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.ServerSecurityComponentImpl.registerListenerWithAdminService", "261", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "attempt to register ConfigChangeListener failed", exception);
            }
        }
        finally {
            if (admin2 != null) {
                this.releaseService(admin2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerListenerWithAdminService");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        this.fireStoppedEvent();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Security loadSecurityXMLFromConfig() throws ConfigurationWarning, ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadSecurityXMLFromConfig");
        }
        Repository repository2 = null;
        Security security2 = null;
        try {
            repository2 = (Repository)this.getService(Repository.class);
            ConfigRoot configRoot = repository2.getConfigRoot();
            Resource resource = null;
            String string = "security.xml";
            try {
                resource = configRoot.getResource(0, string);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.core.SSLComponentImpl.initialize", "304", this);
                Tr.error(tc, "ssl.loadresource.error.CWPKI0011E", new Object[]{string, exception});
                throw new ConfigurationError(exception);
            }
            Security security3 = (Security)resource.getContents().get(0);
            EtoolsCopyUtility etoolsCopyUtility = new EtoolsCopyUtility();
            security2 = (Security)etoolsCopyUtility.copy((EObject)security3);
            if (security2 == null) {
                Tr.error(tc, "ssl.init.nullsecobject.CWPKI0009E");
                throw new ConfigurationError("Cannot get WCCM Security object.  security.xml might be corrupt or missing.");
            }
        }
        finally {
            if (repository2 != null) {
                this.releaseService(repository2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadSecurityXMLFromConfig");
        }
        return security2;
    }

    void initializeSSLMBean() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeSSLMBean");
        }
        try {
            SSLAdmin sSLAdmin = new SSLAdmin();
            MBeanFactory mBeanFactory = AdminServiceFactory.getMBeanFactory();
            DefaultRuntimeCollaborator defaultRuntimeCollaborator = new DefaultRuntimeCollaborator(sSLAdmin, "SSLAdmin");
            mBeanFactory.activateMBean("SSLAdmin", defaultRuntimeCollaborator, mBeanFactory.getConfigId("SSLAdmin"), "com/ibm/ws/management/descriptor/xml/SSLAdmin.xml");
        }
        catch (Exception exception) {
            Tr.error(tc, "ssl.init.mbeanerror.CWPKI0006E", new Object[]{"SSLAdmin", exception});
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeSSLMBean");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(SSLServiceListener sSLServiceListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addListener", sSLServiceListener);
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            if (!this.listeners.contains(sSLServiceListener)) {
                this.listeners.add(sSLServiceListener);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(SSLServiceListener sSLServiceListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeListener", sSLServiceListener);
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(sSLServiceListener);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStartedEvent() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fireStartedEvent");
        }
        List list = null;
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            list = (List)this.listeners.clone();
        }
        if (list != null) {
            int n = list.size();
            SSLServiceEvent sSLServiceEvent = new SSLServiceEvent(1);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "list size = " + n);
            }
            for (int i = 0; i < n; ++i) {
                if (tc.isDebugEnabled()) {
                    StringBuffer stringBuffer = new StringBuffer("Invoking stateChanged(), Listener.hashCode() = ");
                    stringBuffer.append(list.get(i).hashCode());
                    stringBuffer.append("Listener.toString()");
                    stringBuffer.append(list.get(i).toString());
                    Tr.debug(tc, stringBuffer.toString());
                }
                try {
                    ((SSLServiceListener)list.get(i)).stateChanged(sSLServiceEvent);
                    continue;
                }
                catch (Exception exception) {
                    Tr.error(tc, "ssl.init.error.CWPKI0008E", new Object[]{exception});
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.core.SSLComponentImpl.fireStartedEvent", "429", this);
                }
            }
        }
        this.componentState = 1;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fireStartedEvent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStoppedEvent() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fireStoppedEvent");
        }
        List list = null;
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            list = (List)this.listeners.clone();
        }
        if (list != null) {
            int n = list.size();
            SSLServiceEvent sSLServiceEvent = new SSLServiceEvent(2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "list size = " + n);
            }
            for (int i = 0; i < n; ++i) {
                if (tc.isDebugEnabled()) {
                    StringBuffer stringBuffer = new StringBuffer("Invoking stateChanged(), Listener.hashCode() = ");
                    stringBuffer.append(list.get(i).hashCode());
                    stringBuffer.append("Listener.toString()");
                    stringBuffer.append(list.get(i).toString());
                    Tr.debug(tc, stringBuffer.toString());
                }
                try {
                    ((SSLServiceListener)list.get(i)).stateChanged(sSLServiceEvent);
                    continue;
                }
                catch (Exception exception) {
                    Tr.error(tc, "ssl.stop.error.CWPKI0015E", new Object[]{exception});
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.core.SSLComponentImpl.fireStoppedEvent", "476", this);
                }
            }
        }
        this.componentState = 2;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fireStoppedEvent");
        }
    }

    public Properties getSecureSocketLayer(String string) throws IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecureSocketLayer", string);
        }
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("Alias is null or empty string.");
        }
        SSLConfig sSLConfig = sslConfigManager.getSSLConfig(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecureSocketLayer");
        }
        return sSLConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigRoot getConfigRoot() {
        Repository repository2 = this.getRepositoryService();
        try {
            ConfigRoot configRoot;
            ConfigRoot configRoot2 = configRoot = repository2.getConfigRoot();
            return configRoot2;
        }
        catch (Exception exception) {
            ConfigRoot configRoot = null;
            return configRoot;
        }
        finally {
            this.releaseRepositoryService(repository2);
        }
    }

    public Repository getRepositoryService() {
        Repository repository2 = null;
        try {
            repository2 = (Repository)this.getService(Repository.class);
            return repository2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void releaseRepositoryService(Repository repository2) {
        if (repository2 != null) {
            this.releaseService(repository2);
        }
    }

    private void expandVariables() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "expandVariables");
        }
        VariableMap variableMap = (VariableMap)this.getService(VariableMap.class);
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        try {
            string = variableMap.expand("${WAS_INSTALL_ROOT}");
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot expand ${WAS_INSTALL_ROOT}");
            }
            string = System.getProperty("was.install.root");
        }
        try {
            string2 = variableMap.expand("${USER_INSTALL_ROOT}");
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot expand ${USER_INSTALL_ROOT}");
            }
            string2 = System.getProperty("user.install.root", System.getProperty("was.install.root"));
        }
        try {
            string3 = variableMap.expand("${WAS_TEMP_DIR}");
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot expand ${WAS_TEMP_DIR}");
            }
            string3 = string + File.separator + "tmp";
        }
        try {
            string5 = variableMap.expand("${WAS_PROPS_DIR}");
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot expand ${WAS_PROPS_DIR}");
            }
            string5 = string + File.separator + "properties";
        }
        try {
            string6 = variableMap.expand("${APP_INSTALL_ROOT}");
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot expand ${APP_INSTALL_ROOT}");
            }
            string6 = string + File.separator + "installedApps";
        }
        try {
            string4 = variableMap.expand("${WAS_ETC_DIR}");
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot expand ${WAS_ETC_DIR}");
            }
            string4 = string + File.separator + "etc";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "expandVariables");
        }
    }

    public static Properties getProperties(List list) {
        Properties properties = new Properties();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Property property = (Property)list.get(i);
                properties.put(property.getName(), property.getValue());
            }
        }
        return properties;
    }

    public static String expand(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "expand <- " + string);
        }
        String string2 = vMap.expand(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "expand -> " + string2);
        }
        return string2;
    }

    public static boolean isServerProcess() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isServerProcess");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isServerProcess -> " + isServerProcess);
        }
        return isServerProcess;
    }

    public static String dumpConfigForFFDC() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(sslConfigManager.toString());
        stringBuffer.append(scopeManager.toString());
        return stringBuffer.toString();
    }

    private Class getNodeGroupHelperClass() {
        block3: {
            if (this._nodeGroupHelperClass == null) {
                Class<?> clazz = null;
                try {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    clazz = classLoader != null ? classLoader.loadClass(NODEGROUPHELPER_CLASS) : Class.forName(NODEGROUPHELPER_CLASS);
                    this._nodeGroupHelperClass = clazz;
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, ManagementScopeManager.class.getName(), "682");
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "Exception getting NodeGroupHelper class.", new Object[]{exception});
                }
            }
        }
        return this._nodeGroupHelperClass;
    }

    private Method getNodeGroupMembersMethod() {
        block3: {
            Class clazz;
            if (this._getNodeGroupMembersMethod == null && (clazz = this.getNodeGroupHelperClass()) != null) {
                try {
                    this._getNodeGroupMembersMethod = clazz.getMethod("getNodeGroupMembers", Session.class, ConfigService.class, String.class);
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, ManagementScopeManager.class.getName(), "703");
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "Exception getting NodeGroupHelper class.", new Object[]{exception});
                }
            }
        }
        return this._getNodeGroupMembersMethod;
    }

    public void initializeCurrentScope() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeCurrentScope");
        }
        AdminService adminService = AdminServiceFactory.getAdminService();
        this.processType = adminService.getProcessType();
        this.processName = adminService.getProcessName();
        this.serverType = adminService.getServerType();
        this.nodeName = adminService.getNodeName();
        this.cellName = adminService.getCellName();
        this.jvmType = adminService.getJvmType();
        this.clusterName = this.getClusterNameFromConfig();
        ConfigRoot configRoot = this.getConfigRoot();
        this.configRootPath = configRoot.getConfigRootPath();
        this.cellURI = "cells/" + this.cellName + "/";
        this.nodesURI = "cells/" + this.cellName + "/nodes/";
        this.clustersURI = "cells/" + this.cellName + "/clusters/";
        this.nodeGroupNames = this.getCurrentNodeGroupNames(this.nodeName);
        this.currentScopeNames = this.formCurrentFullScopeNames();
        this.currentNodeGroupScopeNames = this.formNodeGroupScopes(this.nodeGroupNames);
        this.currentClusterScopeName = this.formClusterScope();
        this.currentProcessScopeName = this.formProcessScope();
        this.currentNodeScopeName = this.formNodeScope();
        this.currentCellScopeName = this.formCellScope();
        this.cpd = new CurrentProcessData(this.processType, this.processName, this.serverType, this.nodeName, this.nodeGroupNames, this.cellName, this.jvmType, this.clusterName, this.currentScopeNames, this.currentNodeGroupScopeNames, this.currentClusterScopeName, this.currentProcessScopeName, this.currentNodeScopeName, this.currentCellScopeName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeCurrentScope", new Object[]{this.currentScopeNames[0]});
        }
    }

    private String[] formCurrentFullScopeNames() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formCurrentScopeNames");
        }
        if (this.nodeGroupNames != null && this.nodeGroupNames.length == 1) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "formCurrentScopeNames(1)");
            }
            return new String[]{this.formCurrentFullScope(this.nodeGroupNames[0])};
        }
        if (this.nodeGroupNames != null && this.nodeGroupNames.length > 1) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < this.nodeGroupNames.length; ++i) {
                arrayList.add(this.formCurrentFullScope(this.nodeGroupNames[i]));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "formCurrentScopeNames(>1)");
            }
            return arrayList.toArray(new String[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formCurrentScopeNames(null)");
        }
        return new String[]{this.formCurrentFullScope(null)};
    }

    public ArrayList getClusterMembers(ConfigRoot configRoot, String string) {
        return null;
    }

    private String[] formNodeGroupScopes(String[] stringArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formNodeGroupScopes");
        }
        if (stringArray != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("(cell):");
                stringBuffer.append(this.cellName);
                stringBuffer.append(":(nodegroup):");
                stringBuffer.append(stringArray[i]);
                String string = stringBuffer.toString();
                arrayList.add(string);
            }
            String[] stringArray2 = arrayList.toArray(new String[0]);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "formNodeGroupScopes");
            }
            return stringArray2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formNodeGroupScopes (null)");
        }
        return null;
    }

    private String formCurrentFullScope(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formCurrentFullScope");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(cell):");
        stringBuffer.append(this.cellName);
        if (string != null) {
            stringBuffer.append(":(nodegroup):");
            stringBuffer.append(string);
        }
        if (this.clusterName != null) {
            stringBuffer.append(":(cluster):");
            stringBuffer.append(this.clusterName);
        }
        stringBuffer.append(":(node):");
        stringBuffer.append(this.nodeName);
        stringBuffer.append(":(server):");
        stringBuffer.append(this.processName);
        String string2 = stringBuffer.toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formCurrentFullScope: " + string2);
        }
        return string2;
    }

    private String formProcessScope() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formProcessScope");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(cell):");
        stringBuffer.append(this.cellName);
        stringBuffer.append(":(node):");
        stringBuffer.append(this.nodeName);
        stringBuffer.append(":(server):");
        stringBuffer.append(this.processName);
        String string = stringBuffer.toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formProcessScope: " + string);
        }
        return string;
    }

    private String formNodeScope() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formNodeScope");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(cell):");
        stringBuffer.append(this.cellName);
        stringBuffer.append(":(node):");
        stringBuffer.append(this.nodeName);
        String string = stringBuffer.toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formNodeScope: " + string);
        }
        return string;
    }

    private String formCellScope() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formCellScope");
        }
        String string = "(cell):" + this.cellName;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formCellScope: " + string);
        }
        return string;
    }

    private String formClusterScope() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formClusterScope");
        }
        String string = null;
        if (this.clusterName != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("(cell):");
            stringBuffer.append(this.cellName);
            stringBuffer.append(":(cluster):");
            stringBuffer.append(this.clusterName);
            string = stringBuffer.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formClusterScope: " + string);
        }
        return string;
    }

    private String getClusterNameFromConfig() {
        String string;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getClusterName");
            }
            string = null;
            try {
                Repository repository2 = this.getRepositoryService();
                if (repository2 != null) {
                    string = repository2.getClusterName();
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getClusterName -> " + string);
                    }
                }
                this.releaseRepositoryService(repository2);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.config.ManagementScopeManager.getClusterName", "912", this);
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "Exception occurred getting Cluster name.", new Object[]{exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterName -> null");
        }
        return string;
    }

    private String[] getCurrentNodeGroupNames(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCurrentNodeGroupNames", new Object[]{string});
        }
        ArrayList arrayList = this.getNodeGroupNames(this.configRootPath, this.cellURI);
        String[] stringArray = null;
        if (arrayList != null && arrayList.size() == 1) {
            return new String[]{(String)arrayList.get(0)};
        }
        if (arrayList != null && arrayList.size() > 1) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            String[] stringArray2 = arrayList.toArray(new String[0]);
            for (int i = 0; i < stringArray2.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "NodeGroup[" + i + "]: " + stringArray2[i]);
                }
                if ((stringArray = this.getNodeGroupMembers(stringArray2[i])) == null) continue;
                for (int j = 0; j < stringArray.length; ++j) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "NodeGroupMember[" + j + "]: " + stringArray[j]);
                    }
                    if (!string.equals(stringArray[j])) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "This node is a member of NodeGroup: " + stringArray2[i]);
                    }
                    arrayList2.add(stringArray2[i]);
                }
            }
            if (arrayList2 != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getCurrentNodeGroupNames", new Object[]{arrayList2});
                }
                return arrayList2.toArray(new String[0]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCurrentNodeGroupNames -> null");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getNodeGroupMembers(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeGroupMembers");
        }
        ConfigService configService = null;
        Session session = null;
        try {
            Object object;
            String[] stringArray = null;
            session = new Session();
            configService = ConfigServiceFactory.getConfigService();
            if (configService == null) {
                object = new Properties();
                ((Properties)object).setProperty("location", "local");
                configService = ConfigServiceFactory.createConfigService(true, (Properties)object);
            }
            if ((object = this.getNodeGroupMembersMethod()) != null) {
                stringArray = (String[])((Method)object).invoke(null, session, configService, string);
            }
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getNodeGroupMembers", new Object[]{stringArray});
            }
            String[] stringArray2 = stringArray;
            return stringArray2;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.config.ManagementScopeManager.getNodeGroupMembers", "990", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred getting NodeGroup members.", new Object[]{exception});
            }
        }
        finally {
            try {
                if (session != null && configService != null) {
                    configService.discard(session);
                }
            }
            catch (Exception exception) {}
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeGroupMembers -> null");
        }
        return null;
    }

    private ArrayList getNodeGroupNames(String string, String string2) {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getNodeGroupNames");
            }
            try {
                File[] fileArray;
                String string3 = string + string2 + "nodegroups/";
                File file = new File(string3);
                if (file != null && file.isDirectory() && (fileArray = file.listFiles()) != null && fileArray.length > 0) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (int i = 0; i < fileArray.length; ++i) {
                        if (!fileArray[i].isDirectory()) continue;
                        arrayList.add(fileArray[i].getName());
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getNodeGroupNames -> ", new Object[]{arrayList});
                    }
                    return arrayList;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.config.ManagementScopeManager.getNodeGroupNames", "1031", this);
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "Exception occurred getting NodeGroup names.", new Object[]{exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeGroupNames -> null");
        }
        return null;
    }

    private ArrayList getServerNames(String string, String string2) {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getServerNames");
            }
            try {
                File[] fileArray;
                String string3 = string + string2 + "/servers/";
                File file = new File(string3);
                if (file != null && file.isDirectory() && (fileArray = file.listFiles()) != null && fileArray.length > 0) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (int i = 0; i < fileArray.length; ++i) {
                        if (!fileArray[i].isDirectory()) continue;
                        arrayList.add(fileArray[i].getName());
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getServerNames -> ", new Object[]{arrayList});
                    }
                    return arrayList;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.config.ManagementScopeManager.getServerNames", "1071", this);
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "Exception occurred getting Server names.", new Object[]{exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerNames -> null");
        }
        return null;
    }

    public static Boolean queryProvider(String string) {
        return new Boolean(StreamHandlerUtils.queryProvider(string));
    }

    public static void addProvider(String string, String string2) {
        try {
            StreamHandlerUtils.addProvider(string, string2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Boolean queryHandler() {
        return new Boolean(StreamHandlerUtils.queryHandler());
    }

    public static void createStreamHandler() {
        try {
            StreamHandlerUtils.createStreamHandler();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Map getNodeAdminProps() throws Exception {
        HashMap<String, Properties> hashMap;
        block15: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getNodeAdminProps");
            }
            ConfigRoot configRoot = this.getConfigRoot();
            hashMap = new HashMap<String, Properties>();
            String string = ManagementScopeManager.getInstance().getCellName();
            try {
                String[] stringArray = configRoot.list(3, null);
                String string2 = configRoot.getValue(3);
                for (int i = 0; i < stringArray.length; ++i) {
                    String string3 = stringArray[i];
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Node name: " + string3);
                    }
                    configRoot.setValue(3, stringArray[i]);
                    Resource resource = configRoot.getResource(3, "serverindex.xml");
                    EList eList = resource.getContents();
                    ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
                    EList eList2 = serverIndex.getServerEntries();
                    for (int j = 0; j < eList2.size(); ++j) {
                        Properties properties = null;
                        ServerEntry serverEntry = (ServerEntry)eList2.get(j);
                        String string4 = null;
                        if (serverEntry != null) {
                            properties = new Properties();
                            properties.setProperty("queryString", "WebSphere:type=SSLAdmin,cell=" + string + ",node=" + string3 + ",*");
                            String string5 = serverEntry.getServerType();
                            if (string5.equals("NODE_AGENT")) {
                                EndPoint endPoint = null;
                                EndPoint endPoint2 = null;
                                EList eList3 = serverEntry.getSpecialEndpoints();
                                for (int k = 0; k < eList3.size(); ++k) {
                                    NamedEndPoint namedEndPoint = (NamedEndPoint)eList3.get(k);
                                    if (namedEndPoint.getEndPointName().equals("SOAP_CONNECTOR_ADDRESS")) {
                                        endPoint = namedEndPoint.getEndPoint();
                                    }
                                    if (!namedEndPoint.getEndPointName().equals("BOOTSTRAP_ADDRESS") || (endPoint2 = namedEndPoint.getEndPoint()) == null) continue;
                                    String string6 = new Integer(endPoint2.getPort()).toString();
                                    string4 = endPoint2.getHost();
                                    properties.setProperty("java.naming.provider.url", "corbaloc:iiop:" + string4 + ":" + string6 + "/WsnAdminNameService");
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug(tc, "PROVIDER_URL: corbaloc:iiop:" + string4 + ":" + string6);
                                }
                                if (endPoint != null) {
                                    if (string4 == null) {
                                        string4 = endPoint.getHost();
                                    }
                                    properties.setProperty("SOAP HOST|PORT", endPoint.getHost() + "|" + new Integer(endPoint.getPort()).toString());
                                }
                                if (endPoint2 != null) {
                                    if (string4 == null) {
                                        string4 = endPoint2.getHost();
                                    }
                                    properties.setProperty("RMI HOST|PORT", endPoint2.getHost() + "|" + new Integer(endPoint2.getPort()).toString());
                                }
                            }
                        }
                        if (properties == null || string4 == null) continue;
                        hashMap.put(string4.toLowerCase(), properties);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Set connector props for hostname \"" + string4.toLowerCase() + "\" with prop values: " + properties.toString());
                    }
                }
                configRoot.setValue(3, string2);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.core.SSLComponentImpl.getNodeAdminProps", "1215", this);
                if (!tc.isDebugEnabled()) break block15;
                Tr.debug(tc, "Exception occurred getting Connector props for Node.", new Object[]{exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeAdminProps");
        }
        return hashMap;
    }
}

