/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ssl.config.SSLConfig;
import com.ibm.ws.ssl.core.CertMappingKeyManager;
import com.ibm.ws.ssl.core.TraceNLSHelper;
import com.ibm.wsspi.ssl.KeyManagerExtendedInfo;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;

public final class WSX509KeyManager
implements X509KeyManager {
    private static final TraceComponent tc = Tr.register(WSX509KeyManager.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private SSLConfig config = null;
    private KeyStore ks = null;
    private KeyManager[] kmList = null;
    private X509KeyManager km = null;
    private X509KeyManager customKM = null;
    private CertMappingKeyManager certMappingKeyManager = null;
    private String clientAlias = null;
    private String serverAlias = null;
    private int clientslotnum = 0;
    private int serverslotnum = 0;

    public void setClientAlias(String string, int n) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setClientAlias", new Object[]{string, new Integer(n)});
        }
        if (!this.ks.containsAlias(string)) {
            String string2 = this.config.getProperty("com.ibm.ssl.keyStore");
            String string3 = this.config.getProperty("com.ibm.ssl.tokenLibraryFile");
            String string4 = string2 != null ? string2 : string3;
            String string5 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.client.alias.not.found.CWPKI0023E", new Object[]{string, string4}, "Client alias " + string + " not found in keystore.");
            Tr.error(tc, string5);
            throw new IllegalArgumentException(string5);
        }
        this.clientAlias = string;
        this.clientslotnum = n;
        if (this.customKM != null && this.customKM instanceof KeyManagerExtendedInfo) {
            ((KeyManagerExtendedInfo)((Object)this.customKM)).setKeyStoreClientAlias(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setClientAlias");
        }
    }

    public void setServerAlias(String string, int n) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setServerAlias", new Object[]{string, new Integer(n)});
        }
        if (!this.ks.containsAlias(string)) {
            String string2 = this.config.getProperty("com.ibm.ssl.keyStore");
            String string3 = this.config.getProperty("com.ibm.ssl.tokenLibraryFile");
            String string4 = string2 != null ? string2 : string3;
            String string5 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.server.alias.not.found.CWPKI0024E", new Object[]{string, string4}, "Server alias " + string + " not found in keystore.");
            Tr.error(tc, string5);
            throw new IllegalArgumentException(string5);
        }
        this.serverAlias = string;
        this.serverslotnum = n;
        if (this.customKM != null && this.customKM instanceof KeyManagerExtendedInfo) {
            ((KeyManagerExtendedInfo)((Object)this.customKM)).setKeyStoreServerAlias(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setServerAlias");
        }
    }

    public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "chooseClientAlias", new Object[]{stringArray, principalArray, socket});
        }
        if (this.customKM != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "chooseClientAlias -> " + this.customKM.getClass().getName());
            }
            return this.customKM.chooseClientAlias(stringArray, principalArray, socket);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "chooseClientAlias");
        }
        return this.chooseClientAlias(stringArray[0], principalArray);
    }

    public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "chooseServerAlias", new Object[]{string, principalArray, socket});
        }
        if (this.customKM != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "chooseServerAlias -> " + this.customKM.getClass().getName());
            }
            return this.customKM.chooseServerAlias(string, principalArray, socket);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "chooseServerAlias");
        }
        return this.chooseServerAlias(string, principalArray);
    }

    public String chooseClientAlias(String string, Principal[] principalArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "chooseClientAlias", new Object[]{string, principalArray});
        }
        if (this.clientAlias != null && !this.clientAlias.equals("")) {
            String[] stringArray = this.km.getClientAliases(string, principalArray);
            String string2 = "";
            if (stringArray != null) {
                boolean bl = false;
                for (int i = 0; i < stringArray.length; ++i) {
                    string2 = string2 + stringArray[i] + " ";
                    if (!this.clientAlias.equalsIgnoreCase(stringArray[i])) continue;
                    bl = true;
                }
                if (bl) {
                    String string3 = this.normalizeAliasName(this.clientAlias);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "chooseClientAlias", new Object[]{string3});
                    }
                    return string3;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "chooseClientAlias (default)", new Object[]{this.clientAlias});
            }
            return this.clientAlias;
        }
        String[] stringArray = new String[]{string};
        String string4 = this.km.chooseClientAlias(stringArray, principalArray, null);
        String string5 = this.normalizeAliasName(string4);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "chooseClientAlias (from JSSE)", new Object[]{string5});
        }
        return string5;
    }

    public String chooseServerAlias(String string, Principal[] principalArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "chooseServerAlias", new Object[]{string, principalArray});
        }
        Map map = JSSEHelper.getInstance().getInboundConnectionInfo();
        String string2 = this.certMappingKeyManager.getProperty("com.ibm.ssl.cert.mapping.file");
        String string3 = null;
        if (map != null && ((Boolean)map.get(JSSEHelper.CONNECTION_INFO_IS_WEB_CONTAINER_INBOUND)).booleanValue() && string2 != null) {
            string3 = this.certMappingKeyManager.chooseServerAlias(string, principalArray, null);
        }
        if (string3 == null) {
            if (this.serverAlias != null && !this.serverAlias.equals("")) {
                String[] stringArray = this.km.getServerAliases(string, principalArray);
                String string4 = "";
                if (stringArray != null) {
                    boolean bl = false;
                    for (int i = 0; i < stringArray.length; ++i) {
                        string4 = string4 + stringArray[i] + " ";
                        if (!this.serverAlias.equalsIgnoreCase(stringArray[i])) continue;
                        bl = true;
                    }
                    if (bl) {
                        String string5 = this.normalizeAliasName(this.serverAlias);
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "chooseServerAlias", new Object[]{string5});
                        }
                        return string5;
                    }
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "chooseServerAlias (default)", new Object[]{this.serverAlias});
                }
                return this.serverAlias;
            }
            String string6 = this.km.chooseServerAlias(string, principalArray, null);
            String string7 = this.normalizeAliasName(string6);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "chooseServerAlias (from JSSE)", new Object[]{string7});
            }
            return string7;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "chooseServerAlias", new Object[]{string3});
        }
        return string3;
    }

    public String[] getClientAliases(String string, Principal[] principalArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClientAliases", new Object[]{string, principalArray});
        }
        if (this.customKM != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getClientAliases -> " + this.customKM.getClass().getName());
            }
            return this.customKM.getClientAliases(string, principalArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClientAliases -> " + this.km.getClass().getName());
        }
        return this.km.getClientAliases(string, principalArray);
    }

    public String[] getServerAliases(String string, Principal[] principalArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerAliases", new Object[]{string, principalArray});
        }
        if (this.customKM != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServerAliases -> " + this.customKM.getClass().getName());
            }
            return this.customKM.getServerAliases(string, principalArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerAliases -> " + this.km.getClass().getName());
        }
        return this.km.getServerAliases(string, principalArray);
    }

    public PrivateKey getPrivateKey(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPrivateKey", new Object[]{string});
        }
        if (this.customKM != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPrivateKey -> " + this.customKM.getClass().getName());
            }
            return this.customKM.getPrivateKey(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPrivateKey -> " + this.km.getClass().getName());
        }
        return this.km.getPrivateKey(string);
    }

    public X509Certificate[] getCertificateChain(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCertificateChain", new Object[]{string});
        }
        if (this.customKM != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCertificateChain -> " + this.customKM.getClass().getName());
            }
            return this.customKM.getCertificateChain(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCertificateChain -> " + this.km.getClass().getName());
        }
        return this.km.getCertificateChain(string);
    }

    public X509KeyManager getX509KeyManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getX509KeyManager");
        }
        if (this.customKM != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getX509KeyManager -> " + this.customKM.getClass().getName());
            }
            return this.customKM;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getX509KeyManager -> " + this.km.getClass().getName());
        }
        return this.km;
    }

    public WSX509KeyManager(KeyStore keyStore, char[] cArray, KeyManagerFactory keyManagerFactory, SSLConfig sSLConfig, X509KeyManager x509KeyManager) throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
        this.ks = keyStore;
        this.kmList = keyManagerFactory.getKeyManagers();
        this.certMappingKeyManager = new CertMappingKeyManager();
        if (this.kmList != null) {
            this.km = (X509KeyManager)this.kmList[0];
        }
        this.config = sSLConfig;
        this.customKM = x509KeyManager;
        if (this.customKM != null && this.customKM instanceof KeyManagerExtendedInfo) {
            if (sSLConfig != null) {
                ((KeyManagerExtendedInfo)((Object)this.customKM)).setSSLConfig(sSLConfig);
            }
            KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
            X509KeyManager x509KeyManager2 = null;
            if (keyManagerArray != null && keyManagerArray[0] != null) {
                x509KeyManager2 = (X509KeyManager)keyManagerArray[0];
            }
            if (x509KeyManager2 != null) {
                ((KeyManagerExtendedInfo)((Object)this.customKM)).setDefaultX509KeyManager(x509KeyManager2);
            }
            if (keyStore != null) {
                ((KeyManagerExtendedInfo)((Object)this.customKM)).setKeyStore(keyStore);
            }
        }
    }

    private String normalizeAliasName(String string) {
        String string2 = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "normalizeAliasName", new Object[]{string});
        }
        if (string != null) {
            string2 = this.ks.getType() != null && (this.ks.getType().equals("CMSKS") || this.ks.getType().equals("JCERACFKS") || this.ks.getType().equals("JCECCARACFKS")) ? string : string.toLowerCase();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "normalizeAliasName", new Object[]{string2});
            }
        }
        return string2;
    }
}

