/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.provider;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ssl.JSSEProvider;
import com.ibm.ws.ssl.config.SSLConfig;
import com.ibm.ws.ssl.provider.AbstractJSSEProvider;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class IBMJSSEFIPSProvider
extends AbstractJSSEProvider
implements JSSEProvider {
    private String keyManager = "IbmX509";
    private String trustManager = "IbmX509";
    private String contextProvider = "IBMJSSE2";
    private String keyStoreProvider = "IBMJCE";
    private String socketFactory = "com.ibm.fips.jsse.JSSESocketFactory";
    private String protocolPackageHandler = "com.ibm.net.ssl.www2.protocol";
    private static TraceComponent tc = Tr.register(IBMJSSEFIPSProvider.class.getName(), "SSL");

    public IBMJSSEFIPSProvider() {
        this.initializeHandlers(this.protocolPackageHandler);
        Provider provider = null;
        try {
            provider = Security.getProvider("IBMJSSE");
        }
        catch (Throwable throwable) {
            System.err.println("getProvider(IBMJSSE) Exception caught: " + throwable.getMessage());
            throwable.printStackTrace();
        }
        Provider provider2 = null;
        try {
            provider2 = Security.getProvider("IBMJSSEFIPS");
        }
        catch (Throwable throwable) {
            System.err.println("getProvider(IBMJSSEFIPS) Exception caught: " + throwable.getMessage());
            throwable.printStackTrace();
        }
        try {
            if (provider2 == null) {
                int n = 0;
                if (provider != null) {
                    Provider[] providerArray = Security.getProviders();
                    for (int i = 0; i < providerArray.length; ++i) {
                        if (providerArray[i] == null || !new String("IBMJSSE").equals(providerArray[i].getName())) continue;
                        n = i;
                        break;
                    }
                }
                provider2 = (Provider)Class.forName("com.ibm.fips.jsse.IBMJSSEFIPSProvider").newInstance();
                if (n > 0) {
                    Security.insertProviderAt(provider2, n);
                } else {
                    Security.addProvider(provider2);
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Exception caught adding IBMJSSEFIPS: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public String getDefaultSSLSocketFactoryClass() {
        return super.getDefaultSSLSocketFactoryClass(this.socketFactory);
    }

    public String getSSLProtocolPackageHandler() {
        return this.protocolPackageHandler;
    }

    public SSLContext getSSLContextInstance(SSLConfig sSLConfig) throws SSLException {
        return super.getSSLContextInstance(sSLConfig);
    }

    public TrustManagerFactory getTrustManagerFactoryInstance() throws NoSuchAlgorithmException, NoSuchProviderException {
        return super.getTrustManagerFactoryInstance(this.trustManager, this.contextProvider);
    }

    public KeyManagerFactory getKeyManagerFactoryInstance() throws NoSuchAlgorithmException, NoSuchProviderException {
        return super.getKeyManagerFactoryInstance(this.keyManager, this.contextProvider);
    }

    public KeyStore getKeyStoreInstance(String string, String string2) throws KeyStoreException, NoSuchProviderException {
        if (string2 == null) {
            string2 = this.keyStoreProvider;
        }
        return super.getKeyStoreInstance(string, string2);
    }

    public String getKeyManager() {
        return this.keyManager;
    }

    public String getTrustManager() {
        return this.trustManager;
    }

    public String getContextProvider() {
        return this.contextProvider;
    }

    public String getKeyStoreProvider() {
        return this.keyStoreProvider;
    }

    public String getSocketFactory() {
        return this.socketFactory;
    }

    public String getProtocolPackageHandler() {
        return this.protocolPackageHandler;
    }
}

