/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.startupservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.startupservice.StartUpModule;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.naming.InitialContext;

public class StartUpApplication {
    Map modules;
    String name;
    boolean started;
    static TraceComponent tc = Tr.register(StartUpApplication.class, "StartupService", "com.ibm.ws.startupservice.StartupServiceMessages");

    public StartUpApplication(String string) {
        this.name = string;
        this.modules = new LinkedHashMap(100);
        this.started = false;
    }

    public synchronized StartUpModule replaceModule(String string) {
        StartUpModule startUpModule = null;
        startUpModule = new StartUpModule(string);
        this.modules.put(string, startUpModule);
        return startUpModule;
    }

    public synchronized void removeModule(String string) {
        if (this.modules.containsKey(string)) {
            Tr.debug(tc, "Removing meta data for module: " + string);
            this.modules.remove(string);
        }
    }

    public boolean isEmpty() {
        return this.modules.isEmpty();
    }

    public synchronized StartUpModule getModule(String string) {
        StartUpModule startUpModule = null;
        if (this.modules.containsKey(string)) {
            startUpModule = (StartUpModule)this.modules.get(string);
        } else {
            startUpModule = new StartUpModule(string);
            this.modules.put(string, startUpModule);
        }
        return startUpModule;
    }

    public synchronized StartUpModule getModuleNoCreate(String string) {
        StartUpModule startUpModule = null;
        if (this.modules.containsKey(string)) {
            startUpModule = (StartUpModule)this.modules.get(string);
        }
        return startUpModule;
    }

    public boolean start(InitialContext initialContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "starting " + this.name);
        }
        try {
            this.started = true;
            boolean bl = true;
            Iterator iterator = this.modules.values().iterator();
            while (iterator.hasNext()) {
                StartUpModule startUpModule = (StartUpModule)iterator.next();
                boolean bl2 = startUpModule.appStart(initialContext);
                if (bl2) continue;
                bl = false;
            }
            boolean bl3 = bl;
            return bl3;
        }
        catch (RuntimeException runtimeException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Start processing aborted with RuntimeException: " + runtimeException);
            }
            throw runtimeException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "starting " + this.name);
            }
        }
    }

    public void stop(InitialContext initialContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopping " + this.name);
        }
        try {
            if (this.started) {
                this.started = false;
                ArrayList arrayList = this.putModulesInList();
                if (arrayList == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "No EJBModules in application: " + this.name);
                    }
                } else {
                    for (int i = arrayList.size() - 1; i >= 0; --i) {
                        ((StartUpModule)arrayList.get(i)).appStop(initialContext);
                    }
                }
            }
        }
        catch (RuntimeException runtimeException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Stop processing aborted with RuntimeException: " + runtimeException);
            }
            throw runtimeException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "stopping " + this.name);
            }
        }
    }

    public void allStop(InitialContext initialContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopping all" + this.name);
        }
        try {
            if (this.started) {
                this.started = false;
                ArrayList arrayList = this.putModulesInList();
                if (arrayList == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "No EJBModules in application: " + this.name);
                    }
                } else {
                    int n;
                    for (n = arrayList.size() - 1; n >= 0; --n) {
                        ((StartUpModule)arrayList.get(n)).appStop(initialContext);
                    }
                    for (n = arrayList.size() - 1; n >= 0; --n) {
                        ((StartUpModule)arrayList.get(n)).modStop(initialContext);
                    }
                }
            }
        }
        catch (RuntimeException runtimeException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "AllStop processing aborted with RuntimeException: " + runtimeException);
            }
            throw runtimeException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "stopping all " + this.name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList putModulesInList() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "modulesInReverseOrder()");
        }
        try {
            Object object;
            ArrayList<StartUpModule> arrayList = null;
            int n = this.modules.size();
            if (n > 0) {
                arrayList = new ArrayList<StartUpModule>();
                object = this.modules.values().iterator();
                while (object.hasNext()) {
                    arrayList.add((StartUpModule)object.next());
                }
            }
            object = arrayList;
            return object;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "modulesInReverseOrder");
            }
        }
    }
}

