/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.startupservice;

import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.EJBModuleInitializationCollaborator;
import com.ibm.websphere.csi.EJBModuleMetaData;
import com.ibm.websphere.models.config.startupbeansservice.StartupBeansService;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.deploy.DeployedApplication;
import com.ibm.ws.runtime.deploy.DeployedModule;
import com.ibm.ws.runtime.deploy.DeployedObject;
import com.ibm.ws.runtime.deploy.DeployedObjectEvent;
import com.ibm.ws.runtime.deploy.DeployedObjectListener;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.runtime.metadata.MetaDataEvent;
import com.ibm.ws.runtime.metadata.MetaDataListener;
import com.ibm.ws.runtime.metadata.MetaDataSlot;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.runtime.service.ApplicationMgr;
import com.ibm.ws.runtime.service.EJBContainer;
import com.ibm.ws.runtime.service.MetaDataService;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.startupservice.StartUpApplication;
import com.ibm.ws.startupservice.StartUpBeanInvalid;
import com.ibm.ws.startupservice.StartUpModule;
import com.ibm.ws.util.PlatformHelper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class StartUpService
extends ComponentImpl
implements MetaDataListener,
DeployedObjectListener,
EJBModuleInitializationCollaborator,
PropertyChangeListener {
    static final TraceComponent tc = Tr.register(StartUpService.class, "StartupService", "com.ibm.ws.startupservice.StartupServiceMessages");
    Map applications = new HashMap();
    MetaDataSlot md_slot;
    InitialContext ic;
    protected boolean isConfigAvailable = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initialize(Object object) throws ComponentDisabledException {
        boolean bl;
        PlatformHelper platformHelper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        boolean bl2 = this.isConfigAvailable = object != null && object instanceof StartupBeansService;
        if (this.isConfigAvailable && !(platformHelper = (StartupBeansService)object).isEnable()) {
            Tr.info(tc, "STARTUPSVC_NOT_ENABLED");
            throw new ComponentDisabledException();
        }
        platformHelper = AdminHelper.getPlatformHelper();
        boolean bl3 = bl = platformHelper.isZOS() ? platformHelper.isCRAJvm() : false;
        if (bl) {
            Tr.info(tc, "STARTUPSVC_NOT_ENABLED");
            throw new ComponentDisabledException();
        }
        ApplicationMgr applicationMgr = null;
        MetaDataService metaDataService = null;
        EJBContainer eJBContainer = null;
        Server server2 = null;
        eJBContainer = (EJBContainer)this.getService(EJBContainer.class);
        if (eJBContainer == null) {
            Tr.error(tc, "ERR_NO_SERVICE", "EJBContainer");
            throw new ComponentDisabledException();
        }
        metaDataService = (MetaDataService)this.getService(MetaDataService.class);
        if (metaDataService == null) {
            Tr.error(tc, "ERR_NO_SERVICE", "MetaDataService");
            throw new ComponentDisabledException();
        }
        applicationMgr = (ApplicationMgr)this.getService(ApplicationMgr.class);
        if (applicationMgr == null) {
            Tr.error(tc, "ERR_NO_SERVICE", "ApplicationMgr");
            throw new ComponentDisabledException();
        }
        server2 = (Server)this.getService(Server.class);
        if (server2 == null) {
            Tr.error(tc, "ERR_NO_SERVICE", "Server");
            throw new ComponentDisabledException();
        }
        eJBContainer.addCollaborator(this);
        this.md_slot = metaDataService.reserveSlot(ModuleMetaData.class);
        metaDataService.addMetaDataListener(this);
        applicationMgr.addDeployedObjectListener(this);
        server2.addPropertyChangeListener("state", this);
        Tr.info(tc, "STARTUPSVC_STARTED");
        Object var10_8 = null;
        try {
            if (eJBContainer != null) {
                this.releaseService(eJBContainer);
            }
            if (applicationMgr != null) {
                this.releaseService(applicationMgr);
            }
            if (metaDataService != null) {
                this.releaseService(metaDataService);
            }
            if (server2 == null) return;
            this.releaseService(server2);
            return;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize");
            }
        }
        {
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.startupservice.StartUpService.initialize", "64", this);
                Tr.error(tc, "ERR_INITERR", new Object[]{throwable});
                Tr.warning(tc, "STARTUPSVC_DISABLED");
                if (!(throwable instanceof ComponentDisabledException)) throw new ComponentDisabledException(throwable);
                throw (ComponentDisabledException)throwable;
            }
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            try {
                if (eJBContainer != null) {
                    this.releaseService(eJBContainer);
                }
                if (applicationMgr != null) {
                    this.releaseService(applicationMgr);
                }
                if (metaDataService != null) {
                    this.releaseService(metaDataService);
                }
                if (server2 == null) throw throwable;
                this.releaseService(server2);
                throw throwable;
            }
            finally {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "initialize");
                }
            }
        }
    }

    public void start() {
    }

    public synchronized InitialContext getInitialContext() throws NamingException {
        if (this.ic == null) {
            this.ic = new InitialContext();
        }
        return this.ic;
    }

    public void metaDataCreated(MetaDataEvent metaDataEvent) throws RuntimeWarning, RuntimeError {
        MetaData metaData;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "metaDataCreated", metaDataEvent.getMetaData().getClass().getName());
        }
        if ((metaData = metaDataEvent.getMetaData()) instanceof BeanMetaData) {
            this.checkAndAddStartupBean((BeanMetaData)metaData);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "metaDataCreated");
        }
    }

    public void metaDataDestroyed(MetaDataEvent metaDataEvent) {
        MetaData metaData = metaDataEvent.getMetaData();
        if (metaData instanceof ModuleMetaData) {
            StartUpApplication startUpApplication;
            DeployedModule deployedModule = (DeployedModule)metaDataEvent.getDeployedObject();
            DeployedApplication deployedApplication = deployedModule.getDeployedApplication();
            String string = deployedApplication.getName();
            String string2 = deployedModule.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "metaDataDestroyed:App name is " + string);
                Tr.debug(tc, "metaDataDestroyed:Module name is " + string2);
            }
            if ((startUpApplication = (StartUpApplication)this.applications.get(string)) != null) {
                startUpApplication.removeModule(string2);
            }
        }
    }

    public synchronized StartUpApplication getApplication(String string) {
        StartUpApplication startUpApplication = null;
        if (!this.applications.containsKey(string)) {
            startUpApplication = new StartUpApplication(string);
            this.applications.put(string, startUpApplication);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding application to map: " + string);
            }
        } else {
            startUpApplication = (StartUpApplication)this.applications.get(string);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Returning startupApplication: " + startUpApplication.name);
        }
        return startUpApplication;
    }

    public void checkAndAddStartupBean(BeanMetaData beanMetaData) throws RuntimeWarning, RuntimeError {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAndAddStartupBean", beanMetaData.getJ2EEName());
        }
        boolean bl = tc.isDebugEnabled();
        String string = beanMetaData.getJ2EEName().getApplication();
        String string2 = beanMetaData.getJ2EEName().getModule();
        if (bl) {
            Tr.debug(tc, "checkAndAddStartupBean:App name is " + string);
            Tr.debug(tc, "checkAndAddStartupBean:Module name is " + string2);
        }
        if ((n = beanMetaData.getEJBComponentType()) == 3 || n == 2) {
            String string3 = beanMetaData.homeInterfaceClassName;
            boolean bl2 = false;
            boolean bl3 = false;
            if (string3 != null) {
                bl2 = string3.equals("com.ibm.websphere.startupservice.ModStartUpHome");
                bl3 = string3.equals("com.ibm.websphere.startupservice.AppStartUpHome");
            }
            if (bl) {
                Tr.debug(tc, "homInterfaceClassName = " + string3);
                Tr.debug(tc, "isModStartupBean = " + bl2);
                Tr.debug(tc, "isAppStartupBean = " + bl3);
            }
            if (bl2 || bl3) {
                StartUpApplication startUpApplication = this.getApplication(string);
                StartUpModule startUpModule = startUpApplication.getModule(string2);
                if (bl) {
                    if (bl2) {
                        Tr.debug(tc, "Found module startup bean " + beanMetaData.getJ2EEName());
                    } else {
                        Tr.debug(tc, "Found application startup bean " + beanMetaData.getJ2EEName());
                    }
                }
                if (n == 3) {
                    if (bl && beanMetaData.sessionTimeout != 0) {
                        Tr.debug(tc, "Overriding Stateful Session Timeout to zero.  Configured value=" + beanMetaData.sessionTimeout);
                    }
                    beanMetaData.sessionTimeout = 0;
                }
                try {
                    if (bl2) {
                        startUpModule.addModStartUpBean(beanMetaData);
                    }
                    startUpModule.addAppStartUpBean(beanMetaData);
                }
                catch (StartUpBeanInvalid startUpBeanInvalid) {
                    if (bl) {
                        Tr.debug(tc, "Unable to add new startup bean.  Application Load Aborted: ", new Object[]{beanMetaData.getJ2EEName(), startUpBeanInvalid});
                    }
                    throw new RuntimeWarning(startUpBeanInvalid);
                }
            } else if (bl) {
                Tr.debug(tc, "Skipping bean. Not a startup bean:" + beanMetaData.getJ2EEName());
            }
        } else if (bl) {
            Tr.debug(tc, "Skipping bean. Not a session bean:" + beanMetaData.getJ2EEName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAndAddStartupBean");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(DeployedObjectEvent deployedObjectEvent) throws RuntimeError, RuntimeWarning {
        boolean bl = tc.isDebugEnabled();
        boolean bl2 = tc.isEntryEnabled();
        if (bl2) {
            Tr.entry(tc, "stateChanged", deployedObjectEvent);
        }
        try {
            if (deployedObjectEvent.getNewValue() == "STARTED") {
                DeployedObject deployedObject = (DeployedObject)deployedObjectEvent.getSource();
                if (deployedObject.getModuleFile().isEJBJarFile()) {
                    InitialContext initialContext;
                    boolean bl3;
                    StartUpModule startUpModule;
                    StartUpApplication startUpApplication;
                    if (bl) {
                        Tr.debug(tc, "Module Started:  " + deployedObject.getName());
                    }
                    if ((startUpApplication = (StartUpApplication)this.applications.get(((DeployedModule)deployedObject).getDeployedApplication().getName())) != null && (startUpModule = startUpApplication.getModule(deployedObject.getName())) != null && !(bl3 = startUpModule.modStart(initialContext = this.getInitialContext()))) {
                        throw new RuntimeWarning("Module Startup Bean failed to start.");
                    }
                } else if (deployedObject.getModuleFile().isEARFile()) {
                    InitialContext initialContext;
                    boolean bl4;
                    StartUpApplication startUpApplication;
                    if (bl) {
                        Tr.debug(tc, "EAR Started:  " + deployedObject.getName());
                    }
                    if ((startUpApplication = (StartUpApplication)this.applications.get(deployedObject.getName())) != null && !(bl4 = startUpApplication.start(initialContext = this.getInitialContext()))) {
                        throw new RuntimeWarning("Application Startup Bean failed to start.");
                    }
                }
            } else if (deployedObjectEvent.getNewValue() == "STOPPING") {
                DeployedObject deployedObject = (DeployedObject)deployedObjectEvent.getSource();
                if (deployedObject.getModuleFile().isEJBJarFile()) {
                    if (bl) {
                        Tr.debug(tc, "Module Stopping:  " + deployedObject.getName());
                    }
                    String string = ((DeployedModule)deployedObject).getDeployedApplication().getName();
                    StartUpApplication startUpApplication = (StartUpApplication)this.applications.get(string);
                    if (bl) {
                        Tr.debug(tc, "Module Stopping, application = " + startUpApplication);
                    }
                    if (startUpApplication != null) {
                        String string2 = deployedObject.getName();
                        StartUpModule startUpModule = startUpApplication.getModuleNoCreate(string2);
                        if (startUpModule != null) {
                            InitialContext initialContext = this.getInitialContext();
                            startUpModule.modStop(initialContext);
                            startUpApplication.removeModule(string2);
                        }
                        if (startUpApplication.isEmpty()) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "StateChanged()Removing application from map: " + string);
                            }
                            this.applications.remove(string);
                        }
                    }
                } else if (deployedObject.getModuleFile().isEARFile()) {
                    StartUpApplication startUpApplication;
                    if (bl) {
                        Tr.debug(tc, "EAR Stopping:  " + deployedObject.getName());
                    }
                    if ((startUpApplication = (StartUpApplication)this.applications.get(deployedObject.getName())) != null) {
                        InitialContext initialContext = this.getInitialContext();
                        startUpApplication.stop(initialContext);
                    }
                }
            }
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.startupservice.StartUpService.stateChanged", "228", this);
        }
        finally {
            if (bl2) {
                Tr.exit(tc, "stateChanged");
            }
        }
    }

    public void started(EJBModuleMetaData eJBModuleMetaData) {
    }

    public void starting(EJBModuleMetaData eJBModuleMetaData) {
    }

    public void stopped(EJBModuleMetaData eJBModuleMetaData) {
    }

    public void stopping(EJBModuleMetaData eJBModuleMetaData) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "propertyChange", new Object[]{propertyChangeEvent});
        }
        Server server2 = (Server)this.getService(Server.class);
        try {
            if (propertyChangeEvent.getSource() == server2 && propertyChangeEvent.getNewValue().equals("STOPPING")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Stopping all Startup Beans");
                }
                String[] stringArray = new String[this.applications.keySet().size()];
                this.applications.keySet().toArray(stringArray);
                InitialContext initialContext = this.getInitialContext();
                for (int i = 0; i < stringArray.length; ++i) {
                    StartUpApplication startUpApplication = (StartUpApplication)this.applications.get(stringArray[i]);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Stopping Startup Bean: " + stringArray[i]);
                    }
                    startUpApplication.allStop(initialContext);
                    if (!startUpApplication.isEmpty()) continue;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "propertyChanged() removing application from map: " + stringArray[i]);
                    }
                    this.applications.remove(stringArray[i]);
                }
            }
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.startupservice.StartUpService.propertyChange", "393", this);
        }
        finally {
            if (server2 != null) {
                this.releaseService(server2);
            }
            if (bl) {
                Tr.exit(tc, "propertyChange");
            }
        }
    }

    public void stop() {
        super.stop();
        Tr.info(tc, "STARTUPSVC_STOPPED");
    }
}

