/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.taskconfig.monitor.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.ConfigRepositoryListener;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.models.config.taskconfig.EmailNotifications;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.taskconfig.monitor.impl.XDPlatformHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.management.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class TaskConfigMonitorImpl
extends ComponentImpl
implements ConfigRepositoryListener {
    private static final TraceComponent tc = Tr.register(TaskConfigMonitorImpl.class.getName(), "taskmanagement", "com.ibm.ws.taskmanagement.nls.Messages");
    private static String POLICY_FILENAME = "notification.xml";
    private static String MBEAN_FILENAME = "META-INF/TaskConfigMonitor.xml";
    private TaskConfigMBean myMBean = null;
    private HashMap change_cache = new HashMap();
    private DefaultRuntimeCollaborator collab = null;

    public void initialize(Object object) throws ComponentDisabledException, ConfigurationWarning, ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", new Object[]{object, this});
        }
        if (XDPlatformHelper.isZOS() && !XDPlatformHelper.isZOSControlRegion()) {
            throw new ComponentDisabledException();
        }
        String string = AdminServiceFactory.getAdminService().getProcessType();
        if (!string.equals("DeploymentManager")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize", "ComponentDisabledException");
            }
            throw new ComponentDisabledException();
        }
        this.myMBean = new TaskConfigMBean();
        this.collab = new DefaultRuntimeCollaborator(this.myMBean, "TaskConfigMonitor");
        try {
            MBeanFactory mBeanFactory = AdminServiceFactory.getMBeanFactory();
            mBeanFactory.activateMBean("TaskConfigMonitor", this.collab, "TaskConfigMonitor", MBEAN_FILENAME);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Activated Task Config Monitor");
            }
        }
        catch (AdminException adminException) {
            Tr.error(tc, "ERROR_INITIALIZING", new Object[]{adminException});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void start() throws RuntimeWarning, RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start", this);
        }
        ConfigRepositoryFactory.getConfigRepository().addListener(this);
        Tr.info(tc, "INFO_INITIALIZATION_COMPLETE");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public synchronized void onChangeStart(ConfigRepositoryEvent configRepositoryEvent) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "onChangeStart", new Object[]{configRepositoryEvent, this});
        }
        String string = String.valueOf(configRepositoryEvent.getId());
        if (tc.isDebugEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "TaskConfigMonitorImpl:onChangeStart: Event ID = " + string);
        }
        ConfigChangeNotifier[] configChangeNotifierArray = configRepositoryEvent.getChanges();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TaskConfigMonitorImpl:onChangeStart: Iterating through changes, # of Notifications = " + configChangeNotifierArray.length);
        }
        HashMap<String, EmailNotifications> hashMap = new HashMap<String, EmailNotifications>();
        for (int i = 0; i < configChangeNotifierArray.length; ++i) {
            String string2;
            ConfigChangeNotifier configChangeNotifier = configChangeNotifierArray[i];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TaskConfigMonitorImpl:onChangeStart: Type of Change = " + configChangeNotifier.getChangeType());
            }
            if (!(string2 = configChangeNotifier.getUri()).endsWith(POLICY_FILENAME)) continue;
            if (configChangeNotifier.getChangeType() == 2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "TaskConfigMonitorImpl:onChangeStart: Modified URI = " + string2);
                }
                try {
                    ConfigRepository configRepository = ConfigRepositoryFactory.getConfigRepository();
                    DocumentContentSource documentContentSource = configRepository.extract(string2);
                    WASResourceSetImpl wASResourceSetImpl = new WASResourceSetImpl();
                    URI uRI = URI.createFileURI((String)documentContentSource.getDocument().getURI());
                    Resource resource = wASResourceSetImpl.createResource(uRI);
                    resource.load(documentContentSource.getSource(), new HashMap());
                    EmailNotifications emailNotifications = (EmailNotifications)resource.getContents().get(0);
                    hashMap.put(string2, emailNotifications);
                }
                catch (Exception exception) {
                    Tr.error(tc, "ERROR_READING_NOTIFICATION_POLICY_ON_CHANGE_START", new Object[]{exception});
                    hashMap.put(string2, null);
                }
                continue;
            }
            if (configChangeNotifier.getChangeType() == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "TaskConfigMonitorImpl:onChangeStart: Added URI = " + string2);
                }
                hashMap.put(string2, null);
                continue;
            }
            if (configChangeNotifier.getChangeType() != 1) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TaskConfigMonitorImpl:onChangeStart: Deleted URI = " + string2);
            }
            hashMap.put(string2, null);
        }
        this.change_cache.put(string, hashMap);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "onChangeStart");
        }
    }

    public synchronized void onChangeCompletion(ConfigRepositoryEvent configRepositoryEvent) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "onChangeCompletion", new Object[]{configRepositoryEvent, this});
        }
        String string = String.valueOf(configRepositoryEvent.getId());
        HashMap hashMap = (HashMap)this.change_cache.get(string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TaskConfigMonitorImpl:onChangeCompletion: Event ID = " + string);
        }
        ConfigChangeNotifier[] configChangeNotifierArray = configRepositoryEvent.getChanges();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TaskConfigMonitorImpl:onChangeCompletion: Iterating through changes, # of Notifications = " + configChangeNotifierArray.length);
        }
        for (int i = 0; i < configChangeNotifierArray.length; ++i) {
            String string2;
            ConfigChangeNotifier configChangeNotifier = configChangeNotifierArray[i];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TaskConfigMonitorImpl:onChangeCompletion: Type of Change = " + configChangeNotifier.getChangeType());
            }
            if (!(string2 = configChangeNotifier.getUri()).endsWith(POLICY_FILENAME)) continue;
            if (configChangeNotifier.getChangeType() == 2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "TaskConfigMonitorImpl:onChangeCompletion: Modified URI = " + string2);
                }
                try {
                    ConfigRepository configRepository = ConfigRepositoryFactory.getConfigRepository();
                    DocumentContentSource documentContentSource = configRepository.extract(string2);
                    WASResourceSetImpl wASResourceSetImpl = new WASResourceSetImpl();
                    URI uRI = URI.createFileURI((String)documentContentSource.getDocument().getURI());
                    Resource resource = wASResourceSetImpl.createResource(uRI);
                    resource.load(documentContentSource.getSource(), new HashMap());
                    EmailNotifications emailNotifications = (EmailNotifications)resource.getContents().get(0);
                    EmailNotifications emailNotifications2 = (EmailNotifications)hashMap.get(string2);
                    this.determineChange(emailNotifications, emailNotifications2);
                }
                catch (Exception exception) {
                    Tr.error(tc, "ERROR_READING_NOTIFICATION_POLICY_ON_CHANGE_COMPLETE", new Object[]{exception});
                }
                continue;
            }
            if (configChangeNotifier.getChangeType() == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "TaskConfigMonitorImpl:onChangeCompletion: Added URI = " + string2);
                }
                this.sendPolicyNotification("websphere.notificationparms.created", "", null);
                continue;
            }
            if (configChangeNotifier.getChangeType() != 1) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TaskConfigMonitorImpl:onChangeCompletion: Deleted URI = " + string2);
            }
            this.sendPolicyNotification("websphere.notificationparms.removed", "", null);
        }
        this.change_cache.remove(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "onChangeCompletion");
        }
    }

    private void determineChange(EmailNotifications emailNotifications, EmailNotifications emailNotifications2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "determineChange", new Object[]{emailNotifications, emailNotifications2, this});
        }
        if (emailNotifications.getPort() != emailNotifications2.getPort()) {
            this.sendPolicyNotification("websphere.notificationparms.modified", "portNumber", new Integer(emailNotifications.getPort()));
        }
        if (emailNotifications.isEnabled() != emailNotifications2.isEnabled()) {
            this.sendPolicyNotification("websphere.notificationparms.modified", "enabled", new Boolean(emailNotifications.isEnabled()));
        }
        if (!emailNotifications.getTransportHostName().equals(emailNotifications2.getTransportHostName())) {
            this.sendPolicyNotification("websphere.notificationparms.modified", "transportHostName", emailNotifications.getTransportHostName());
        }
        if (!emailNotifications.getTransportUserId().equals(emailNotifications2.getTransportUserId())) {
            this.sendPolicyNotification("websphere.notificationparms.modified", "transportUserId", emailNotifications.getTransportUserId());
        }
        if (!emailNotifications.getTransportPassword().equals(emailNotifications2.getTransportPassword())) {
            this.sendPolicyNotification("websphere.notificationparms.modified", "transportPassword", emailNotifications.getTransportPassword());
        }
        EList eList = emailNotifications2.getEmailAddresses();
        EList eList2 = emailNotifications.getEmailAddresses();
        if (eList.size() != eList2.size()) {
            this.sendPolicyNotification("websphere.notificationparms.modified", "emailAddresses", eList2);
        } else {
            Object object;
            Iterator iterator = eList2.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                if (eList.contains(object)) continue;
                this.sendPolicyNotification("websphere.notificationparms.created", "emailAddresses", eList2);
            }
            object = eList.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                if (eList2.contains((Object)string)) continue;
                this.sendPolicyNotification("websphere.notificationparms.removed", "emailAddresses", eList2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "determineChange");
        }
    }

    public void onRepositoryLock() {
    }

    public void onRepositoryUnlock() {
    }

    public void onRepositoryEpochRefresh() {
    }

    private void sendPolicyNotification(String string, String string2, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendPolicyNotification", new Object[]{string, string2, object, this});
        }
        Properties properties = new Properties();
        if (!string2.equals("")) {
            properties.put("notificationAttribute", string2);
        }
        if (object != null) {
            properties.put("modifiedValue", object);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TaskConfigMonitorImpl:sendPolicyNotification: " + string + ";" + string2);
        }
        this.myMBean.sendTaskConfigMonitorNotification(properties, string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendPolicyNotification");
        }
    }

    public class TaskConfigMBean
    extends RuntimeCollaborator {
        private void sendTaskConfigMonitorNotification(Properties properties, String string) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sending a notification:  " + string + ":" + properties.toString());
            }
            Notification notification = new Notification(string, TaskConfigMonitorImpl.this.collab.getObjectName(), System.currentTimeMillis());
            notification.setUserData(properties);
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "TaskConfigMonitorImpl:sendTaskConfigMonitorNotification: " + string + ";" + properties.toString());
                }
                TaskConfigMonitorImpl.this.collab.sendNotification(notification);
            }
            catch (Exception exception) {
                Tr.error(tc, "ERROR_SENDING_NOTIFICATION", new Object[]{exception});
            }
        }
    }
}

