/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.taskmanagement.mapper;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.taskconfig.EmailNotifications;
import com.ibm.websphere.models.config.topology.cell.Cell;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.taskmanagement.mapper.TaskManagementServiceMapperEvent;
import com.ibm.ws.taskmanagement.mapper.TaskManagementServiceMapperFactory;
import com.ibm.ws.taskmanagement.mapper.TaskManagementServiceMapperListener;
import com.ibm.ws.taskmanagement.task.ManagedTask;
import com.ibm.ws.taskmanagement.task.PlannedTask;
import com.ibm.ws.taskmanagement.task.Task;
import com.ibm.ws.taskmanagement.task.TaskNotificationProvider;
import com.ibm.ws.taskmanagement.util.TaskImplConstants;
import com.ibm.ws.util.ImplFactory;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.event.TransportEvent;
import javax.mail.event.TransportListener;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class TaskManagementServiceMapper
extends WsComponentImpl {
    protected static final TraceComponent tc = Tr.register(TaskManagementServiceMapper.class.getName(), "taskmanagement", TaskImplConstants.NLSPROPSFILE);
    private Transport _smtpTransport = null;
    private Session _session = null;
    private boolean _enabled = false;
    private List _emailAddresses = null;
    private String _cellName = null;
    private String _hostname = null;
    private static Vector listeners = new Vector(5);
    public static final String SENDER_KEY = "task.email.global.sender.id";
    public static final String DEFAULT_SENDER = "wasxd";
    private TaskNotificationProvider[] _providers;

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initialize", new Object[]{object, this});
            }
            AdminService adminService = AdminServiceFactory.getAdminService();
            this._cellName = adminService.getCellName();
            if (adminService.getProcessType() != "DeploymentManager" && adminService.getProcessType() != "UnManagedProcess") {
                throw new ComponentDisabledException();
            }
            try {
                WsServiceRegistry.addService((Object)this, (Class)TaskManagementServiceMapper.class);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception " + exception.getMessage() + " on addService");
                }
                throw new ComponentDisabledException();
            }
            TaskManagementServiceMapperFactory.setMapper(this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Mapper is initialized");
            }
            TaskManagementServiceMapper.notifyListeners();
            this.initializeMailSession();
            try {
                ObjectName objectName = new ObjectName("WebSphere:*,type=TaskConfigMonitor");
                adminService.addNotificationListenerExtended(objectName, new NotificationListener(){

                    public void handleNotification(Notification notification, Object object) {
                        if (tc.isEntryEnabled()) {
                            Tr.entry(tc, "handleNotification");
                        }
                        TaskManagementServiceMapper.this.initializeMailSession();
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "handleNotification");
                        }
                    }
                }, null, null);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.taskmanagement.task.TaskManagementServiceMapper", "138", this);
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "Exception caught registering for notifications: " + throwable.getClass().getName() + " " + throwable.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    private void initializeMailSession() {
        block20: {
            String string;
            block19: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "initializeMailSession", this);
                }
                string = AdminServiceFactory.getAdminService().getCellName();
                if (this._smtpTransport != null) {
                    try {
                        if (this._smtpTransport.isConnected()) {
                            this._smtpTransport.close();
                        }
                    }
                    catch (MessagingException messagingException) {
                        FFDCFilter.processException(messagingException.getCause(), "com.ibm.ws.taskmanagement.task.TaskManagementServiceMapper", "166", this);
                        if (!tc.isDebugEnabled()) break block19;
                        Tr.debug(tc, "MessagingException caught while closing transport with message " + messagingException.getMessage());
                    }
                }
            }
            String string2 = "cells/" + string + "/notification.xml";
            EmailNotifications emailNotifications = null;
            try {
                DocumentContentSource documentContentSource = ConfigRepositoryFactory.getConfigRepository().extract(string2);
                if (documentContentSource != null) {
                    WASResourceSetImpl wASResourceSetImpl = new WASResourceSetImpl();
                    URI uRI = URI.createFileURI((String)documentContentSource.getDocument().getURI());
                    Resource resource = wASResourceSetImpl.createResource(uRI);
                    resource.load(documentContentSource.getSource(), new HashMap());
                    emailNotifications = (EmailNotifications)resource.getContents().get(0);
                    if (emailNotifications != null) {
                        this._enabled = emailNotifications.isEnabled();
                        if (this._enabled) {
                            SecurityManager securityManager;
                            this._emailAddresses = emailNotifications.getEmailAddresses();
                            this._hostname = emailNotifications.getTransportHostName();
                            int n = emailNotifications.getPort();
                            Properties properties = new Properties();
                            properties.put("mail.smtp.host", this._hostname);
                            properties.put("mail.smtp.port", String.valueOf(n));
                            String string3 = emailNotifications.getTransportUserId();
                            SMTPAuthenticator sMTPAuthenticator = null;
                            if (string3 != null && string3.length() > 0) {
                                sMTPAuthenticator = new SMTPAuthenticator(string3, emailNotifications.getTransportPassword());
                                properties.put("mail.smtp.auth", "true");
                            }
                            if ((securityManager = System.getSecurityManager()) == null) {
                                this._session = Session.getInstance((Properties)properties, sMTPAuthenticator);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Non-Default session instance used");
                                }
                            } else {
                                this._session = Session.getDefaultInstance((Properties)properties, sMTPAuthenticator);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Default session instance used");
                                }
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Created mail session successfully.");
                            }
                            if (tc.isDebugEnabled()) {
                                this._session.setDebug(true);
                            }
                            this._smtpTransport = this._session.getTransport("smtp");
                            this._smtpTransport.connect();
                            if (tc.isDebugEnabled()) {
                                this._smtpTransport.addTransportListener((TransportListener)new DebugTransportListener());
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception.getCause(), "com.ibm.ws.taskmanagement.task.TaskManagementServiceMapper", "225", this);
                if (!tc.isDebugEnabled()) break block20;
                Tr.debug(tc, "Exception caught loading URI " + string2 + ". Exception " + exception.getClass().getName() + " " + exception.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeMailSession");
        }
    }

    public void mapTask(ManagedTask managedTask) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapTask", new Object[]{managedTask, this});
        }
        if ((managedTask.getCurrentState() == null || managedTask.getCurrentState().getStateType() == 1) && this._enabled && this._emailAddresses != null && !this._emailAddresses.isEmpty()) {
            MimeMessage mimeMessage = new MimeMessage(this._session);
            Task task = managedTask.getTask();
            String string = null;
            string = task instanceof PlannedTask ? TraceNLS.getFormattedMessage(TaskImplConstants.NLSPROPSFILE, "TASKTYPE_" + ((PlannedTask)task).getType(), null, "Recommendation") : TraceNLS.getFormattedMessage(TaskImplConstants.NLSPROPSFILE, "TASKTYPE_4", null, "Notification");
            String string2 = TraceNLS.getFormattedMessage(TaskImplConstants.NLSPROPSFILE, "SEVERITY_" + task.getGlobalSeverity(), null, "unknown");
            String string3 = TraceNLS.getFormattedMessage(TaskImplConstants.NLSPROPSFILE, "BODY_1", new Object[]{string, new Long(managedTask.getGlobalId()), string2, this._cellName, new Date(task.getOriginatedTime())}, "WebSphere Application Server Task Occurred in cell " + this._cellName + ". Please access the \"System administration\"->\"Task managment\"->\"Runtime tasks\" view in the WebSphere Administrative Console for additional task details.");
            String string4 = TraceNLS.getFormattedMessage(TaskImplConstants.NLSPROPSFILE, "BODY_2", null, "**Please note: this email is for notification purposes only.  Please do not respond to this id.");
            String string5 = TraceNLS.getFormattedMessage(TaskImplConstants.NLSPROPSFILE, "SUBJECT", new Object[]{string2, string, new Long(managedTask.getGlobalId()), this._cellName}, "WebSphere Application Server Task Occurred in cell " + this._cellName);
            try {
                Message[] messageArray;
                Object object;
                mimeMessage.setText(string3.concat("\n\n").concat(string4));
                mimeMessage.setSubject(string5);
                String string6 = this.getEmailSender();
                if (!string6.contains("@")) {
                    string6 = string6 + "@" + this._hostname;
                }
                InternetAddress internetAddress = new InternetAddress(string6, "WebSphere Extended Deployment");
                mimeMessage.setFrom((Address)internetAddress);
                Iterator iterator = this._emailAddresses.iterator();
                while (iterator.hasNext()) {
                    try {
                        object = new InternetAddress((String)iterator.next());
                        mimeMessage.addRecipient(Message.RecipientType.TO, (Address)object);
                    }
                    catch (AddressException addressException) {
                        Tr.error(tc, "MSG_KEY_080");
                    }
                }
                if (this._smtpTransport == null || !this._smtpTransport.isConnected()) {
                    this.initializeMailSession();
                }
                object = new HashSet();
                TaskNotificationProvider[] taskNotificationProviderArray = this.getTaskNotificationProviders();
                if (taskNotificationProviderArray != null && taskNotificationProviderArray.length > 0) {
                    for (int i = 0; i < taskNotificationProviderArray.length; ++i) {
                        messageArray = taskNotificationProviderArray[i].getMessages(managedTask, (Message)mimeMessage);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "p_msgs=" + messageArray);
                        }
                        if (messageArray == null) continue;
                        object.addAll(Arrays.asList(messageArray));
                    }
                } else {
                    object.add(mimeMessage);
                }
                Iterator iterator2 = object.iterator();
                while (iterator2.hasNext()) {
                    messageArray = (Message[])iterator2.next();
                    try {
                        this._smtpTransport.sendMessage((Message)messageArray, messageArray.getAllRecipients());
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Sent email sucessfully.");
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.taskmanagement.task.TaskManagementServiceMapper", "313", this);
                        try {
                            this.initializeMailSession();
                            this._smtpTransport.sendMessage((Message)messageArray, messageArray.getAllRecipients());
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Sent email sucessfully after re-initialization of mail session.");
                        }
                        catch (Throwable throwable2) {
                            FFDCFilter.processException(throwable2, "com.ibm.ws.taskmanagement.task.TaskManagementServiceMapper", "365", this);
                            Tr.error(tc, "MSG_KEY_081", new Object[]{new Long(managedTask.getGlobalId()), throwable2.getLocalizedMessage()});
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "mapTask");
            }
        }
    }

    public static synchronized void addListener(TaskManagementServiceMapperListener taskManagementServiceMapperListener) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding listener " + taskManagementServiceMapperListener);
        }
        listeners.add(taskManagementServiceMapperListener);
    }

    public static synchronized void removeListener(TaskManagementServiceMapperListener taskManagementServiceMapperListener) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Removing listener " + taskManagementServiceMapperListener);
        }
        listeners.remove(taskManagementServiceMapperListener);
    }

    private static void notifyListeners() {
        if (!listeners.isEmpty()) {
            TaskManagementServiceMapperEvent taskManagementServiceMapperEvent = new TaskManagementServiceMapperEvent(1);
            int n = listeners.size();
            for (int i = 0; i < n; ++i) {
                TaskManagementServiceMapperListener taskManagementServiceMapperListener = (TaskManagementServiceMapperListener)listeners.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Notifying listener " + taskManagementServiceMapperListener);
                }
                taskManagementServiceMapperListener.stateChanged(taskManagementServiceMapperEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized TaskNotificationProvider[] getTaskNotificationProviders() {
        if (this._providers == null) {
            TaskNotificationProvider taskNotificationProvider;
            Object object;
            URL uRL;
            String string;
            ArrayList<TaskNotificationProvider> arrayList = new ArrayList<TaskNotificationProvider>(3);
            IExtensionRegistry iExtensionRegistry = ExtensionRegistryFactory.instance().getExtensionRegistry();
            IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(string = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".task-management-notification-provider");
            if (iExtensionPoint == null) {
                IllegalStateException illegalStateException = new IllegalStateException("extension point, " + string + ", is null");
                if (tc.isErrorEnabled()) {
                    Tr.error(tc, "WSVR0100W", new Object[]{"TaskManagementServiceMapper", illegalStateException});
                }
                return null;
            }
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            for (int i = 0; i < iExtensionArray.length; ++i) {
                IExtension iExtension = iExtensionArray[i];
                IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
                for (int j = 0; j < iConfigurationElementArray.length; ++j) {
                    uRL = iConfigurationElementArray[j];
                    object = uRL.getAttribute("class");
                    try {
                        taskNotificationProvider = (TaskNotificationProvider)uRL.createExecutableExtension("class");
                        arrayList.add(taskNotificationProvider);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "aproviders.add: " + taskNotificationProvider);
                        continue;
                    }
                    catch (Throwable throwable) {
                        if (!tc.isErrorEnabled()) continue;
                        Tr.error(tc, "WSVR0100W", new Object[]{object, throwable});
                    }
                }
            }
            Enumeration<URL> enumeration = null;
            try {
                enumeration = Thread.currentThread().getContextClassLoader().getResources("META-INF/ws-task-management-notification.provider");
                while (enumeration.hasMoreElements()) {
                    uRL = enumeration.nextElement();
                    object = null;
                    try {
                        String string2;
                        object = new BufferedReader(new InputStreamReader(uRL.openStream()));
                        while ((string2 = ((BufferedReader)object).readLine()) != null) {
                            try {
                                taskNotificationProvider = (TaskNotificationProvider)ImplFactory.loadImplFromClass(string2);
                                arrayList.add(taskNotificationProvider);
                            }
                            catch (Throwable throwable) {
                                if (!tc.isErrorEnabled()) continue;
                                Tr.error(tc, "WSVR0100W", new Object[]{string2, throwable});
                            }
                        }
                    }
                    catch (IOException iOException) {
                        if (!tc.isServiceEnabled()) continue;
                        Tr.service(tc, "WSVR0100W", new Object[]{uRL.toString(), iOException});
                    }
                    finally {
                        if (object == null) continue;
                        try {
                            ((BufferedReader)object).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._providers = new TaskNotificationProvider[arrayList.size()];
            arrayList.toArray(this._providers);
        }
        return this._providers;
    }

    private String getEmailSender() {
        String string = AdminServiceFactory.getAdminService().getCellName();
        String string2 = "cells/" + string + "/cell.xml";
        try {
            DocumentContentSource documentContentSource = ConfigRepositoryFactory.getConfigRepository().extract(string2);
            if (documentContentSource != null) {
                WASResourceSetImpl wASResourceSetImpl = new WASResourceSetImpl();
                URI uRI = URI.createFileURI((String)documentContentSource.getDocument().getURI());
                Resource resource = wASResourceSetImpl.createResource(uRI);
                resource.load(documentContentSource.getSource(), new HashMap());
                Cell cell = (Cell)resource.getContents().get(0);
                EList eList = cell.getProperties();
                Iterator iterator = eList.iterator();
                while (iterator.hasNext()) {
                    Property property;
                    Object e2 = iterator.next();
                    if (!(e2 instanceof Property) || (property = (Property)e2).getName() == null || !property.getName().equals(SENDER_KEY)) continue;
                    return property.getValue();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return DEFAULT_SENDER;
    }

    private class DebugTransportListener
    implements TransportListener {
        public void messageDelivered(TransportEvent transportEvent) {
            Tr.debug(tc, "Message delivered:" + transportEvent.getMessage());
        }

        public void messageNotDelivered(TransportEvent transportEvent) {
            Tr.debug(tc, "Message Not Delivered: " + transportEvent.getMessage());
        }

        public void messagePartiallyDelivered(TransportEvent transportEvent) {
            Tr.debug(tc, "Message Partially Delivered." + transportEvent.getMessage());
            StringBuffer stringBuffer = new StringBuffer();
            Address[] addressArray = transportEvent.getValidUnsentAddresses();
            for (int i = 0; i < addressArray.length; ++i) {
                stringBuffer.append(addressArray[i]);
                if (i >= addressArray.length - 1) continue;
                stringBuffer.append(",");
            }
            Tr.debug(tc, "Addresses of excluded recipients" + stringBuffer.toString());
        }
    }

    private class SMTPAuthenticator
    extends Authenticator {
        private String _userName = null;
        private String _passWord = null;

        public SMTPAuthenticator(String string, String string2) {
            this._userName = string;
            this._passWord = string2;
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this._userName, this._passWord);
        }
    }
}

