/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.taskmanagement.proxy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.taskmanagement.exceptions.TaskManagementSubmissionFailedException;
import com.ibm.ws.taskmanagement.task.ActionPlanStatus;
import com.ibm.ws.taskmanagement.task.Task;
import com.ibm.ws.taskmanagement.task.TaskReport;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class TaskManagementServiceProxy {
    protected static final TraceComponent tc = Tr.register(TaskManagementServiceProxy.class.getName(), "taskmanagement", "com.ibm.ws.taskmanagement.nls.Messages");
    private ObjectName tskMgrMBean = null;
    private AdminClient dmgr_ac = null;
    private static AdminService adminService;

    public long[] submitTaskReport(TaskReport taskReport) throws TaskManagementSubmissionFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "submitTaskReport", taskReport);
        }
        if (taskReport == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "submitTaskReport received null report");
            }
            throw new TaskManagementSubmissionFailedException("MSG_KEY_003", new String[0], null);
        }
        long[] lArray = this.generateIds(taskReport);
        if (SecurityContext.isSecurityEnabled()) {
            try {
                ContextManager contextManager = ContextManagerFactory.getInstance();
                contextManager.runAsSystem(new TaskSubmitter(taskReport, lArray));
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "PrivilegedActionException: " + privilegedActionException.getMessage());
                }
                throw new TaskManagementSubmissionFailedException("MSG_KEY_003", new String[0], privilegedActionException.fillInStackTrace());
            }
        } else {
            this.submitJMXTaskReport(taskReport, lArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "submitTaskReport", lArray);
        }
        return lArray;
    }

    private long[] generateIds(TaskReport taskReport) {
        long l = 0L;
        if (taskReport == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "generateIds received null report");
            }
            return null;
        }
        Task[] taskArray = taskReport.getTasks();
        long[] lArray = new long[taskArray.length];
        for (int i = 0; i < taskArray.length; ++i) {
            if (taskArray[i] == null) continue;
            if (TaskManagementServiceProxy.getAdminService() == null) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer(TaskManagementServiceProxy.getAdminService().getLocalServer().toString());
            stringBuffer.append(System.currentTimeMillis());
            stringBuffer.append(taskArray[i].hashCode());
            l = stringBuffer.toString().hashCode();
            long l2 = 0x80000001L;
            lArray[i] = l += l2;
        }
        return lArray;
    }

    private long[] submitJMXTaskReport(TaskReport taskReport, long[] lArray) throws TaskManagementSubmissionFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "submitJMXTaskReport", new Object[]{taskReport, lArray, this});
        }
        ObjectName objectName = this.getTskMgrMBean();
        String[] stringArray = new String[]{"com.ibm.ws.taskmanagement.task.TaskReport", "[J"};
        Object[] objectArray = new Object[]{taskReport, lArray};
        String string = null;
        try {
            String string2 = TaskManagementServiceProxy.getAdminService().getProcessType();
            if (string2.equals("UnManagedProcess") || string2.equals("DeploymentManager")) {
                adminService.invoke(objectName, "submit", objectArray, stringArray);
            } else {
                this.getDmgrAdminClient().invoke(objectName, "submit", objectArray, stringArray);
            }
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "submitTaskReport", "TaskManagementSubmissionFailedException");
            }
            throw new TaskManagementSubmissionFailedException("MSG_KEY_002", string, instanceNotFoundException.fillInStackTrace());
        }
        catch (MBeanException mBeanException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "submitTaskReport", "TaskManagementSubmissionFailedException");
            }
            throw new TaskManagementSubmissionFailedException("MSG_KEY_003", string, mBeanException.fillInStackTrace());
        }
        catch (ReflectionException reflectionException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "submitTaskReport", "TaskManagementSubmissionFailedException");
            }
            throw new TaskManagementSubmissionFailedException("MSG_KEY_004", string, reflectionException.fillInStackTrace());
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TaskManagementServiceProxy: Exception caught " + exception.getMessage());
            }
            Tr.error(tc, exception.toString());
            throw new TaskManagementSubmissionFailedException("MSG_KEY_004", string, exception.fillInStackTrace());
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "submitJMXTaskReport");
            }
        }
        return lArray;
    }

    public void submitTaskActionPlanStatus(ActionPlanStatus actionPlanStatus) throws TaskManagementSubmissionFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "submitTaskActionPlanStatus", actionPlanStatus);
        }
        if (SecurityContext.isSecurityEnabled()) {
            try {
                ContextManager contextManager = ContextManagerFactory.getInstance();
                contextManager.runAsSystem(new TaskSubmitter(actionPlanStatus));
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "PrivilegedActionException: " + privilegedActionException.getMessage());
                }
                throw new TaskManagementSubmissionFailedException("MSG_KEY_003", new String[0], privilegedActionException.fillInStackTrace());
            }
        } else {
            this.submitJMXTaskActionPlanStatus(actionPlanStatus);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "submitTaskActionPlanStatus");
        }
    }

    private void submitJMXTaskActionPlanStatus(ActionPlanStatus actionPlanStatus) throws TaskManagementSubmissionFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "submitJMXTaskActionPlanStatus", actionPlanStatus);
        }
        ObjectName objectName = this.getTskMgrMBean();
        String[] stringArray = new String[]{"com.ibm.ws.taskmanagement.task.ActionPlanStatus"};
        Object[] objectArray = new Object[]{actionPlanStatus};
        String string = null;
        try {
            String string2 = TaskManagementServiceProxy.getAdminService().getProcessType();
            if (string2.equals("UnManagedProcess") || string2.equals("DeploymentManager")) {
                adminService.invoke(objectName, "updateActionPlanStatus", objectArray, stringArray);
            } else {
                this.getDmgrAdminClient().invoke(objectName, "updateActionPlanStatus", objectArray, stringArray);
            }
        }
        catch (ConnectorException connectorException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "submitTaskActionPlanStatus", "TaskManagementSubmissionFailedException");
            }
            throw new TaskManagementSubmissionFailedException("MSG_KEY_001", string, connectorException.fillInStackTrace());
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "submitTaskActionPlanStatus", "TaskManagementSubmissionFailedException");
            }
            throw new TaskManagementSubmissionFailedException("MSG_KEY_002", string, instanceNotFoundException.fillInStackTrace());
        }
        catch (MBeanException mBeanException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "submitTaskActionPlanStatus", "TaskManagementSubmissionFailedException");
            }
            throw new TaskManagementSubmissionFailedException("MSG_KEY_003", string, mBeanException.fillInStackTrace());
        }
        catch (ReflectionException reflectionException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "submitTaskActionPlanStatus", "TaskManagementSubmissionFailedException");
            }
            throw new TaskManagementSubmissionFailedException("MSG_KEY_004", string, reflectionException.fillInStackTrace());
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "submitTaskActionPlanStatus", "TaskManagementSubmissionFailedException");
            }
            throw new TaskManagementSubmissionFailedException("MSG_KEY_005", string, nullPointerException.fillInStackTrace());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "submitJMXTaskActionPlanStatus");
        }
    }

    private ObjectName getTskMgrMBean() throws TaskManagementSubmissionFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTskMgrMBean", this);
        }
        if (this.tskMgrMBean == null) {
            try {
                String string = TaskManagementServiceProxy.getAdminService().getProcessType();
                ObjectName objectName = null;
                Set set = null;
                if (string.equals("UnManagedProcess") || string.equals("DeploymentManager")) {
                    String string2 = TaskManagementServiceProxy.getAdminService().getNodeName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "query = WebSphere:*,node=" + string2 + ",type=TaskManagement");
                    }
                    objectName = new ObjectName("WebSphere:*,node=" + string2 + ",type=TaskManagement");
                    set = TaskManagementServiceProxy.getAdminService().queryNames(objectName, null);
                } else {
                    try {
                        ObjectName objectName2 = this.getDmgrAdminClient().getServerMBean();
                        if (objectName2 != null) {
                            String string3 = objectName2.getKeyProperty("node");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "query = WebSphere:*,node=" + string3 + ",type=TaskManagement");
                            }
                            objectName = new ObjectName("WebSphere:*,node=" + string3 + ",type=TaskManagement");
                            set = this.getDmgrAdminClient().queryNames(objectName, null);
                        }
                    }
                    catch (TaskManagementSubmissionFailedException taskManagementSubmissionFailedException) {
                        if (tc.isDebugEnabled()) {
                            Tr.warning(tc, "dmgr could not be found");
                        }
                        throw taskManagementSubmissionFailedException;
                    }
                }
                if (set.size() == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "tskMgrMBean = null");
                    }
                    Tr.warning(tc, "tskMgrMBean = null");
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getTskMgrMBean");
                    }
                    return null;
                }
                this.tskMgrMBean = (ObjectName)set.iterator().next();
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "TaskManagementServiceProxy::getTskMgrMBean:: MalformedObjectNameException caught: " + malformedObjectNameException.getMessage());
                }
                Tr.error(tc, malformedObjectNameException.toString());
            }
            catch (Exception exception) {
                throw new TaskManagementSubmissionFailedException("MSG_KEY_001", null);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTskMgrMBean", this.tskMgrMBean);
        }
        return this.tskMgrMBean;
    }

    private static AdminService getAdminService() {
        if (adminService == null && (adminService = AdminServiceFactory.getAdminService()) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adminService = null");
            }
            Tr.warning(tc, "adminService = null");
            return null;
        }
        return adminService;
    }

    private AdminClient getDmgrAdminClient() throws TaskManagementSubmissionFailedException {
        try {
            if (this.dmgr_ac == null) {
                this.dmgr_ac = AdminServiceFactory.getAdminService().getDeploymentManagerAdminClient();
            } else {
                this.dmgr_ac.isAlive();
            }
        }
        catch (Exception exception) {
            String string = null;
            this.dmgr_ac = null;
            throw new TaskManagementSubmissionFailedException("MSG_KEY_001", string, exception.fillInStackTrace());
        }
        return this.dmgr_ac;
    }

    private class TaskSubmitter
    implements PrivilegedExceptionAction {
        private TaskReport report = null;
        long[] gids = null;
        ActionPlanStatus status = null;

        public TaskSubmitter(TaskReport taskReport, long[] lArray) {
            this.report = taskReport;
            this.gids = lArray;
        }

        public TaskSubmitter(ActionPlanStatus actionPlanStatus) {
            this.status = actionPlanStatus;
        }

        public Object run() throws Exception {
            if (this.report != null && this.gids != null) {
                TaskManagementServiceProxy.this.submitJMXTaskReport(this.report, this.gids);
                this.report = null;
                this.gids = null;
            }
            if (this.status != null) {
                TaskManagementServiceProxy.this.submitJMXTaskActionPlanStatus(this.status);
            }
            return null;
        }
    }
}

