/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.taskmanagement.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.taskmanagement.exceptions.TaskManagementException;
import com.ibm.ws.taskmanagement.task.ManagedTask;
import com.ibm.ws.taskmanagement.task.ManagedTaskState;
import com.ibm.ws.taskmanagement.task.TaskContainer;
import com.ibm.ws.taskmanagement.util.TaskImplConstants;

public class ExecutingTaskState
extends ManagedTaskState {
    private static final long serialVersionUID = -5474397724259101300L;
    protected static final TraceComponent tc = Tr.register(ExecutingTaskState.class.getName(), "taskmanagement", TaskImplConstants.NLSPROPSFILE);
    private static ExecutingTaskState _ets = new ExecutingTaskState(null, null, 0L, 0);

    private ExecutingTaskState(ManagedTask managedTask, String string, long l, byte by) {
        super(managedTask, string, l, by);
    }

    public static ManagedTaskState start(ManagedTask managedTask) {
        ExecutingTaskState executingTaskState = _ets;
        executingTaskState.getClass();
        InProgress inProgress = executingTaskState.new InProgress(managedTask);
        ((ManagedTaskState)inProgress).enter();
        return inProgress;
    }

    protected ManagedTaskState processEvent(int n) throws TaskManagementException {
        return null;
    }

    private class Unknown
    extends ExecutingTaskState {
        private static final long serialVersionUID = -6724154228013289409L;

        public Unknown(ManagedTask managedTask) {
            super(managedTask, ManagedTaskState.getUserId(), System.currentTimeMillis(), (byte)14);
            this._terminal = true;
        }

        public ManagedTaskState processEvent(int n) throws TaskManagementException {
            throw new TaskManagementException("MSG_KEY_100", String.valueOf(this._managedTask.getGlobalId()));
        }
    }

    private class Failed
    extends ExecutingTaskState {
        private static final long serialVersionUID = -8065129739690733190L;

        public Failed(ManagedTask managedTask) {
            super(managedTask, ManagedTaskState.getUserId(), System.currentTimeMillis(), (byte)12);
            this._terminal = true;
        }

        public ManagedTaskState processEvent(int n) throws TaskManagementException {
            throw new TaskManagementException("MSG_KEY_100", String.valueOf(this._managedTask.getGlobalId()));
        }
    }

    private class Succeeded
    extends ExecutingTaskState {
        private static final long serialVersionUID = -6619265399962110956L;

        public Succeeded(ManagedTask managedTask) {
            super(managedTask, ManagedTaskState.getUserId(), System.currentTimeMillis(), (byte)13);
            this._terminal = true;
        }

        public ManagedTaskState processEvent(int n) throws TaskManagementException {
            throw new TaskManagementException("MSG_KEY_100", String.valueOf(this._managedTask.getGlobalId()));
        }
    }

    private class Closed
    extends ExecutingTaskState {
        private static final long serialVersionUID = 9007737066339508411L;

        public Closed(ManagedTask managedTask) {
            super(managedTask, ManagedTaskState.getUserId(), System.currentTimeMillis(), (byte)11);
            this._terminal = true;
        }

        public ManagedTaskState processEvent(int n) throws TaskManagementException {
            throw new TaskManagementException("MSG_KEY_100", String.valueOf(this._managedTask.getGlobalId()));
        }
    }

    private class InProgress
    extends ExecutingTaskState {
        private static final long serialVersionUID = -4924733315888400776L;

        public InProgress(ManagedTask managedTask) {
            super(managedTask, managedTask.getTask().getOriginatorId(), System.currentTimeMillis(), (byte)6);
            this._transitional = true;
        }

        public void enter() {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "enter");
            }
            super.enter();
            TaskContainer.getExecutor().execute(this._managedTask);
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "enter");
            }
        }

        public ManagedTaskState processEvent(int n) throws TaskManagementException {
            ExecutingTaskState executingTaskState;
            switch (n) {
                case 8: {
                    executingTaskState = new Failed(this._managedTask);
                    break;
                }
                case 9: {
                    executingTaskState = new Succeeded(this._managedTask);
                    break;
                }
                case 11: {
                    executingTaskState = new Unknown(this._managedTask);
                    break;
                }
                default: {
                    throw new TaskManagementException("MSG_KEY_100", String.valueOf(this._managedTask.getGlobalId()));
                }
            }
            executingTaskState.enter();
            return executingTaskState;
        }
    }
}

