/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.taskmanagement.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.taskmanagement.task.ManagedTaskState;
import com.ibm.ws.taskmanagement.task.Task;
import com.ibm.ws.taskmanagement.task.TaskMessage;
import com.ibm.ws.taskmanagement.task.TaskPolicy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class ManagedTask
implements Serializable {
    protected static final TraceComponent tc = Tr.register(ManagedTask.class.getName(), "taskmanagement", "com.ibm.ws.taskmanagement.nls.Messages");
    private static final long serialVersionUID = -845099667243424568L;
    private static Random r = new Random(System.currentTimeMillis());
    private long _globalId;
    private List _aliasIds = new ArrayList(0);
    private long _taskToken;
    private ManagedTaskState _currentState;
    private List _historicState = new ArrayList();
    private Task _task;
    private byte _status;
    private TaskMessage _statusMsg;
    private int hashCode;
    private String serializedFileName;
    private long removalTime;
    private List _policies = new ArrayList(0);

    public ManagedTask() {
        this._taskToken = r.nextLong();
    }

    public void archiveHistoricState(ManagedTaskState managedTaskState) {
    }

    public Task getTask() {
        return this._task;
    }

    public long getTaskToken() {
        return this._taskToken;
    }

    public ManagedTaskState getCurrentState() {
        return this._currentState;
    }

    public List getHistoricState() {
        return this._historicState;
    }

    public void setTask(Task task) {
        this._task = task;
    }

    public void setCurrentState(ManagedTaskState managedTaskState) {
        this._historicState.add(this._currentState);
        this._currentState = managedTaskState;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "State change for task " + this._globalId, this._currentState);
        }
    }

    public void setGlobalId(long l) {
        this._globalId = l;
    }

    public long getGlobalId() {
        return this._globalId;
    }

    public void addAliasId(long l) {
        this._aliasIds.add(new Long(l));
    }

    public List getAliasIds() {
        return this._aliasIds;
    }

    public byte getStatus() {
        return this._status;
    }

    public TaskMessage getStatusMessage() {
        return this._statusMsg;
    }

    public void setFinalStatus(byte by) {
        this._status = by;
    }

    public void setFinalStatusMessage(TaskMessage taskMessage) {
        this._statusMsg = taskMessage;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("task ID=");
        stringBuffer.append(this._globalId);
        stringBuffer.append("\n");
        stringBuffer.append("status=");
        stringBuffer.append(this.getStatusString());
        stringBuffer.append("\n");
        stringBuffer.append("status message=");
        stringBuffer.append(this._statusMsg);
        stringBuffer.append("\n");
        stringBuffer.append(this._task.toString());
        return stringBuffer.toString();
    }

    private String getStatusString() {
        String string = null;
        switch (this._status) {
            case 30: {
                string = "completed";
                break;
            }
            case 20: {
                string = "completed with errors";
                break;
            }
            case 10: {
                string = "failed";
                break;
            }
            case 40: {
                string = "unknown";
                break;
            }
            default: {
                string = "" + this._status;
            }
        }
        return string;
    }

    protected void setSerializedFileName(String string) {
        this.serializedFileName = string;
    }

    protected String getSerializedFileName() {
        return this.serializedFileName;
    }

    public void addPolicy(TaskPolicy taskPolicy) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addPolicy", taskPolicy);
        }
        if (taskPolicy != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding policy");
            }
            this._policies.add(taskPolicy);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addPolicy", taskPolicy);
        }
    }

    public void removePolicy(TaskPolicy taskPolicy) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removePolicy", taskPolicy);
        }
        if (taskPolicy == null) {
            return;
        }
        int n = this._policies.size();
        for (int i = 0; i < n; ++i) {
            if (!this._policies.get(i).equals(taskPolicy)) continue;
            this._policies.remove(i);
            if (!tc.isDebugEnabled()) break;
            Tr.debug(tc, "Removed policy");
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removePolicy", taskPolicy);
        }
    }

    public List getPolicies() {
        return new ArrayList(this._policies);
    }
}

