/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.taskmanagement.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.taskmanagement.exceptions.TaskManagementException;
import com.ibm.ws.taskmanagement.task.ManagedTask;
import com.ibm.ws.taskmanagement.task.TaskManagementMBean;
import com.ibm.ws.taskmanagement.task.TaskPersister;
import com.ibm.ws.taskmanagement.task.impl.TaskStateImpl;
import java.util.HashMap;

public abstract class ManagedTaskState
extends TaskStateImpl {
    static final long serialVersionUID = 2617098253429216984L;
    protected ManagedTask _managedTask;
    protected static final TraceComponent tc = Tr.register(ManagedTaskState.class.getName(), "taskmanagement", "com.ibm.ws.taskmanagement.nls.Messages");

    protected ManagedTaskState(ManagedTask managedTask, String string, long l, byte by) {
        if (managedTask != null) {
            this._managedTask = managedTask;
            this.setInvokerId(string);
            this.setTime(l);
            this.setStateType(by);
        }
    }

    protected void enter() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Entering ", new Object[]{this.getClass().getName(), new Long(this._managedTask.getGlobalId())});
        }
        this._managedTask.setCurrentState(this);
        int n = TaskPersister.getPersister().persistTask(this._managedTask);
        if (tc.isDebugEnabled()) {
            if (n != 0) {
                Tr.debug(tc, "ERROR: persistTask returned " + n);
            } else {
                Tr.debug(tc, "Persisted " + this._managedTask.getSerializedFileName() + " for class " + this.getClass().getName());
            }
        }
        this.sendNotification(this._managedTask.getGlobalId(), this._managedTask.getCurrentState().getStateType());
    }

    protected abstract ManagedTaskState processEvent(int var1) throws TaskManagementException;

    protected static String getUserId() {
        String string = SecurityHelper.getUserName();
        if (string == null) {
            string = "unknown";
        }
        return string;
    }

    protected void sendNotification(long l, byte by) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
        hashMap.put("task.id", String.valueOf(l));
        hashMap.put("task.state", new Byte(by));
        TaskManagementMBean.sendNotification("websphere.taskmanagement.taskstatechange", hashMap);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("task ID=");
        stringBuffer.append(this._managedTask.getGlobalId());
        stringBuffer.append("; ");
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }
}

