/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.taskmanagement.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.taskmanagement.exceptions.TaskManagementActionPlanExecutionException;
import com.ibm.ws.taskmanagement.task.ActionPlanStatus;
import com.ibm.ws.taskmanagement.task.ManagedTask;
import com.ibm.ws.taskmanagement.task.PlannedTask;
import com.ibm.ws.taskmanagement.task.TaskFactory;
import com.ibm.ws.taskmanagement.task.TaskManagementMBean;
import com.ibm.ws.taskmanagement.task.TaskMessage;
import com.ibm.ws.taskmanagement.util.TaskImplConstants;
import com.ibm.ws.util.ThreadPool;
import java.util.HashMap;
import java.util.Set;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public class TaskActionPlanExecutor {
    private static final String EXECUTE = "execute";
    private static final String PREVIEW = "preview";
    private static final String ROLLBACK = "rollback";
    private static final String COMMIT = "commit";
    private HashMap _alarmMap = new HashMap();
    private StatusTimeOutListener _statusTimeOutListener = new StatusTimeOutListener();
    private static TaskActionPlanExecutor executor = new TaskActionPlanExecutor();
    private ThreadPool threadPool;
    private static final TraceComponent tc = Tr.register(TaskActionPlanExecutor.class, "taskmanagement", TaskImplConstants.NLSPROPSFILE);

    protected static TaskActionPlanExecutor getExecutor() {
        return executor;
    }

    public void execute(ManagedTask managedTask) {
        this.invoke(managedTask, EXECUTE);
    }

    public void preview(ManagedTask managedTask) {
        this.invoke(managedTask, PREVIEW);
    }

    public void rollback(ManagedTask managedTask) {
        this.invoke(managedTask, ROLLBACK);
    }

    public void commit(ManagedTask managedTask) {
        this.invoke(managedTask, COMMIT);
    }

    private void invoke(ManagedTask managedTask, String string) {
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "invoke", new Object[]{managedTask, string, this});
            }
            try {
                if (managedTask.getTask() instanceof PlannedTask && ((PlannedTask)managedTask.getTask()).getType() == 3) {
                    if (((PlannedTask)managedTask.getTask()).isInProgress()) {
                        Alarm alarm = AlarmManager.createDeferrable(((PlannedTask)managedTask.getTask()).getActionPlan().getTimeOut(), this._statusTimeOutListener, managedTask);
                        this._alarmMap.put(new Long(managedTask.getGlobalId()), alarm);
                    } else {
                        this.getThreadPool().execute(new ExecutionDispatcher(managedTask, string));
                    }
                } else {
                    this.getThreadPool().execute(new ExecutionDispatcher(managedTask, string));
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.taskmanagement.task.TaskActionPlanExecutor", "62", this);
                TaskMessage taskMessage = TaskFactory.createTaskMessage("MSG_KEY_063", new Object[]{new Long(managedTask.getGlobalId())}, TraceNLS.getFormattedMessage(TaskImplConstants.NLSPROPSFILE, "MSG_KEY_063", new Object[]{new Long(managedTask.getGlobalId())}, ""), TaskImplConstants.NLSPROPSFILE);
                ActionPlanStatus actionPlanStatus = TaskFactory.createActionPlanStatus(managedTask.getGlobalId(), managedTask.getTaskToken(), taskMessage, (byte)10);
                this.updateActionPlanStatus(actionPlanStatus);
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "TaskActionPlanExecutor: Exception " + throwable.getClass().getName() + " caught with message " + throwable.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke");
        }
    }

    public void updateActionPlanStatus(ActionPlanStatus actionPlanStatus) {
        boolean bl;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Received ActionPlan status update: taskId: " + actionPlanStatus.getTaskGlobalId() + "; token = " + actionPlanStatus.getTaskToken() + "; msg = " + actionPlanStatus.getMessage() + "; status = " + actionPlanStatus.getStatus());
        }
        if (bl = TaskManagementMBean.getTaskContainer().setTaskStatus(actionPlanStatus)) {
            Alarm alarm = (Alarm)this._alarmMap.get(new Long(actionPlanStatus.getTaskGlobalId()));
            if (alarm != null) {
                alarm.cancel();
                this._alarmMap.remove(new Long(actionPlanStatus.getTaskGlobalId()));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cancelled alarm since status was received for task " + actionPlanStatus.getTaskGlobalId());
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not locate alarm for task " + actionPlanStatus.getTaskGlobalId());
            }
        }
    }

    private ThreadPool getThreadPool() {
        if (this.threadPool == null) {
            this.threadPool = new ThreadPool("TaskManagement", 0, 50);
            this.threadPool.setGrowAsNeeded(true);
        }
        return this.threadPool;
    }

    private class StatusTimeOutListener
    implements AlarmListener {
        private final TraceComponent tc = Tr.register(class$com$ibm$ws$taskmanagement$task$TaskActionPlanExecutor == null ? (class$com$ibm$ws$taskmanagement$task$TaskActionPlanExecutor = TaskActionPlanExecutor.class$("com.ibm.ws.taskmanagement.task.TaskActionPlanExecutor")) : class$com$ibm$ws$taskmanagement$task$TaskActionPlanExecutor, "taskmanagement", TaskImplConstants.NLSPROPSFILE);

        private StatusTimeOutListener() {
        }

        public synchronized void alarm(Object object) {
            if (this.tc.isEntryEnabled()) {
                Tr.entry(this.tc, "alarm", new Object[]{object, this});
            }
            ManagedTask managedTask = (ManagedTask)object;
            TaskMessage taskMessage = TaskFactory.createTaskMessage("MSG_KEY_064", new Object[]{new Long(managedTask.getGlobalId())}, TraceNLS.getFormattedMessage(TaskImplConstants.NLSPROPSFILE, "MSG_KEY_064", new Object[]{new Long(managedTask.getGlobalId())}, ""), TaskImplConstants.NLSPROPSFILE);
            ActionPlanStatus actionPlanStatus = TaskFactory.createActionPlanStatus(managedTask.getGlobalId(), managedTask.getTaskToken(), taskMessage, (byte)40);
            TaskActionPlanExecutor.this.updateActionPlanStatus(actionPlanStatus);
            TaskActionPlanExecutor.this._alarmMap.remove(new Long(managedTask.getGlobalId()));
            if (this.tc.isEntryEnabled()) {
                Tr.exit(this.tc, "alarm");
            }
        }
    }

    private class ExecutionDispatcher
    implements Runnable {
        private ManagedTask mtask;
        private String operation;

        public ExecutionDispatcher(ManagedTask managedTask, String string) {
            this.mtask = managedTask;
            this.operation = string;
        }

        public void run() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "run", this);
            }
            try {
                Subject subject = ContextManagerFactory.getInstance().getServerSubject();
                if (subject != null) {
                    ContextManagerFactory.getInstance().setInvocationSubject(subject);
                }
            }
            catch (WSSecurityException wSSecurityException) {
                FFDCFilter.processException((Throwable)wSSecurityException, "com.ibm.ws.xd.visualizationengine.cacheservice.CacheManager", "568", this);
            }
            char c = this.operation.charAt(0);
            switch (c) {
                case 'c': 
                case 'e': 
                case 'p': 
                case 'r': {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Execute ActionPlan for Task " + this.mtask.getGlobalId());
                        }
                        PlannedTask plannedTask = null;
                        if (!(this.mtask.getTask() instanceof PlannedTask)) {
                            throw new TaskManagementActionPlanExecutionException("MSG_KEY_061", String.valueOf(this.mtask.getGlobalId()));
                        }
                        plannedTask = (PlannedTask)this.mtask.getTask();
                        ObjectName objectName = this.resolve(plannedTask.getActionPlan().getExecutorObjectName());
                        if (objectName == null) {
                            Object[] objectArray = new Object[]{plannedTask.getActionPlan().getExecutorObjectName(), new Long(this.mtask.getGlobalId())};
                            Tr.error(tc, "MSG_KEY_062", objectArray);
                            TaskMessage taskMessage = TaskFactory.createTaskMessage("MSG_KEY_062", objectArray, TraceNLS.getFormattedMessage(TaskImplConstants.NLSPROPSFILE, "MSG_KEY_062", objectArray, ""), TaskImplConstants.NLSPROPSFILE);
                            ActionPlanStatus actionPlanStatus = TaskFactory.createActionPlanStatus(this.mtask.getGlobalId(), this.mtask.getTaskToken(), taskMessage, (byte)10);
                            TaskActionPlanExecutor.this.updateActionPlanStatus(actionPlanStatus);
                            break;
                        }
                        Alarm alarm = AlarmManager.createDeferrable(plannedTask.getActionPlan().getTimeOut(), TaskActionPlanExecutor.this._statusTimeOutListener, this.mtask);
                        TaskActionPlanExecutor.this._alarmMap.put(new Long(this.mtask.getGlobalId()), alarm);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Submitting action plan for execution to " + objectName);
                        }
                        String[] stringArray = new String[]{"com.ibm.ws.taskmanagement.task.TaskActionPlan", "long", "long"};
                        Object[] objectArray = new Object[]{plannedTask.getActionPlan(), new Long(this.mtask.getTaskToken()), new Long(this.mtask.getGlobalId())};
                        AdminServiceFactory.getAdminService().invoke(objectName, this.operation, objectArray, stringArray);
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug(tc, "Sucessfully submitted action plan for execution");
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.taskmanagement.task.TaskActionPlanExecutor", "52", this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception " + throwable.getClass().getName() + " caught with message: " + throwable.getMessage());
                        }
                        TaskMessage taskMessage = TaskFactory.createTaskMessage("MSG_KEY_063", new Object[]{new Long(this.mtask.getGlobalId())}, TraceNLS.getFormattedMessage(TaskImplConstants.NLSPROPSFILE, "MSG_KEY_063", new Object[]{new Long(this.mtask.getGlobalId())}, ""), TaskImplConstants.NLSPROPSFILE);
                        ActionPlanStatus actionPlanStatus = TaskFactory.createActionPlanStatus(this.mtask.getGlobalId(), this.mtask.getTaskToken(), taskMessage, (byte)10);
                        TaskActionPlanExecutor.this.updateActionPlanStatus(actionPlanStatus);
                    }
                    break;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "run");
            }
        }

        private ObjectName resolve(ObjectName objectName) {
            ObjectName objectName2 = null;
            if (objectName.isPattern()) {
                Set set = AdminServiceFactory.getAdminService().queryNames(objectName, null);
                if (set.size() != 0) {
                    objectName2 = (ObjectName)set.iterator().next();
                }
            } else {
                objectName2 = objectName;
            }
            return objectName2;
        }
    }
}

