/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.taskmanagement.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.topology.cell.Cell;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.taskmanagement.exceptions.TaskManagementException;
import com.ibm.ws.taskmanagement.mapper.TaskManagementServiceMapper;
import com.ibm.ws.taskmanagement.mapper.TaskManagementServiceMapperEvent;
import com.ibm.ws.taskmanagement.mapper.TaskManagementServiceMapperFactory;
import com.ibm.ws.taskmanagement.mapper.TaskManagementServiceMapperListener;
import com.ibm.ws.taskmanagement.task.ActionPlanStatus;
import com.ibm.ws.taskmanagement.task.DisplayTask;
import com.ibm.ws.taskmanagement.task.ManagedTask;
import com.ibm.ws.taskmanagement.task.ManagedTaskState;
import com.ibm.ws.taskmanagement.task.NonPlannedTask;
import com.ibm.ws.taskmanagement.task.PlannedTask;
import com.ibm.ws.taskmanagement.task.Task;
import com.ibm.ws.taskmanagement.task.TaskActionPlan;
import com.ibm.ws.taskmanagement.task.TaskActionPlanExecutor;
import com.ibm.ws.taskmanagement.task.TaskManagementMBean;
import com.ibm.ws.taskmanagement.task.TaskPersister;
import com.ibm.ws.taskmanagement.task.TaskPolicy;
import com.ibm.ws.taskmanagement.task.TaskReport;
import com.ibm.ws.taskmanagement.task.TaskStateFactory;
import com.ibm.ws.taskmanagement.task.TaskTargetObject;
import com.ibm.ws.taskmanagement.task.impl.DisplayTaskImpl;
import com.ibm.ws.taskmanagement.util.TaskHelper;
import com.ibm.ws.taskmanagement.util.TaskImplConstants;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class TaskContainer
implements TaskManagementServiceMapperListener {
    Map _taskMap;
    Map _componentMap;
    Map _submittorMap;
    Map _severityMap;
    Set _plannedTaskSet;
    Set _nonplannedTaskSet;
    Map _targetObjectMap;
    Set _terminatedTaskSet;
    private long _nextGlobalId;
    private int DEFAULT_REMOVAL_TIME;
    private int _removalTime;
    private static final String TIMEOUT_PROPERTY = "terminated.task.remove.timeout";
    RemoveAlarmListener _removalAlarmListener;
    ExpireAlarmListener _expireAlarmListener;
    private static final TraceComponent tc = Tr.register(TaskContainer.class, "taskmanagement", TaskImplConstants.NLSPROPSFILE);
    private Map expireAlarmMap;
    private Map removeAlarmMap;
    private ArrayList savedTasks;
    private ArrayList savedGids;
    private static String persistentStorageDirectory;
    private static final String TMS_STORAGE_DIRECTORY = "tmsStorageDir";
    private static final String TMS_EXECUTOR = "tmsExecutor";
    private static final String TMS_CLASSNAME = "classname";
    private static TaskActionPlanExecutor _executor;

    public TaskContainer() {
        boolean bl;
        block12: {
            this._taskMap = new HashMap();
            this._componentMap = new HashMap();
            this._submittorMap = new HashMap();
            this._severityMap = new HashMap();
            this._plannedTaskSet = new HashSet();
            this._nonplannedTaskSet = new HashSet();
            this._targetObjectMap = new HashMap();
            this._terminatedTaskSet = new HashSet();
            this._nextGlobalId = System.currentTimeMillis();
            this._removalTime = this.DEFAULT_REMOVAL_TIME = 86400000;
            this._removalAlarmListener = null;
            this._expireAlarmListener = null;
            this.expireAlarmMap = new HashMap();
            this.removeAlarmMap = new HashMap();
            this.savedTasks = new ArrayList();
            this.savedGids = new ArrayList();
            persistentStorageDirectory = this.queryPersistentStorageDirectory();
            this.queryAlternativeExecutor();
            if (_executor == null) {
                _executor = new TaskActionPlanExecutor();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting _executor to default: " + _executor);
                }
            }
            String string = System.getProperty(TIMEOUT_PROPERTY);
            bl = false;
            if (string != null) {
                try {
                    this._removalTime = new Integer(string);
                    bl = true;
                    Tr.info(tc, "MSG_KEY_025", new Object[]{TIMEOUT_PROPERTY, new Integer(string)});
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "server.xml contains timeout setting = " + this._removalTime);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    if (!tc.isDebugEnabled()) break block12;
                    Tr.debug(tc, "Invalid number for timeout property = " + string);
                }
            }
        }
        if (!bl) {
            String string = "cells/" + AdminServiceFactory.getAdminService().getCellName() + "/cell.xml";
            Cell cell = null;
            try {
                Resource resource;
                URI uRI;
                EList eList;
                DocumentContentSource documentContentSource = ConfigRepositoryFactory.getConfigRepository().extract(string);
                if (documentContentSource != null) {
                    eList = new WASResourceSetImpl();
                    uRI = URI.createFileURI((String)documentContentSource.getDocument().getURI());
                    resource = eList.createResource(uRI);
                    resource.load(documentContentSource.getSource(), new HashMap());
                    cell = (Cell)resource.getContents().get(0);
                }
                eList = cell.getProperties();
                uRI = eList.iterator();
                while (uRI.hasNext()) {
                    resource = (Property)uRI.next();
                    if (!resource.getName().equals(TIMEOUT_PROPERTY)) continue;
                    this._removalTime = new Integer(resource.getValue());
                    Tr.info(tc, "MSG_KEY_025", new Object[]{TIMEOUT_PROPERTY, new Integer(resource.getValue())});
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "cell.xml contains timeout setting = " + resource.getValue());
                }
            }
            catch (Throwable throwable) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "timeout property not found");
                }
                FFDCFilter.processException(throwable, "com.ibm.ws.taskmanagement.task.TaskContainer", "225", this);
            }
        }
    }

    public void submit(List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "submit", list);
        }
        if (list == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Submitted List of TaskReports is null; returning");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "submit", list);
            }
            throw new NullPointerException("submit input parameter \"reports\" was null");
        }
        Iterator iterator = list.iterator();
        int n = -1;
        while (iterator.hasNext()) {
            ++n;
            TaskReport taskReport = null;
            try {
                taskReport = (TaskReport)iterator.next();
            }
            catch (ClassCastException classCastException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "List index[" + n + "] was not a TaskReport; " + "element skipped");
                }
                Tr.warning(tc, "List index[" + n + "] was not a TaskReport; " + "element skipped");
                continue;
            }
            if (taskReport == null) continue;
            this.submit(taskReport);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "submit", list);
        }
    }

    public synchronized void submit(TaskReport taskReport) {
        String string;
        if (taskReport == null) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "submit", taskReport);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Submitted TaskReport is null; throwing exception");
            }
            Tr.debug(tc, "Submitted TaskReport is null; throwing exception");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "submit", taskReport);
            }
            throw new NullPointerException("submit input parameter \"report\" was null");
        }
        String string2 = taskReport.getOriginatorId();
        if (string2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "submit", taskReport);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TaskReport originator ID is null; returning");
            }
            Tr.warning(tc, "TaskReport originator ID is null; returning");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "submit", taskReport);
            }
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "submit", string2);
        }
        if (!this._submittorMap.containsKey(string = TaskHelper.generateSubmitterId(taskReport))) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Report: Adding " + string + " to _submittorMap");
            }
            this._submittorMap.put(string, new HashSet());
        }
        HashSet hashSet = new HashSet((Set)this._submittorMap.get(string));
        Task[] taskArray = taskReport.getTasks();
        ArrayList<Task> arrayList = new ArrayList<Task>(taskArray.length);
        int n = -1;
        for (int i = 0; i < taskArray.length; ++i) {
            n = this.validateIds(taskArray[i], string2, string);
            if (n != 0) continue;
            arrayList.add(taskArray[i]);
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ManagedTaskState managedTaskState;
            ManagedTask managedTask = (ManagedTask)iterator.next();
            if (managedTask.getTask() instanceof NonPlannedTask) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "NonPlannedTask submitted, so continuing");
                continue;
            }
            if (arrayList.contains(managedTask.getTask())) {
                managedTaskState = managedTask.getCurrentState();
                if (managedTaskState.getStateType() != 1 && managedTaskState.getStateType() != 2 && managedTaskState.getStateType() != 4 && managedTaskState.getStateType() != 5) continue;
                int n2 = arrayList.indexOf(managedTask.getTask());
                Task task = (Task)arrayList.get(n2);
                if (task.getGlobalSeverity() != managedTask.getTask().getGlobalSeverity()) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
                    hashMap.put("task.id", String.valueOf(managedTask.getGlobalId()));
                    hashMap.put("task.severity", new Byte(task.getGlobalSeverity()));
                    TaskManagementMBean.sendNotification("websphere.taskmanagement.taskseveritychange", hashMap);
                }
                managedTask.setTask(task);
                this.renew(managedTask);
                arrayList.remove(managedTask.getTask());
                continue;
            }
            managedTaskState = managedTask.getCurrentState();
            if (managedTaskState.getStateType() != 1 && managedTaskState.getStateType() != 2 && managedTaskState.getStateType() != 4 && managedTaskState.getStateType() != 5) continue;
            this.expire(managedTask);
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.handleNewTask((Task)iterator.next(), null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "submit", taskReport.getOriginatorId());
        }
    }

    private int validateIds(Task task, String string, String string2) {
        if (task != null) {
            String string3 = task.getOriginatorId();
            if (string3 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Task originator ID is null; skipping task");
                }
                Tr.warning(tc, "Task originator ID is null; skipping task");
                return -1;
            }
            if (!string.equals(string3)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Ignoring task with originator ID " + string3);
                }
                Tr.warning(tc, "Ignoring task with originator ID " + string3);
                return -2;
            }
            String string4 = TaskHelper.generateSubmitterId(task);
            if (string4 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Task originator ID is null; skipping task");
                }
                Tr.warning(tc, "Task originator ID is null; skipping task");
                return -3;
            }
            if (!string2.equals(string4)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Ignoring task with submittor ID " + string4);
                }
                Tr.warning(tc, "Ignoring task with submittor ID " + string4);
                return -4;
            }
            return 0;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Ignoring null task in submitted report.");
        }
        return -5;
    }

    public synchronized void submit(TaskReport taskReport, long[] lArray) {
        Object object;
        String string;
        if (taskReport == null) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "submit", taskReport);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Submitted TaskReport is null; throwing exception");
            }
            Tr.warning(tc, "Submitted TaskReport is null; throwing exception");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "submit", taskReport);
            }
            throw new NullPointerException("submit input parameter \"report\" was null");
        }
        if (lArray == null) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "submit", taskReport.getOriginatorId());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Submitted array of global IDs is null; throwing exception");
            }
            Tr.warning(tc, "Submitted array of global IDs is null; throwing exception");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "submit", taskReport.getOriginatorId());
            }
            throw new NullPointerException("submit input parameter \"gids\" was null");
        }
        String string2 = taskReport.getOriginatorId();
        if (string2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "submit", taskReport);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TaskReport originator ID is null; returning");
            }
            Tr.warning(tc, "TaskReport originator ID is null; returning");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "submit", taskReport);
            }
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "submit", string2);
        }
        if (!this._submittorMap.containsKey(string = TaskHelper.generateSubmitterId(taskReport))) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Report Gids: Adding " + string + " to _submittorMap");
            }
            this._submittorMap.put(string, new HashSet());
        }
        HashSet hashSet = new HashSet((Set)this._submittorMap.get(string));
        Task[] taskArray = taskReport.getTasks();
        ArrayList<Task> arrayList = new ArrayList<Task>(taskArray.length);
        ArrayList<Long> arrayList2 = new ArrayList<Long>(lArray.length);
        int n = -1;
        for (int i = 0; i < taskArray.length; ++i) {
            n = this.validateIds(taskArray[i], string2, string);
            if (n != 0) continue;
            arrayList.add(taskArray[i]);
            arrayList2.add(new Long(lArray[i]));
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ManagedTaskState managedTaskState;
            object = (ManagedTask)iterator.next();
            if (((ManagedTask)object).getTask() instanceof NonPlannedTask) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "NonPlannedTask submitted, so continuing");
                continue;
            }
            if (arrayList.contains(((ManagedTask)object).getTask())) {
                Serializable serializable;
                managedTaskState = ((ManagedTask)object).getCurrentState();
                if (managedTaskState.getStateType() != 1 && managedTaskState.getStateType() != 2 && managedTaskState.getStateType() != 4 && managedTaskState.getStateType() != 5) continue;
                int n2 = arrayList.indexOf(((ManagedTask)object).getTask());
                Task task = (Task)arrayList.get(n2);
                if (task.getGlobalSeverity() != ((ManagedTask)object).getTask().getGlobalSeverity()) {
                    serializable = new HashMap<String, String>(2);
                    ((HashMap)serializable).put("task.id", String.valueOf(((ManagedTask)object).getGlobalId()));
                    ((HashMap)serializable).put("task.severity", new Byte(task.getGlobalSeverity()));
                    TaskManagementMBean.sendNotification("websphere.taskmanagement.taskseveritychange", serializable);
                }
                ((ManagedTask)object).setTask(task);
                serializable = (Long)arrayList2.remove(arrayList.indexOf(((ManagedTask)object).getTask()));
                ((ManagedTask)object).addAliasId((Long)serializable);
                this._taskMap.put(serializable, object);
                this.renew((ManagedTask)object);
                arrayList.remove(((ManagedTask)object).getTask());
                continue;
            }
            managedTaskState = ((ManagedTask)object).getCurrentState();
            if (managedTaskState.getStateType() != 1 && managedTaskState.getStateType() != 2 && managedTaskState.getStateType() != 4 && managedTaskState.getStateType() != 5) continue;
            this.expire((ManagedTask)object);
        }
        iterator = arrayList.iterator();
        object = arrayList2.iterator();
        while (iterator.hasNext()) {
            this.handleNewTask((Task)iterator.next(), (Long)object.next());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "submit", taskReport.getOriginatorId());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void accept(long l) throws TaskManagementException {
        ManagedTask managedTask;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "accept: " + l);
        }
        if ((managedTask = (ManagedTask)this._taskMap.get(new Long(l))) == null) {
            throw new TaskManagementException("MSG_KEY_011", String.valueOf(l));
        }
        Task task = managedTask.getTask();
        if (task == null) throw new TaskManagementException("MSG_KEY_014", String.valueOf(l));
        if (!(task instanceof PlannedTask)) throw new TaskManagementException("MSG_KEY_016", String.valueOf(l));
        byte by = ((PlannedTask)task).getType();
        if (by != 2 && by != 1) throw new TaskManagementException("MSG_KEY_021", String.valueOf(l));
        ManagedTaskState managedTaskState = managedTask.getCurrentState();
        byte by2 = managedTaskState.getStateType();
        if (by2 != 1 && by2 != 2 && by2 != 8 && by2 != 4 && by2 != 5) throw new TaskManagementException("MSG_KEY_015", String.valueOf(l));
        ManagedTaskState managedTaskState2 = managedTaskState.processEvent(4);
        if (managedTaskState2.isTerminal()) {
            this.removeTask(managedTask);
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "accept: " + l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void preview(long l) throws TaskManagementException {
        ManagedTask managedTask;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "preview: " + l);
        }
        if ((managedTask = (ManagedTask)this._taskMap.get(new Long(l))) == null) {
            throw new TaskManagementException("MSG_KEY_011", String.valueOf(l));
        }
        Task task = managedTask.getTask();
        if (task == null) throw new TaskManagementException("MSG_KEY_014", String.valueOf(l));
        if (!(task instanceof PlannedTask)) throw new TaskManagementException("MSG_KEY_016", String.valueOf(l));
        byte by = ((PlannedTask)task).getType();
        if (by != 1) throw new TaskManagementException("MSG_KEY_021", String.valueOf(l));
        ManagedTaskState managedTaskState = managedTask.getCurrentState();
        byte by2 = managedTaskState.getStateType();
        if (by2 != 1 && by2 != 5 && by2 != 2 && by2 != 4) throw new TaskManagementException("MSG_KEY_015", String.valueOf(l));
        ManagedTaskState managedTaskState2 = managedTaskState.processEvent(5);
        if (managedTaskState2.isTerminal()) {
            this.removeTask(managedTask);
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "preview: " + l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void commit(long l) throws TaskManagementException {
        ManagedTask managedTask;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit: " + l);
        }
        if ((managedTask = (ManagedTask)this._taskMap.get(new Long(l))) == null) {
            throw new TaskManagementException("MSG_KEY_011", String.valueOf(l));
        }
        Task task = managedTask.getTask();
        if (task == null) throw new TaskManagementException("MSG_KEY_014", String.valueOf(l));
        if (!(task instanceof PlannedTask)) throw new TaskManagementException("MSG_KEY_016", String.valueOf(l));
        byte by = ((PlannedTask)task).getType();
        if (by != 1) throw new TaskManagementException("MSG_KEY_021", String.valueOf(l));
        ManagedTaskState managedTaskState = managedTask.getCurrentState();
        byte by2 = managedTaskState.getStateType();
        if (by2 != 8 && by2 != 7) throw new TaskManagementException("MSG_KEY_015", String.valueOf(l));
        ManagedTaskState managedTaskState2 = managedTaskState.processEvent(7);
        if (managedTaskState2.isTerminal()) {
            this.removeTask(managedTask);
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "commit: " + l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void rollback(long l) throws TaskManagementException {
        ManagedTask managedTask;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rollback: " + l);
        }
        if ((managedTask = (ManagedTask)this._taskMap.get(new Long(l))) == null) {
            throw new TaskManagementException("MSG_KEY_011", String.valueOf(l));
        }
        Task task = managedTask.getTask();
        if (task == null) throw new TaskManagementException("MSG_KEY_014", String.valueOf(l));
        if (!(task instanceof PlannedTask)) throw new TaskManagementException("MSG_KEY_016", String.valueOf(l));
        byte by = ((PlannedTask)task).getType();
        if (by != 1) throw new TaskManagementException("MSG_KEY_021", String.valueOf(l));
        ManagedTaskState managedTaskState = managedTask.getCurrentState();
        byte by2 = managedTaskState.getStateType();
        if (by2 != 8) throw new TaskManagementException("MSG_KEY_015", String.valueOf(l));
        ManagedTaskState managedTaskState2 = managedTaskState.processEvent(6);
        if (managedTaskState2.isTerminal()) {
            this.removeTask(managedTask);
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "rollback: " + l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deny(long l) throws TaskManagementException {
        ManagedTask managedTask;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deny: " + l);
        }
        if ((managedTask = (ManagedTask)this._taskMap.get(new Long(l))) == null) {
            throw new TaskManagementException("MSG_KEY_011", String.valueOf(l));
        }
        Task task = managedTask.getTask();
        if (task == null) throw new TaskManagementException("MSG_KEY_017", String.valueOf(l));
        if (!(task instanceof PlannedTask)) throw new TaskManagementException("MSG_KEY_019", String.valueOf(l));
        byte by = ((PlannedTask)task).getType();
        if (by != 2 && by != 1) throw new TaskManagementException("MSG_KEY_020", String.valueOf(l));
        ManagedTaskState managedTaskState = managedTask.getCurrentState();
        byte by2 = managedTaskState.getStateType();
        if (by2 != 1 && by2 != 2) throw new TaskManagementException("MSG_KEY_018", String.valueOf(l));
        ManagedTaskState managedTaskState2 = managedTaskState.processEvent(3);
        if (managedTaskState2.isTerminal()) {
            this.removeTask(managedTask);
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "deny: " + l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close(long l) throws TaskManagementException {
        ManagedTask managedTask;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "close: " + l);
        }
        if ((managedTask = (ManagedTask)this._taskMap.get(new Long(l))) == null) throw new TaskManagementException("MSG_KEY_022", String.valueOf(l));
        Task task = managedTask.getTask();
        if (task == null) throw new TaskManagementException("MSG_KEY_022", String.valueOf(l));
        if (task instanceof PlannedTask && ((PlannedTask)task).getType() == 3) {
            throw new TaskManagementException("MSG_KEY_024", String.valueOf(l));
        }
        ManagedTaskState managedTaskState = managedTask.getCurrentState();
        byte by = managedTaskState.getStateType();
        if (by != 1 && by != 2 && by != 5 && by != 4) throw new TaskManagementException("MSG_KEY_023", String.valueOf(l));
        ManagedTaskState managedTaskState2 = managedTask.getCurrentState().processEvent(10);
        if (managedTaskState2.isTerminal()) {
            this.removeTask(managedTask);
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "close: " + l);
    }

    private void renew(ManagedTask managedTask) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "renew: " + managedTask.getGlobalId());
        }
        try {
            ManagedTaskState managedTaskState = managedTask.getCurrentState().processEvent(1);
            if (managedTaskState.isTerminal()) {
                this.removeTask(managedTask);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.taskmanagement.task.TaskContainer", "1118", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "renew: " + managedTask.getGlobalId());
        }
    }

    private void expire(ManagedTask managedTask) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "expire: " + managedTask.getGlobalId());
        }
        if (managedTask == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "expire called with a null task!");
            }
            Tr.warning(tc, "expire called with a null task!");
            return;
        }
        try {
            ManagedTaskState managedTaskState = managedTask.getCurrentState().processEvent(2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "state = " + managedTaskState.getStateTypeString() + " isTerminal = " + managedTaskState.isTerminal());
            }
            if (managedTaskState.isTerminal()) {
                this.removeTask(managedTask);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.taskmanagement.task.TaskContainer", "1161", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "expire: " + managedTask.getGlobalId());
        }
    }

    private void fail(ManagedTask managedTask) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fail: " + managedTask.getGlobalId());
        }
        try {
            ManagedTaskState managedTaskState = managedTask.getCurrentState().processEvent(8);
            if (managedTaskState.isTerminal()) {
                this.removeTask(managedTask);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.taskmanagement.task.TaskContainer", "1190", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fail: " + managedTask.getGlobalId());
        }
    }

    private void unknown(ManagedTask managedTask) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unknown: " + managedTask.getGlobalId());
        }
        try {
            ManagedTaskState managedTaskState = managedTask.getCurrentState().processEvent(11);
            if (managedTaskState.isTerminal()) {
                this.removeTask(managedTask);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.taskmanagement.task.TaskContainer", "266", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unknown: " + managedTask.getGlobalId());
        }
    }

    private void complete(ManagedTask managedTask) {
        if (managedTask == null) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "complete: " + managedTask);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "task is null; returning");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "complete: " + managedTask);
            }
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "complete: " + managedTask.getGlobalId());
        }
        try {
            ManagedTaskState managedTaskState = managedTask.getCurrentState().processEvent(9);
            if (managedTaskState.isTerminal()) {
                this.removeTask(managedTask);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.taskmanagement.task.TaskContainer", "1231", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "complete: " + managedTask.getGlobalId());
        }
    }

    public DisplayTask getTask(long l) {
        ManagedTask managedTask = (ManagedTask)this._taskMap.get(new Long(l));
        DisplayTaskImpl displayTaskImpl = null;
        if (managedTask != null) {
            displayTaskImpl = new DisplayTaskImpl(managedTask.getTask(), managedTask.getGlobalId(), managedTask.getCurrentState(), managedTask.getStatus(), managedTask.getStatusMessage());
        }
        return displayTaskImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getTasks() {
        HashSet<DisplayTaskImpl> hashSet = new HashSet<DisplayTaskImpl>(this._taskMap.size());
        Map map = this._taskMap;
        synchronized (map) {
            Iterator iterator = this._taskMap.values().iterator();
            while (iterator.hasNext()) {
                ManagedTask managedTask = (ManagedTask)iterator.next();
                hashSet.add(new DisplayTaskImpl(managedTask.getTask(), managedTask.getGlobalId(), managedTask.getCurrentState(), managedTask.getStatus(), managedTask.getStatusMessage()));
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getTasksByComponent(String string) {
        Set set = (Set)this._componentMap.get(string);
        if (set != null) {
            HashSet<DisplayTaskImpl> hashSet = new HashSet<DisplayTaskImpl>(set.size());
            Set set2 = set;
            synchronized (set2) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    ManagedTask managedTask = (ManagedTask)iterator.next();
                    hashSet.add(new DisplayTaskImpl(managedTask.getTask(), managedTask.getGlobalId(), managedTask.getCurrentState(), managedTask.getStatus(), managedTask.getStatusMessage()));
                }
            }
            return hashSet;
        }
        return new HashSet(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getTasksByTargetObjectContext(String string) {
        Set set = (Set)this._targetObjectMap.get(string);
        if (set != null) {
            HashSet<DisplayTaskImpl> hashSet = new HashSet<DisplayTaskImpl>(set.size());
            Set set2 = set;
            synchronized (set2) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    ManagedTask managedTask = (ManagedTask)iterator.next();
                    hashSet.add(new DisplayTaskImpl(managedTask.getTask(), managedTask.getGlobalId(), managedTask.getCurrentState(), managedTask.getStatus(), managedTask.getStatusMessage()));
                }
            }
            return hashSet;
        }
        return new HashSet(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer numberofActiveTasks(String string) {
        Set set = (Set)this._targetObjectMap.get(string);
        int n = 0;
        if (set != null) {
            Set set2 = set;
            synchronized (set2) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    ManagedTask managedTask = (ManagedTask)iterator.next();
                    if (managedTask.getCurrentState().isTerminal()) continue;
                    ++n;
                }
            }
        }
        return new Integer(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getTasksBySeverity(byte by) {
        Byte by2 = new Byte(by);
        Set set = (Set)this._severityMap.get(by2);
        if (set != null) {
            HashSet<DisplayTaskImpl> hashSet = new HashSet<DisplayTaskImpl>(set.size());
            Set set2 = set;
            synchronized (set2) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    ManagedTask managedTask = (ManagedTask)iterator.next();
                    hashSet.add(new DisplayTaskImpl(managedTask.getTask(), managedTask.getGlobalId(), managedTask.getCurrentState(), managedTask.getStatus(), managedTask.getStatusMessage()));
                }
            }
            return hashSet;
        }
        return new HashSet(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getPlannedTasks() {
        Set set = this._plannedTaskSet;
        HashSet<DisplayTaskImpl> hashSet = new HashSet<DisplayTaskImpl>(set.size());
        Set set2 = set;
        synchronized (set2) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ManagedTask managedTask = (ManagedTask)iterator.next();
                hashSet.add(new DisplayTaskImpl(managedTask.getTask(), managedTask.getGlobalId(), managedTask.getCurrentState(), managedTask.getStatus(), managedTask.getStatusMessage()));
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getNonPlannedTasks() {
        Set set = this._nonplannedTaskSet;
        HashSet<DisplayTaskImpl> hashSet = new HashSet<DisplayTaskImpl>(set.size());
        Set set2 = set;
        synchronized (set2) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ManagedTask managedTask = (ManagedTask)iterator.next();
                hashSet.add(new DisplayTaskImpl(managedTask.getTask(), managedTask.getGlobalId(), managedTask.getCurrentState(), managedTask.getStatus(), managedTask.getStatusMessage()));
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getTerminatedTasks() {
        Set set = this._terminatedTaskSet;
        HashSet<DisplayTaskImpl> hashSet = new HashSet<DisplayTaskImpl>(set.size());
        Set set2 = set;
        synchronized (set2) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ManagedTask managedTask = (ManagedTask)iterator.next();
                hashSet.add(new DisplayTaskImpl(managedTask.getTask(), managedTask.getGlobalId(), managedTask.getCurrentState(), managedTask.getStatus(), managedTask.getStatusMessage()));
            }
        }
        return hashSet;
    }

    public TaskActionPlan getActionPlan(long l) throws TaskManagementException {
        ManagedTask managedTask = (ManagedTask)this._taskMap.get(new Long(l));
        if (managedTask != null) {
            Task task = managedTask.getTask();
            if (task instanceof PlannedTask) {
                return ((PlannedTask)task).getActionPlan();
            }
            throw new TaskManagementException("MSG_KEY_012", String.valueOf(l));
        }
        throw new TaskManagementException("MSG_KEY_011", String.valueOf(l));
    }

    public ManagedTaskState getCurrentState(long l) throws TaskManagementException {
        ManagedTask managedTask = (ManagedTask)this._taskMap.get(new Long(l));
        if (managedTask != null) {
            return managedTask.getCurrentState();
        }
        throw new TaskManagementException("MSG_KEY_011", String.valueOf(l));
    }

    public Byte getGlobalSeverity(long l) throws TaskManagementException {
        ManagedTask managedTask = (ManagedTask)this._taskMap.get(new Long(l));
        if (managedTask != null) {
            return new Byte(managedTask.getTask().getGlobalSeverity());
        }
        throw new TaskManagementException("MSG_KEY_011", String.valueOf(l));
    }

    public void setActionPlan(String string, TaskActionPlan taskActionPlan) throws TaskManagementException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNewTask(Task task, Long l) {
        Serializable serializable;
        TaskManagementServiceMapper taskManagementServiceMapper;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Handling new gid " + l + " and task ", task);
        }
        if ((taskManagementServiceMapper = TaskManagementServiceMapperFactory.getTaskMapper()) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Mapper is not yet defined; returning.");
            }
            ArrayList arrayList = this.savedTasks;
            synchronized (arrayList) {
                this.savedTasks.add(task);
                this.savedGids.add(l);
            }
            TaskManagementServiceMapper.addListener(this);
            return;
        }
        ManagedTask managedTask = new ManagedTask();
        managedTask.setTask(task);
        long l2 = 0L;
        l2 = l == null ? this.generateGlobalId() : l.longValue();
        managedTask.setGlobalId(l2);
        TaskManagementServiceMapperFactory.getTaskMapper().mapTask(managedTask);
        this._taskMap.put(new Long(l2), managedTask);
        this.addToCollections(managedTask);
        if (task instanceof PlannedTask) {
            serializable = (PlannedTask)task;
            byte by = serializable.getType();
            if (serializable.getKeepAlive() > 0L && (by == 2 || by == 1 || by == 0)) {
                if (this._expireAlarmListener == null) {
                    this._expireAlarmListener = new ExpireAlarmListener();
                }
                Alarm alarm = AlarmManager.createDeferrable(serializable.getKeepAlive(), this._expireAlarmListener, new Long(managedTask.getGlobalId()));
                Map map = this.expireAlarmMap;
                synchronized (map) {
                    this.expireAlarmMap.put(new Long(managedTask.getGlobalId()), alarm);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Added task " + managedTask.getGlobalId() + " to expireAlarmMap; new size is " + this.expireAlarmMap.size());
                    }
                }
            } else if (serializable.getKeepAlive() < 0L && tc.isDebugEnabled()) {
                Tr.debug(tc, "Ignoring keepAlive value of " + serializable.getKeepAlive());
            }
        }
        serializable = new HashMap(1);
        ((HashMap)serializable).put("task.id", String.valueOf(managedTask.getGlobalId()));
        TaskManagementMBean.sendNotification("websphere.taskmanagement.tasknew", serializable);
        ManagedTaskState managedTaskState = TaskStateFactory.startTaskState(managedTask);
    }

    private void addToCollections(ManagedTask managedTask) {
        Task task = managedTask.getTask();
        String string = task.getOriginatorId();
        if (!this._componentMap.containsKey(string)) {
            this._componentMap.put(string, new HashSet(1));
        }
        Set set = (Set)this._componentMap.get(string);
        set.add(managedTask);
        String string2 = TaskHelper.generateSubmitterId(task);
        Set set2 = (Set)this._submittorMap.get(string2);
        if (set2 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ERROR: null set for submittor ID " + string2);
            }
            set.remove(managedTask);
            return;
        }
        set2.add(managedTask);
        Byte by = new Byte(task.getGlobalSeverity());
        if (!this._severityMap.containsKey(by)) {
            this._severityMap.put(by, new HashSet());
        }
        set = (Set)this._severityMap.get(by);
        set.add(managedTask);
        if (task instanceof PlannedTask) {
            this._plannedTaskSet.add(managedTask);
        } else {
            this._nonplannedTaskSet.add(managedTask);
        }
        TaskTargetObject[] taskTargetObjectArray = task.getTargetObjects();
        for (int i = 0; i < taskTargetObjectArray.length; ++i) {
            String string3 = taskTargetObjectArray[i].getTargetContext();
            if (!this._targetObjectMap.containsKey(string3)) {
                this._targetObjectMap.put(string3, new HashSet());
            }
            Set set3 = (Set)this._targetObjectMap.get(string3);
            set3.add(managedTask);
        }
    }

    private void removeFromCollections(ManagedTask managedTask) {
        Task task = managedTask.getTask();
        Set set = (Set)this._componentMap.get(task.getOriginatorId());
        set.remove(managedTask);
        set = (Set)this._submittorMap.get(TaskHelper.generateSubmitterId(task));
        set.remove(managedTask);
        set = (Set)this._severityMap.get(new Byte(task.getGlobalSeverity()));
        set.remove(managedTask);
        if (task instanceof PlannedTask) {
            this._plannedTaskSet.remove(managedTask);
        } else {
            this._nonplannedTaskSet.remove(managedTask);
        }
        TaskTargetObject[] taskTargetObjectArray = task.getTargetObjects();
        for (int i = 0; i < taskTargetObjectArray.length; ++i) {
            set = (Set)this._targetObjectMap.get(taskTargetObjectArray[i].getTargetContext());
            set.remove(managedTask);
        }
        this._terminatedTaskSet.remove(managedTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTask(ManagedTask managedTask) {
        block8: {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Scheduling removal task " + managedTask.getGlobalId() + " in " + this._removalTime + " milliseconds");
            }
            this._terminatedTaskSet.add(managedTask);
            this.cleanAlarmMaps(new Long(managedTask.getGlobalId()), true);
            long l = this._removalTime;
            if (this._removalAlarmListener == null) {
                this._removalAlarmListener = new RemoveAlarmListener();
            }
            try {
                Alarm alarm = AlarmManager.createDeferrable(l, this._removalAlarmListener, new Long(managedTask.getGlobalId()));
                Map map = this.removeAlarmMap;
                synchronized (map) {
                    this.removeAlarmMap.put(new Long(managedTask.getGlobalId()), alarm);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Added task " + managedTask.getGlobalId() + " to removeAlarmMap; new size = " + this.removeAlarmMap.size());
                    }
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "removalTask caught exception " + exception.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTask(ManagedTask managedTask, long l) {
        block8: {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Scheduling removal task " + managedTask.getGlobalId() + " in " + l + " milliseconds");
            }
            this._terminatedTaskSet.add(managedTask);
            if (this._removalAlarmListener == null) {
                this._removalAlarmListener = new RemoveAlarmListener();
            }
            try {
                Alarm alarm = AlarmManager.createDeferrable(l, this._removalAlarmListener, new Long(managedTask.getGlobalId()));
                Map map = this.removeAlarmMap;
                synchronized (map) {
                    this.removeAlarmMap.put(new Long(managedTask.getGlobalId()), alarm);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Added task " + managedTask.getGlobalId() + " to removeAlarmMap; new size = " + this.removeAlarmMap.size());
                    }
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "removalTask caught exception " + exception.getMessage());
            }
        }
    }

    private synchronized long generateGlobalId() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "new global ID is " + this._nextGlobalId);
        }
        return this._nextGlobalId++;
    }

    public void updateActionPlanStatus(ActionPlanStatus actionPlanStatus) throws TaskManagementException {
        if (actionPlanStatus == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "null status received in updateActionPlanStatus");
            }
            throw new NullPointerException();
        }
        try {
            TaskContainer.getExecutor().updateActionPlanStatus(actionPlanStatus);
        }
        catch (Exception exception) {
            throw new TaskManagementException(exception.toString());
        }
    }

    public boolean setTaskStatus(ActionPlanStatus actionPlanStatus) {
        if (actionPlanStatus == null) {
            throw new NullPointerException("ActionPlanStatus is null");
        }
        ManagedTask managedTask = (ManagedTask)this._taskMap.get(new Long(actionPlanStatus.getTaskGlobalId()));
        if (managedTask != null) {
            if (managedTask.getTaskToken() == actionPlanStatus.getTaskToken() || ((PlannedTask)managedTask.getTask()).isInProgress() && ((PlannedTask)managedTask.getTask()).getType() == 3) {
                managedTask.setFinalStatus(actionPlanStatus.getStatus());
                managedTask.setFinalStatusMessage(actionPlanStatus.getMessage());
                switch (actionPlanStatus.getStatus()) {
                    case 30: {
                        this.complete(managedTask);
                        break;
                    }
                    case 20: {
                        this.complete(managedTask);
                        break;
                    }
                    case 10: {
                        this.fail(managedTask);
                        break;
                    }
                    case 40: {
                        this.unknown(managedTask);
                        break;
                    }
                    default: {
                        this.fail(managedTask);
                    }
                }
                HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
                hashMap.put("task.id", String.valueOf(managedTask.getGlobalId()));
                hashMap.put("task.status", new Byte(managedTask.getStatus()));
                TaskManagementMBean.sendNotification("websphere.taskmanagement.tasksstatus", hashMap);
                return true;
            }
            Tr.error(tc, "MSG_KEY_013", new Long(managedTask.getGlobalId()));
            return false;
        }
        Tr.error(tc, "MSG_KEY_011", new Long(actionPlanStatus.getTaskGlobalId()));
        return false;
    }

    public void delete(long l) {
        Long l2;
        ManagedTask managedTask;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "delete");
        }
        if ((managedTask = (ManagedTask)this._taskMap.get(new Long(l))) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Task ID " + l + " was not in task map; returning");
            }
            Tr.warning(tc, "Task ID " + l + " was not in task map; returning");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "delete");
            }
            return;
        }
        Iterator iterator = managedTask.getAliasIds().iterator();
        while (iterator.hasNext()) {
            l2 = (Long)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Removing alias " + l2 + " from task map");
            }
            this._taskMap.remove(l2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Removing " + l + " from task map");
        }
        this._taskMap.remove(new Long(l));
        this.removeFromCollections(managedTask);
        l2 = new Long(l);
        this.cleanAlarmMaps(l2, true);
        TaskPersister.getPersister().removeTask(managedTask);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "delete");
        }
    }

    public void delete(long[] lArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "delete");
        }
        if (lArray == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "delete input parameter \"taskIds\" was null");
            }
            Tr.warning(tc, "delete input parameter \"taskIds\" was null");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "delete");
            }
            throw new NullPointerException("delete input parameter \"taskIds\" was null");
        }
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long l;
            ManagedTask managedTask = (ManagedTask)this._taskMap.get(new Long(lArray[i]));
            if (managedTask == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Task ID " + lArray[i] + " was not in task map" + "; skipping it");
                }
                Tr.warning(tc, "Task ID " + lArray[i] + " was not in task map" + "; skipping it");
                continue;
            }
            Iterator iterator = managedTask.getAliasIds().iterator();
            while (iterator.hasNext()) {
                l = (Long)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Removing alias " + l + " from task map");
                }
                this._taskMap.remove(l);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Removing " + lArray[i] + " from task map");
            }
            this._taskMap.remove(new Long(lArray[i]));
            this.removeFromCollections(managedTask);
            l = new Long(lArray[i]);
            this.cleanAlarmMaps(l, true);
            TaskPersister.getPersister().removeTask(managedTask);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "delete");
        }
    }

    public void addPolicy(TaskPolicy taskPolicy, long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addPolicy");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "policy = " + taskPolicy + " taskId = " + l);
        }
        if (taskPolicy == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Submitted TaskPolicy is null; throwing exception");
            }
            Tr.warning(tc, "Submitted TaskPolicy is null; throwing exception");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addPolicy");
            }
            throw new NullPointerException("addPolicy input parameter \"policy\" was null");
        }
        ManagedTask managedTask = (ManagedTask)this._taskMap.get(new Long(l));
        if (managedTask == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Task ID " + l + " was not in task map; returning");
            }
            Tr.warning(tc, "Task ID " + l + " was not in task map; returning");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addPolicy");
            }
            return;
        }
        managedTask.addPolicy(taskPolicy);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addPolicy");
        }
    }

    public void removePolicy(TaskPolicy taskPolicy, long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removePolicy");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "policy = " + taskPolicy + " taskId = " + l);
        }
        if (taskPolicy == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Submitted TaskPolicy is null; throwing exception");
            }
            Tr.warning(tc, "Submitted TaskPolicy is null; throwing exception");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removePolicy");
            }
            throw new NullPointerException("removePolicy input parameter \"policy\" was null");
        }
        ManagedTask managedTask = (ManagedTask)this._taskMap.get(new Long(l));
        if (managedTask == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Task ID " + l + " was not in task map; returning");
            }
            Tr.warning(tc, "Task ID " + l + " was not in task map; returning");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removePolicy");
            }
            return;
        }
        managedTask.removePolicy(taskPolicy);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removePolicy");
        }
    }

    public List getPolicies(long l) {
        ManagedTask managedTask;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPolicies", new Long(l));
        }
        if ((managedTask = (ManagedTask)this._taskMap.get(new Long(l))) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Task ID " + l + " was not in task map; returning");
            }
            Tr.warning(tc, "Task ID " + l + " was not in task map; returning");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPolicies", new Long(l));
            }
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPolicies", new Long(l));
        }
        return managedTask.getPolicies();
    }

    private synchronized void cleanAlarmMaps(Long l, boolean bl) {
        Alarm alarm;
        if (this.expireAlarmMap.containsKey(l) && (alarm = (Alarm)this.expireAlarmMap.get(l)) != null) {
            if (bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cancelling alarm");
                }
                alarm.cancel();
            }
            this.expireAlarmMap.remove(l);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Removed task " + l + " from expireAlarmMap; " + "new size = " + this.expireAlarmMap.size());
            }
        }
        if (this.removeAlarmMap.containsKey(l) && (alarm = (Alarm)this.removeAlarmMap.get(l)) != null) {
            if (bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cancelling alarm");
                }
                alarm.cancel();
            }
            this.removeAlarmMap.remove(l);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Removed task " + l + " from removeAlarmMap; " + "new size = " + this.removeAlarmMap.size());
            }
        }
    }

    protected void handlePersistedTasks() {
        TaskManagementServiceMapper taskManagementServiceMapper = TaskManagementServiceMapperFactory.getTaskMapper();
        if (taskManagementServiceMapper == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Mapper is not yet defined; returning.");
            }
            TaskManagementServiceMapper.addListener(this);
            return;
        }
        ArrayList arrayList = TaskPersister.getPersister().getPersistedTasks(this._removalTime);
        int n = arrayList.size();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                ManagedTask managedTask = (ManagedTask)arrayList.get(i);
                this.handlePersistedTask(managedTask);
            }
        }
    }

    private void handlePersistedTask(ManagedTask managedTask) {
        String string;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Handling persisted task", new Long(managedTask.getGlobalId()));
        }
        if (!this._submittorMap.containsKey(string = TaskHelper.generateSubmitterId(managedTask.getTask()))) {
            this._submittorMap.put(string, new HashSet());
        }
        Long l = new Long(managedTask.getGlobalId());
        this._taskMap.put(l, managedTask);
        this.addToCollections(managedTask);
        Task task = managedTask.getTask();
        long l2 = System.currentTimeMillis();
        ManagedTaskState managedTaskState = managedTask.getCurrentState();
        byte by = managedTaskState.getStateType();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stateType = " + managedTaskState.getStateTypeString());
        }
        if (task instanceof PlannedTask) {
            PlannedTask plannedTask = (PlannedTask)task;
            byte by2 = plannedTask.getType();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "type = " + by2);
            }
            if (managedTaskState.isTransitional()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, TaskHelper.getPlannedTaskTypeAsString(by2) + "-type task in state " + managedTaskState.getStateTypeString() + "is moving to UNKNOWN");
                }
                this.changeStateToUnknown(managedTaskState, managedTask);
            } else {
                if (plannedTask.getKeepAlive() > 0L) {
                    this.handleTaskWithAutoExpire(managedTask, l2, managedTaskState);
                }
                this.handleTerminalTask(managedTask, l2, managedTaskState, by2);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "This is NOT a planned task");
            }
            if (managedTaskState.isTerminal()) {
                this.removeTask(managedTask);
            }
        }
    }

    private void changeStateToUnknown(ManagedTaskState managedTaskState, ManagedTask managedTask) {
        block4: {
            try {
                ManagedTaskState managedTaskState2 = managedTaskState.processEvent(11);
                if (managedTaskState2.isTerminal()) {
                    this.removeTask(managedTask);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Started persisted removal alarm");
                    }
                }
            }
            catch (TaskManagementException taskManagementException) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "transition to unknown threw " + taskManagementException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTaskWithAutoExpire(ManagedTask managedTask, long l, ManagedTaskState managedTaskState) {
        Task task = managedTask.getTask();
        PlannedTask plannedTask = (PlannedTask)task;
        byte by = plannedTask.getType();
        byte by2 = managedTaskState.getStateType();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getKeepAlive = " + plannedTask.getKeepAlive() + " originated time = " + plannedTask.getOriginatedTime() + " currentTime = " + l);
        }
        if (plannedTask.getOriginatedTime() + plannedTask.getKeepAlive() < l) {
            if (!managedTaskState.isTerminal()) {
                if (by == 1 && by2 == 8) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Preview task in Previewed state; left alone");
                    }
                } else {
                    this.expire(managedTask);
                }
            }
        } else if (!managedTaskState.isTerminal()) {
            long l2 = plannedTask.getOriginatedTime() + plannedTask.getKeepAlive() - l;
            if (this._expireAlarmListener == null) {
                this._expireAlarmListener = new ExpireAlarmListener();
            }
            Alarm alarm = AlarmManager.createDeferrable(l2, this._expireAlarmListener, new Long(managedTask.getGlobalId()));
            Map map = this.expireAlarmMap;
            synchronized (map) {
                this.expireAlarmMap.put(new Long(managedTask.getGlobalId()), alarm);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Added persisted task " + managedTask.getGlobalId() + " to expireAlarmMap; expires in " + l2 + " milliseconds");
                }
            }
        }
    }

    private void handleTerminalTask(ManagedTask managedTask, long l, ManagedTaskState managedTaskState, byte by) {
        boolean bl = managedTaskState.isTerminal();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No auto-expire; isTerminal = " + bl);
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Started terminal persisted task removal alarm");
            }
            long l2 = managedTaskState.getTime();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "currenttime = " + l + " lasttime = " + l2 + " removaltime = " + this._removalTime);
            }
            if (l - l2 > (long)this._removalTime) {
                this.removeTask(managedTask, 0L);
            } else {
                long l3 = (long)this._removalTime - (l - l2);
                this.removeTask(managedTask, l3);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Leaving task as is");
        }
    }

    public void stateChanged(TaskManagementServiceMapperEvent taskManagementServiceMapperEvent) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stateChanged");
        }
        if (taskManagementServiceMapperEvent.getState() == 1) {
            ContainerListener containerListener = new ContainerListener(this);
            Thread thread = new Thread(containerListener);
            thread.start();
            TaskManagementServiceMapper.removeListener(this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stateChanged");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleSavedTasks() {
        ArrayList arrayList = this.savedTasks;
        synchronized (arrayList) {
            int n = this.savedTasks.size();
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    Task task = (Task)this.savedTasks.get(i);
                    Long l = (Long)this.savedGids.get(i);
                    this.handleNewTask(task, l);
                }
            }
            this.savedTasks.clear();
            this.savedGids.clear();
        }
    }

    private String queryPersistentStorageDirectory() {
        IExtensionRegistry iExtensionRegistry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        if (iExtensionRegistry == null) {
            if (tc.isErrorEnabled()) {
                Tr.error(tc, "Unable to get eclipse extension registry");
            }
            return null;
        }
        String string = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".service-provider";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Looking for instances of epid: " + string);
        }
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(string);
        IConfigurationElement iConfigurationElement = null;
        String string2 = null;
        for (int i = 0; i < iConfigurationElementArray.length; ++i) {
            Object object;
            block14: {
                iConfigurationElement = iConfigurationElementArray[i];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "element name = " + iConfigurationElement.getName());
                }
                if (!TMS_STORAGE_DIRECTORY.equals(iConfigurationElement.getName())) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "attribute = " + iConfigurationElement.getAttribute(TMS_CLASSNAME));
                }
                if (iConfigurationElement.getAttribute(TMS_CLASSNAME) == null || iConfigurationElement.getAttribute(TMS_CLASSNAME).length() == 0) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "classname attribute not defined; skipping");
                    continue;
                }
                object = null;
                try {
                    object = iConfigurationElement.createExecutableExtension(TMS_CLASSNAME);
                    if (!tc.isDebugEnabled()) break block14;
                    Tr.debug(tc, "class name = " + object.getClass().getName());
                }
                catch (CoreException coreException) {
                    FFDCFilter.processException((Throwable)coreException, "com.ibm.ws.taskmanagement.task.TaskContainer", "2562", this);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Couldn't load service provider implementation with classname: " + iConfigurationElement.getAttribute(TMS_CLASSNAME));
                    continue;
                }
            }
            try {
                Class<?> clazz = object.getClass();
                Class<?>[] classArray = null;
                Method method2 = clazz.getMethod("getStorageDirectory", classArray);
                Object[] objectArray = null;
                string2 = (String)method2.invoke(object, objectArray);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "TMS user specified storage directory = " + string2);
                }
                return string2;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Tr.error(tc, "Caught " + noSuchMethodException + " when calling getStorageDirectory");
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                Tr.error(tc, "Caught " + illegalAccessException + " when calling getStorageDirectory");
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                Tr.error(tc, "Caught " + invocationTargetException + " when calling getStorageDirectory");
            }
        }
        return string2;
    }

    private void queryAlternativeExecutor() {
        IExtensionRegistry iExtensionRegistry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        if (iExtensionRegistry == null) {
            if (tc.isErrorEnabled()) {
                Tr.error(tc, "Unable to get eclipse extension registry");
            }
            return;
        }
        String string = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".service-provider";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Looking for instances of epid: " + string);
        }
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(string);
        IConfigurationElement iConfigurationElement = null;
        Object var5_5 = null;
        for (int i = 0; i < iConfigurationElementArray.length; ++i) {
            Object object;
            block10: {
                iConfigurationElement = iConfigurationElementArray[i];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "element name = " + iConfigurationElement.getName());
                }
                if (!TMS_EXECUTOR.equals(iConfigurationElement.getName())) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "attribute = " + iConfigurationElement.getAttribute(TMS_CLASSNAME));
                }
                if (iConfigurationElement.getAttribute(TMS_CLASSNAME) == null || iConfigurationElement.getAttribute(TMS_CLASSNAME).length() == 0) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "classname attribute not defined; skipping");
                    continue;
                }
                object = null;
                try {
                    object = iConfigurationElement.createExecutableExtension(TMS_CLASSNAME);
                    if (!tc.isDebugEnabled()) break block10;
                    Tr.debug(tc, "class name = " + object.getClass().getName());
                }
                catch (CoreException coreException) {
                    FFDCFilter.processException((Throwable)coreException, "com.ibm.ws.taskmanagement.task.TaskContainer", "2758", this);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Couldn't load service provider implementation with classname: " + iConfigurationElement.getAttribute(TMS_CLASSNAME));
                    continue;
                }
            }
            if (!(object instanceof TaskActionPlanExecutor)) continue;
            _executor = (TaskActionPlanExecutor)object;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found an alternative executor");
            }
            return;
        }
    }

    protected static String getPersistentStorageDirectory() {
        return persistentStorageDirectory;
    }

    protected static TaskActionPlanExecutor getExecutor() {
        return _executor;
    }

    class ContainerListener
    implements Runnable {
        private TaskContainer container;

        protected ContainerListener(TaskContainer taskContainer2) {
            this.container = taskContainer2;
        }

        public void run() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "run");
            }
            this.container.handlePersistedTasks();
            this.container.handleSavedTasks();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "run");
            }
        }
    }

    private class ExpireAlarmListener
    implements AlarmListener {
        private final TraceComponent tc = Tr.register(class$com$ibm$ws$taskmanagement$task$TaskContainer == null ? (class$com$ibm$ws$taskmanagement$task$TaskContainer = TaskContainer.class$("com.ibm.ws.taskmanagement.task.TaskContainer")) : class$com$ibm$ws$taskmanagement$task$TaskContainer, "RemoveAlarmListener", TaskImplConstants.NLSPROPSFILE);

        private ExpireAlarmListener() {
        }

        public synchronized void alarm(Object object) {
            if (this.tc.isEntryEnabled()) {
                Tr.entry(this.tc, "alarm", new Object[]{object, this});
            }
            if (this.tc.isDebugEnabled()) {
                Tr.debug(this.tc, "expiring task " + object);
            }
            TaskContainer.this.cleanAlarmMaps((Long)object, false);
            ManagedTask managedTask = (ManagedTask)TaskContainer.this._taskMap.get(object);
            TaskContainer.this.expire(managedTask);
            if (this.tc.isEntryEnabled()) {
                Tr.exit(this.tc, "alarm");
            }
        }
    }

    private class RemoveAlarmListener
    implements AlarmListener {
        private final TraceComponent tc = Tr.register(class$com$ibm$ws$taskmanagement$task$TaskContainer == null ? (class$com$ibm$ws$taskmanagement$task$TaskContainer = TaskContainer.class$("com.ibm.ws.taskmanagement.task.TaskContainer")) : class$com$ibm$ws$taskmanagement$task$TaskContainer, "RemoveAlarmListener", TaskImplConstants.NLSPROPSFILE);

        private RemoveAlarmListener() {
        }

        public synchronized void alarm(Object object) {
            if (this.tc.isEntryEnabled()) {
                Tr.entry(this.tc, "alarm", new Object[]{object, this});
            }
            if (this.tc.isDebugEnabled()) {
                Tr.debug(this.tc, "removing task " + object);
            }
            ManagedTask managedTask = (ManagedTask)TaskContainer.this._taskMap.get(object);
            Iterator iterator = managedTask.getAliasIds().iterator();
            while (iterator.hasNext()) {
                TaskContainer.this._taskMap.remove(iterator.next());
            }
            TaskContainer.this._taskMap.remove(object);
            TaskContainer.this.removeFromCollections(managedTask);
            TaskContainer.this.cleanAlarmMaps((Long)object, false);
            TaskPersister.getPersister().removeTask(managedTask);
            if (this.tc.isEntryEnabled()) {
                Tr.exit(this.tc, "alarm");
            }
        }
    }
}

