/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.taskmanagement.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.taskmanagement.task.TaskActionPlanExecutor;
import com.ibm.ws.taskmanagement.task.TaskContainer;
import com.ibm.ws.taskmanagement.util.TaskImplConstants;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import javax.management.Notification;

public class TaskManagementMBean
extends WsComponentImpl {
    static TaskContainer container;
    static TaskActionPlanExecutor executor;
    static DefaultRuntimeCollaborator collab;
    protected static final TraceComponent tc;

    public void initialize(Object object) throws ComponentDisabledException, ConfigurationWarning, ConfigurationError {
        block9: {
            String string;
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "initialize", new Object[]{this});
            }
            if (!(string = AdminServiceFactory.getAdminService().getProcessType()).equals("DeploymentManager") && !string.equals("UnManagedProcess")) {
                throw new ComponentDisabledException();
            }
            try {
                WsServiceRegistry.addService((Object)this, (Class)TaskManagementMBean.class);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception " + exception.getMessage() + " on addService");
                }
                throw new ComponentDisabledException();
            }
            container = new TaskContainer();
            executor = TaskContainer.getExecutor();
            container.handlePersistedTasks();
            try {
                collab = new DefaultRuntimeCollaborator(container, "TaskManagement");
                AdminServiceFactory.getMBeanFactory().activateMBean("TaskManagement", collab, "TaskManagement", "META-INF/TaskManagement.xml");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Activated Task Management Service");
                }
            }
            catch (AdminException adminException) {
                Tr.error(tc, "TaskManagementMBean:initialize: Could not activate MBean: " + adminException.getMessage());
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, adminException.getMessage(), adminException);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public static TaskContainer getTaskContainer() {
        return container;
    }

    static void sendNotification(String string, Object object) {
        block3: {
            if (collab != null) {
                try {
                    Notification notification = new Notification(string, collab.getObjectName(), System.currentTimeMillis());
                    notification.setUserData(object);
                    collab.sendNotification(notification);
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception.getCause(), "com.ibm.ws.taskmanagement.task.TaskManagementMBean", "126", null);
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "TaskManagementMBean:sendNotification: Exception " + exception.getClass().getName() + " caught with message " + exception.getMessage());
                }
            }
        }
    }

    public static void reloadTasks() {
        TaskManagementMBean.getTaskContainer().handlePersistedTasks();
    }

    static {
        collab = null;
        tc = Tr.register(TaskManagementMBean.class, "taskmanagement", TaskImplConstants.NLSPROPSFILE);
    }
}

