/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.taskmanagement.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.taskmanagement.task.ManagedTask;
import com.ibm.ws.taskmanagement.task.PlannedTask;
import com.ibm.ws.taskmanagement.task.Task;
import com.ibm.ws.taskmanagement.task.TaskContainer;
import com.ibm.ws.taskmanagement.util.TaskImplConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class TaskPersister {
    private static final TraceComponent tc = Tr.register(TaskPersister.class, "taskmanagement", TaskImplConstants.NLSPROPSFILE);
    private static AdminService adminService;
    private static String wasHome;
    private static String storageDirPath;
    private static String separator;
    private static File storageDirFile;
    private static final String TMS_DIRECTORY = "tmsStorage";
    private static final long FUDGE_FACTOR = 60000L;
    private static char[] invalidChars;
    private static TaskPersister persister;

    public TaskPersister() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TaskPersister", wasHome);
        }
        String string = null;
        string = TaskContainer.getPersistentStorageDirectory();
        if (string != null) {
            this.createPersistenceDirectory(string);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "TaskPersister", wasHome);
            }
        } else {
            string = this.getWasHome();
            if (string != null) {
                this.createPersistenceDirectory(string);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ERROR: Home path could not be determined");
                }
                Tr.warning(tc, "ERROR: Home path could not be determined");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "TaskPersister", wasHome);
            }
        }
    }

    protected static TaskPersister getPersister() {
        return persister;
    }

    private void createPersistenceDirectory(String string) {
        if (string != null) {
            storageDirPath = new String(string + File.separator + TMS_DIRECTORY);
            separator = new String(File.separator);
            storageDirFile = new File(storageDirPath);
            if (!storageDirFile.exists()) {
                boolean bl = storageDirFile.mkdirs();
                if (!bl) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Failed creating " + storageDirFile);
                    }
                    storageDirFile = null;
                } else {
                    wasHome = new String(storageDirPath);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Created " + storageDirFile);
                    }
                }
            } else {
                wasHome = new String(storageDirPath);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, storageDirFile + " exists");
                }
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "createPersistenceDirectory path is null");
            }
            Tr.warning(tc, "createPersistenceDirectory path is null");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getWasHome() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWasHome", wasHome);
        }
        if (wasHome == null) {
            wasHome = System.getProperty("user.install.root");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wasHome property = " + wasHome);
            }
            if (wasHome != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getWasHome", wasHome);
                }
                return wasHome;
            }
            adminService = AdminServiceFactory.getAdminService();
            if (adminService == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "adminService = null");
                }
                Tr.warning(tc, "adminService = null");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getWasHome");
                }
                return null;
            }
            String string = adminService.getNodeName();
            ObjectName objectName = null;
            try {
                objectName = new ObjectName("*:*,type=AdminOperations,node=" + string);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "caught " + malformedObjectNameException.getMessage());
                }
                Tr.warning(tc, "1: caught " + malformedObjectNameException.getMessage());
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getWasHome");
                }
                return null;
            }
            Set set = adminService.queryNames(objectName, null);
            if (set.size() != 0) {
                ObjectName objectName2 = (ObjectName)set.iterator().next();
                if (objectName2 != null) {
                    try {
                        wasHome = (String)adminService.invoke(objectName2, "expandVariable", new Object[]{"${USER_INSTALL_ROOT}"}, new String[]{"java.lang.String"});
                    }
                    catch (InstanceNotFoundException instanceNotFoundException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "caught " + instanceNotFoundException.getMessage());
                        }
                        Tr.warning(tc, "2: caught " + instanceNotFoundException.getMessage());
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getWasHome");
                        }
                        return null;
                    }
                    catch (MBeanException mBeanException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "caught " + mBeanException.getMessage());
                        }
                        Tr.warning(tc, "3: caught " + mBeanException.getMessage());
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getWasHome");
                        }
                        return null;
                    }
                    catch (ReflectionException reflectionException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "caught " + reflectionException.getMessage());
                        }
                        Tr.warning(tc, "4: caught " + reflectionException.getMessage());
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getWasHome");
                        }
                        return null;
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "adminOps = null");
                    }
                    Tr.warning(tc, "adminOps = null");
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getWasHome");
                    }
                    return null;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "set size = 0");
            }
            Tr.warning(tc, "set size = 0");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getWasHome");
            }
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWasHome", wasHome);
        }
        return wasHome;
    }

    public String createSubdirectory(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSubdirectory");
        }
        String string2 = this.getWasHome();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "path = " + string2);
        }
        if (string2 != null) {
            StringBuffer stringBuffer = new StringBuffer(string);
            String string3 = new String(stringBuffer.toString());
            for (int i = 0; i < invalidChars.length; ++i) {
                int n;
                while ((n = string3.indexOf(invalidChars[i])) > -1) {
                    stringBuffer = stringBuffer.deleteCharAt(n);
                    string3 = new String(stringBuffer.toString());
                }
            }
            String string4 = new String(storageDirPath + separator + string3);
            File file = new File(string4);
            if (!file.exists()) {
                boolean bl;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating " + string4);
                }
                if (!(bl = file.mkdirs())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Failed creating " + string4);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "createSubdirectory");
                    }
                    return null;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Created " + string4);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createSubdirectory");
                }
                return string3;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string4 + " exists");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createSubdirectory");
            }
            return string3;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSubdirectory");
        }
        return null;
    }

    protected int persistTask(ManagedTask managedTask) {
        if (wasHome == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wasHome is null; can't persist task");
            }
            Tr.warning(tc, "wasHome is null; can't persist task");
            return -3;
        }
        long l = System.currentTimeMillis();
        String string = new Long(managedTask.getGlobalId()).toString();
        String string2 = managedTask.getTask().getOriginatorId();
        String string3 = this.createSubdirectory(string2);
        if (string3 == null) {
            return -1;
        }
        String string4 = new String(storageDirPath + separator + string3 + separator + "task_" + string);
        managedTask.setSerializedFileName(string4);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "persistTask path = " + managedTask.getSerializedFileName());
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string4, false);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(managedTask);
            objectOutputStream.close();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception on creating persistence file " + string4 + ": " + exception);
            }
            return -2;
        }
        long l2 = System.currentTimeMillis();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Serialization duration = " + (l2 - l));
        }
        return 0;
    }

    protected void removeTask(ManagedTask managedTask) {
        int n;
        String string;
        String string2 = managedTask.getSerializedFileName();
        if (string2 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no persistence file: " + string2);
            }
            return;
        }
        File file = new File(string2);
        boolean bl = file.delete();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Removed " + string2 + " from the file system: " + bl);
        }
        if ((bl = (file = new File(string = string2.substring(0, n = string2.indexOf(separator + "task_")))).delete()) && tc.isDebugEnabled()) {
            Tr.debug(tc, "Deleted dir " + string + " from the file system");
        }
    }

    protected ArrayList getPersistedTasks(long l) {
        ArrayList<ManagedTask> arrayList = new ArrayList<ManagedTask>(10);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPersistedTasks");
        }
        if (storageDirFile != null) {
            if (storageDirFile.exists()) {
                File[] fileArray = storageDirFile.listFiles();
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    if (!fileArray[i].isDirectory()) continue;
                    File[] fileArray2 = fileArray[i].listFiles();
                    int n2 = fileArray2.length;
                    for (int j = 0; j < n2; ++j) {
                        if (!fileArray2[j].isFile()) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Handling " + fileArray2[j].getAbsolutePath());
                        }
                        FileInputStream fileInputStream = null;
                        try {
                            fileInputStream = new FileInputStream(fileArray2[j].getAbsolutePath());
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "new FIS exception " + fileNotFoundException.getMessage());
                            }
                            Tr.warning(tc, "new FIS exception " + fileNotFoundException.getMessage());
                            continue;
                        }
                        ObjectInputStream objectInputStream = null;
                        try {
                            objectInputStream = new ObjectInputStream(fileInputStream);
                        }
                        catch (IOException iOException) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "new OIS exception " + iOException.getMessage());
                            }
                            Tr.warning(tc, "new OIS exception " + iOException.getMessage());
                            try {
                                fileInputStream.close();
                            }
                            catch (IOException iOException2) {}
                            continue;
                        }
                        ManagedTask managedTask = null;
                        try {
                            managedTask = (ManagedTask)objectInputStream.readObject();
                            try {
                                objectInputStream.close();
                                fileInputStream.close();
                            }
                            catch (IOException iOException) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "exception " + iOException.getMessage() + " when closing stream files");
                                }
                                Tr.warning(tc, "exception " + iOException.getMessage() + " when closing stream files");
                            }
                            long l2 = managedTask.getCurrentState().getTime();
                            long l3 = System.currentTimeMillis();
                            if (managedTask.getCurrentState().isTerminal()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "lastTime(" + l2 + ") + interval(" + l + ") = " + (l2 + l) + ", current time(" + l3 + ") + factor(" + 60000L + ") = " + (l3 + 60000L));
                                }
                                if (l2 + l < l3 + 60000L) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Discarding task " + managedTask.getGlobalId() + " " + managedTask.getCurrentState().getStateType());
                                    }
                                    this.removeTask(managedTask);
                                    continue;
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Terminal task " + managedTask.getGlobalId() + " is not too old; add it");
                                }
                                arrayList.add(managedTask);
                                continue;
                            }
                            Task task = managedTask.getTask();
                            if (task instanceof PlannedTask) {
                                PlannedTask plannedTask = (PlannedTask)task;
                                if (plannedTask.getKeepAlive() > 0L) {
                                    if (plannedTask.getOriginatedTime() + plannedTask.getKeepAlive() + l < l3) {
                                        if (managedTask.getCurrentState().isTransitional()) {
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "Task " + managedTask.getGlobalId() + " is transitional; add it");
                                            }
                                            arrayList.add(managedTask);
                                            continue;
                                        }
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Auto-expiring and removing task " + managedTask.getGlobalId() + "; ( " + plannedTask.getKeepAlive() + " + " + l + " + " + plannedTask.getOriginatedTime() + " ) is less than " + l3);
                                        }
                                        this.removeTask(managedTask);
                                        continue;
                                    }
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Task " + managedTask.getGlobalId() + " is not ready to be removed; add it");
                                    }
                                    arrayList.add(managedTask);
                                    continue;
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Task " + managedTask.getGlobalId() + " does not auto-expire; add it");
                                }
                                arrayList.add(managedTask);
                                continue;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Non-planned task " + managedTask.getGlobalId() + " is not terminal; add it");
                            }
                            arrayList.add(managedTask);
                            continue;
                        }
                        catch (IOException iOException) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "readObject exception " + iOException.getMessage());
                            }
                            Tr.warning(tc, "readObject exception " + iOException.getMessage());
                            try {
                                objectInputStream.close();
                                fileInputStream.close();
                            }
                            catch (IOException iOException3) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "close exception " + iOException.getMessage());
                                }
                                Tr.warning(tc, "close exception " + iOException.getMessage());
                            }
                            continue;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "ERROR: exception " + classNotFoundException.getMessage());
                            }
                            try {
                                objectInputStream.close();
                                fileInputStream.close();
                                continue;
                            }
                            catch (IOException iOException) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "close exception " + iOException.getMessage());
                                }
                                Tr.warning(tc, "close exception " + iOException.getMessage());
                            }
                        }
                    }
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, storageDirFile + " does not exist");
                }
                Tr.warning(tc, storageDirFile + " does not exist");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, storageDirFile + " is null");
            }
            Tr.warning(tc, storageDirFile + " is null");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPersistedTasks");
        }
        return arrayList;
    }

    static {
        invalidChars = new char[]{'.', '\"', '/', '\\', '[', ']', ':', ';', '|', '=', ',', '*', '?', ' '};
        persister = new TaskPersister();
    }
}

