/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.taskmanagement.task.impl;

import com.ibm.ws.taskmanagement.task.Task;
import com.ibm.ws.taskmanagement.task.TaskMessage;
import com.ibm.ws.taskmanagement.task.TaskTargetObject;
import com.ibm.ws.taskmanagement.util.TaskHelper;
import java.util.Date;
import javax.management.ObjectName;

public abstract class TaskImpl
implements Task {
    private static final long serialVersionUID = -3006173354954211576L;
    private String _originatorId;
    private long _originatedTime;
    private byte _globalSeverity;
    private TaskMessage[] _reasonMsgs;
    private ObjectName _processObjectName;
    private boolean _processUnique;
    private TaskTargetObject[] _targetObjects;

    public TaskImpl(String string, boolean bl, ObjectName objectName, TaskMessage taskMessage, byte by, long l, TaskTargetObject[] taskTargetObjectArray) {
        this._originatorId = string;
        this._processUnique = bl;
        this._processObjectName = objectName;
        this._reasonMsgs = new TaskMessage[]{taskMessage};
        this._globalSeverity = by;
        this._originatedTime = l;
        this._targetObjects = taskTargetObjectArray;
    }

    public TaskImpl(String string, boolean bl, ObjectName objectName, TaskMessage[] taskMessageArray, byte by, long l, TaskTargetObject[] taskTargetObjectArray) {
        this._originatorId = string;
        this._processUnique = bl;
        this._processObjectName = objectName;
        this._reasonMsgs = taskMessageArray;
        this._globalSeverity = by;
        this._originatedTime = l;
        this._targetObjects = taskTargetObjectArray;
    }

    public void setGlobalSeverity(byte by) {
        this._globalSeverity = by;
    }

    public void setOriginatedTime(long l) {
        this._originatedTime = l;
    }

    public void setOriginatorId(String string) {
        this._originatorId = string;
    }

    public void setReasonMsgs(TaskMessage[] taskMessageArray) {
        this._reasonMsgs = taskMessageArray;
    }

    public void setTargetObjects(TaskTargetObject[] taskTargetObjectArray) {
        this._targetObjects = taskTargetObjectArray;
    }

    public void setProcessObjectName(ObjectName objectName) {
        this._processObjectName = objectName;
    }

    public void setProcessUnique(boolean bl) {
        this._processUnique = bl;
    }

    public byte getGlobalSeverity() {
        return this._globalSeverity;
    }

    public long getOriginatedTime() {
        return this._originatedTime;
    }

    public String getOriginatorId() {
        return this._originatorId;
    }

    public ObjectName getProcessObjectName() {
        return this._processObjectName;
    }

    public TaskMessage[] getReasonMsgs() {
        return this._reasonMsgs;
    }

    public TaskTargetObject[] getTargetObjects() {
        return this._targetObjects;
    }

    public boolean isProcessUnique() {
        return this._processUnique;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Task) {
            Task task = (Task)object;
            if (this.hashCode() != task.hashCode()) {
                return false;
            }
            if (this._processUnique && !this._processObjectName.equals(task.getProcessObjectName())) {
                return false;
            }
            if (this._targetObjects.length != task.getTargetObjects().length) {
                return false;
            }
            for (int i = 0; i < this._targetObjects.length; ++i) {
                if (this._targetObjects[i].equals(task.getTargetObjects()[i])) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return this._originatorId.hashCode();
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("SubmitterId=");
        stringBuffer.append(TaskHelper.generateSubmitterId(this));
        stringBuffer.append("\n");
        stringBuffer.append("GlobalSeverity=");
        stringBuffer.append(this._globalSeverity);
        stringBuffer.append("\n");
        stringBuffer.append("Date Originated=");
        stringBuffer.append(new Date(this._originatedTime));
        stringBuffer.append("\n");
        stringBuffer.append("Reason=");
        if (this._reasonMsgs != null) {
            for (n = 0; n < this._reasonMsgs.length; ++n) {
                if (this._reasonMsgs[n] == null) continue;
                stringBuffer.append(this._reasonMsgs[n].getDefaultMessage());
            }
        }
        stringBuffer.append("\n");
        stringBuffer.append("Number of TargetObjects=");
        stringBuffer.append(this._targetObjects.length);
        for (n = 0; n < this._targetObjects.length; ++n) {
            stringBuffer.append("\n");
            stringBuffer.append(this._targetObjects[n].toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

