/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.taskmanagement.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.taskmanagement.task.ActionPlanStep;
import com.ibm.ws.taskmanagement.task.TargetObjectMonitor;
import com.ibm.ws.taskmanagement.task.Task;
import com.ibm.ws.taskmanagement.task.TaskFactory;
import com.ibm.ws.taskmanagement.task.TaskReport;
import com.ibm.ws.taskmanagement.task.TaskTargetObject;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class TaskHelper {
    protected static final TraceComponent tc = Tr.register(TaskHelper.class.getName(), "taskmanagement", "com.ibm.ws.taskmanagement.nls.Messages");

    public static String generateSubmitterId(TaskReport taskReport) {
        StringBuffer stringBuffer = new StringBuffer(taskReport.getOriginatorId());
        if (taskReport.isProcessUnique()) {
            stringBuffer.append("#");
            stringBuffer.append(taskReport.getProcessObjectName());
        }
        String string = stringBuffer.toString();
        return string;
    }

    public static String generateSubmitterId(Task task) {
        StringBuffer stringBuffer = new StringBuffer(task.getOriginatorId());
        if (task.isProcessUnique()) {
            stringBuffer.append("#");
            stringBuffer.append(task.getProcessObjectName());
        }
        String string = stringBuffer.toString();
        return string;
    }

    public static TaskTargetObject createServerTargetObject(String string, String string2, byte by, TargetObjectMonitor[] targetObjectMonitorArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createServerTargetObject", new Object[]{string, string2, new Byte(by), targetObjectMonitorArray});
        }
        StringBuffer stringBuffer = new StringBuffer("cells/");
        stringBuffer.append(AdminServiceFactory.getAdminService().getCellName());
        stringBuffer.append("/nodes/");
        stringBuffer.append(string2);
        stringBuffer.append("/servers/");
        stringBuffer.append(string);
        stringBuffer.append("/");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createServerTargetObject");
        }
        return TaskFactory.createTaskTargetObject(stringBuffer.toString(), by, targetObjectMonitorArray);
    }

    public static TaskTargetObject createNodeTargetObject(String string, byte by, TargetObjectMonitor[] targetObjectMonitorArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createNodeTargetObject", new Object[]{string, new Byte(by), targetObjectMonitorArray});
        }
        StringBuffer stringBuffer = new StringBuffer("cells/");
        stringBuffer.append(AdminServiceFactory.getAdminService().getCellName());
        stringBuffer.append("/nodes/");
        stringBuffer.append(string);
        stringBuffer.append("/");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createNodeTargetObject");
        }
        return TaskFactory.createTaskTargetObject(stringBuffer.toString(), by, targetObjectMonitorArray);
    }

    public static TaskTargetObject createStaticClusterTargetObject(String string, byte by, TargetObjectMonitor[] targetObjectMonitorArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createStaticClusterTargetObject", new Object[]{string, new Byte(by), targetObjectMonitorArray});
        }
        StringBuffer stringBuffer = new StringBuffer("cells/");
        stringBuffer.append(AdminServiceFactory.getAdminService().getCellName());
        stringBuffer.append("/clusters/");
        stringBuffer.append(string);
        stringBuffer.append("/");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStaticClusterTargetObject");
        }
        return TaskFactory.createTaskTargetObject(stringBuffer.toString(), by, targetObjectMonitorArray);
    }

    public static TaskTargetObject createDynamicClusterTargetObject(String string, String string2, byte by, TargetObjectMonitor[] targetObjectMonitorArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDynamicClusterTargetObject", new Object[]{string, string2, new Byte(by), targetObjectMonitorArray});
        }
        StringBuffer stringBuffer = new StringBuffer("cells/");
        stringBuffer.append(AdminServiceFactory.getAdminService().getCellName());
        stringBuffer.append("/nodegroups/");
        stringBuffer.append(string2);
        stringBuffer.append("/dynamicclusters/");
        stringBuffer.append(string);
        stringBuffer.append("/");
        return TaskFactory.createTaskTargetObject(stringBuffer.toString(), by, targetObjectMonitorArray);
    }

    public static TaskTargetObject createServiceClassTargetObject(String string, byte by, TargetObjectMonitor[] targetObjectMonitorArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createServiceClassTargetObject", new Object[]{string, new Byte(by), targetObjectMonitorArray});
        }
        StringBuffer stringBuffer = new StringBuffer("cells/");
        stringBuffer.append(AdminServiceFactory.getAdminService().getCellName());
        stringBuffer.append("/serviceclasses/");
        stringBuffer.append(string);
        stringBuffer.append("/");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createServiceClassTargetObject");
        }
        return TaskFactory.createTaskTargetObject(stringBuffer.toString(), by, targetObjectMonitorArray);
    }

    public static TaskTargetObject createApplicationTargetObject(String string, byte by, TargetObjectMonitor[] targetObjectMonitorArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createApplicationTargetObject", new Object[]{string, new Byte(by), targetObjectMonitorArray});
        }
        StringBuffer stringBuffer = new StringBuffer("cells/");
        stringBuffer.append(AdminServiceFactory.getAdminService().getCellName());
        stringBuffer.append("/applications/");
        stringBuffer.append(string);
        stringBuffer.append("/");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createApplicationTargetObject");
        }
        return TaskFactory.createTaskTargetObject(stringBuffer.toString(), by, targetObjectMonitorArray);
    }

    public static TargetObjectMonitor createProcessCPUTargetMonitor() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createProcessCPUTargetMonitor");
        }
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("#");
        stringBuffer.append("cpu");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createProcessCPUTargetMonitor");
        }
        return TaskFactory.createTargetObjectMonitor((byte)0, stringBuffer.toString());
    }

    public static TargetObjectMonitor createProcessAgeMonitor() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createProcessAgeMonitor");
        }
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("#");
        stringBuffer.append("ut");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createProcessAgeMonitor");
        }
        return TaskFactory.createTargetObjectMonitor((byte)0, stringBuffer.toString());
    }

    public static TargetObjectMonitor createProcessWorkMonitor() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createProcessWorkMonitor");
        }
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("#");
        stringBuffer.append("tr");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createProcessWorkMonitor");
        }
        return TaskFactory.createTargetObjectMonitor((byte)0, stringBuffer.toString());
    }

    public static TargetObjectMonitor createNodeCPUTargetMonitor() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createNodeCPUTargetMonitor");
        }
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("#");
        stringBuffer.append("cpu");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createNodeCPUTargetMonitor");
        }
        return TaskFactory.createTargetObjectMonitor((byte)0, stringBuffer.toString());
    }

    public static TargetObjectMonitor createProcessUsedMemoryTargetMonitor() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createFreeMemoryCPUTargetMonitor");
        }
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("#");
        stringBuffer.append("mem");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createFreeMemoryTargetMonitor");
        }
        return TaskFactory.createTargetObjectMonitor((byte)0, stringBuffer.toString());
    }

    public static TargetObjectMonitor createDynamicClusterResponseTimeTargetMonitor() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDynamicClusterResponseTimeTargetMonitor");
        }
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("#");
        stringBuffer.append("rt");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDynamicClusterResponseTimeTargetMonitor");
        }
        return TaskFactory.createTargetObjectMonitor((byte)0, stringBuffer.toString());
    }

    public static TargetObjectMonitor createApplicationResponseTimeTargetMonitor() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createApplicationResponseTimeTargetMonitor");
        }
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("#");
        stringBuffer.append("rt");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createApplicationResponseTimeTargetMonitor");
        }
        return TaskFactory.createTargetObjectMonitor((byte)0, stringBuffer.toString());
    }

    public static TargetObjectMonitor createDynamicClusterPercentResponseTimeTargetMonitor() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDynamicClusterPercentResponseTimeTargetMonitor");
        }
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("#");
        stringBuffer.append("prt");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDynamicClusterPercentResponseTimeTargetMonitor");
        }
        return TaskFactory.createTargetObjectMonitor((byte)0, stringBuffer.toString());
    }

    public static TargetObjectMonitor createApplicationPercentResponseTimeTargetMonitor() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createApplicationPercentResponseTimeTargetMonitor");
        }
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("#");
        stringBuffer.append("prt");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createApplicationPercentResponseTimeTargetMonitor");
        }
        return TaskFactory.createTargetObjectMonitor((byte)0, stringBuffer.toString());
    }

    public static TargetObjectMonitor createDynamicClusterConfigurationTargetMonitor() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createApplicationPercentResponseTimeTargetMonitor");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createApplicationPercentResponseTimeTargetMonitor");
        }
        return TaskFactory.createTargetObjectMonitor((byte)3, "");
    }

    public static ActionPlanStep createServerStartActionPlanStep(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createServerStartActionPlanStep", new Object[]{string, string2});
        }
        if (string == null || string2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createServerStartActionPlanStep", null);
            }
            return null;
        }
        ObjectName objectName = TaskHelper.getNodeAgentMBeanQuery(string2);
        String string3 = "launchProcess";
        String[] stringArray = new String[]{"java.lang.String"};
        Object[] objectArray = new Object[]{string};
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createServerStartActionPlanStep");
        }
        return TaskFactory.createOperationActionPlanStep(objectName, string3, stringArray, objectArray);
    }

    public static ActionPlanStep createServerStopActionPlanStep(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createServerStopActionPlanStep", new Object[]{string, string2});
        }
        if (string == null || string2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createServerStopActionPlanStep", null);
            }
            return null;
        }
        ObjectName objectName = TaskHelper.getProcessMBeanQuery(string, string2);
        String string3 = "stop";
        String[] stringArray = new String[]{};
        Object[] objectArray = new Object[]{};
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createServerStopActionPlanStep");
        }
        return TaskFactory.createOperationActionPlanStep(objectName, string3, stringArray, objectArray);
    }

    public static ActionPlanStep createServerStartActionPlanStep(String string, String string2, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createServerStartActionPlanStep", new Object[]{string, string2, new Integer(n)});
        }
        if (string == null || string2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createServerStartActionPlanStep", null);
            }
            return null;
        }
        ObjectName objectName = TaskHelper.getNodeAgentMBeanQuery(string2);
        String string3 = "launchProcess";
        String[] stringArray = new String[]{"java.lang.String", "java.lang.Integer"};
        Object[] objectArray = new Object[]{string, new Integer(n)};
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createServerStartActionPlanStep");
        }
        return TaskFactory.createOperationActionPlanStep(objectName, string3, stringArray, objectArray);
    }

    public static ActionPlanStep createServerStopImmediateActionPlanStep(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createServerStopImmediateActionPlanStep", new Object[]{string, string2});
        }
        if (string == null || string2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createServerStopImmediateActionPlanStep", null);
            }
            return null;
        }
        ObjectName objectName = TaskHelper.getProcessMBeanQuery(string, string2);
        String string3 = "stopImmediate";
        String[] stringArray = new String[]{};
        Object[] objectArray = new Object[]{};
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createServerStopImmediateActionPlanStep");
        }
        return TaskFactory.createOperationActionPlanStep(objectName, string3, stringArray, objectArray);
    }

    private static ObjectName getNodeAgentMBeanQuery(String string) {
        ObjectName objectName;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getNodeAgentMBeanQuery", string);
            }
            objectName = null;
            try {
                objectName = new ObjectName("WebSphere:*,type=NodeAgent,node=" + string);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                FFDCFilter.processException(malformedObjectNameException.getCause(), "com.ibm.ws.taskmanagement.util.TaskHelper", "52", null);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "TaskFactory::getNodeAgentMBeanQuery:: MalformedObjectNameException caught: " + malformedObjectNameException.getMessage());
                Tr.error(tc, malformedObjectNameException.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeAgentMBeanQuery", objectName);
        }
        return objectName;
    }

    private static ObjectName getProcessMBeanQuery(String string, String string2) {
        ObjectName objectName;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getProcessMBeanQuery", new Object[]{string, string2});
            }
            objectName = null;
            try {
                objectName = new ObjectName("WebSphere:*,type=Server,process=" + string + ",node=" + string2);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                FFDCFilter.processException(malformedObjectNameException.getCause(), "com.ibm.ws.taskmanagement.util.TaskHelper", "53", null);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "TaskFactory::getProcessMBeanQuery:: MalformedObjectNameException caught: " + malformedObjectNameException.getMessage());
                Tr.error(tc, malformedObjectNameException.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProcessMBeanQuery", objectName);
        }
        return objectName;
    }

    public static String getPlannedTaskTypeAsString(byte by) {
        String string = null;
        switch (by) {
            case 0: {
                string = "Manual";
                break;
            }
            case 1: {
                string = "Preview";
                break;
            }
            case 2: {
                string = "Approval";
                break;
            }
            case 3: {
                string = "Executing";
                break;
            }
        }
        return string;
    }
}

