/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.commands;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.channel.commands.CFCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.management.ObjectName;

public class ListTCPThreadPoolsCommand
extends CFCommand {
    public ListTCPThreadPoolsCommand(CommandMetadata commandMetadata) {
        super(commandMetadata);
    }

    public ListTCPThreadPoolsCommand(CommandData commandData) throws CommandNotFoundException {
        super(commandData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() throws CommandValidationException {
        block5: {
            super.validate();
            ObjectName objectName = (ObjectName)this.getTargetObject();
            boolean bl = false;
            try {
                bl = this.checkType(objectName, new String[]{"TCPInboundChannel", "TCPOutboundChannel"}, false);
            }
            catch (Exception exception) {
                bl = false;
            }
            finally {
                if (bl) break block5;
                throw new InvalidParameterValueException(this.getName(), "target", objectName);
            }
        }
    }

    public void execute() {
        CommandResultImpl commandResultImpl = new CommandResultImpl();
        try {
            this.validate();
            commandResultImpl.setResult(this.getThreadPools((ObjectName)this.getTargetObject()));
        }
        catch (Exception exception) {
            commandResultImpl.setException(exception);
        }
        this.setCommandResult(commandResultImpl);
    }

    protected List getThreadPools(ObjectName objectName) throws Exception {
        Properties properties = ConfigServiceHelper.getObjectLocation(objectName);
        String string = ConfigServiceHelper.getConfigDataId(objectName).getContextUri();
        ConfigService configService = this.getConfigService();
        Session session = this.getConfigSession();
        ConfigDataId configDataId = new ConfigDataId(string, "server.xml");
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(configDataId);
        ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, "ThreadPoolManager");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName2, objectName3, null);
        ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>();
        if (objectNameArray != null && objectNameArray.length > 0) {
            List list = (List)configService.getAttribute(session, objectNameArray[0], "threadPools", false);
            for (int i = 0; list != null && i < list.size(); ++i) {
                ObjectName objectName4 = (ObjectName)list.get(i);
                String string2 = (String)configService.getAttribute(session, objectName4, "name");
                if (string2 == null || string2.trim().length() <= 0) continue;
                arrayList.add(objectName4);
            }
        }
        return arrayList;
    }
}

