/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.io.async.AsyncTimeoutException;
import com.ibm.io.async.IAbstractAsyncFuture;
import com.ibm.io.async.IAsyncFuture;
import com.ibm.io.async.ICompletionListener;
import com.ibm.io.async.TimerWorkItem;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.ws.tcp.channel.impl.AioSocketIOChannel;
import com.ibm.ws.tcp.channel.impl.AioTCPReadRequestContextImpl;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import java.io.IOException;
import java.net.SocketTimeoutException;

class AioReadCompletionListener
implements ICompletionListener {
    private static final TraceComponent tc = Tr.register(AioReadCompletionListener.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");
    private static IOException connClosedException = null;

    AioReadCompletionListener() {
    }

    public void futureCompleted(IAbstractAsyncFuture iAbstractAsyncFuture, Object object) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "AIOReadCallback.futureCompleted");
        }
        AioTCPReadRequestContextImpl aioTCPReadRequestContextImpl = (AioTCPReadRequestContextImpl)((Object)object);
        boolean bl = false;
        IOException iOException = null;
        long l = 0L;
        boolean bl2 = false;
        VirtualConnection virtualConnection = null;
        TimerWorkItem timerWorkItem = iAbstractAsyncFuture.getTimeoutWorkItem();
        if (timerWorkItem != null) {
            timerWorkItem.state = 2L;
        }
        if ((virtualConnection = aioTCPReadRequestContextImpl.getTCPConnLink().getVirtualConnection()) != null) {
            if (virtualConnection.isInputStateTrackingOperational() && !virtualConnection.requestPermissionToFinishRead()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Can't get permission to finish read, throwing read request away.");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "AIOReadCallback.futureCompleted");
                }
                return;
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Can't get virtual connection object, throwing read request away.");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "AIOReadCallback.futureCompleted");
            }
            return;
        }
        try {
            IAsyncFuture iAsyncFuture = (IAsyncFuture)iAbstractAsyncFuture;
            l = iAsyncFuture.getByteCount();
            if (iAsyncFuture.getJITBuffer() != null) {
                aioTCPReadRequestContextImpl.setBuffer(iAsyncFuture.getJITBuffer());
            }
            if (l == 0L) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getByteCount returned 0, channel must be closed ");
                }
                bl = true;
                if (connClosedException == null) {
                    connClosedException = new IOException("Read failed: Connection closed by peer.");
                }
                iOException = connClosedException;
            } else {
                aioTCPReadRequestContextImpl.postProcessReadBuffers(l);
                bl2 = aioTCPReadRequestContextImpl.updateIOCounts(l, 0);
            }
        }
        catch (AsyncTimeoutException asyncTimeoutException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught: " + asyncTimeoutException);
            }
            iOException = new SocketTimeoutException(asyncTimeoutException.getMessage());
            iOException.initCause(asyncTimeoutException);
            bl = true;
        }
        catch (IOException iOException2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught: " + iOException2);
            }
            iOException = iOException2;
            bl = true;
        }
        catch (InterruptedException interruptedException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "AioReadCompletionListener caught exception. " + interruptedException);
            }
            FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.tcp.channel.impl.AioReadCompletionListener", (String)"134");
        }
        if (!bl) {
            if (bl2) {
                iAbstractAsyncFuture.setFullyCompleted(true);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "calling callback.complete method");
                }
                aioTCPReadRequestContextImpl.getReadCompletedCallback().complete(aioTCPReadRequestContextImpl.getTCPConnLink().getVirtualConnection(), (TCPReadRequestContext)aioTCPReadRequestContextImpl);
            } else {
                long l2;
                if (aioTCPReadRequestContextImpl.getTCPConnLink().getConfig().getDumpStatsInterval() > 0) {
                    ++aioTCPReadRequestContextImpl.getTCPConnLink().getTCPChannel().totalPartialAsyncReads;
                }
                if ((l2 = (long)aioTCPReadRequestContextImpl.getTimeoutInterval()) != 0L && (l2 = aioTCPReadRequestContextImpl.getTimeoutTime() - System.currentTimeMillis()) <= 0L) {
                    iOException = new SocketTimeoutException("Async read timed out after reading partial data");
                    bl = true;
                }
                if (!bl) {
                    try {
                        ((AioSocketIOChannel)aioTCPReadRequestContextImpl.getTCPConnLink().getSocketIOChannel()).readAIO(aioTCPReadRequestContextImpl, true, l2);
                    }
                    catch (IOException iOException3) {
                        iOException = iOException3;
                        bl = true;
                    }
                }
            }
        }
        if (bl) {
            if (aioTCPReadRequestContextImpl.getJITAllocateAction() && aioTCPReadRequestContextImpl.getBuffer() != null) {
                aioTCPReadRequestContextImpl.getBuffer().release();
                aioTCPReadRequestContextImpl.setBuffer(null);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "IOException while doing IO requested on local: " + aioTCPReadRequestContextImpl.getTCPConnLink().getSocketIOChannel().getSocket().getLocalSocketAddress() + " remote: " + aioTCPReadRequestContextImpl.getTCPConnLink().getSocketIOChannel().getSocket().getRemoteSocketAddress());
                Tr.event(tc, "Calling read error callback with Exception is: " + iOException);
            }
            aioTCPReadRequestContextImpl.getReadCompletedCallback().error(aioTCPReadRequestContextImpl.getTCPConnLink().getVirtualConnection(), (TCPReadRequestContext)aioTCPReadRequestContextImpl, iOException);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "AIOReadCallback.futureCompleted");
        }
    }
}

