/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.io.async.AsyncSocketChannel;
import com.ibm.io.async.AsyncSocketChannelHelper;
import com.ibm.io.async.IAsyncFuture;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.ws.tcp.channel.impl.AioReadCompletionListener;
import com.ibm.ws.tcp.channel.impl.AioTCPChannel;
import com.ibm.ws.tcp.channel.impl.AioTCPWriteRequestContextImpl;
import com.ibm.ws.tcp.channel.impl.AioWriteCompletionListener;
import com.ibm.ws.tcp.channel.impl.SocketIOChannel;
import com.ibm.ws.tcp.channel.impl.TCPChannel;
import com.ibm.ws.tcp.channel.impl.TCPReadRequestContextImpl;
import com.ibm.ws.tcp.channel.impl.TCPWriteRequestContextImpl;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;

public class AioSocketIOChannel
extends SocketIOChannel {
    private static final TraceComponent tc = Tr.register(AioSocketIOChannel.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");
    private AsyncSocketChannel asyncChannel = null;
    private AsyncSocketChannelHelper asyncHelper = null;
    private boolean closed = false;
    private boolean processClose = true;
    private IAsyncFuture readFuture = null;
    private IAsyncFuture writeFuture = null;
    private ByteBuffer[] singleReadBuffer = new ByteBuffer[1];
    private ByteBuffer[] singleWriteBuffer = new ByteBuffer[1];

    protected AioSocketIOChannel(Socket socket, AsyncSocketChannel asyncSocketChannel, TCPChannel tCPChannel) {
        super(socket, tCPChannel);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "AioSocketIOChannel");
        }
        this.asyncChannel = asyncSocketChannel;
        this.asyncHelper = new AsyncSocketChannelHelper(this.asyncChannel);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "AioSocketIOChannel");
        }
    }

    protected static SocketIOChannel createIOChannel(Socket socket, AsyncSocketChannel asyncSocketChannel, TCPChannel tCPChannel) {
        AioSocketIOChannel aioSocketIOChannel = new AioSocketIOChannel(socket, asyncSocketChannel, tCPChannel);
        return aioSocketIOChannel;
    }

    public void connectActions() throws IOException {
        this.asyncChannel.prepareSocket();
    }

    protected boolean readAIO(TCPReadRequestContextImpl tCPReadRequestContextImpl, boolean bl, long l) throws IOException {
        AioReadCompletionListener aioReadCompletionListener = AioTCPChannel.getAioReadCompletionListener();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "readAIO");
        }
        boolean bl2 = bl;
        boolean bl3 = false;
        long l2 = 0L;
        boolean bl4 = false;
        ByteBuffer[] byteBufferArray = null;
        VirtualConnection virtualConnection = tCPReadRequestContextImpl.getTCPConnLink().getVirtualConnection();
        if (tCPReadRequestContextImpl.getBuffers().length == 1) {
            this.singleReadBuffer[0] = tCPReadRequestContextImpl.preProcessOneReadBuffer();
            byteBufferArray = this.singleReadBuffer;
        } else {
            byteBufferArray = tCPReadRequestContextImpl.preProcessReadBuffers();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "calling asyncHelper.read");
        }
        if (AioTCPChannel.getJitSupportedByNative() && tCPReadRequestContextImpl.getJITAllocateAction() && tCPReadRequestContextImpl.getIODoneAmount() == 0L && tCPReadRequestContextImpl.getJITAllocateSize() == 8192) {
            bl4 = true;
        }
        this.readFuture = this.asyncHelper.read(byteBufferArray, l, bl2, tCPReadRequestContextImpl.getIOAmount() - tCPReadRequestContextImpl.getIODoneAmount(), bl4, virtualConnection, true);
        if (this.readFuture == null) {
            return false;
        }
        if (this.readFuture.isCompleted() && !bl2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "data already available and forceQueue is false");
            }
            try {
                l2 = this.readFuture.getByteCount();
            }
            catch (InterruptedException interruptedException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "InterruptedException recieved on immediate async read " + interruptedException.getMessage());
                }
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.tcp.channel.impl.AioSocketIOChannel", (String)"138");
                IOException iOException = new IOException(interruptedException.getMessage());
                iOException.initCause(interruptedException);
                throw iOException;
            }
            tCPReadRequestContextImpl.postProcessReadBuffers(l2);
            bl3 = tCPReadRequestContextImpl.updateIOCounts(l2, 0);
            if (!bl3) {
                this.readFuture = this.asyncHelper.read(byteBufferArray, l, bl2, tCPReadRequestContextImpl.getIOAmount(), false, virtualConnection, true);
                if (this.tcpChannel.getConfig().getDumpStatsInterval() > 0) {
                    ++this.tcpChannel.totalAsyncReadRetries;
                }
            }
        }
        if (!bl3) {
            if (bl4 && l2 == 0L && !this.readFuture.isCompleted()) {
                tCPReadRequestContextImpl.getBuffer().release();
                tCPReadRequestContextImpl.setBuffer(null);
            }
            this.readFuture.addCompletionListener(aioReadCompletionListener, tCPReadRequestContextImpl);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "added completion listener to read future");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "readAIO");
        }
        return bl3;
    }

    protected long readAIOSync(long l, TCPReadRequestContextImpl tCPReadRequestContextImpl) throws IOException {
        VirtualConnection virtualConnection = tCPReadRequestContextImpl.getTCPConnLink().getVirtualConnection();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "readAIOSync");
        }
        boolean bl = false;
        long l2 = 0L;
        long l3 = tCPReadRequestContextImpl.getTimeoutInterval();
        while (!bl) {
            ByteBuffer[] byteBufferArray = null;
            if (tCPReadRequestContextImpl.getBuffers().length == 1) {
                this.singleReadBuffer[0] = tCPReadRequestContextImpl.preProcessOneReadBuffer();
                byteBufferArray = this.singleReadBuffer;
            } else {
                byteBufferArray = tCPReadRequestContextImpl.preProcessReadBuffers();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "calling asyncHelper.read");
            }
            this.readFuture = this.asyncHelper.read(byteBufferArray, false, l, false, virtualConnection, false);
            try {
                if (l == 0L) {
                    if (this.readFuture.isCompleted()) {
                        l2 = this.readFuture.getByteCount();
                        tCPReadRequestContextImpl.postProcessReadBuffers(l2);
                        return l2;
                    }
                    return 0L;
                }
                l2 = this.readFuture.getByteCount(l3);
                tCPReadRequestContextImpl.postProcessReadBuffers(l2);
            }
            catch (InterruptedException interruptedException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "InterruptedException caught while doing getByteCount");
                }
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.tcp.channel.impl.AioSocketIOChannel", (String)"234");
                IOException iOException = new IOException(interruptedException.getMessage());
                iOException.initCause(interruptedException);
                throw iOException;
            }
            bl = tCPReadRequestContextImpl.updateIOCounts(l2, 0);
            if (bl) continue;
            if (this.tcpChannel.getConfig().getDumpStatsInterval() > 0) {
                ++this.tcpChannel.totalPartialSyncReads;
            }
            if (tCPReadRequestContextImpl.getTimeoutInterval() == 0 || (l3 = tCPReadRequestContextImpl.getTimeoutTime() - System.currentTimeMillis()) > 0L) continue;
            SocketTimeoutException socketTimeoutException = new SocketTimeoutException("Sync read timed out after reading partial data");
            throw socketTimeoutException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "readAIOSync");
        }
        return tCPReadRequestContextImpl.getIODoneAmount();
    }

    protected boolean writeAIO(TCPWriteRequestContextImpl tCPWriteRequestContextImpl, boolean bl, long l) throws IOException {
        AioWriteCompletionListener aioWriteCompletionListener = AioTCPChannel.getAioWriteCompletionListener();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "writeAIO");
        }
        boolean bl2 = bl;
        boolean bl3 = false;
        ByteBuffer[] byteBufferArray = null;
        VirtualConnection virtualConnection = tCPWriteRequestContextImpl.getTCPConnLink().getVirtualConnection();
        if (tCPWriteRequestContextImpl.getBuffers().length == 1) {
            this.singleWriteBuffer[0] = tCPWriteRequestContextImpl.preProcessOneWriteBuffer();
            byteBufferArray = this.singleWriteBuffer;
        } else {
            byteBufferArray = tCPWriteRequestContextImpl.preProcessWriteBuffers();
        }
        this.writeFuture = this.asyncHelper.write(byteBufferArray, tCPWriteRequestContextImpl.getTimeoutInterval(), bl2, tCPWriteRequestContextImpl.getIOAmount(), virtualConnection, true);
        if (this.writeFuture == null) {
            return false;
        }
        if (this.writeFuture.isCompleted() && !bl2) {
            long l2;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "data already written and forceQueue is false");
            }
            try {
                l2 = this.writeFuture.getByteCount();
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.tcp.channel.impl.AioSocketIOChannel", (String)"290");
                IOException iOException = new IOException(interruptedException.getMessage());
                iOException.initCause(interruptedException);
                throw iOException;
            }
            tCPWriteRequestContextImpl.postProcessWriteBuffers(l2);
            bl3 = tCPWriteRequestContextImpl.getIOAmount() == -1L ? ((AioTCPWriteRequestContextImpl)tCPWriteRequestContextImpl).updateForAllData(l2) : tCPWriteRequestContextImpl.updateIOCounts(l2, 1);
            if (!bl3) {
                this.writeFuture = this.asyncHelper.write(byteBufferArray, tCPWriteRequestContextImpl.getTimeoutInterval(), bl2, tCPWriteRequestContextImpl.getIOAmount(), virtualConnection, true);
                if (this.tcpChannel.getConfig().getDumpStatsInterval() > 0) {
                    ++this.tcpChannel.totalAsyncWriteRetries;
                }
            }
        }
        if (!bl3) {
            this.writeFuture.addCompletionListener(aioWriteCompletionListener, tCPWriteRequestContextImpl);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "added completion listener to write future");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "writeAIO");
        }
        return bl3;
    }

    protected long writeAIOSync(TCPWriteRequestContextImpl tCPWriteRequestContextImpl) throws IOException {
        VirtualConnection virtualConnection = tCPWriteRequestContextImpl.getTCPConnLink().getVirtualConnection();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "writeAIOSync");
        }
        boolean bl = false;
        long l = 0L;
        long l2 = tCPWriteRequestContextImpl.getTimeoutInterval();
        while (!bl) {
            ByteBuffer[] byteBufferArray = null;
            if (tCPWriteRequestContextImpl.getBuffers().length == 1) {
                this.singleWriteBuffer[0] = tCPWriteRequestContextImpl.preProcessOneWriteBuffer();
                byteBufferArray = this.singleWriteBuffer;
            } else {
                byteBufferArray = tCPWriteRequestContextImpl.preProcessWriteBuffers();
            }
            this.writeFuture = this.asyncHelper.write(byteBufferArray, false, tCPWriteRequestContextImpl.getIOAmount(), virtualConnection, false);
            try {
                l = this.writeFuture.getByteCount(l2);
                tCPWriteRequestContextImpl.postProcessWriteBuffers(l);
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.tcp.channel.impl.AioSocketIOChannel", (String)"358");
                IOException iOException = new IOException(interruptedException.getMessage());
                iOException.initCause(interruptedException);
                throw iOException;
            }
            bl = tCPWriteRequestContextImpl.getIOAmount() == -1L ? ((AioTCPWriteRequestContextImpl)tCPWriteRequestContextImpl).updateForAllData(l) : tCPWriteRequestContextImpl.updateIOCounts(l, 1);
            if (bl) continue;
            if (this.tcpChannel.getConfig().getDumpStatsInterval() > 0) {
                ++this.tcpChannel.totalPartialSyncWrites;
            }
            if (tCPWriteRequestContextImpl.getTimeoutInterval() == 0 || (l2 = tCPWriteRequestContextImpl.getTimeoutTime() - System.currentTimeMillis()) > 0L) continue;
            SocketTimeoutException socketTimeoutException = new SocketTimeoutException("Sync write timed out after writing partial data");
            throw socketTimeoutException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "writeAIOSync");
        }
        return tCPWriteRequestContextImpl.getIODoneAmount();
    }

    protected void timeoutReadFuture() {
        if (this.readFuture != null && !this.readFuture.isCompleted()) {
            this.readFuture.cancel(new SocketTimeoutException("Socket read operation timed out by application request"));
        }
    }

    protected void timeoutWriteFuture() {
        if (this.writeFuture != null && !this.writeFuture.isCompleted()) {
            this.writeFuture.cancel(new SocketTimeoutException("Socket write operation timed out by application request"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void close() {
        if (TraceComponent.isAnyTracingEnabled() && AioSocketIOChannel.tc.isEntryEnabled()) {
            Tr.entry(AioSocketIOChannel.tc, "close");
        }
        if (TraceComponent.isAnyTracingEnabled() && AioSocketIOChannel.tc.isDebugEnabled()) {
            Tr.debug(AioSocketIOChannel.tc, "SocketChannel close starting, local: " + this.socket.getLocalSocketAddress() + " remote: " + this.socket.getRemoteSocketAddress());
        }
        var1_1 = this;
        synchronized (var1_1) {
            if (this.closed) {
                this.processClose = false;
            }
            this.closed = true;
        }
        if (this.processClose) {
            try {
                if (TraceComponent.isAnyTracingEnabled() && AioSocketIOChannel.tc.isEventEnabled()) {
                    Tr.event(AioSocketIOChannel.tc, "AsyncSocketChannel close, local: " + this.socket.getLocalSocketAddress() + " remote: " + this.socket.getRemoteSocketAddress());
                }
                if (this.asyncChannel == null) ** GOTO lbl30
                this.asyncChannel.close();
            }
            catch (IOException var1_2) {
                if (!TraceComponent.isAnyTracingEnabled() || !AioSocketIOChannel.tc.isDebugEnabled()) ** GOTO lbl30
                Tr.debug(AioSocketIOChannel.tc, "IOException while closing channel " + var1_2.getMessage());
            }
            finally {
                super.close();
            }
        } else if (TraceComponent.isAnyTracingEnabled() && AioSocketIOChannel.tc.isDebugEnabled()) {
            Tr.debug(AioSocketIOChannel.tc, "close called on channel already closed, local: " + this.socket.getLocalSocketAddress() + " remote: " + this.socket.getRemoteSocketAddress());
        }
lbl30:
        // 7 sources

        if (TraceComponent.isAnyTracingEnabled() && AioSocketIOChannel.tc.isEntryEnabled()) {
            Tr.exit(AioSocketIOChannel.tc, "close");
        }
    }

    protected AsyncSocketChannel getAsyncChannel() {
        return this.asyncChannel;
    }

    protected Object[] buildDumpList() {
        return null;
    }

    protected String getFFDCDumpData() {
        StringBuffer stringBuffer = null;
        try {
            stringBuffer = new StringBuffer("AioSocketIOChannel Data");
            stringBuffer.append("\nAsyncSocketChannel: " + this.getAsyncChannel());
            stringBuffer.append(super.getFFDCDumpData());
        }
        catch (Exception exception) {
            stringBuffer.append("\nException Occurred Gathering Dump Data: " + exception);
        }
        return stringBuffer.toString();
    }
}

