/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.io.async.AsyncChannelGroup;
import com.ibm.io.async.AsyncException;
import com.ibm.io.async.AsyncLibrary;
import com.ibm.io.async.AsyncSocketChannel;
import com.ibm.io.async.IAsyncProvider;
import com.ibm.ws.tcp.channel.impl.AioReadCompletionListener;
import com.ibm.ws.tcp.channel.impl.AioSocketIOChannel;
import com.ibm.ws.tcp.channel.impl.AioTCPReadRequestContextImpl;
import com.ibm.ws.tcp.channel.impl.AioTCPWriteRequestContextImpl;
import com.ibm.ws.tcp.channel.impl.AioWorkQueueManager;
import com.ibm.ws.tcp.channel.impl.AioWriteCompletionListener;
import com.ibm.ws.tcp.channel.impl.ChannelTermination;
import com.ibm.ws.tcp.channel.impl.ConnectionManager;
import com.ibm.ws.tcp.channel.impl.SocketIOChannel;
import com.ibm.ws.tcp.channel.impl.TCPChannel;
import com.ibm.ws.tcp.channel.impl.TCPChannelConfiguration;
import com.ibm.ws.tcp.channel.impl.TCPChannelFactory;
import com.ibm.ws.tcp.channel.impl.TCPConnLink;
import com.ibm.ws.tcp.channel.impl.TCPPort;
import com.ibm.ws.tcp.channel.impl.TCPReadRequestContextImpl;
import com.ibm.ws.tcp.channel.impl.TCPWriteRequestContextImpl;
import com.ibm.ws.tcp.channel.impl.WorkQueueManager;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.runtime.ThreadPool;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.Hashtable;

public class AioTCPChannel
extends TCPChannel
implements ChannelTermination {
    private AsyncChannelGroup asyncChannelGroup;
    private static Hashtable tP2ACGMap = new Hashtable();
    private static AioReadCompletionListener aioReadCompletionListener = null;
    private static AioWriteCompletionListener aioWriteCompletionListener = null;
    private static boolean jitSupportedByNative;
    private static final TraceComponent tc;
    int connectionCount = 0;
    Object connectionCountSync = new Object();
    private static AioWorkQueueManager wqm;

    public ChannelTermination setup(ChannelData channelData, TCPChannelConfiguration tCPChannelConfiguration, TCPChannelFactory tCPChannelFactory) throws ChannelException {
        super.setup(channelData, tCPChannelConfiguration, tCPChannelFactory);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "AioTCPChannel");
        }
        try {
            IAsyncProvider iAsyncProvider = AsyncLibrary.createInstance();
            jitSupportedByNative = this.config.getAllocateBuffersDirect() == 1 ? iAsyncProvider.hasCapability(4) : false;
        }
        catch (AsyncException asyncException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "AioTCPChannel couldn't load native AIO library: " + asyncException.getMessage());
            }
            throw new ChannelException((Throwable)asyncException);
        }
        if (!this.config.isInbound()) {
            boolean bl = false;
            if (wqm == null) {
                wqm = new AioWorkQueueManager();
                bl = true;
            }
            this.connectionManager = new ConnectionManager((TCPChannel)this, (WorkQueueManager)wqm);
            if (bl) {
                wqm.startSelectors(false);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "AioTCPChannel");
        }
        return this;
    }

    public void init() throws ChannelException {
        super.init();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "init");
        }
        if (!this.config.isInbound()) {
            try {
                this.asyncChannelGroup = this.findOrCreateACG();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "AioTCPChannel created completion port for outbound connections, completionPort = " + this.asyncChannelGroup.getCompletionPort());
                }
            }
            catch (AsyncException asyncException) {
                ChannelException channelException = new ChannelException("Error creating async channel group ");
                channelException.initCause((Throwable)asyncException);
                throw channelException;
            }
        }
        aioReadCompletionListener = new AioReadCompletionListener();
        aioWriteCompletionListener = new AioWriteCompletionListener();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public void terminate() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "terminate");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "terminate - call AsyncLibrary.shutdown");
        }
        AsyncLibrary.shutdown();
        tP2ACGMap.clear();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "terminate");
        }
    }

    public TCPPort createEndPoint() throws ChannelException {
        TCPPort tCPPort = super.createEndPoint();
        try {
            this.asyncChannelGroup = this.findOrCreateACG();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "AioTCPChannel created completion port for inbound connections on host " + this.config.getHostname() + ", port " + this.config.getPort() + ", completionPort = " + this.asyncChannelGroup.getCompletionPort());
            }
        }
        catch (AsyncException asyncException) {
            ChannelException channelException = new ChannelException("Error creating async channel group ");
            channelException.initCause((Throwable)asyncException);
            throw channelException;
        }
        return tCPPort;
    }

    private AsyncChannelGroup findOrCreateACG() throws AsyncException {
        ThreadPool threadPool;
        AsyncChannelGroup asyncChannelGroup;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "findOrCreateACG");
        }
        if ((asyncChannelGroup = (AsyncChannelGroup)tP2ACGMap.get(threadPool = this.getThreadPool())) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "create new AsyncChannelGroup with threadpool " + threadPool);
            }
            asyncChannelGroup = new AsyncChannelGroup(threadPool);
            tP2ACGMap.put(threadPool, asyncChannelGroup);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "findOrCreateACG");
        }
        return asyncChannelGroup;
    }

    public TCPReadRequestContextImpl createReadInterface(TCPConnLink tCPConnLink) {
        return new AioTCPReadRequestContextImpl(tCPConnLink);
    }

    public TCPWriteRequestContextImpl createWriteInterface(TCPConnLink tCPConnLink) {
        return new AioTCPWriteRequestContextImpl(tCPConnLink);
    }

    public static AioReadCompletionListener getAioReadCompletionListener() {
        return aioReadCompletionListener;
    }

    public static AioWriteCompletionListener getAioWriteCompletionListener() {
        return aioWriteCompletionListener;
    }

    public static boolean getJitSupportedByNative() {
        return jitSupportedByNative;
    }

    public SocketIOChannel createOutboundSocketIOChannel() throws IOException {
        AsyncSocketChannel asyncSocketChannel = AsyncSocketChannel.open(this.asyncChannelGroup);
        Socket socket = asyncSocketChannel.socket();
        return AioSocketIOChannel.createIOChannel(socket, asyncSocketChannel, this);
    }

    public SocketIOChannel createInboundSocketIOChannel(SocketChannel socketChannel) throws IOException {
        AsyncSocketChannel asyncSocketChannel = null;
        asyncSocketChannel = new AsyncSocketChannel(socketChannel, this.asyncChannelGroup);
        return AioSocketIOChannel.createIOChannel(socketChannel.socket(), asyncSocketChannel, this);
    }

    protected AsyncChannelGroup getAsyncChannelGroup() {
        return this.asyncChannelGroup;
    }

    public void dumpStatistics() {
        super.dumpStatistics();
        this.asyncChannelGroup.dumpStatistics();
    }

    static {
        tc = Tr.register(AioTCPChannel.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");
        wqm = null;
    }
}

