/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.io.async.AsyncTimeoutException;
import com.ibm.ws.tcp.channel.impl.AioSocketIOChannel;
import com.ibm.ws.tcp.channel.impl.TCPConnLink;
import com.ibm.ws.tcp.channel.impl.TCPReadRequestContextImpl;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;

public class AioTCPReadRequestContextImpl
extends TCPReadRequestContextImpl {
    private static final TraceComponent tc = Tr.register(AioTCPReadRequestContextImpl.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");
    private boolean immedTimeoutRequested = false;

    public AioTCPReadRequestContextImpl(TCPConnLink tCPConnLink) {
        super(tCPConnLink);
    }

    public VirtualConnection processAsyncReadRequest() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "processAsyncReadRequest()");
        }
        IOException iOException = null;
        this.immedTimeoutRequested = false;
        this.jITAllocateAction = false;
        if (this.getJITAllocateSize() > 0 && this.getBuffers() == null) {
            if (this.oTCPConnLink.getConfig().getAllocateBuffersDirect() == 1) {
                this.setBuffer(this.oTCPConnLink.getTCPChannel().getWsByteBufferManager().allocateDirect(this.getJITAllocateSize()));
            } else {
                this.setBuffer(this.oTCPConnLink.getTCPChannel().getWsByteBufferManager().allocate(this.getJITAllocateSize()));
            }
            this.jITAllocateAction = true;
        }
        try {
            boolean bl = ((AioSocketIOChannel)this.getTCPConnLink().getSocketIOChannel()).readAIO(this, this.isForceQueue(), this.getTimeoutInterval());
            if (bl) {
                return this.oTCPConnLink.getVirtualConnection();
            }
        }
        catch (IOException iOException2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "IOexception caught: " + iOException2);
            }
            iOException = iOException2;
        }
        if (iOException != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Socket socket = this.getTCPConnLink().getSocketIOChannel().getSocket();
                Tr.event(tc, "IOException while processing readAsynch request local: " + socket.getLocalSocketAddress() + " remote: " + socket.getRemoteSocketAddress());
                Tr.event(tc, "Exception is: " + iOException);
            }
            if (this.jITAllocateAction) {
                this.getBuffer().release();
                this.setBuffer(null);
                this.jITAllocateAction = false;
            }
            this.getReadCompletedCallback().error(this.getTCPConnLink().getVirtualConnection(), (TCPReadRequestContext)this, iOException);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "processAsyncReadRequest()");
        }
        return null;
    }

    public long processSyncReadRequest(long l, int n) throws IOException {
        long l2 = 0L;
        boolean bl = false;
        IOException iOException = null;
        this.immedTimeoutRequested = false;
        this.jITAllocateAction = false;
        if (this.getJITAllocateSize() > 0 && this.getBuffers() == null) {
            if (this.oTCPConnLink.getConfig().getAllocateBuffersDirect() == 1) {
                this.setBuffer(this.oTCPConnLink.getTCPChannel().getWsByteBufferManager().allocateDirect(this.getJITAllocateSize()));
            } else {
                this.setBuffer(this.oTCPConnLink.getTCPChannel().getWsByteBufferManager().allocate(this.getJITAllocateSize()));
            }
            this.jITAllocateAction = true;
        }
        this.setIOAmount(l);
        this.setLastIOAmt(0L);
        this.setIODoneAmount(0L);
        this.setTimeoutTime(n);
        try {
            l2 = ((AioSocketIOChannel)this.getTCPConnLink().getSocketIOChannel()).readAIOSync(l, this);
            if (l == 0L && l2 == 0L) {
                bl = true;
            }
        }
        catch (AsyncTimeoutException asyncTimeoutException) {
            iOException = new SocketTimeoutException(asyncTimeoutException.getMessage());
            iOException.initCause(asyncTimeoutException);
            bl = true;
        }
        catch (IOException iOException2) {
            iOException = iOException2;
            bl = true;
        }
        if (bl && this.jITAllocateAction) {
            this.getBuffer().release();
            this.setBuffer(null);
            this.jITAllocateAction = false;
        }
        if (iOException != null) {
            throw iOException;
        }
        return l2;
    }

    protected void immediateTimeout() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "immediateTimeout");
        }
        this.immedTimeoutRequested = true;
        ((AioSocketIOChannel)this.getTCPConnLink().getSocketIOChannel()).timeoutReadFuture();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "immediateTimeout");
        }
    }

    protected boolean isImmedTimeoutRequested() {
        return this.immedTimeoutRequested;
    }
}

