/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.io.async.AsyncTimeoutException;
import com.ibm.ws.tcp.channel.impl.AioSocketIOChannel;
import com.ibm.ws.tcp.channel.impl.SocketIOChannel;
import com.ibm.ws.tcp.channel.impl.TCPConnLink;
import com.ibm.ws.tcp.channel.impl.TCPWriteRequestContextImpl;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;

public class AioTCPWriteRequestContextImpl
extends TCPWriteRequestContextImpl {
    private static final TraceComponent tc = Tr.register(AioTCPWriteRequestContextImpl.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");
    private boolean immedTimeoutRequested = false;

    protected AioTCPWriteRequestContextImpl(TCPConnLink tCPConnLink) {
        super(tCPConnLink);
    }

    public VirtualConnection processAsyncWriteRequest() {
        this.immedTimeoutRequested = false;
        IOException iOException = null;
        try {
            boolean bl = ((AioSocketIOChannel)this.getTCPConnLink().getSocketIOChannel()).writeAIO(this, this.isForceQueue(), this.getTimeoutInterval());
            if (bl) {
                return this.oTCPConnLink.getVirtualConnection();
            }
        }
        catch (IOException iOException2) {
            if (iOException2 instanceof AsyncTimeoutException) {
                iOException = new SocketTimeoutException(iOException2.getMessage());
                iOException.initCause(iOException2);
            }
            iOException = iOException2;
        }
        if (iOException != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SocketIOChannel socketIOChannel = this.getTCPConnLink().getSocketIOChannel();
                Tr.event(tc, "IOException while processing writeAsynch request local: " + socketIOChannel.getSocket().getLocalSocketAddress() + " remote: " + socketIOChannel.getSocket().getRemoteSocketAddress());
                Tr.event(tc, "Exception is: " + iOException);
            }
            this.getWriteCompletedCallback().error(this.getTCPConnLink().getVirtualConnection(), (TCPWriteRequestContext)this, iOException);
        }
        return null;
    }

    public long processSyncWriteRequest(long l, int n) throws IOException {
        this.immedTimeoutRequested = false;
        IOException iOException = null;
        this.setIOAmount(l);
        this.setLastIOAmt(0L);
        this.setIODoneAmount(0L);
        this.setTimeoutTime(n);
        SocketIOChannel socketIOChannel = this.oTCPConnLink.getSocketIOChannel();
        try {
            return ((AioSocketIOChannel)socketIOChannel).writeAIOSync(this);
        }
        catch (IOException iOException2) {
            iOException = iOException2;
            if (iOException != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "IOException while processing sync write. request local: " + socketIOChannel.getSocket().getLocalSocketAddress() + " remote: " + socketIOChannel.getSocket().getRemoteSocketAddress());
                    Tr.event(tc, "Exception is: " + iOException);
                }
                throw iOException;
            }
            return 0L;
        }
    }

    protected boolean updateForAllData(long l) {
        ByteBuffer[] byteBufferArray = this.getByteBufferArray();
        boolean bl = true;
        for (int i = 0; i < byteBufferArray.length && bl; ++i) {
            if (!byteBufferArray[i].hasRemaining()) continue;
            bl = false;
        }
        this.setLastIOAmt(l);
        this.setIODoneAmount(this.getIODoneAmount() + l);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            SocketIOChannel socketIOChannel = this.getTCPConnLink().getSocketIOChannel();
            Tr.event(tc, "Wrote " + l + "(" + this.getIODoneAmount() + ")" + " bytes, " + this.getIOAmount() + " requested on local: " + socketIOChannel.getSocket().getLocalSocketAddress() + " remote: " + socketIOChannel.getSocket().getRemoteSocketAddress());
        }
        if (bl) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "write complete, at least minimum amount of data written");
            }
        } else {
            Tr.debug(tc, "write not complete, more data needs to be written");
        }
        return bl;
    }

    protected void immediateTimeout() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "immediateTimeout");
        }
        this.immedTimeoutRequested = true;
        ((AioSocketIOChannel)this.getTCPConnLink().getSocketIOChannel()).timeoutWriteFuture();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "immediateTimeout");
        }
    }

    protected boolean isImmedTimeoutRequested() {
        return this.immedTimeoutRequested;
    }
}

