/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.io.async.AsyncTimeoutException;
import com.ibm.io.async.IAbstractAsyncFuture;
import com.ibm.io.async.IAsyncFuture;
import com.ibm.io.async.ICompletionListener;
import com.ibm.io.async.TimerWorkItem;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.ws.tcp.channel.impl.AioSocketIOChannel;
import com.ibm.ws.tcp.channel.impl.AioTCPWriteRequestContextImpl;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.IOException;
import java.net.SocketTimeoutException;

class AioWriteCompletionListener
implements ICompletionListener {
    private static final TraceComponent tc = Tr.register(AioWriteCompletionListener.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");
    public static IOException connClosedException = null;

    AioWriteCompletionListener() {
    }

    public void futureCompleted(IAbstractAsyncFuture iAbstractAsyncFuture, Object object) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "AIOWriteCallback.futureCompleted");
        }
        AioTCPWriteRequestContextImpl aioTCPWriteRequestContextImpl = (AioTCPWriteRequestContextImpl)((Object)object);
        boolean bl = false;
        IOException iOException = null;
        long l = 0L;
        boolean bl2 = false;
        VirtualConnection virtualConnection = null;
        TimerWorkItem timerWorkItem = iAbstractAsyncFuture.getTimeoutWorkItem();
        if (timerWorkItem != null) {
            timerWorkItem.state = 2L;
        }
        if ((virtualConnection = aioTCPWriteRequestContextImpl.getTCPConnLink().getVirtualConnection()) != null) {
            if (virtualConnection.isInputStateTrackingOperational() && !virtualConnection.requestPermissionToFinishWrite()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Can't get permission to finish write, throwing write request away.");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "AIOWriteCallback.futureCompleted");
                }
                return;
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Can't get virtual connection object, throwing write request away.");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "AIOWriteCallback.futureCompleted");
            }
            return;
        }
        try {
            IAsyncFuture iAsyncFuture = (IAsyncFuture)iAbstractAsyncFuture;
            l = iAsyncFuture.getByteCount();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "async write multi buffer bytesWritten: (" + l);
            }
            aioTCPWriteRequestContextImpl.postProcessWriteBuffers(l);
            bl2 = aioTCPWriteRequestContextImpl.getIOAmount() == -1L ? aioTCPWriteRequestContextImpl.updateForAllData(l) : aioTCPWriteRequestContextImpl.updateIOCounts(l, 1);
            if (l == 0L) {
                bl = true;
                if (connClosedException == null) {
                    connClosedException = new IOException("Write failed: Connection closed by peer.");
                }
                iOException = connClosedException;
            }
        }
        catch (IOException iOException2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught: " + iOException2);
            }
            if (iOException2 instanceof AsyncTimeoutException) {
                iOException = new SocketTimeoutException(iOException2.getMessage());
                iOException.initCause(iOException2);
            } else {
                iOException = iOException2;
            }
            bl = true;
        }
        catch (InterruptedException interruptedException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "AioWriteCompletionListener caught exception. " + interruptedException);
            }
            FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.tcp.channel.impl.AioWriteCompletionListener", (String)"134");
        }
        if (!bl) {
            if (bl2) {
                iAbstractAsyncFuture.setFullyCompleted(true);
                aioTCPWriteRequestContextImpl.getWriteCompletedCallback().complete(aioTCPWriteRequestContextImpl.getTCPConnLink().getVirtualConnection(), (TCPWriteRequestContext)aioTCPWriteRequestContextImpl);
            } else {
                long l2;
                if (aioTCPWriteRequestContextImpl.getTCPConnLink().getConfig().getDumpStatsInterval() > 0) {
                    ++aioTCPWriteRequestContextImpl.getTCPConnLink().getTCPChannel().totalPartialAsyncWrites;
                }
                if ((l2 = (long)aioTCPWriteRequestContextImpl.getTimeoutInterval()) != 0L && (l2 = aioTCPWriteRequestContextImpl.getTimeoutTime() - System.currentTimeMillis()) <= 0L) {
                    iOException = new SocketTimeoutException("Async write timed out after writing partial data");
                    bl = true;
                }
                if (!bl) {
                    try {
                        ((AioSocketIOChannel)aioTCPWriteRequestContextImpl.getTCPConnLink().getSocketIOChannel()).writeAIO(aioTCPWriteRequestContextImpl, true, l2);
                    }
                    catch (IOException iOException3) {
                        iOException = iOException3;
                        bl = true;
                    }
                }
            }
        }
        if (bl) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "IOException while doing IO requested on local: " + aioTCPWriteRequestContextImpl.getTCPConnLink().getSocketIOChannel().getSocket().getLocalSocketAddress() + " remote: " + aioTCPWriteRequestContextImpl.getTCPConnLink().getSocketIOChannel().getSocket().getRemoteSocketAddress());
                Tr.event(tc, "Calling write error callback with Exception is: " + iOException);
            }
            aioTCPWriteRequestContextImpl.getWriteCompletedCallback().error(aioTCPWriteRequestContextImpl.getTCPConnLink().getVirtualConnection(), (TCPWriteRequestContext)aioTCPWriteRequestContextImpl, iOException);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "AIOWriteCallback.futureCompleted");
        }
    }
}

