/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.models.config.channelservice.InboundTransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannelFactory;
import com.ibm.websphere.models.config.channelservice.channels.TCPInboundChannel;
import com.ibm.websphere.models.config.channelservice.channels.TCPOutboundChannel;
import com.ibm.websphere.models.config.process.ThreadPool;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.tcp.channel.impl.TCPChannelFactory;
import com.ibm.ws.tcp.channel.impl.TCPOutboundChannelDefinition;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.channel.WSChannelFactory;
import com.ibm.wsspi.channel.framework.ChannelFactoryData;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.channel.framework.OutboundChannelDefinition;
import com.ibm.wsspi.channel.framework.exception.ChannelFactoryException;
import com.ibm.wsspi.channel.framework.exception.InvalidChannelFactoryException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;

public class WSTCPChannelFactory
extends TCPChannelFactory
implements WSChannelFactory {
    private static final TraceComponent tc = Tr.register(WSTCPChannelFactory.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");
    public static final String ENDPOINT_NAME = "endPointName";
    public static final String ZAIO_FREE_INITIAL_BUFFER_KEY = "zaioFreeInitialBuffers";

    protected static boolean isSun(String string) {
        if (string == null) {
            return false;
        }
        return string.indexOf("SunOS") != -1 || string.indexOf("Solaris") != -1;
    }

    public void init(ChannelFactoryData channelFactoryData) throws ChannelFactoryException {
        Map map;
        String string = System.getProperty("os.name", "unknown");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "OS Name is:" + string);
        }
        if ((map = channelFactoryData.getProperties()) != null) {
            if (map.get("commClass") == null) {
                if (WSTCPChannelFactory.isSun(string)) {
                    map.put("commClass", "com.ibm.ws.tcp.channel.impl.NioTCPChannel");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "commClass is null, configuring for NIO: " + map.get("commClass"));
                    }
                } else {
                    map.put("commClass", "com.ibm.ws.tcp.channel.impl.AioTCPChannel");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "commClass is null, configuring for AIO: " + map.get("commClass"));
                    }
                }
            }
            map.put("auditTraceLevel", "INFO");
        }
        super.init(channelFactoryData);
    }

    public Map createChannelConfigurationMap(TransportChannel transportChannel, ChannelFrameworkService channelFrameworkService) throws ConfigurationError {
        PlatformHelper platformHelper;
        Property property;
        Object object;
        Object object2;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ThreadPool threadPool = null;
        String string = null;
        TCPInboundChannel tCPInboundChannel = null;
        TCPOutboundChannel tCPOutboundChannel = null;
        EList eList = null;
        ThreadPoolMgr threadPoolMgr = (ThreadPoolMgr)channelFrameworkService.lookupService(ThreadPoolMgr.class);
        if (transportChannel instanceof TCPInboundChannel) {
            Object[] objectArray;
            EndPointMgr.NodeEndPoints nodeEndPoints;
            tCPInboundChannel = (TCPInboundChannel)transportChannel;
            string = tCPInboundChannel.getName();
            threadPool = tCPInboundChannel.getThreadPool();
            object2 = (Server)channelFrameworkService.lookupService(Server.class);
            object = (EndPointMgr)channelFrameworkService.lookupService(EndPointMgr.class);
            if (object2 == null) {
                throw new ConfigurationError("TCP channel factory could not determine its parent server");
            }
            if (object == null) {
                throw new ConfigurationError("TCP channel factory could not locate the EndPointMgr");
            }
            try {
                nodeEndPoints = object.getNodeEndPoints(object2.getNodeName());
                objectArray = nodeEndPoints.getServerEndPoints(object2.getName());
                property = objectArray.getEndPoint(tCPInboundChannel.getEndPointName());
                hashMap.put("hostname", property.getHost());
                hashMap.put("port", String.valueOf(property.getPort()));
                hashMap.put(ENDPOINT_NAME, tCPInboundChannel.getEndPointName());
            }
            catch (Exception exception) {
                throw new ConfigurationError("endPointName \"" + tCPInboundChannel.getEndPointName() + "\" could not be resolved; please check serverindex.xml", exception);
            }
            hashMap.put("inactivityTimeout", String.valueOf(tCPInboundChannel.getInactivityTimeout()));
            hashMap.put("maxOpenConnections", String.valueOf(tCPInboundChannel.getMaxOpenConnections()));
            nodeEndPoints = tCPInboundChannel.getAddressExcludeList();
            if (nodeEndPoints != null && nodeEndPoints.size() > 0) {
                objectArray = new String[nodeEndPoints.size()];
                objectArray = (String[])nodeEndPoints.toArray(objectArray);
                hashMap.put("addressExcludeList", objectArray);
            }
            if ((nodeEndPoints = tCPInboundChannel.getAddressIncludeList()) != null && nodeEndPoints.size() > 0) {
                objectArray = new String[nodeEndPoints.size()];
                objectArray = (String[])nodeEndPoints.toArray(objectArray);
                hashMap.put("addressIncludeList", objectArray);
            }
            if ((nodeEndPoints = tCPInboundChannel.getHostNameExcludeList()) != null && nodeEndPoints.size() > 0) {
                objectArray = new String[nodeEndPoints.size()];
                objectArray = (String[])nodeEndPoints.toArray(objectArray);
                hashMap.put("hostNameExcludeList", objectArray);
            }
            if ((nodeEndPoints = tCPInboundChannel.getHostNameIncludeList()) != null && nodeEndPoints.size() > 0) {
                objectArray = new String[nodeEndPoints.size()];
                objectArray = (String[])nodeEndPoints.toArray(objectArray);
                hashMap.put("hostNameIncludeList", objectArray);
            }
            eList = transportChannel.getProperties();
        } else if (transportChannel instanceof TCPOutboundChannel) {
            tCPOutboundChannel = (TCPOutboundChannel)transportChannel;
            string = tCPOutboundChannel.getName();
            threadPool = tCPOutboundChannel.getThreadPool();
            hashMap.put("inactivityTimeout", String.valueOf(tCPOutboundChannel.getInactivityTimeout()));
            eList = transportChannel.getProperties();
        }
        if (threadPool != null) {
            object2 = threadPoolMgr.getThreadPoolName(threadPool);
            hashMap.put("threadPoolName", object2);
            object = threadPool.getCustomProperties();
            boolean bl = true;
            if (object != null) {
                for (int i = 0; i < object.size(); ++i) {
                    property = (Property)object.get(i);
                    if (!property.getName().equals("com.ibm.websphere.threadpool.requestBufferSize")) continue;
                    bl = false;
                }
            }
            if (bl) {
                threadPoolMgr.setRequestBufferSize((String)object2, 1000);
            }
        }
        if (eList != null) {
            for (int i = 0; i < eList.size(); ++i) {
                object = (Property)eList.get(i);
                if (tCPInboundChannel != null) {
                    if (object.getName().equals("acceptThread")) {
                        hashMap.put("acceptThread", object.getValue());
                        continue;
                    }
                    if (object.getName().equals("listenBacklog")) {
                        hashMap.put("listenBacklog", object.getValue());
                        continue;
                    }
                    if (object.getName().equals("allocateBuffersDirect")) {
                        hashMap.put("allocateBuffersDirect", object.getValue());
                        continue;
                    }
                    if (object.getName().equals("newConnectionBufferSize")) {
                        hashMap.put("newConnectionBufferSize", object.getValue());
                        continue;
                    }
                }
                if (object.getName().equals("soReuseAddr")) {
                    hashMap.put("soReuseAddr", object.getValue());
                    continue;
                }
                if (object.getName().equals("tcpNoDelay")) {
                    hashMap.put("tcpNoDelay", object.getValue());
                    continue;
                }
                if (object.getName().equals("soLinger")) {
                    hashMap.put("soLinger", object.getValue());
                    continue;
                }
                if (object.getName().equals("keepAlive")) {
                    hashMap.put("keepAlive", object.getValue());
                    continue;
                }
                if (object.getName().equals("receiveBufferSize")) {
                    hashMap.put("receiveBufferSize", object.getValue());
                    continue;
                }
                if (object.getName().equals("sendBufferSize")) {
                    hashMap.put("sendBufferSize", object.getValue());
                    continue;
                }
                if (object.getName().equals("pureNonblocking")) {
                    hashMap.put("pureNonblocking", object.getValue());
                    continue;
                }
                if (object.getName().equals("commOption")) {
                    hashMap.put("commOption", object.getValue());
                    continue;
                }
                if (object.getName().equals("blockingChannel")) {
                    hashMap.put("blockingChannel", object.getValue());
                    continue;
                }
                if (object.getName().equals("dumpStatsInterval")) {
                    hashMap.put("dumpStatsInterval", object.getValue());
                    continue;
                }
                if (object.getName().equals("zaioResolveForeignHostnames")) {
                    hashMap.put("zaioResolveForeignHostnames", object.getValue());
                    continue;
                }
                if (object.getName().equals(ZAIO_FREE_INITIAL_BUFFER_KEY)) {
                    hashMap.put(ZAIO_FREE_INITIAL_BUFFER_KEY, object.getValue());
                    continue;
                }
                Tr.warning(tc, "UNRECOGNIZED_CUSTOM_PROPERTY", new Object[]{string, object.getName()});
            }
        }
        if ((platformHelper = PlatformHelperFactory.getPlatformHelper()).isZOS() && platformHelper.isControlJvm() && !hashMap.containsKey("soReuseAddr")) {
            hashMap.put("soReuseAddr", "1");
        }
        return hashMap;
    }

    public Map createFactoryConfigurationMap(TransportChannelFactory transportChannelFactory, ChannelFrameworkService channelFrameworkService) {
        AdminService adminService;
        String string;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        EList eList = transportChannelFactory.getProperties();
        if (eList != null) {
            for (int i = 0; i < eList.size(); ++i) {
                string = (Property)eList.get(i);
                if (string.getName().equals("maxKeysPerSelector")) {
                    hashMap.put("maxKeysPerSelector", string.getValue());
                    continue;
                }
                if (string.getName().equals("channelSelectorIdleTimeout")) {
                    hashMap.put("channelSelectorIdleTimeout", string.getValue());
                    continue;
                }
                if (string.getName().equals("channelSelectorWaitToTerminate")) {
                    hashMap.put("channelSelectorWaitToTerminate", string.getValue());
                    continue;
                }
                if (string.getName().equals("selectorYield")) {
                    hashMap.put("selectorYield", string.getValue());
                    continue;
                }
                if (string.getName().equals("maxRunnableSelectorThreads")) {
                    hashMap.put("maxRunnableSelectorThreads", string.getValue());
                    continue;
                }
                if (string.getName().equals("newSelectorConnectionThreshold")) {
                    hashMap.put("newSelectorConnectionThreshold", string.getValue());
                    continue;
                }
                if (string.getName().equals("selectorWakeup")) {
                    hashMap.put("selectorWakeup", string.getValue());
                    continue;
                }
                if (string.getName().equals("cancelKeyOnClose")) {
                    hashMap.put("cancelKeyOnClose", string.getValue());
                    continue;
                }
                if (string.getName().equals("combineSelectors")) {
                    hashMap.put("combineSelectors", string.getValue());
                    continue;
                }
                if (string.getName().equals("inboundReadSelectorsToStart")) {
                    hashMap.put("inboundReadSelectorsToStart", string.getValue());
                    continue;
                }
                if (string.getName().equals("maxRunnableSelectorThreads")) {
                    hashMap.put("maxRunnableSelectorThreads", string.getValue());
                    continue;
                }
                if (string.getName().equals("newSelectorConnectionThreshold")) {
                    hashMap.put("newSelectorConnectionThreshold", string.getValue());
                    continue;
                }
                if (string.getName().equals("commClass")) {
                    hashMap.put("commClass", string.getValue());
                    continue;
                }
                Tr.warning(tc, "UNRECOGNIZED_CUSTOM_PROPERTY", new Object[]{string.getName(), "TCP Factory"});
            }
        }
        if ((string = (adminService = AdminServiceFactory.getAdminService()).getProcessType()).equals("DeploymentManager") || string.equals("NodeAgent")) {
            hashMap.put("combineSelectors", "1");
        }
        return hashMap;
    }

    public OutboundChannelDefinition getOutboundChannelDefinition(Map map) {
        return new TCPOutboundChannelDefinition();
    }

    public String determineAcceptorID(InboundTransportChannel inboundTransportChannel) {
        return null;
    }
}

