/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.threadpool.strategy;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.threadpool.strategy.LogicalPoolDistribution;
import com.ibm.ws.threadpool.strategy.Util;
import com.ibm.ws.threadpool.strategy.WorkQueueElement;

class Classification {
    int totalInvokes = 0;
    long totalTime = 0L;
    long lastTime = 0L;
    long avgTotal = 0L;
    int maxExecTime = 0;
    int minExecTime = 0;
    int avgExecTime = 0;
    long totalQTime = 0L;
    int maxQTime = 0;
    int minQTime = 0;
    int avgQTime = 0;
    int lruCount = 0;
    String className = null;
    int timesLeftToBind = 0;
    int lastOutQueueNdx = 0;

    public synchronized int getAvgExecTime() {
        return this.avgExecTime;
    }

    public synchronized void setBoundQueue(int n) {
        this.lastOutQueueNdx = n;
        this.timesLeftToBind = LogicalPoolDistribution.poolBindCount;
    }

    public synchronized int getBoundQueue() {
        if (--this.timesLeftToBind > 0) {
            return this.lastOutQueueNdx;
        }
        return -1;
    }

    Classification(String string) {
        this.className = string;
    }

    synchronized void setClassName(String string) {
        this.className = string;
    }

    synchronized void calcNewAvgTime(long l, long l2) {
        int n = (int)(l - l2);
        if (n < this.minExecTime) {
            this.minExecTime = n;
        }
        if (n > this.maxExecTime) {
            this.maxExecTime = n;
        }
        ++this.totalInvokes;
        this.lastTime = l;
        this.totalTime += (long)n;
        if (this.avgTotal >= (long)this.avgExecTime) {
            this.avgTotal -= (long)this.avgExecTime;
        }
        this.avgTotal += (long)n;
        this.avgExecTime = (int)((double)this.avgTotal / LogicalPoolDistribution.execAvgDivisor);
    }

    synchronized void updateWQEStats(WorkQueueElement workQueueElement) {
        long l = workQueueElement.dequeueTime;
        long l2 = workQueueElement.enqueueTime;
        int n = (int)(l - l2);
        this.totalQTime += (long)n;
        if (n > this.maxQTime) {
            this.maxQTime = n;
        }
        if (n < this.minQTime) {
            this.minQTime = n;
        }
        this.avgQTime = (int)((double)this.totalQTime / (double)this.totalInvokes);
    }

    synchronized void dumpStats(TraceComponent traceComponent) {
        Util.infoMsg(traceComponent, "-----Processing class detail-------");
        Util.infoMsg(traceComponent, "Name: " + this.className);
        Util.infoMsg(traceComponent, "   Total invoked....... " + this.totalInvokes);
        Util.infoMsg(traceComponent, "   Total exec time..... " + this.totalTime);
        Util.infoMsg(traceComponent, "   Max exec time....... " + this.maxExecTime);
        Util.infoMsg(traceComponent, "   Min exec time....... " + this.minExecTime);
        Util.infoMsg(traceComponent, "   Avg exec time....... " + this.avgExecTime);
        Util.infoMsg(traceComponent, "   Total queue time.... " + this.totalQTime);
        Util.infoMsg(traceComponent, "   Max queue time...... " + this.maxQTime);
        Util.infoMsg(traceComponent, "   Min queue time...... " + this.minQTime);
        Util.infoMsg(traceComponent, "   Avg queue time...... " + this.avgQTime);
        Util.infoMsg(traceComponent, "----end processing class detail----");
    }

    synchronized void incLruCount() {
        ++this.lruCount;
    }

    synchronized void zeroLruCount() {
        this.lruCount = 0;
    }

    synchronized int getLruCount() {
        return this.lruCount;
    }
}

