/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.threadpool.strategy;

import com.ibm.CORBA.iiop.ThreadPool;
import com.ibm.CORBA.iiop.WorkUnit;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.EJBServantManager;
import com.ibm.websphere.csi.ThreadPoolStrategy;
import com.ibm.ws.runtime.service.ORB;
import com.ibm.ws.threadpool.strategy.PooledThread;
import com.ibm.ws.threadpool.strategy.StatsQueue;
import com.ibm.ws.threadpool.strategy.StatsQueueProcessor;
import com.ibm.ws.threadpool.strategy.Util;
import com.ibm.ws.threadpool.strategy.WorkQueue;
import com.ibm.ws.threadpool.strategy.WorkQueueProcessor;
import com.ibm.ws.util.ObjectPool;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class LogicalPoolDistribution
implements ThreadPool,
ThreadPoolStrategy {
    protected com.ibm.ws.util.ThreadPool threadPool;
    public static final boolean fTrEnabled;
    protected ObjectPool[] workerPool;
    protected Runnable runner;
    public static int NUM_QUEUES;
    public static int[] relativeTpSizes;
    public static int[] queueSizes;
    public static int statsFrequency;
    public static int calcRedistInterval;
    public static int statsInterval;
    public static int lruInterval;
    public static int poolBindCount;
    public static double execAvgDivisor;
    public static boolean _fUseRandomClassify;
    private static TraceComponent tc;
    protected static String configName;
    protected WorkQueue wq;
    protected WorkQueueProcessor wqp;
    protected StatsQueue sq;
    protected StatsQueueProcessor sqp;
    protected static EJBServantManager ejbServantManager;
    protected ORB orbService = null;

    public void init(com.ibm.ws.util.ThreadPool threadPool, Properties properties, Object[] objectArray) {
        Util.useTrMessages(false);
        Tr.entry(tc, "init");
        this.threadPool = threadPool;
        this.setParameters(properties);
        if (NUM_QUEUES <= 0) {
            NUM_QUEUES = 1;
        }
        Util.infoMsg(tc, configName + " workqueue......: " + queueSizes[0]);
        Util.infoMsg(tc, configName + " statsinterval..: " + statsInterval);
        Util.infoMsg(tc, configName + " calcinterval...: " + calcRedistInterval);
        Util.infoMsg(tc, configName + " lruinterval....: " + lruInterval);
        Util.infoMsg(tc, configName + " execavgdivisor.: " + execAvgDivisor);
        Util.infoMsg(tc, configName + " debug..........: " + fTrEnabled);
        if (_fUseRandomClassify) {
            Util.infoMsg(tc, configName + " random: " + _fUseRandomClassify);
        }
        this.workerPool = new ObjectPool[NUM_QUEUES];
        Util.infoMsg(tc, configName + " : " + NUM_QUEUES + " pools");
        for (int i = 0; i < NUM_QUEUES; ++i) {
            int n = (int)((double)threadPool.getMaximumPoolSize() * ((double)relativeTpSizes[i] / 100.0));
            if (n <= 0) {
                n = 1;
            }
            Util.infoMsg(tc, configName + " -- pool " + i + " size = " + n);
            this.workerPool[i] = new ObjectPool("ORB thread pool #" + i, n);
            for (int j = 0; j < n; ++j) {
                this.workerPool[i].add(new PooledThread(this.workerPool[i], this));
            }
        }
        this.sq = new StatsQueue();
        this.wq = new WorkQueue(queueSizes[0], statsFrequency, this.sq);
        this.wqp = new WorkQueueProcessor(this.wq, this.workerPool, _fUseRandomClassify);
        this.sqp = new StatsQueueProcessor(this.wq, this.sq, this.workerPool, this.wqp, calcRedistInterval, lruInterval, statsInterval);
        Tr.exit(tc, "init");
    }

    protected void setParameters(Properties properties) {
        try {
            String string;
            String string2;
            String string3;
            String string4;
            String string5;
            String string6 = "com.ibm.websphere.threadpool.strategy.LogicalPoolDistribution.";
            String string7 = properties.getProperty(string6 + "execavgdivisor");
            if (string7 != null && (execAvgDivisor = Double.parseDouble(string7)) <= 32.0) {
                execAvgDivisor = 32.0;
            }
            if ((string5 = properties.getProperty(string6 + "workqueue")) != null) {
                LogicalPoolDistribution.queueSizes[0] = Integer.parseInt(string5);
                if (queueSizes[0] <= 0) {
                    LogicalPoolDistribution.queueSizes[0] = 10;
                }
            }
            if ((string4 = properties.getProperty(string6 + "statsinterval")) != null && (statsInterval = Integer.parseInt(string4)) != 0 && statsInterval < 30000) {
                statsInterval = 30000;
            }
            if ((string3 = properties.getProperty(string6 + "calcinterval")) != null && (calcRedistInterval = Integer.parseInt(string3)) < 20000) {
                calcRedistInterval = 20000;
            }
            if ((string2 = properties.getProperty(string6 + "lruinterval")) != null && (lruInterval = Integer.parseInt(string2)) < 40000) {
                lruInterval = 40000;
            }
            if ((string = properties.getProperty(string6 + "outqueues")) != null) {
                Vector<String> vector = new Vector<String>();
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    vector.add(stringTokenizer.nextToken());
                }
                relativeTpSizes = new int[vector.size()];
                for (int i = 0; i < vector.size(); ++i) {
                    LogicalPoolDistribution.relativeTpSizes[i] = Integer.parseInt((String)vector.elementAt(i));
                }
                NUM_QUEUES = vector.size();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setServantManager(EJBServantManager eJBServantManager) {
        ejbServantManager = eJBServantManager;
    }

    public void cleanup() {
    }

    public void init(com.ibm.CORBA.iiop.ORB oRB) {
    }

    public void startWorkerThread(WorkUnit workUnit) {
        if (fTrEnabled) {
            Tr.entry(tc, "startWorkerThread");
        }
        this.wq.add(workUnit);
        if (fTrEnabled) {
            Tr.event(tc, "ORB Request added");
        }
        if (fTrEnabled) {
            Tr.exit(tc, "startWorkerThread");
        }
    }

    private static String getSystemProperty(String string) {
        String string2 = null;
        final String[] stringArray = new String[]{null};
        final String[] stringArray2 = new String[]{null};
        stringArray2[0] = string;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                stringArray[0] = System.getProperty(stringArray2[0]);
                return null;
            }
        });
        if (stringArray[0] != null) {
            string2 = stringArray[0];
        }
        return string2;
    }

    static {
        NUM_QUEUES = 4;
        relativeTpSizes = new int[]{40, 25, 20, 15};
        queueSizes = new int[]{96};
        statsFrequency = 1000;
        calcRedistInterval = 60000;
        statsInterval = 0;
        lruInterval = 300000;
        poolBindCount = 8;
        execAvgDivisor = 48.0;
        _fUseRandomClassify = false;
        tc = Tr.register(LogicalPoolDistribution.class);
        configName = "com.ibm.websphere.threadpool.strategy.LogicalPoolDistribution";
        ejbServantManager = null;
        boolean bl = false;
        String string = LogicalPoolDistribution.getSystemProperty(configName + ".debug");
        if (string != null && string.equalsIgnoreCase("true")) {
            bl = true;
        }
        fTrEnabled = bl;
    }
}

