/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.threadpool.strategy;

import com.ibm.CORBA.iiop.WorkUnit;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.threadpool.strategy.LogicalPoolDistribution;
import com.ibm.ws.threadpool.strategy.WorkQueueElement;
import com.ibm.ws.util.ObjectPool;

class PooledThread
implements Runnable {
    WorkUnit workUnit;
    ObjectPool pool;
    protected LogicalPoolDistribution lpd;
    private static TraceComponent tc = Tr.register(PooledThread.class);
    WorkQueueElement e = null;

    public PooledThread(ObjectPool objectPool, LogicalPoolDistribution logicalPoolDistribution) {
        this.pool = objectPool;
        this.lpd = logicalPoolDistribution;
    }

    void handleRequest(WorkQueueElement workQueueElement) {
        if (LogicalPoolDistribution.fTrEnabled) {
            Tr.entry(tc, "handleRequest");
        }
        this.e = workQueueElement;
        try {
            this.lpd.threadPool.execute(this);
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.threadpool.strategy.LogicalPoolDistribution.startWorkerThread", "68", this);
        }
        if (LogicalPoolDistribution.fTrEnabled) {
            Tr.exit(tc, "handleRequest");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (LogicalPoolDistribution.fTrEnabled) {
            Tr.entry(tc, "run");
        }
        try {
            if (this.e != null) {
                this.e.started();
            }
            if (this.e.workUnit != null) {
                this.e.workUnit.doWork();
            }
        }
        finally {
            if (this.e != null) {
                this.e.ended();
            }
            this.e = null;
            this.pool.add(this);
        }
        if (LogicalPoolDistribution.fTrEnabled) {
            Tr.exit(tc, "run");
        }
    }
}

