/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.threadpool.strategy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.threadpool.strategy.Classification;
import com.ibm.ws.threadpool.strategy.StatsQueue;
import com.ibm.ws.threadpool.strategy.Util;
import com.ibm.ws.threadpool.strategy.WorkQueue;
import com.ibm.ws.threadpool.strategy.WorkQueueElement;
import com.ibm.ws.threadpool.strategy.WorkQueueProcessor;
import com.ibm.ws.util.ObjectPool;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

class StatsQueueProcessor
extends Thread {
    private static TraceComponent tc = Tr.register(StatsQueueProcessor.class);
    long _lastLruTime = 0L;
    long _curTime = 0L;
    long _lastDistRecalcTime = 0L;
    long _lastStatsWriteTime = 0L;
    ObjectPool[] _workerPool = null;
    WorkQueue _wq = null;
    StatsQueue _sq = null;
    WorkQueueProcessor _qp = null;
    HashMap _classifications = null;
    int _waitTimeout = 0;
    long _distRecalcInterval = 0L;
    long _lruInterval = 0L;
    long _statsInterval = 0L;
    long _minDistRecalcInterval = 0L;
    long _minLruInterval = 0L;
    long _minStatsInterval = 0L;
    int[] _execTimes = new int[64];
    int _processedSinceLastStats = 0;

    StatsQueueProcessor(WorkQueue workQueue, StatsQueue statsQueue, ObjectPool[] objectPoolArray, WorkQueueProcessor workQueueProcessor, long l, long l2, long l3) {
        this._wq = workQueue;
        this._sq = statsQueue;
        this._qp = workQueueProcessor;
        this._classifications = new HashMap();
        this._workerPool = objectPoolArray;
        this._processedSinceLastStats = 0;
        this._waitTimeout = 5000;
        this._minDistRecalcInterval = this._waitTimeout * 4;
        this._minLruInterval = this._waitTimeout * 12;
        this._minStatsInterval = this._waitTimeout * 6;
        this._distRecalcInterval = 20000L;
        this._lruInterval = 300000L;
        this._statsInterval = 0L;
        if (l >= this._minDistRecalcInterval) {
            this._distRecalcInterval = l;
        }
        if (l2 >= this._minLruInterval) {
            this._lruInterval = l2;
        }
        if (l3 >= this._minStatsInterval || l3 == 0L) {
            this._statsInterval = l3;
        }
        this._lastLruTime = this._curTime = System.currentTimeMillis();
        this._lastDistRecalcTime = this._curTime;
        this._lastStatsWriteTime = this._curTime;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int n = 0;
        while (true) {
            boolean bl = false;
            WorkQueueElement workQueueElement = this._sq.remove();
            if (workQueueElement == null) {
                bl = this._sq.doWait(this._waitTimeout);
            }
            if (workQueueElement != null) {
                this.processStats(workQueueElement);
                ++n;
                ++this._processedSinceLastStats;
            }
            if (n <= 200 && !bl) continue;
            this._curTime = System.currentTimeMillis();
            if (this._curTime - this._lastLruTime > this._lruInterval) {
                this.doLru();
            }
            if (this._curTime - this._lastDistRecalcTime > this._distRecalcInterval) {
                this.doDistRecalc();
            }
            if (this._curTime - this._lastStatsWriteTime > this._statsInterval) {
                this.doStatsWrite();
            }
            n = 0;
        }
    }

    void processStats(WorkQueueElement workQueueElement) {
        String string = workQueueElement.getWorkUnitClass();
        Classification classification = workQueueElement.getClassification();
        if (classification != null) {
            classification.calcNewAvgTime(workQueueElement.endTime, workQueueElement.startTime);
            classification.updateWQEStats(workQueueElement);
            classification.incLruCount();
            this._classifications.put(classification.className, classification);
        }
        workQueueElement.wq._qp.updateProcessQueueStats(workQueueElement);
        workQueueElement.reInit();
        this._wq.free(workQueueElement);
    }

    void doLru() {
        this._lastLruTime = this._curTime = System.currentTimeMillis();
        Vector<String> vector = new Vector<String>();
        Collection collection = this._classifications.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Classification classification = (Classification)iterator.next();
            int n = classification.getLruCount();
            classification.zeroLruCount();
            if (n != 0) continue;
            vector.add(classification.className);
        }
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            this._classifications.remove(string);
        }
    }

    void doDistRecalc() {
        this._lastDistRecalcTime = this._curTime = System.currentTimeMillis();
        if (this._workerPool.length < 2) {
            return;
        }
        int n = this._classifications.size();
        if (n > this._execTimes.length) {
            this._execTimes = new int[n];
        }
        Collection collection = this._classifications.values();
        Iterator iterator = collection.iterator();
        for (n = 0; iterator.hasNext() && n < this._execTimes.length; ++n) {
            Classification classification = (Classification)iterator.next();
            this._execTimes[n] = classification.getAvgExecTime();
        }
        try {
            this.sort(this._execTimes, n);
        }
        catch (Exception exception) {
            System.out.println("Sort exception...");
        }
        int n2 = n > 0 ? 1 : 0;
        int n3 = 0;
        for (int i = 1; i < n; ++i) {
            if (this._execTimes[n3] == this._execTimes[i]) continue;
            ++n2;
            this._execTimes[++n3] = this._execTimes[i];
        }
        n = n2;
        int n4 = this._workerPool.length;
        if (n > 0) {
            int n5;
            int n6 = (int)Math.round((double)n / (double)n4);
            if (n6 < 1) {
                n6 = 1;
            }
            for (n5 = 0; n5 < n4; ++n5) {
                this._qp.setPoolTarget(n5, this._execTimes[n - 1]);
            }
            for (n5 = 0; n5 < n4 && n5 * n6 < n; ++n5) {
                this._qp.setPoolTarget(n5, this._execTimes[n5 * n6]);
            }
        }
    }

    void doStatsWrite() {
        if (this._processedSinceLastStats == 0 || this._statsInterval == 0L) {
            this._lastStatsWriteTime = this._curTime;
            this._processedSinceLastStats = 0;
            return;
        }
        this._lastStatsWriteTime = this._curTime = System.currentTimeMillis();
        this._processedSinceLastStats = 0;
        Util.infoMsg(tc, "-----------------------------------");
        Util.infoMsg(tc, "- EJB work queue statistics begin -");
        Util.infoMsg(tc, "-----------------------------------");
        this._wq.dumpStats();
        Util.infoMsg(tc, "-begin Queue Processor Stats ------");
        Collection collection = this._classifications.values();
        Util.infoMsg(tc, "------ processing class stats------");
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Classification classification = (Classification)iterator.next();
            classification.dumpStats(tc);
        }
        Util.infoMsg(tc, "---end processing class stats------");
        Util.infoMsg(tc, "---Stats for processing queues ----");
        int n = this._workerPool.length;
        for (int i = 0; i < n; ++i) {
            Util.infoMsg(tc, "Processing queue id............" + i);
            Util.infoMsg(tc, "   target processing time......" + this._qp.poolTargetServiceTime[i]);
            Util.infoMsg(tc, "   max actual processing time.." + this._qp.poolMaxActual[i]);
            Util.infoMsg(tc, "   min actual processing time.." + this._qp.poolMinActual[i]);
            Util.infoMsg(tc, "   avg actual processing time.." + this._qp.poolAvgActual[i]);
            Util.infoMsg(tc, "   total processing time......." + this._qp.poolTotalTime[i]);
            Util.infoMsg(tc, "   total requests.............." + this._qp.poolExecs[i]);
            Util.infoMsg(tc, "   Availablity................." + this._qp.ps[i].getAvailability());
        }
        Util.infoMsg(tc, "---End stats for processing queues-");
        Util.infoMsg(tc, "--end- Queue Processor Stats ------");
        Util.infoMsg(tc, "-----------------------------------");
        Util.infoMsg(tc, "- EJB work queue statistics end   -");
        Util.infoMsg(tc, "-----------------------------------");
    }

    private void QuickSort(int[] nArray, int n, int n2) throws Exception {
        int n3 = 4;
        if (n2 - n > n3) {
            int n4 = (n2 + n) / 2;
            if (nArray[n] > nArray[n4]) {
                this.swap(nArray, n, n4);
            }
            if (nArray[n] > nArray[n2]) {
                this.swap(nArray, n, n2);
            }
            if (nArray[n4] > nArray[n2]) {
                this.swap(nArray, n4, n2);
            }
            int n5 = n2 - 1;
            this.swap(nArray, n4, n5);
            n4 = n;
            int n6 = nArray[n5];
            while (true) {
                if (nArray[++n4] < n6) {
                    continue;
                }
                while (nArray[--n5] > n6) {
                }
                if (n5 < n4) break;
                this.swap(nArray, n4, n5);
            }
            this.swap(nArray, n4, n2 - 1);
            this.QuickSort(nArray, n, n5);
            this.QuickSort(nArray, n4 + 1, n2);
        }
    }

    private void swap(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    private void InsertionSort(int[] nArray, int n, int n2) throws Exception {
        for (int i = n + 1; i <= n2; ++i) {
            int n3 = nArray[i];
            for (int j = i; j > n && nArray[j - 1] > n3; --j) {
                nArray[j] = nArray[j - 1];
            }
            nArray[j] = n3;
        }
    }

    public void sort(int[] nArray, int n) throws Exception {
        this.QuickSort(nArray, 0, n - 1);
        this.InsertionSort(nArray, 0, n - 1);
    }
}

