/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.threadpool.strategy;

import com.ibm.CORBA.iiop.WorkUnit;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.threadpool.strategy.LogicalPoolDistribution;
import com.ibm.ws.threadpool.strategy.StatsQueue;
import com.ibm.ws.threadpool.strategy.Timer;
import com.ibm.ws.threadpool.strategy.Util;
import com.ibm.ws.threadpool.strategy.WorkQueueElement;
import com.ibm.ws.threadpool.strategy.WorkQueueProcessor;

class WorkQueue {
    WorkQueueElement _head = null;
    WorkQueueElement _free = null;
    WorkQueueElement _tail = null;
    int _maxSize = 0;
    int _curSize = 0;
    int _biggest = 0;
    int timesFull = 0;
    int totalAdds = 0;
    int totalRemoves = 0;
    long totalAddTime = 0L;
    int minAddTime = 0;
    int maxAddTime = 0;
    int avgAddTime = 0;
    long totalInQueueTime = 0L;
    int minInQueueTime = 0;
    int maxInQueueTime = 0;
    int avgInQueueTime = 0;
    int statsFrequency = 0;
    WorkQueueProcessor _qp = null;
    StatsQueue _sq = null;
    int awakens = 0;
    private static TraceComponent tc = Tr.register(WorkQueue.class);

    private WorkQueue() {
        this._maxSize = 20;
        this.statsFrequency = 0;
    }

    WorkQueue(int n, int n2, StatsQueue statsQueue) {
        this._sq = statsQueue;
        this._maxSize = n;
        this.statsFrequency = n2;
    }

    void setQueueProcessor(WorkQueueProcessor workQueueProcessor) {
        this._qp = workQueueProcessor;
    }

    int getStatsFrequency() {
        return this.statsFrequency;
    }

    synchronized WorkQueueElement first() {
        return this._head;
    }

    synchronized WorkQueueElement last() {
        return this._tail;
    }

    synchronized WorkQueueElement next(WorkQueueElement workQueueElement) {
        return workQueueElement.next;
    }

    synchronized int size() {
        return this._curSize;
    }

    synchronized int getMaxSize() {
        return this._maxSize;
    }

    synchronized boolean isFull() {
        return this._curSize >= this._maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void remove(WorkQueueElement workQueueElement) {
        if (LogicalPoolDistribution.fTrEnabled) {
            Tr.entry(tc, "remove");
        }
        ++this.totalRemoves;
        workQueueElement.dequeueTime = Timer.getTimer();
        this.workQueueInQueueStatsUpdate(workQueueElement.dequeueTime, workQueueElement.enqueueTime);
        if (this._maxSize > 0) {
            WorkQueueElement workQueueElement2 = workQueueElement;
            synchronized (workQueueElement2) {
                if (workQueueElement == this._head && workQueueElement == this._tail) {
                    this._tail = null;
                    this._head = null;
                    workQueueElement.next = null;
                    workQueueElement.prev = null;
                }
                if (this._head == workQueueElement) {
                    this._head = workQueueElement.next;
                }
                if (this._tail == workQueueElement) {
                    this._tail = workQueueElement.prev;
                }
                if (workQueueElement.next != null) {
                    workQueueElement.next.prev = workQueueElement.prev;
                }
                if (workQueueElement.prev != null) {
                    workQueueElement.prev.next = workQueueElement.next;
                }
                workQueueElement.prev = null;
                workQueueElement.next = null;
            }
            --this._curSize;
            this.notify();
        }
        if (LogicalPoolDistribution.fTrEnabled) {
            Tr.exit(tc, "remove");
        }
    }

    synchronized void free(WorkQueueElement workQueueElement) {
        if (LogicalPoolDistribution.fTrEnabled) {
            Tr.entry(tc, "free");
        }
        workQueueElement.next = this._free;
        this._free = workQueueElement;
        if (LogicalPoolDistribution.fTrEnabled) {
            Tr.exit(tc, "free");
        }
    }

    synchronized void add(WorkUnit workUnit) {
        long l;
        if (LogicalPoolDistribution.fTrEnabled) {
            Tr.entry(tc, "add");
        }
        ++this.totalAdds;
        long l2 = Timer.getTimer();
        WorkQueueElement workQueueElement = this._free;
        if (workQueueElement != null) {
            this._free = workQueueElement.next;
        } else {
            workQueueElement = new WorkQueueElement();
        }
        workQueueElement.next = null;
        workQueueElement.prev = null;
        workQueueElement.wq = this;
        workQueueElement.sq = this._sq;
        workQueueElement.workUnit = workUnit;
        workQueueElement.outboundQueueNdx = -1;
        if (this._maxSize > 0) {
            while (this._curSize >= this._maxSize) {
                try {
                    if (LogicalPoolDistribution.fTrEnabled) {
                        Tr.event(tc, "Work queue full.  Waiting...");
                    }
                    ++this.timesFull;
                    this.wait();
                    if (!LogicalPoolDistribution.fTrEnabled) continue;
                    Tr.event(tc, "Done waiting to place work into queue.");
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this._tail == null) {
                this._head = this._tail = workQueueElement;
            } else {
                workQueueElement.prev = this._tail;
                this._tail.next = workQueueElement;
                this._tail = workQueueElement;
            }
            ++this._curSize;
            if (this._curSize > this._biggest) {
                this._biggest = this._curSize;
            }
        }
        workQueueElement.enqueueTime = l = Timer.getTimer();
        this.workQueueAddStatsUpdate(l, l2);
        if (this._maxSize <= 0) {
            this._qp.classifyAndExecute(workQueueElement);
        } else {
            this._qp.awaken();
        }
        if (LogicalPoolDistribution.fTrEnabled) {
            Tr.exit(tc, "add");
        }
    }

    synchronized void doWait() throws InterruptedException {
        if (this.awakens <= 0) {
            this.wait();
        }
        this.awakens = 0;
    }

    synchronized void awaken() {
        ++this.awakens;
        this.notify();
    }

    void dumpQueue() {
        Util.infoMsg(tc, "Begin Work queue dump...");
        int n = 0;
        WorkQueueElement workQueueElement = this._head;
        while (workQueueElement != null) {
            ++n;
            Util.infoMsg(tc, "    -> " + workQueueElement.className + " -- " + workQueueElement);
            workQueueElement = workQueueElement.next;
        }
        Util.infoMsg(tc, "   tail = " + this._tail);
        Util.infoMsg(tc, "End Work queue dump. Total: " + n);
    }

    void workQueueAddStatsUpdate(long l, long l2) {
        int n = (int)(l - l2);
        if (n > this.maxAddTime) {
            this.maxAddTime = n;
        }
        if (n < this.minAddTime) {
            this.minAddTime = n;
        }
        this.totalAddTime += (long)n;
        this.avgAddTime = (int)((double)this.totalAddTime / (double)this.totalAdds);
    }

    void workQueueInQueueStatsUpdate(long l, long l2) {
        int n = (int)(l - l2);
        if (n > this.maxInQueueTime) {
            this.maxInQueueTime = n;
        }
        if (n < this.minInQueueTime) {
            this.minInQueueTime = n;
        }
        this.totalInQueueTime += (long)n;
        this.avgInQueueTime = (int)((double)this.totalInQueueTime / (double)this.totalAdds);
    }

    synchronized void dumpStats() {
        Util.infoMsg(tc, "EJB work queue statistics");
        Util.infoMsg(tc, "   Queue max allowed... " + this._maxSize);
        Util.infoMsg(tc, "   Queue max seen...... " + this._biggest);
        Util.infoMsg(tc, "   Total adds.......... " + this.totalAdds);
        Util.infoMsg(tc, "   Total removes....... " + this.totalRemoves);
        Util.infoMsg(tc, "   Times full.......... " + this.timesFull);
        Util.infoMsg(tc, "   Total add time...... " + this.totalAddTime);
        Util.infoMsg(tc, "   Min add time........ " + this.minAddTime);
        Util.infoMsg(tc, "   Max add time........ " + this.maxAddTime);
        Util.infoMsg(tc, "   Avg add time........ " + this.avgAddTime);
        Util.infoMsg(tc, "   Total time in queue. " + this.totalInQueueTime);
        Util.infoMsg(tc, "   Min time in queue... " + this.minInQueueTime);
        Util.infoMsg(tc, "   Max time in queue... " + this.maxInQueueTime);
        Util.infoMsg(tc, "   Avg time in queue... " + this.avgInQueueTime);
    }
}

