/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.threadpool.strategy;

import com.ibm.CORBA.iiop.Message;
import com.ibm.CORBA.iiop.ObjectKey;
import com.ibm.CORBA.iiop.RequestMessage;
import com.ibm.CORBA.iiop.WorkUnit;
import com.ibm.ejs.csi.J2EENameFactoryImpl;
import com.ibm.ejs.oa.UserKey;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.EJBServantManager;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.threadpool.strategy.Classification;
import com.ibm.ws.threadpool.strategy.LogicalPoolDistribution;
import com.ibm.ws.threadpool.strategy.StatsQueue;
import com.ibm.ws.threadpool.strategy.Timer;
import com.ibm.ws.threadpool.strategy.WorkQueue;

class WorkQueueElement {
    private static TraceComponent tc = Tr.register(WorkQueueElement.class);
    int outboundQueueNdx = -1;
    WorkUnit workUnit = null;
    WorkQueueElement next = null;
    WorkQueueElement prev = null;
    WorkQueue wq = null;
    StatsQueue sq = null;
    long startTime = 0L;
    long endTime = 0L;
    long enqueueTime = 0L;
    long dequeueTime = 0L;
    String className = null;
    int msgType = -1;
    Classification classification = null;

    WorkQueueElement() {
    }

    public void started() {
        if (LogicalPoolDistribution.fTrEnabled && tc.isEntryEnabled()) {
            Tr.entry(tc, "started: " + this.className);
        }
        this.startTime = Timer.getTimer();
        if (LogicalPoolDistribution.fTrEnabled) {
            Tr.exit(tc, "started");
        }
    }

    public void ended() {
        if (LogicalPoolDistribution.fTrEnabled && tc.isEntryEnabled()) {
            Tr.entry(tc, "ended: " + this.className);
        }
        this.endTime = Timer.getTimer();
        if (this.wq.getMaxSize() > 0) {
            this.wq._qp.awaken();
        } else {
            this.wq.awaken();
        }
        this.sq.add(this);
        if (LogicalPoolDistribution.fTrEnabled) {
            Tr.exit(tc, "ended");
        }
    }

    void reInit() {
        if (LogicalPoolDistribution.fTrEnabled && tc.isEntryEnabled()) {
            Tr.entry(tc, "reInit");
        }
        this.outboundQueueNdx = -1;
        this.workUnit = null;
        this.startTime = 0L;
        this.endTime = 0L;
        this.enqueueTime = 0L;
        this.dequeueTime = 0L;
        this.className = null;
        int n = -1;
        this.classification = null;
        if (LogicalPoolDistribution.fTrEnabled) {
            Tr.exit(tc, "reInit");
        }
    }

    void setClassification(Classification classification) {
        this.classification = classification;
    }

    Classification getClassification() {
        return this.classification;
    }

    public String getWorkUnitClass() {
        block6: {
            boolean bl = false;
            String string = "$$SYSTEM";
            if (LogicalPoolDistribution.fTrEnabled && (bl = tc.isDebugEnabled())) {
                Tr.debug(tc, "className at entry: " + this.className);
            }
            if (this.className == null) {
                this.className = "<unknown>";
                try {
                    Message message = this.workUnit.getMessage();
                    if (message != null && message instanceof RequestMessage) {
                        RequestMessage requestMessage = (RequestMessage)message;
                        this.className = this.getObjectClassName(requestMessage) + "." + requestMessage.getOperation();
                        if (LogicalPoolDistribution.fTrEnabled && bl) {
                            Tr.debug(tc, "className: " + this.className);
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (!LogicalPoolDistribution.fTrEnabled || !bl) break block6;
                    Tr.debug(tc, "exception: " + throwable.getMessage());
                }
            }
        }
        return this.className;
    }

    public String getObjectClassName(RequestMessage requestMessage) {
        boolean bl = false;
        if (LogicalPoolDistribution.fTrEnabled) {
            bl = tc.isDebugEnabled();
        }
        String string = "<unknown>";
        byte[] byArray = requestMessage.getObjectKey();
        if (byArray != null) {
            byte[] byArray2;
            UserKey userKey;
            StringBuffer stringBuffer;
            block19: {
                ObjectKey objectKey = new ObjectKey(byArray);
                stringBuffer = null;
                if (bl) {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("ObjectKey = ");
                    for (int i = 0; i < byArray.length; ++i) {
                        stringBuffer.append(byArray[i] >= 32 ? (char)byArray[i] : (char)'.');
                    }
                    Tr.debug(tc, stringBuffer.toString());
                }
                userKey = null;
                byArray2 = objectKey.getUserKey();
                try {
                    userKey = new UserKey(byArray2);
                }
                catch (Exception exception) {
                    if (!bl) break block19;
                    Tr.debug(tc, "invalid userkey");
                }
            }
            if (userKey != null) {
                EJBServantManager eJBServantManager;
                byte[] byArray3 = userKey.getServantKey();
                if (bl) {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("servantKey = ");
                    for (int i = 0; i < byArray3.length; ++i) {
                        stringBuffer.append(byArray3[i] >= 32 ? (char)byArray3[i] : (char)'.');
                    }
                    Tr.debug(tc, stringBuffer.toString());
                }
                if ((eJBServantManager = LogicalPoolDistribution.ejbServantManager) != null && byArray3 != null) {
                    byte[] byArray4 = null;
                    try {
                        byArray4 = eJBServantManager.getJ2EENameBytes(byArray3);
                    }
                    catch (Exception exception) {
                        byArray4 = null;
                    }
                    if (byArray4 != null) {
                        J2EENameFactoryImpl j2EENameFactoryImpl = new J2EENameFactoryImpl();
                        J2EEName j2EEName = j2EENameFactoryImpl.create(byArray4);
                        string = j2EEName.getComponent();
                        if (bl) {
                            Tr.debug(tc, "j2eeName=" + ((Object)j2EEName).toString() + ":: " + string);
                        }
                    }
                    if (bl && byArray4 == null) {
                        Tr.debug(tc, "j2eeNameBytes returned from ejbServantManager.getJ2EENameBytes was null");
                    }
                } else {
                    if (bl) {
                        Tr.debug(tc, "Invalid beanid");
                    }
                    string = "<unknown>";
                }
            } else if (byArray2 != null) {
                string = "<unknown>";
            }
        }
        return string;
    }
}

