/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.threadpool.strategy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.threadpool.strategy.Classification;
import com.ibm.ws.threadpool.strategy.LogicalPoolDistribution;
import com.ibm.ws.threadpool.strategy.PoolStats;
import com.ibm.ws.threadpool.strategy.PooledThread;
import com.ibm.ws.threadpool.strategy.Util;
import com.ibm.ws.threadpool.strategy.WorkQueue;
import com.ibm.ws.threadpool.strategy.WorkQueueElement;
import com.ibm.ws.util.ObjectPool;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import java.util.WeakHashMap;

class WorkQueueProcessor
extends Thread {
    private static TraceComponent tc = Tr.register(WorkQueueProcessor.class);
    WorkQueue wq = null;
    ObjectPool[] workerPool = null;
    protected PoolStats[] ps = null;
    WeakHashMap classifications = null;
    int[] poolTargetServiceTime;
    int[] poolMaxActual;
    int[] poolMinActual;
    int[] poolAvgActual;
    long[] poolTotalTime;
    long[] poolExecs;
    long processed = 0L;
    int statsFrequency = 10000;
    int awakens = 0;
    Random rand = null;
    boolean fUseRandomClassify = false;

    WorkQueueProcessor(WorkQueue workQueue, ObjectPool[] objectPoolArray, boolean bl) {
        int n;
        int n2;
        Tr.entry(tc, "WorkQueueProcesor");
        this.wq = workQueue;
        this.workerPool = objectPoolArray;
        workQueue.setQueueProcessor(this);
        this.statsFrequency = workQueue.getStatsFrequency();
        if (workQueue.getMaxSize() > 0) {
            this.start();
        }
        this.classifications = new WeakHashMap();
        this.poolTargetServiceTime = new int[objectPoolArray.length];
        int n3 = this.poolTargetServiceTime.length;
        for (n2 = 0; n2 < n3; ++n2) {
            this.poolTargetServiceTime[n2] = 25 * (n2 + 1) + n2 * 15;
        }
        n2 = objectPoolArray.length;
        this.poolMaxActual = new int[n2];
        this.poolMinActual = new int[n2];
        this.poolAvgActual = new int[n2];
        this.poolTotalTime = new long[n2];
        this.poolExecs = new long[n2];
        for (n = 0; n < n2; ++n) {
            this.poolMaxActual[n] = 0;
            this.poolMinActual[n] = 0;
            this.poolAvgActual[n] = 0;
            this.poolTotalTime[n] = 0L;
            this.poolExecs[n] = 0L;
        }
        this.ps = new PoolStats[objectPoolArray.length];
        for (n = 0; n < this.ps.length; ++n) {
            this.ps[n] = new PoolStats();
        }
        this.fUseRandomClassify = bl;
        this.rand = new Random();
        Tr.exit(tc, "WorkQueueProcesor");
    }

    synchronized void setPoolTarget(int n, int n2) {
        this.poolTargetServiceTime[n] = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Classification getClassification(String string) {
        if (LogicalPoolDistribution.fTrEnabled) {
            Tr.entry(tc, "getClassification");
        }
        Classification classification = null;
        WeakHashMap weakHashMap = this.classifications;
        synchronized (weakHashMap) {
            classification = (Classification)this.classifications.get(string);
            if (classification == null) {
                classification = new Classification(string);
                this.classifications.put(string, classification);
            }
        }
        if (LogicalPoolDistribution.fTrEnabled) {
            Tr.exit(tc, "getClassification");
        }
        return classification;
    }

    void setClassExecTime(String string, long l, long l2) {
        if (LogicalPoolDistribution.fTrEnabled) {
            Tr.entry(tc, "setClassExecTime");
        }
        Classification classification = this.getClassification(string);
        classification.calcNewAvgTime(l, l2);
        if (LogicalPoolDistribution.fTrEnabled) {
            Tr.exit(tc, "setClassExecTime");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateProcessQueueStats(WorkQueueElement workQueueElement) {
        int n = workQueueElement.outboundQueueNdx;
        ObjectPool objectPool = this.workerPool[n];
        synchronized (objectPool) {
            int n2 = (int)(workQueueElement.endTime - workQueueElement.startTime);
            int n3 = n;
            this.poolExecs[n3] = this.poolExecs[n3] + 1L;
            int n4 = n;
            this.poolTotalTime[n4] = this.poolTotalTime[n4] + (long)n2;
            long l = this.poolTotalTime[n];
            this.poolAvgActual[n] = (int)((double)l / (double)this.poolExecs[n]);
            if (n2 > this.poolMaxActual[n]) {
                this.poolMaxActual[n] = n2;
            }
            if (n2 < this.poolMinActual[n]) {
                this.poolMinActual[n] = n2;
            }
        }
    }

    void updateClassStats(WorkQueueElement workQueueElement) {
        Classification classification = workQueueElement.getClassification();
        if (classification != null) {
            classification.updateWQEStats(workQueueElement);
        }
    }

    int classify(WorkQueueElement workQueueElement) {
        if (LogicalPoolDistribution.fTrEnabled) {
            Tr.entry(tc, "classify");
        }
        int n = 0;
        Classification classification = workQueueElement.getClassification();
        if (classification == null) {
            String string = workQueueElement.getWorkUnitClass();
            if (LogicalPoolDistribution.fTrEnabled) {
                Tr.debug(tc, "\t  method: " + string);
            }
            classification = this.getClassification(string);
            workQueueElement.setClassification(classification);
            n = this.getPoolNdx(classification);
        } else {
            if (LogicalPoolDistribution.fTrEnabled && tc.isDebugEnabled()) {
                Tr.debug(tc, "re-classify since classification was not null");
            }
            n = this.getPoolNdx(classification);
        }
        if (LogicalPoolDistribution.fTrEnabled) {
            Tr.exit(tc, "classify");
        }
        return n;
    }

    int getPoolNdx(Classification classification) {
        int n = this.rand.nextInt(this.poolTargetServiceTime.length);
        if (this.fUseRandomClassify) {
            return n;
        }
        int n2 = this.poolTargetServiceTime[n];
        if (classification != null) {
            n2 = classification.getAvgExecTime();
        }
        for (int i = 0; i < this.workerPool.length; ++i) {
            n = i;
            if (n2 <= this.poolTargetServiceTime[i]) break;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            WorkQueueElement workQueueElement = this.wq.first();
            WorkQueueElement workQueueElement2 = this.wq.last();
            int n = this.wq.size();
            boolean bl = true;
            while (bl) {
                bl = false;
                while (workQueueElement != null) {
                    PooledThread pooledThread;
                    workQueueElement.outboundQueueNdx = this.classify(workQueueElement);
                    int n2 = workQueueElement.outboundQueueNdx;
                    if (n2 < 0 || n2 > this.workerPool.length) {
                        Tr.error(tc, "WorkQueueProcessor: Invalid outbound queue index specified after classify");
                    }
                    if ((pooledThread = (PooledThread)this.workerPool[n2].remove()) != null) {
                        WorkQueueElement workQueueElement3 = workQueueElement.next;
                        this.ps[n2].wasAvailable();
                        this.wq.remove(workQueueElement);
                        this.updateClassStats(workQueueElement);
                        pooledThread.handleRequest(workQueueElement);
                        ++this.processed;
                        workQueueElement = workQueueElement3;
                        continue;
                    }
                    this.ps[n2].notAvailable();
                    int n3 = this.wq.size();
                    if (workQueueElement == workQueueElement2 && n3 != n) {
                        workQueueElement = this.wq.first();
                        workQueueElement2 = this.wq.last();
                        n = n3;
                        continue;
                    }
                    workQueueElement = this.wq.next(workQueueElement);
                }
            }
            try {
                this.doWait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    void classifyAndExecute(WorkQueueElement workQueueElement) {
        int n;
        if (workQueueElement.outboundQueueNdx == -1) {
            workQueueElement.outboundQueueNdx = this.classify(workQueueElement);
        }
        if ((n = workQueueElement.outboundQueueNdx) < 0 || n > this.workerPool.length) {
            Tr.error(tc, "WorkQueueProcessor: Invalid outbound queue index specified after classify" + n);
            n = 0;
        }
        PooledThread pooledThread = null;
        while (pooledThread == null) {
            pooledThread = (PooledThread)this.workerPool[n].remove();
            if (pooledThread != null) {
                this.wq.remove(workQueueElement);
                this.updateClassStats(workQueueElement);
                pooledThread.handleRequest(workQueueElement);
                continue;
            }
            try {
                workQueueElement.wq.doWait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    synchronized void doWait() throws InterruptedException {
        if (LogicalPoolDistribution.fTrEnabled) {
            Tr.entry(tc, "doWait");
        }
        if (this.awakens == 0) {
            this.wait();
        }
        this.awakens = 0;
        if (LogicalPoolDistribution.fTrEnabled) {
            Tr.exit(tc, "doWait");
        }
    }

    synchronized void awaken() {
        if (LogicalPoolDistribution.fTrEnabled) {
            Tr.entry(tc, "awaken");
        }
        ++this.awakens;
        this.notify();
        if (LogicalPoolDistribution.fTrEnabled) {
            Tr.exit(tc, "awaken");
        }
    }

    void dumpStats() {
        Util.infoMsg(tc, "-----------------------------------");
        Util.infoMsg(tc, "- EJB work queue statistics begin -");
        Util.infoMsg(tc, "-----------------------------------");
        this.wq.dumpStats();
        Util.infoMsg(tc, "-begin Queue Processor Stats ------");
        Collection collection = this.classifications.values();
        Util.infoMsg(tc, "------ processing class stats------");
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Classification classification = (Classification)iterator.next();
            classification.dumpStats(tc);
        }
        Util.infoMsg(tc, "---end processing class stats------");
        Util.infoMsg(tc, "---Stats for processing queues ----");
        int n = this.workerPool.length;
        for (int i = 0; i < n; ++i) {
            Util.infoMsg(tc, "Processing queue id............" + i);
            Util.infoMsg(tc, "   target processing time......" + this.poolTargetServiceTime[i]);
            Util.infoMsg(tc, "   max actual processing time.." + this.poolMaxActual[i]);
            Util.infoMsg(tc, "   min actual processing time.." + this.poolMinActual[i]);
            Util.infoMsg(tc, "   avg actual processing time.." + this.poolAvgActual[i]);
            Util.infoMsg(tc, "   total processing time......." + this.poolTotalTime[i]);
            Util.infoMsg(tc, "   total requests.............." + this.poolExecs[i]);
            Util.infoMsg(tc, "   Availablity................." + this.ps[i].getAvailability());
        }
        Util.infoMsg(tc, "---End stats for processing queues-");
        Util.infoMsg(tc, "--end- Queue Processor Stats ------");
        Util.infoMsg(tc, "-----------------------------------");
        Util.infoMsg(tc, "- EJB work queue statistics end   -");
        Util.infoMsg(tc, "-----------------------------------");
    }
}

