/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tpv.advisor;

import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.performance.tuning.rule.RuleOutput;
import com.ibm.ws.tpv.engine.UserPreferences;
import com.ibm.ws.tpv.engine.buffer.StatRequest;
import java.util.Properties;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class AdvisorDriver {
    private AdminClient adminClient = null;
    private ObjectName tpvAdvisor = null;
    private ObjectName tpvEngine = null;
    private String host;
    private String port;

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            return;
        }
        AdvisorDriver advisorDriver = new AdvisorDriver(stringArray[0], stringArray[1]);
        advisorDriver.createAdminClient();
        advisorDriver.getAdvisorMBean();
        advisorDriver.getEngineMBean();
        advisorDriver.invokeAdvisorMBean();
    }

    public AdvisorDriver(String string, String string2) {
        this.host = string;
        this.port = string2;
    }

    private void createAdminClient() {
        Properties properties = new Properties();
        properties.setProperty("type", "SOAP");
        properties.setProperty("host", this.host);
        properties.setProperty("port", this.port);
        try {
            this.adminClient = AdminClientFactory.createAdminClient(properties);
        }
        catch (ConnectorException connectorException) {
            System.exit(-1);
        }
    }

    public void getAdvisorMBean() {
        try {
            String string = "WebSphere:name=TPVAdvisorMBean,*";
            ObjectName objectName = new ObjectName(string);
            Set set = this.adminClient.queryNames(objectName, null);
            if (!set.isEmpty()) {
                this.tpvAdvisor = (ObjectName)set.iterator().next();
            } else {
                System.exit(-1);
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            System.exit(-1);
        }
        catch (ConnectorException connectorException) {
            System.exit(-1);
        }
    }

    public void getEngineMBean() {
        try {
            String string = "WebSphere:name=TPVEngineMBean,*";
            ObjectName objectName = new ObjectName(string);
            Set set = this.adminClient.queryNames(objectName, null);
            if (!set.isEmpty()) {
                this.tpvEngine = (ObjectName)set.iterator().next();
            } else {
                System.exit(-1);
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            System.exit(-1);
        }
        catch (ConnectorException connectorException) {
            System.exit(-1);
        }
    }

    public void getData() {
    }

    public void invokeAdvisorMBean() {
        Object[] objectArray = new Object[1];
        UserPreferences userPreferences = new UserPreferences();
        userPreferences.setUserId("bert");
        userPreferences.setRefreshRate(10);
        userPreferences.setServerName("server1");
        userPreferences.setNodeName("DefaultNode");
        userPreferences.setBufferSize(40);
        objectArray[0] = userPreferences;
        String[] stringArray = new String[]{"com.ibm.ws.tpv.engine.UserPreferences"};
        try {
            this.adminClient.invoke(this.tpvEngine, "monitorServer", objectArray, stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Object[] objectArray2 = new Object[1];
        StatRequest statRequest = new StatRequest("DefaultNode", "server1", 0, true, true, null, "bert");
        StatRequest[] statRequestArray = new StatRequest[]{statRequest};
        objectArray2[0] = statRequestArray;
        String[] stringArray2 = new String[]{"[Lcom.ibm.ws.tpv.engine.buffer.StatRequest;"};
        try {
            this.adminClient.invoke(this.tpvEngine, "register", objectArray2, stringArray2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Object[] objectArray3 = new Object[]{"bert", "DefaultNode", "server1", null};
        String[] stringArray3 = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"};
        RuleOutput[] ruleOutputArray = null;
        try {
            ruleOutputArray = (RuleOutput[])this.adminClient.invoke(this.tpvAdvisor, "runRules", objectArray3, stringArray3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

