/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tpv.advisor;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.performance.tuning.rule.RuleOutput;
import com.ibm.ws.tpv.advisor.AdvisorOperations;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class AdvisorProxy
implements AdvisorOperations {
    private static AdvisorProxy advisor;
    private AdminService as;
    private HashMap adminClients;
    private HashMap advisorMBeans;
    private static TraceComponent tc;

    private AdvisorProxy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.as = AdminServiceFactory.getAdminService();
        this.advisorMBeans = new HashMap();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public static AdvisorProxy getProxy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProxy");
        }
        if (advisor == null) {
            advisor = new AdvisorProxy();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProxy");
        }
        return advisor;
    }

    public RuleOutput[] runRules(String string, String string2, String string3, String string4, String string5) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "runRules", new Object[]{string3, string4});
        }
        Object[] objectArray = new Object[]{string2, string3, string4, string5};
        String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"};
        RuleOutput[] ruleOutputArray = (RuleOutput[])this.invoke("runRules", string, objectArray, stringArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "runRules");
        }
        return ruleOutputArray;
    }

    protected Object invoke(String string, String string2, Object[] objectArray, String[] stringArray) {
        Object object;
        if (tc.isEntryEnabled()) {
            int n;
            object = new ArrayList<String>();
            ((ArrayList)object).add(string);
            ((ArrayList)object).add(string2);
            if (objectArray != null) {
                for (n = 0; n < objectArray.length; ++n) {
                    ((ArrayList)object).add(objectArray[n]);
                }
            }
            if (stringArray != null) {
                for (n = 0; n < stringArray.length; ++n) {
                    ((ArrayList)object).add(stringArray[n]);
                }
            }
            Tr.entry(tc, "invoke", ((ArrayList)object).toArray());
        }
        object = null;
        try {
            ObjectName objectName = this.getAdvisorMBean(string2);
            object = this.as.invoke(objectName, string, objectArray, stringArray);
        }
        catch (JMException jMException) {
            jMException.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke", object);
        }
        return object;
    }

    protected ObjectName getAdvisorMBean(String string) throws InstanceNotFoundException {
        ObjectName objectName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdvisorMBean", string);
        }
        if ((objectName = (ObjectName)this.advisorMBeans.get(string)) == null) {
            try {
                ObjectName objectName2 = new ObjectName("WebSphere:type=TivoliPerfAdvisor,*,node=" + string);
                Set set = this.as.queryNames(objectName2, null);
                if (set == null || set.size() != 1) {
                    if (set == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Null results returned when looking for advisor mbean");
                        }
                    } else if (set.size() == 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Zero results returned when looking for advisor mbean");
                        }
                    } else if (set.size() > 0 && tc.isDebugEnabled()) {
                        Tr.debug(tc, "More than one result returned when looking for advisor mbean: " + set.size());
                        Iterator iterator = set.iterator();
                        while (iterator.hasNext()) {
                            ObjectName objectName3 = (ObjectName)iterator.next();
                            Tr.debug(tc, objectName3.toString());
                        }
                    }
                    throw new InstanceNotFoundException("TPA MBean not found on node " + string);
                }
                objectName = (ObjectName)set.iterator().next();
                this.advisorMBeans.put(string, objectName);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caught MalformedObjectNameException");
                }
                throw new InstanceNotFoundException(malformedObjectNameException.toString());
            }
        }
        return objectName;
    }

    protected AdminClient getAdminClient(String string) throws ConnectorException, JMException {
        AdminClient adminClient;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdminClient", string);
        }
        if ((adminClient = (AdminClient)this.adminClients.get(string)) == null) {
            Properties properties;
            Set set;
            ObjectName objectName = new ObjectName("WebSphere:type=JMXConnector,process=nodeagent,node=" + string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Query " + objectName);
            }
            if ((set = this.as.queryNames(objectName, null)) != null && set.size() > 0) {
                ObjectName objectName2 = (ObjectName)set.iterator().next();
                properties = (Properties)this.as.invoke(objectName2, "getProperties", null, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Attempting to create AdminClient using properties: " + properties);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No results returned from JMXConnector query.");
                }
                throw new ConnectorException("Could not create AdminClient to node " + string);
            }
            adminClient = AdminClientFactory.createAdminClient(properties);
            this.adminClients.put(string, adminClient);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdminClient");
        }
        return adminClient;
    }

    static {
        tc = Tr.register(AdvisorProxy.class, "TivoliPerformanceViewer", "com.ibm.ws.tpv.engine.property.tpvengine");
    }
}

