/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tpv.advisor.calc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.websphere.pmi.stat.WSAverageStatistic;
import com.ibm.websphere.pmi.stat.WSCountStatistic;
import com.ibm.websphere.pmi.stat.WSDoubleStatistic;
import com.ibm.websphere.pmi.stat.WSRangeStatistic;
import com.ibm.websphere.pmi.stat.WSStatistic;
import com.ibm.ws.performance.tuning.calc.IBasicDataPointCalc;
import com.ibm.ws.performance.tuning.calc.ILogReadingCalc;
import com.ibm.ws.tpv.advisor.calc.TPVData;

public class ClientBasicDataPointCalc
implements IBasicDataPointCalc,
ILogReadingCalc {
    private static TraceComponent tc = Tr.register(ClientBasicDataPointCalc.class, null, null);
    protected TPVData data;
    private int dataId;
    private PerfDescriptor pd;
    protected String userId = null;
    protected String logName = null;

    public void setUserId(String string) {
        this.userId = string;
    }

    public void setLogName(String string) {
        this.logName = string;
    }

    public void init(PerfDescriptor perfDescriptor, int n) {
        this.pd = perfDescriptor;
        this.dataId = n;
        this._init();
        if (this.data == null) {
            Tr.debug(tc, "[ClientBasicDataPointCalc] Data not found for " + perfDescriptor.getFullName());
        }
    }

    protected void _init() {
        if (this.data == null) {
            this.data = TPVData.createData(this.pd, this.dataId, this.userId, this.logName);
        }
        if (this.data != null && this.data.numItemsInCache() == 0) {
            this.data = null;
        }
    }

    public long getLongValue() {
        this._init();
        if (this.data == null) {
            return -102L;
        }
        long l = 0L;
        WSStatistic wSStatistic = this.data.getCacheValue(0);
        if (this.data.getType() == 2) {
            l = ((WSCountStatistic)wSStatistic).getCount();
        } else if (this.data.getType() == 7) {
            l = ((WSRangeStatistic)wSStatistic).getCurrent();
        }
        Tr.debug(tc, "[ClientBasicDataPointCalc] getLongValue() returned: " + l);
        return l;
    }

    public double getDoubleValue() {
        this._init();
        if (this.data == null) {
            return -102.0;
        }
        double d = 0.0;
        WSStatistic wSStatistic = this.data.getCacheValue(0);
        if (this.data.getType() == 2) {
            d = ((WSCountStatistic)wSStatistic).getCount();
        } else if (this.data.getType() == 3) {
            d = ((WSDoubleStatistic)wSStatistic).getDouble();
        } else if (this.data.getType() == 7) {
            d = ((WSRangeStatistic)wSStatistic).getCurrent();
        } else if (this.data.getType() == 6 || this.data.getType() == 4) {
            double d2 = ((WSAverageStatistic)wSStatistic).getTotal();
            double d3 = ((WSAverageStatistic)wSStatistic).getCount();
            if (d3 > 0.0) {
                d = d2 / d3;
            }
        }
        Tr.debug(tc, "[ClientBasicDataPointCalc] getDoubleValue() returned: " + d);
        return d;
    }

    public double getIntegral() {
        this._init();
        if (this.data == null) {
            return -102.0;
        }
        double d = 0.0;
        WSStatistic wSStatistic = this.data.getCacheValue(0);
        d = this.data.getType() == 7 ? ((WSRangeStatistic)wSStatistic).getIntegral() : -102.0;
        Tr.debug(tc, "[ClientBasicDataPointCalc] getIntegral() returned: " + d);
        return d;
    }

    public String toString() {
        return null;
    }

    public PerfDescriptor getPD() {
        return this.pd;
    }

    public int getCounter() {
        return this.dataId;
    }

    public void clear() {
        if (this.data != null) {
            this.data.clear();
        }
    }
}

