/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tpv.advisor.calc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.stat.WSAverageStatistic;
import com.ibm.websphere.pmi.stat.WSCountStatistic;
import com.ibm.websphere.pmi.stat.WSDoubleStatistic;
import com.ibm.websphere.pmi.stat.WSRangeStatistic;
import com.ibm.websphere.pmi.stat.WSStatistic;
import com.ibm.ws.performance.tuning.calc.IBasicDataPointHistoryCalc;
import com.ibm.ws.tpv.advisor.calc.ClientBasicDataPointCalc;

public class ClientBasicDataPointHistoryCalc
extends ClientBasicDataPointCalc
implements IBasicDataPointHistoryCalc {
    private static TraceComponent tc = Tr.register(ClientBasicDataPointCalc.class, null, null);
    private boolean calcFlag = false;
    private double avg;
    private double min;
    private double max;
    private double diffCount;

    public void clear() {
        this.diffCount = -102.0;
        this.max = -102.0;
        this.min = -102.0;
        this.avg = -102.0;
        this.calcFlag = false;
        if (this.data != null) {
            this.data.clear();
        }
    }

    public double getAverageDouble() {
        if (!this.calcFlag) {
            this.calc();
        }
        Tr.debug(tc, "[ClientBasicDataPointHistoryCalc] getAverageDouble() returned: " + this.avg);
        return this.avg;
    }

    public double getMaxDouble() {
        if (!this.calcFlag) {
            this.calc();
        }
        Tr.debug(tc, "[ClientBasicDataPointHistoryCalc] getMaxDouble() returned: " + this.max);
        return this.max;
    }

    public double getMinDouble() {
        if (!this.calcFlag) {
            this.calc();
        }
        Tr.debug(tc, "[ClientBasicDataPointHistoryCalc] getMinDouble() returned: " + this.min);
        return this.min;
    }

    public double getDifferenceOverCount() {
        if (!this.calcFlag) {
            this.calc();
        }
        Tr.debug(tc, "[ClientBasicDataPointHistoryCalc] getDifferenceOverCount() returned: " + this.diffCount);
        return this.diffCount;
    }

    private void calc() {
        double d;
        this._init();
        if (this.data == null || this.data.numItemsInCache() == 0) {
            this.clear();
            return;
        }
        double d2 = 0.0;
        this.min = this.max = (d = this.getDoubleFromStat(this.data.getCacheValue(0)));
        d2 = this.max;
        int n = this.data.numItemsInCache();
        for (int i = 1; i < n; ++i) {
            d = this.getDoubleFromStat(this.data.getCacheValue(i));
            d2 += d;
            if (d < this.min) {
                this.min = d;
                continue;
            }
            if (!(d > this.max)) continue;
            this.max = d;
        }
        this.avg = d2 / (double)n;
        this.calcFlag = true;
        if (this.data.getType() == 7) {
            if (n < 2) {
                this.diffCount = 0.0;
            } else {
                WSStatistic wSStatistic = this.data.getCacheValue(0);
                WSStatistic wSStatistic2 = wSStatistic.delta(this.data.getCacheValue(n - 1));
                this.diffCount = ((WSRangeStatistic)wSStatistic2).getMean();
            }
        } else if (this.data.getType() == 6 || this.data.getType() == 4) {
            if (n < 2) {
                this.diffCount = 0.0;
            } else {
                WSStatistic wSStatistic = this.data.getCacheValue(0);
                WSStatistic wSStatistic3 = wSStatistic.delta(this.data.getCacheValue(n - 1));
                this.diffCount = this.getDoubleFromStat(wSStatistic3);
            }
        } else {
            this.diffCount = 0.0;
        }
    }

    public void dump() {
        StringBuffer stringBuffer = new StringBuffer("ClientBasicDataPointHistoryCalc dump:\n");
        stringBuffer.append("avg = ");
        stringBuffer.append(this.avg);
        stringBuffer.append("; min = ");
        stringBuffer.append(this.min);
        stringBuffer.append("; max = ");
        stringBuffer.append(this.max).append("; diffCount = ").append(this.diffCount);
        Tr.debug(tc, stringBuffer.toString());
    }

    private double getDoubleFromStat(WSStatistic wSStatistic) {
        Tr.debug(tc, "[ClientBasicDataPointHistoryCalc] getDoubleFromStat() stat: " + wSStatistic);
        Tr.debug(tc, "data.getType() :" + this.data.getType());
        double d = 0.0;
        if (this.data.getType() == 2) {
            d = ((WSCountStatistic)wSStatistic).getCount();
        } else if (this.data.getType() == 3) {
            d = ((WSDoubleStatistic)wSStatistic).getDouble();
        } else if (this.data.getType() == 6 || this.data.getType() == 4) {
            double d2 = ((WSAverageStatistic)wSStatistic).getTotal();
            double d3 = ((WSAverageStatistic)wSStatistic).getCount();
            if (d3 > 0.0) {
                d = d2 / d3;
            }
        } else if (this.data.getType() == 7) {
            d = ((WSRangeStatistic)wSStatistic).getCurrent();
        }
        return d;
    }
}

