/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tpv.advisor.calc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.client.CpdLoad;
import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.websphere.pmi.stat.WSCountStatistic;
import com.ibm.websphere.pmi.stat.WSDoubleStatistic;
import com.ibm.websphere.pmi.stat.WSRangeStatistic;
import com.ibm.websphere.pmi.stat.WSStatistic;
import com.ibm.ws.performance.tuning.EngineParameters;
import com.ibm.ws.performance.tuning.calc.IBasicDataPointHistoryTimeCalc;
import com.ibm.ws.tpv.advisor.calc.ClientBasicDataPointHistoryCalc;

public class ClientBasicDataPointHistoryTimeCalc
extends ClientBasicDataPointHistoryCalc
implements IBasicDataPointHistoryTimeCalc {
    private static TraceComponent tc = Tr.register(ClientBasicDataPointHistoryTimeCalc.class, null, null);
    private double intervalInMilli;
    private long t0 = 0L;

    public void init(PerfDescriptor perfDescriptor, int n) {
        this.init(perfDescriptor, n, EngineParameters.getCalcInterval());
    }

    public void init(PerfDescriptor perfDescriptor, int n, double d) {
        super.init(perfDescriptor, n);
        this.intervalInMilli = d * 1000.0;
    }

    public void setIntervalTime(double d) {
        this.intervalInMilli = d;
    }

    public double getIntervalTime() {
        return this.intervalInMilli;
    }

    public void clearHistory() {
        if (this.data != null) {
            this.data.clear();
        }
    }

    public double getIntervalAverage() {
        double d;
        this._init();
        if (this.data == null) {
            return -102.0;
        }
        int n = this.data.numItemsInCache();
        if (n == 0) {
            return -101.0;
        }
        if (n == 1) {
            return -101.0;
        }
        if (this.t0 == 0L) {
            if (this.data.getCacheValue(0) == null || this.data.getCacheValue(n - 1) == null) {
                return -102.0;
            }
            d = this.data.getCacheValue(0).getLastSampleTime() - this.data.getCacheValue(n - 1).getLastSampleTime();
        } else {
            d = this.data.getCacheValue(0).getLastSampleTime() - this.t0;
            Tr.debug(tc, "[ClientBasicDataPointHistoryTimeCalc] A RESET HAS OCCURRED totalTime: " + d + " since last reset at: " + this.t0);
        }
        if (this.intervalInMilli > d) {
            Tr.debug(tc, "[ClientBasicDataPointHistoryTimeCalc] getIntervalAverage() returned: NO_VALID_INTERVAL interval " + this.intervalInMilli + " > totalTime " + d);
            return -101.0;
        }
        WSStatistic wSStatistic = this.data.getCacheValue(0);
        double d2 = 0.0;
        for (int i = 0; i < n - 1; ++i) {
            if (this.data.getCacheValue(i) == null) {
                return -102.0;
            }
            if (!((d2 += (double)(this.data.getCacheValue(i).getLastSampleTime() - this.data.getCacheValue(i + 1).getLastSampleTime())) >= this.intervalInMilli)) continue;
            double d3 = 0.0;
            d3 = this.data.getType() == 7 ? this._calcIntegralAvg(this.data.getCacheValue(i + 1), this.data.getCacheValue(0)) : this._calcSimpleAvg(i + 1);
            Tr.debug(tc, "[ClientBasicDataPointHistoryTimeCalc] getIntervalAverage() returned: " + d3 + "  intervalInMilli: " + this.intervalInMilli);
            return d3;
        }
        Tr.debug(tc, "[ClientBasicDataPointHistoryTimeCalc] getIntervalAverage(): Error in calculation!");
        return -102.0;
    }

    public double getIntervalStdDev() {
        double d = 0.0;
        double d2 = this.getIntervalStdDevSquared();
        d = d2 == -102.0 || d2 == -101.0 ? d2 : Math.sqrt(d2);
        Tr.debug(tc, "[ClientBasicDataPointHistoryTimeCalc] getIntervalStdDev() returned: " + d);
        return d;
    }

    public double getIntervalStdDevSquared() {
        double d = this.getIntervalAverage();
        if (d == -102.0 || d == -101.0) {
            Tr.debug(tc, "[ClientBasicDataPointHistoryTimeCalc] getIntervalStdDevSquared() returned: NO_VALID_INTERVAL");
            return d;
        }
        WSStatistic wSStatistic = this.data.getCacheValue(0);
        double d2 = 0.0;
        int n = this.data.numItemsInCache();
        int n2 = 0;
        for (int i = 0; i < n - 1; ++i) {
            if (!((d2 += (double)(this.data.getCacheValue(i).getLastSampleTime() - this.data.getCacheValue(i + 1).getLastSampleTime())) >= this.intervalInMilli)) continue;
            n2 = i + 2;
            break;
        }
        if (n2 == 0) {
            Tr.debug(tc, "[ClientBasicDataPointHistoryTimeCalc] getIntervalStdDevSquared() returned: NO_VALID_INTERVAL noPoints = 0");
            return -101.0;
        }
        double d3 = 0.0;
        for (int i = 0; i < n2; ++i) {
            double d4 = 0.0;
            if (this.data.getType() == 7) {
                d4 = ((WSRangeStatistic)this.data.getCacheValue(i)).getCurrent();
            } else if (this.data.getType() == 2) {
                d4 = ((WSCountStatistic)this.data.getCacheValue(i)).getCount();
            } else if (this.data.getType() == 3) {
                d4 = ((WSDoubleStatistic)this.data.getCacheValue(i)).getDouble();
            }
            double d5 = d - d4;
            d3 += d5 * d5;
        }
        double d6 = d3 / (double)(n2 - 1);
        Tr.debug(tc, "[ClientBasicDataPointHistoryTimeCalc] getIntervalStdDev(): mean = " + d + ";stddev = " + Math.sqrt(d6));
        Tr.debug(tc, "[ClientBasicDataPointHistoryTimeCalc] getIntervalStdDevSquared() returned: " + d6);
        return d6;
    }

    private double _calcIntegralAvg(WSStatistic wSStatistic, WSStatistic wSStatistic2) {
        WSRangeStatistic wSRangeStatistic = (WSRangeStatistic)wSStatistic;
        WSRangeStatistic wSRangeStatistic2 = (WSRangeStatistic)wSStatistic2;
        WSRangeStatistic wSRangeStatistic3 = (WSRangeStatistic)wSRangeStatistic2.delta(wSRangeStatistic);
        return wSRangeStatistic3.getIntegral() / (double)(wSRangeStatistic3.getLastSampleTime() - wSRangeStatistic3.getStartTime());
    }

    private double _calcSimpleAvg(int n) {
        double d = 0.0;
        WSStatistic wSStatistic = this.data.getCacheValue(0);
        for (int i = 0; i <= n; ++i) {
            if (this.data.getType() == 2) {
                d += (double)((WSCountStatistic)this.data.getCacheValue(i)).getCount();
                continue;
            }
            if (this.data.getType() != 3) continue;
            d += ((WSDoubleStatistic)this.data.getCacheValue(i)).getDouble();
        }
        Tr.debug(tc, "[ClientBasicDataPointHistoryTimeCalc] _calcSimpleAvg() index: " + n);
        return d / (double)(n + 1);
    }

    public long getInitialTime() {
        return -102L;
    }

    public long getDuration() {
        return -102L;
    }

    public long getCurrentTime() {
        return -102L;
    }

    public boolean hasIncreased() {
        return false;
    }

    public void printCpdLoad(CpdLoad cpdLoad) {
        Tr.debug(tc, this.getPD().getFullName());
        Tr.debug(tc, "integral = " + cpdLoad.getIntegral());
        Tr.debug(tc, "weight = " + cpdLoad.getWeight());
        Tr.debug(tc, "time = " + cpdLoad.getTime());
        Tr.debug(tc, "value = " + cpdLoad.getValue());
    }
}

