/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tpv.advisor.calc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.websphere.pmi.stat.WSCountStatistic;
import com.ibm.ws.performance.tuning.calc.ICacheCalc;
import com.ibm.ws.performance.tuning.calc.ILogReadingCalc;
import com.ibm.ws.pmi.client.PerfDescriptorImpl;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.tpv.advisor.calc.TPVData;
import java.util.ArrayList;

public class ClientCacheCalc
implements ICacheCalc,
ILogReadingCalc {
    private static TraceComponent tc = Tr.register(ClientCacheCalc.class, null, null);
    private static final int HITS_IN_MEMORY = 21;
    private static final int HITS_ON_DISK = 22;
    private static final int EXPLICIT_INVALIDATIONS = 23;
    private static final int LRU_INVALIDATIONS = 24;
    private static final int TIMEOUT_INVALIDATIONS = 25;
    private static final int ENTRIES = 26;
    private static final int MISSES = 28;
    private static final int REQUESTS_FROM_CLIENT = 29;
    private static final int REQUESTS_FROM_JVM = 30;
    private static final int EXPLICIT_INVALIDATIONS_MEMORY = 31;
    private static final int EXPLICIT_INVALIDATIONS_DISK = 32;
    private static final int EXPLICIT_INVALIDATIONS_LOCAL = 34;
    private static final int EXPLICIT_INVALIDATIONS_REMOTE = 35;
    private static final int REMOTE_CREATIONS = 36;
    private String[] cacheModule = new String[]{"cacheModule", "baseCache"};
    private String[] templModule = new String[]{"cacheModule", "baseCache", "cacheModule.template"};
    private String[] objectCacheModule = new String[]{"cacheModule", "baseCache", "cacheModule.objectCache"};
    public String node = null;
    public String server = null;
    private PerfDescriptor cachePD;
    private PerfDescriptor templPD;
    private PerfDescriptor objectCachePD;
    private TPVData cacheData;
    private String userId = null;
    private String logName = null;

    public PerfDescriptor getCachePD() {
        return this.cachePD;
    }

    public PerfDescriptor getTemplatePD() {
        return this.templPD;
    }

    public void setUserId(String string) {
        this.userId = string;
    }

    public void setLogName(String string) {
        this.logName = string;
    }

    public void init(String string, String string2) {
        this.node = string;
        this.server = string2;
        this.cachePD = new PerfDescriptorImpl(string, string2, new DataDescriptor(this.cacheModule));
        this.cachePD.postInit();
        this.templPD = new PerfDescriptorImpl(string, string2, new DataDescriptor(this.templModule));
        this.templPD.postInit();
        this.cacheData = TPVData.createData(this.cachePD, this.userId, this.logName);
    }

    public long getMaxInMemoryCacheSize() {
        if (this.cacheData == null) {
            return -102L;
        }
        WSCountStatistic wSCountStatistic = (WSCountStatistic)this.cacheData.getCacheValue(0, 1);
        if (wSCountStatistic == null) {
            return -102L;
        }
        long l = wSCountStatistic.getCount();
        Tr.debug(tc, "[ClientCacheCalc] getMaxInMemoryCacheSize() returned: " + l);
        if (this.cacheData != null) {
            this.cacheData.dump();
        }
        return l;
    }

    public long getInMemoryCacheSize() {
        if (this.cacheData == null) {
            return -102L;
        }
        WSCountStatistic wSCountStatistic = (WSCountStatistic)this.cacheData.getCacheValue(0, 2);
        if (wSCountStatistic == null) {
            return -102L;
        }
        long l = wSCountStatistic.getCount();
        Tr.debug(tc, "[ClientCacheCalc] getInMemoryCacheSize() returned: " + l);
        if (this.cacheData != null) {
            this.cacheData.dump();
        }
        return l;
    }

    public PerfDescriptor[] getTemplatePerfDescriptors() {
        TPVData tPVData = TPVData.createData(this.templPD, this.userId, this.logName);
        if (tPVData == null) {
            return null;
        }
        ArrayList arrayList = tPVData.getChildren();
        PerfDescriptor[] perfDescriptorArray = new PerfDescriptor[arrayList.size()];
        for (int i = 0; i < perfDescriptorArray.length; ++i) {
            perfDescriptorArray[i] = (PerfDescriptor)arrayList.get(i);
        }
        return perfDescriptorArray;
    }

    public PerfDescriptor getObjectCachePD() {
        return this.objectCachePD;
    }

    public long getHitsInMemory(PerfDescriptor perfDescriptor) {
        this.cacheData = TPVData.createData(perfDescriptor, 21, this.userId, this.logName);
        if (this.cacheData == null) {
            return -102L;
        }
        WSCountStatistic wSCountStatistic = (WSCountStatistic)this.cacheData.getCacheValue(0);
        if (wSCountStatistic == null) {
            return -102L;
        }
        long l = wSCountStatistic.getCount();
        Tr.debug(tc, "[ClientCacheCalc] pd: " + perfDescriptor.getFullName());
        Tr.debug(tc, "[ClientCacheCalc] getHitsInMemory() returned: " + l);
        if (this.cacheData != null) {
            this.cacheData.dump();
        }
        return l;
    }

    public long getHitsOnDisk(PerfDescriptor perfDescriptor) {
        this.cacheData = TPVData.createData(perfDescriptor, 22, this.userId, this.logName);
        if (this.cacheData == null) {
            return -102L;
        }
        WSCountStatistic wSCountStatistic = (WSCountStatistic)this.cacheData.getCacheValue(0);
        if (wSCountStatistic == null) {
            return -102L;
        }
        return wSCountStatistic.getCount();
    }

    public long getExplicitInvalidations(PerfDescriptor perfDescriptor) {
        this.cacheData = TPVData.createData(perfDescriptor, 23, this.userId, this.logName);
        if (this.cacheData == null) {
            return -102L;
        }
        WSCountStatistic wSCountStatistic = (WSCountStatistic)this.cacheData.getCacheValue(0);
        if (wSCountStatistic == null) {
            return -102L;
        }
        return wSCountStatistic.getCount();
    }

    public long getLruInvalidations(PerfDescriptor perfDescriptor) {
        this.cacheData = TPVData.createData(perfDescriptor, 24, this.userId, this.logName);
        if (this.cacheData == null) {
            return -102L;
        }
        WSCountStatistic wSCountStatistic = (WSCountStatistic)this.cacheData.getCacheValue(0);
        if (wSCountStatistic == null) {
            return -102L;
        }
        long l = wSCountStatistic.getCount();
        Tr.debug(tc, "[ClientCacheCalc] pd: " + perfDescriptor.getFullName());
        Tr.debug(tc, "[ClientCacheCalc] getLruInvalidations() returned: " + l);
        if (this.cacheData != null) {
            this.cacheData.dump();
        }
        return l;
    }

    public long getTimeoutInvalidations(PerfDescriptor perfDescriptor) {
        this.cacheData = TPVData.createData(perfDescriptor, 25, this.userId, this.logName);
        if (this.cacheData == null) {
            return -102L;
        }
        WSCountStatistic wSCountStatistic = (WSCountStatistic)this.cacheData.getCacheValue(0);
        if (wSCountStatistic == null) {
            return -102L;
        }
        return wSCountStatistic.getCount();
    }

    public long getEntries(PerfDescriptor perfDescriptor) {
        this.cacheData = TPVData.createData(perfDescriptor, 26, this.userId, this.logName);
        if (this.cacheData == null) {
            return -102L;
        }
        WSCountStatistic wSCountStatistic = (WSCountStatistic)this.cacheData.getCacheValue(0);
        if (wSCountStatistic == null) {
            return -102L;
        }
        return wSCountStatistic.getCount();
    }

    public long getMisses(PerfDescriptor perfDescriptor) {
        this.cacheData = TPVData.createData(perfDescriptor, 28, this.userId, this.logName);
        if (this.cacheData == null) {
            return -102L;
        }
        WSCountStatistic wSCountStatistic = (WSCountStatistic)this.cacheData.getCacheValue(0);
        if (wSCountStatistic == null) {
            return -102L;
        }
        long l = wSCountStatistic.getCount();
        Tr.debug(tc, "[ClientCacheCalc] pd: " + perfDescriptor.getFullName());
        Tr.debug(tc, "[ClientCacheCalc] getMisses() returned: " + l);
        if (this.cacheData != null) {
            this.cacheData.dump();
        }
        return l;
    }

    public long getRequestsFromClient(PerfDescriptor perfDescriptor) {
        this.cacheData = TPVData.createData(perfDescriptor, 29, this.userId, this.logName);
        if (this.cacheData == null) {
            return -102L;
        }
        WSCountStatistic wSCountStatistic = (WSCountStatistic)this.cacheData.getCacheValue(0);
        if (wSCountStatistic == null) {
            return -102L;
        }
        long l = wSCountStatistic.getCount();
        Tr.debug(tc, "[ClientCacheCalc] pd: " + perfDescriptor.getFullName());
        Tr.debug(tc, "[ClientCacheCalc] getRequestsFromClient() returned: " + l);
        if (this.cacheData != null) {
            this.cacheData.dump();
        }
        return l;
    }

    public long getRequestsFromJvm(PerfDescriptor perfDescriptor) {
        this.cacheData = TPVData.createData(perfDescriptor, 30, this.userId, this.logName);
        if (this.cacheData == null) {
            return -102L;
        }
        WSCountStatistic wSCountStatistic = (WSCountStatistic)this.cacheData.getCacheValue(0);
        if (wSCountStatistic == null) {
            return -102L;
        }
        long l = wSCountStatistic.getCount();
        Tr.debug(tc, "[ClientCacheCalc] pd: " + perfDescriptor.getFullName());
        Tr.debug(tc, "[ClientCacheCalc] getRequestsFromJvm() returned: " + l);
        if (this.cacheData != null) {
            this.cacheData.dump();
        }
        return l;
    }

    public long getExplicitInvalidationsFromMemory(PerfDescriptor perfDescriptor) {
        this.cacheData = TPVData.createData(perfDescriptor, 31, this.userId, this.logName);
        if (this.cacheData == null) {
            return -102L;
        }
        WSCountStatistic wSCountStatistic = (WSCountStatistic)this.cacheData.getCacheValue(0);
        if (wSCountStatistic == null) {
            return -102L;
        }
        return wSCountStatistic.getCount();
    }

    public long getExplicitInvalidationsFromDisk(PerfDescriptor perfDescriptor) {
        this.cacheData = TPVData.createData(perfDescriptor, 32, this.userId, this.logName);
        if (this.cacheData == null) {
            return -102L;
        }
        WSCountStatistic wSCountStatistic = (WSCountStatistic)this.cacheData.getCacheValue(0);
        if (wSCountStatistic == null) {
            return -102L;
        }
        return wSCountStatistic.getCount();
    }

    public long getExplicitInvalidationsLocal(PerfDescriptor perfDescriptor) {
        this.cacheData = TPVData.createData(perfDescriptor, 34, this.userId, this.logName);
        if (this.cacheData == null) {
            return -102L;
        }
        WSCountStatistic wSCountStatistic = (WSCountStatistic)this.cacheData.getCacheValue(0);
        if (wSCountStatistic == null) {
            return -102L;
        }
        return wSCountStatistic.getCount();
    }

    public long getExplicitInvalidationsRemote(PerfDescriptor perfDescriptor) {
        this.cacheData = TPVData.createData(perfDescriptor, 35, this.userId, this.logName);
        if (this.cacheData == null) {
            return -102L;
        }
        WSCountStatistic wSCountStatistic = (WSCountStatistic)this.cacheData.getCacheValue(0);
        if (wSCountStatistic == null) {
            return -102L;
        }
        return wSCountStatistic.getCount();
    }

    public long getRemoteCreations(PerfDescriptor perfDescriptor) {
        this.cacheData = TPVData.createData(perfDescriptor, 36, this.userId, this.logName);
        if (this.cacheData == null) {
            return -102L;
        }
        WSCountStatistic wSCountStatistic = (WSCountStatistic)this.cacheData.getCacheValue(0);
        if (wSCountStatistic == null) {
            return -102L;
        }
        return wSCountStatistic.getCount();
    }

    public void getPerfDescriptors(String string, String string2) {
        this.templModule[0] = "cacheModule";
        this.cacheModule[0] = "cacheModule";
        this.cacheModule[1] = string2.equals("Servlet") ? (this.templModule[1] = string) : (this.objectCacheModule[1] = string);
        this.cachePD = new PerfDescriptorImpl(this.node, this.server, new DataDescriptor(this.cacheModule));
        this.cachePD.postInit();
        this.templPD = new PerfDescriptorImpl(this.node, this.server, new DataDescriptor(this.templModule));
        this.templPD.postInit();
        this.objectCachePD = new PerfDescriptorImpl(this.node, this.server, new DataDescriptor(this.objectCacheModule));
        this.objectCachePD.postInit();
        this.cacheData = TPVData.createData(this.cachePD, this.userId, this.logName);
    }

    public void clear() {
        if (this.cacheData != null) {
            this.cacheData.clear();
        }
        this.cachePD = null;
        this.templPD = null;
    }
}

