/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tpv.advisor.calc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.websphere.pmi.stat.WSCountStatistic;
import com.ibm.websphere.pmi.stat.WSTimeStatistic;
import com.ibm.ws.performance.tuning.calc.IJvmpiCalc;
import com.ibm.ws.performance.tuning.calc.ILogReadingCalc;
import com.ibm.ws.tpv.advisor.calc.TPVData;

public class ClientJvmpiCalc
implements IJvmpiCalc,
ILogReadingCalc {
    private static TraceComponent tc = Tr.register(ClientJvmpiCalc.class, null, null);
    protected PerfDescriptor pd;
    protected TPVData jvmpiData;
    protected String node = null;
    protected String server = null;
    protected String userId = null;
    protected String logName = null;
    public static final int NUM_GC_CALLS = 11;
    public static final int AVG_TIME_BETWEEN_GC_CALLS = 12;
    public static final int AVG_GC_DURATION = 13;
    public static final int NUM_OBJS_ALLOCATED = 14;
    public static final int NUM_OBJS_FREED = 15;
    public static final int NUM_OBJS_MOVED = 16;
    public static final int NUM_THREADS_STARTED = 17;
    public static final int NUM_THREADS_DEAD = 18;
    public static final int NUM_WAITS_FOR_LOCK = 19;
    public static final int AVG_TIME_WAIT_FOR_LOCK = 20;
    public static final String GC_STAT = "GC";

    public void debugPrintConstantAndName() {
    }

    public void setUserId(String string) {
        this.userId = string;
    }

    public void setLogName(String string) {
        this.logName = string;
    }

    public void init(String string, String string2, PerfDescriptor perfDescriptor) {
        this.node = string;
        this.server = string2;
        this.pd = perfDescriptor;
        this.jvmpiData = TPVData.createData(this.pd, this.userId, this.logName);
    }

    public long getUpTime() {
        if (this.jvmpiData == null) {
            return -102L;
        }
        WSCountStatistic wSCountStatistic = (WSCountStatistic)this.jvmpiData.getCacheValue(0, 4);
        if (wSCountStatistic == null) {
            return -102L;
        }
        return wSCountStatistic.getCount();
    }

    public long getNumGcCalls() {
        if (this.jvmpiData == null) {
            return -102L;
        }
        WSCountStatistic wSCountStatistic = (WSCountStatistic)this.jvmpiData.getCacheValue(0, 11, GC_STAT);
        if (wSCountStatistic == null) {
            return -102L;
        }
        return wSCountStatistic.getCount();
    }

    public long getAvgTimeBetweenGCs() {
        if (this.jvmpiData == null) {
            return -102L;
        }
        WSTimeStatistic wSTimeStatistic = (WSTimeStatistic)this.jvmpiData.getCacheValue(0, 12, GC_STAT);
        if (wSTimeStatistic == null) {
            return -102L;
        }
        return wSTimeStatistic.getCount();
    }

    public long getAvgGcDuration() {
        if (this.jvmpiData == null) {
            return -102L;
        }
        WSTimeStatistic wSTimeStatistic = (WSTimeStatistic)this.jvmpiData.getCacheValue(0, 13, GC_STAT);
        if (wSTimeStatistic == null) {
            return -102L;
        }
        return wSTimeStatistic.getCount();
    }

    public long getNumWaitsForLock() {
        if (this.jvmpiData == null) {
            return -102L;
        }
        WSCountStatistic wSCountStatistic = (WSCountStatistic)this.jvmpiData.getCacheValue(0, 19);
        if (wSCountStatistic == null) {
            return -102L;
        }
        return wSCountStatistic.getCount();
    }

    public long getAvgTimeWaitForLock() {
        if (this.jvmpiData == null) {
            return -102L;
        }
        WSCountStatistic wSCountStatistic = (WSCountStatistic)this.jvmpiData.getCacheValue(0, 20);
        if (wSCountStatistic == null) {
            return -102L;
        }
        return wSCountStatistic.getCount();
    }

    public long getNumObjectsAllocated() {
        if (this.jvmpiData == null) {
            return -102L;
        }
        WSCountStatistic wSCountStatistic = (WSCountStatistic)this.jvmpiData.getCacheValue(0, 14);
        if (wSCountStatistic == null) {
            return -102L;
        }
        return wSCountStatistic.getCount();
    }

    public long getNumObjectsMoved() {
        if (this.jvmpiData == null) {
            return -102L;
        }
        WSCountStatistic wSCountStatistic = (WSCountStatistic)this.jvmpiData.getCacheValue(0, 16);
        if (wSCountStatistic == null) {
            return -102L;
        }
        return wSCountStatistic.getCount();
    }

    public long getNumObjectsFreed() {
        if (this.jvmpiData == null) {
            return -102L;
        }
        WSCountStatistic wSCountStatistic = (WSCountStatistic)this.jvmpiData.getCacheValue(0, 15);
        if (wSCountStatistic == null) {
            return -102L;
        }
        return wSCountStatistic.getCount();
    }

    public String getJvmVendor() {
        return new String();
    }

    public void clear() {
        if (this.jvmpiData != null) {
            this.jvmpiData.clear();
        }
    }
}

